/*main program that calls cloudy when used as a stand-alone program */
#include "cddefines.h"
#include "cddrive.h"

/*int main( int argc, char *argv[] )*/
int main( void )
{
	int lgOK ,
		lgFirst=TRUE;
	double flux , hden , temp;
	double TotalPressure;		
	/* gas pressure */
	double GasPressure;				
	/* radiation pressure */
	double RadiationPressure;
	/* the ionization parameter */
	double u;


	FILE *ioRES ;
	char chLine[100];

	/* this will be limit to the number of command chLines we can still put in */
	long int nleft;

	/* calculation's results */
	ioRES = fopen("hazy_kmt.txt","w");
	if( ioRES == NULL )
	{
		printf(" could not open hazy_kmt.txt for writing.\n");
		exit(1);
	}

	flux = 18.;
	for( hden=1.; hden<12.01; hden += 0.25 )
	{
		/* initialize the code for this run */
		cdInit();
		cdTalk(FALSE);
		/*cdNoExec( );*/

		/* inputs */
		nleft = cdRead( "background 0 .0000000001"  );
		nleft = cdRead( "table agn "  );
		nleft = cdRead( "stop zone 1 "  );
		nleft = cdRead( "* set radiative recombination badnell "  );
		nleft = cdRead( "* set dielectronic recombination badnell "  );
		nleft = cdRead( "* set dielectronic recombination kludge off "  );

		sprintf(chLine,"phi(h) %f ",flux);
		nleft = cdRead( chLine  );

		sprintf(chLine,"hden %f ",hden);
		nleft = cdRead( chLine  );

		/* log of the ionization parameter */
		u = flux - 10.4771 - hden;

		/* actually call the code */
		lgOK = cdDrive();
		temp = cdTemp_last();
		cdPressure_last(
			/* total pressure, all forms*/
			&TotalPressure,			
			/* gas pressure */
			&GasPressure,				
			/* radiation pressure */
			&RadiationPressure);	

		if( lgFirst )
		{
			/* print a header */
			lgFirst = FALSE;
			fprintf( ioRES , "hden\tlogU\tlogU/T\tlog T\tPgas\n");
			fprintf( stderr, "hden\tlogU\tlogU/T\tlog T\tPgas\n");
		}
		fprintf(ioRES,"%.3e\t%.3e\t%.3e\t%.3e\t%.3e\n",
			hden, u, u-log10(temp) , log10(temp) , GasPressure ); 

		fprintf(stderr,"%.3e\t%.3e\t%.3e\t%.3e\t%.3e\n",
			hden, u, u-log10(temp) , log10(temp) , GasPressure ); 
	}

	puts( "[hazy_kmt ends OK, output went to hazy_kmt.txt]" );
	exit(0);
}

