/*abscf convert gf into absorption coefficient */
#include "cddefines.h"
#include "abscf.h"

double abscf(double gf, 
	  double enercm, 
	  double gl)
{
	double abscf_v;

#	ifdef DEBUG_FUN
	fputs( "<+>abscf()\n", debug_fp );
#	endif

	assert(gl > 0. && enercm > 0. && gf > 0. );

	/* derive line absorption coefficient, given the following:
	 * gf, enercm, g_low
	 * gf is product of g and oscillator strength */
	abscf_v = 1.4974e-6*(gf/gl)*(1e4/enercm);

#	ifdef DEBUG_FUN
	fputs( " <->abscf()\n", debug_fp );
#	endif
	return( abscf_v );
}

