/* abundances.h */
EXTERN struct t_abundances {

	/* array of logical variables saying whether an element is enable (TRUE)
	 * or disabled (FALSE).  It is set totally TRUE in zero
	 * and is set FALSE with the "element off" command.  
	 * In SetAbundances if can be reset so that an element that was disabled
	 * on the first model in a coreload is not later enabled */
	int lgElmtOn[LIMELM];

	/* will we solve for ionization (FALSE) or specify it with element ionization cmnd TRUE */
	int lgSetIoniz[LIMELM];

	/* the ionization fractsions that are set when above set true,
	 * gas phase abundance is this times total aabundance
	 * Ionization fraction for [nelem][ion] */
	float SetIoniz[LIMELM][LIMELM];

	/* logical flag saying whether to include this element in punch output for AGN tables */
	int lgAGN[LIMELM];

	float SolarSave[LIMELM], 
	  anova[LIMELM], 
	  apn[LIMELM], 
	  ahii[LIMELM], 
	  camern[LIMELM], 
	  aprim[LIMELM], 
	  aism[LIMELM];

	int lgAbnSolar;

	/* solar abundances for the current calculation */
	float solar[LIMELM];

	/*lgAbunTabl says whether this element is to have its abundance
	 *determined from a table (true) or stored constant (false)
	 *set true with element table command */
	int lgAbunTabl[LIMELM], 

	  /* lgAbTaDepth says whether depth or radius, true is depth */
	  lgAbTaDepth[LIMELM], 

	  /* general flag saying this option turned on */
	  lgAbTaON;

#	define	LIMTABD	500

	/*AbTabFac abundances for element table*/
	float AbTabFac[LIMTABD][LIMELM], 

	/*AbTabRad depth scale 
	 *parameters for dlaw table command*/
	  AbTabRad[LIMTABD][LIMELM];

	long int nAbunTabl;

	/*frad is log radius in cm, fhden is log hden*/
	float frad[LIMTABD], 
	  fhden[LIMTABD];

	/*lg is true if depth, false if radius to be used*/
	int lgDLWDepth;

	/*number of values*/
	long int nvals;

	/* indices so that abundances can be in any order */
	long int ipSolar[LIMELM], 
	  npSolar;

	/* scale factors to alter abundances of elements, set with element scale */
	float ScaleElement[LIMELM];

	/* Depletion is set of stored scale factors for depletion of general ism */
	float Depletion[LIMELM], 

	/* depset is unity unless depletion is used */
	  depset[LIMELM];

	/* lgDepln is true if depln used */
	int lgDepln;

	/* scale factor for metals, set with metals command	 */
	float ScaleMetals;

	}	abundances;

