/*ChargTran fill in the HCharExcIon and Rec arrays with Kingdon's fitted CT with H,
 * return value is rate O ionizes H */
void ChargTranEval( double * O_HIonRate );

/* sum up the charge transfer heating */
double ChargTranSumHeat(void);

/* punch charge transfer rate coefficients */
void ChargTranPun( FILE* ipPnunit , char* chPunch );

EXTERN struct t_CharExc {
	/*
	 * ion, nelem
	 * these arrays save the charge transfer ionization and recom
	 * rates for the heavy elements onto hydrogen.  ionization is
	 * of the heavy element, and so is a recom for hydrogen
	 * 
	 * HCharExcIon( ion , nelem ), HCharExcRec( ion , nelem )
	 * charge transfer ionization of atomic oxygen = HCharExcIon[ipOXYGEN][0]*hii
	 * charge transfer recombination of ionized oxygen = HCharExcRec[ipOXYGEN][1]*hi
	 * HCharHeatMax, HCharCoolMax are largest fractions of local heating
	 * or cooling due to ct
	 * HCharHeatOn usually 1, set to 0 with no CTHeat command
	 */
	double HCharExcIon[LIMELM][LIMELM+1], 
	  HCharExcRec[LIMELM][LIMELM+1], 
	  HCharHeatMax, 
	  HCharCoolMax, 
	  HCharHeatOn;

	/* this is total rate (s-1) for ct ionization and recombination of H */
	double HCharExcIonTotal,
	  HCharExcRecTotal;

	/* this is total rate (s-1) for ct ionization and recombination of H */
	double HeCharExcIonTotal,
	  HeCharExcRecTotal;

	/* total cooling due to CT ionization of Hydrogen */
	double HCharExcCooling;

	/* this is the current ratio of ct ionization of H, relative to total dest rate*/
	double HIonFrac;

	/* this is the largest ratio of ct ionization of H, relative to total dest rate*/
	double HIonFracMax;

	/*
	 *this is the charge ionization, recom array
	 *that goes into the ionization balance
	 *Ion[ion] is ionization, Rec[ion] is recombination
	 *it has all He charge transfer rates
	 */
	double HeCharExcIon[LIMELM][LIMELM], 
	  HeCharExcRec[LIMELM][LIMELM];

	/* Dalgarno H charge transfer rate coef for high stages of ionization
	 * default is 1.92e-9 in zero, reset with 'set charge transfer' command */
	double HCTAlex;

	/* variable to turn on or off ct ionization-recombiantion of
	 * hydrogen - set 0 with no charge trasnfer command */
	float HCTOn;

	}	ChargTran;
