/*codriv main driver for heavy molecular equilibrium routines */
void codriv(void);

/* evaluate CO rotation cooling */
void RotateCooling(EmLine ** Rotate , float abund, 	
	/* string used to identify calling program in case of error */
	char *chLabel , float *Cooling , float * dCoolingdT );

EXTERN struct t_co {

	/* limit to ratio CO/Total carbon, used to stop fully molecular
	 * models */
	float COLimit;

	/* CODissHeat is CO Photodissociation heating */
	float CODissHeat, 
	  /* largest fraction of total heating */
	  codfrc, 
	  /* total heating integrated over cloud */
	  codtot;

	/* flag saying that there is lots of CO, triggers lgEndFun stopping model */
	int lgLotsCO;

	/* flag saying some molecular abundances were negative */
	int lgComNeg;

	/* flag saying what fraction of total cooling was carried by CO */
	double COCoolBigFrac;

	/* flag saying CO is important but lines capped by highest level */
	int lgCOCoolCaped;

	/* largest fraction of carbon that was molecular */
	float CarMolFrac;

	}	co;

