/*ConvEdenIoniz called by ConvTempIonz, calls ConvIoniz solving for eden */
/*esum sum free electron density over all species, sets variable erredn.EdenTrue
 *called by ConvEdenIoniz which actually controls the electron density updates */
#include "cddefines.h"
#include "tfidle.h"
#include "phycon.h"
#include "trace.h"
#include "hmi.h"
#include "ionfracs.h"
#include "grainvar.h"
#include "hevmolec.h"
#include "converge.h"
/* limit to how many loops we will do */
#define	LOOPMAX	25
/*esum sum free electron density over all species, sets variable erredn.EdenTrue
 *called by ConvEdenIoniz which actually controls the electron density updates */
static void esum(void);

void ConvEdenIoniz(void)
{
	long int LoopEden ,
		/* this will be LOOPMAX at first, then doubled if no oscillations occur*/
		LoopLimit ;

	static double PreviousEden;
	double 
		/* upper and lower limits to the range of the change we want to consider */
		EdenUpperLimit,
		EdenLowerLimit ,
		factor ,
		PreviousChange ;

#	ifdef DEBUG_FUN
	fputs( "<+>ConvEdenIoniz()\n", debug_fp );
#	endif

	/* this routine is called by ConvTempIonz, it calls ConvIonize
	 * and changes the electron density until it converges */

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, "  \n" );
		fprintf( ioQQQ, " ConvEdenIoniz entered \n" );
	}

	/* >>chng 01 apr 13, move next to calls from here, removing from calling
	 * routines, which had then called here */
	/* update density - temperature variables which may have changed */
	tfidle(FALSE);

	/* the old default solver */
	if( strcmp( conv.chSolverEden , "simple" )== 0 )
	{
		LoopEden = 0;
		conv.nConvIonizFails = 0;

		/* this will be increased by 2x if, at the end, no oscillations have occurred */
		LoopLimit = LOOPMAX;

		/* will be set true if sign of change, ever changes */
		conv.lgEdenOscl = FALSE;

		/* will be used to look for oscillations in the electron density */
		PreviousChange = 0.;

		strcpy( conv.chConvIoniz, " NONE!!!!!" );

		/* this is ionization/electron density convergence loop
		 * keep calling ionize until lgIonDone is true */
		do 
		{
			/* this flag will be set false below if electron density not within tolerance 
			 * after ionization is recomputed */
			conv.lgConvEden = TRUE;

			/* remember the old electron density for possible printout */
			PreviousEden = phycon.eden;

			/* converge the current level of ioinization */
			ConvIoniz();

			/* ESUM sets variable EdenTrue to true elec den but does not change eden */
			esum();

			/* following block is to not let electron density change by
			 * too much
			 * phycon.EdenError is allowed error
			 * the default value of EdenError is 0.01 in zerologic
			 * is changed with the SET EdenError command
			 * PreviousEden was incoming value of eden
			 * EdenTrue is correct value from esum for current ionization
			 * new eden will be set using these, trying to prevent oscillations */

			/* is error larger than the tolerance we are trying to beat? */
			if( 
				(float)fabs(phycon.eden-phycon.EdenTrue)/MIN2((float)phycon.eden,phycon.EdenTrue) >= 
				phycon.EdenError )
			{
				/* diference is assumed and true electron density is larger
				 * than tolerance, we are not yet converged, default is 0.01 */
				conv.lgConvEden = FALSE;
				strcpy( conv.chConvIoniz, "Ne big chg" );

				/* SEARCH is TRUE if this is only search for first solution */
				if( conv.lgSearch )
				{
					phycon.eden = (float)pow(10.,
						(log10(phycon.eden) + log10(phycon.EdenTrue))/ 2.);
				}
				else
				{

					/* was the sign of the change in the electron density changing,
					 * or has it ever changed? */
					if( conv.lgConvEden || PreviousChange*(phycon.EdenTrue-phycon.eden) < 0. )
					{
						/* remember that oscillations are happening  */
						conv.lgEdenOscl = TRUE;

						/* changes in electron density are changing sign - be careful,
						 * factor multiplies the error tolerance on the electron density,
						 * largest change allowed is related to this */
						factor = 0.5;
					}
					else
					{
						/* stable so far . .. */
						/* factor = 2.;*/
						/* had been 2, change to 1 stopped oscillations from developing in 
						 * loc blr grid */
						factor = 1.;
					}

					/* use larger factor if not oscillating and change in eden is large */
					if( !conv.lgEdenOscl && 
						fabs( (phycon.EdenTrue-phycon.eden)/phycon.eden) > 3.*phycon.EdenError)
					{
						/* use 3x larger factor */
						factor *= 3.;
					}

					/* now remember this change for the next time through the loop  */
					PreviousChange = phycon.EdenTrue - phycon.eden ;

					/* is the correct electron density - is it too different? */
					EdenUpperLimit = phycon.eden * (1. + phycon.EdenError*factor);
					EdenLowerLimit = phycon.eden / (1. + phycon.EdenError*factor);

					/* get the new electron density */
					if( phycon.EdenTrue > (float)EdenUpperLimit )
					{
						/* this branch, proposed eden too big */
						phycon.eden = (float)EdenUpperLimit;
					}
					else if( phycon.EdenTrue < (float)EdenLowerLimit )
					{
						/* proposed eden too small */
						phycon.eden = (float)EdenLowerLimit;
					}
					else
					{
						/* eden was within fac of the correct value, use it */
						phycon.eden = (float)phycon.EdenTrue;
					}

					if( trace.lgTrace && trace.lgNeBug )
					{
						fprintf( ioQQQ, 
							"     ConvEdenIoniz, chg ne to%10.3e PreviousEden%10.3e ratio%10.3e EdenTrue=%10.3e\n", 
						  phycon.eden, PreviousEden, phycon.eden/PreviousEden,  phycon.EdenTrue );
					}
				}
				/* we now have the proposed new electron density */

				/* update density and temperature related variables */
				tfidle(FALSE);
			}
			/* >>chng 00 oct 21, did not have this branch before so did not make small changes to
			 * electron density (smaller than size that determined eden not converged */
			/* this branch electron density was pretty close, we just need to make a small update */
			else
			{
				/* electron density has converged 
				 * eden was within fac of the correct value, use it */
				factor = phycon.eden;
				phycon.eden = (float)phycon.EdenTrue;

				if( trace.lgTrConvg>=3 )
				{
					fprintf( ioQQQ, "   ConvEdenIoniz converged eden, calling ConvIoniz with final density\n");
				}

				/* we have changed the density slightly, so now must reevaluate ionization with this new value */
				/* converge the current level of ioinization
				 * but only do this if change was significant */
				if( fabs(factor-phycon.eden)/phycon.eden  > phycon.EdenError/10. )
				{
					ConvIoniz();
				}

				/* ESUM sets variable EdenTrue to true elec den but does not change eden */
				esum();

				/* >>chng 01 mar 14, check whether electron density is no longer converged 
				 * after reevaluating ionization */
				if( 
					(float)fabs(phycon.eden-phycon.EdenTrue)/MIN2((float)phycon.eden,phycon.EdenTrue) >= 
					phycon.EdenError )
				{
					/* diference is assumed and true electron density is larger
					 * than tolerance, we are not yet converged, default is 0.01 */
					conv.lgConvEden = FALSE;
				}
			}
			{
				/*@-redef@*/
				/* debug print statement for change in electron density */
				enum {DEBUG=FALSE};
				/*@+redef@*/
				if( DEBUG )
				{
					fprintf(ioQQQ,"edendebugg %li\t%.2e\t%.2e\t%.2e\t%.2e\n", 
						nzone,phycon.eden ,PreviousEden, (phycon.eden-PreviousEden)/phycon.eden, phycon.EdenTrue);
				}
			}
			if( trace.lgTrace && trace.lgNeBug )
			{
				fprintf( ioQQQ, 
					"     ConvEdenIoniz, chg ne to%10.3e PreviousEden%10.3e ratio%10.3e EdenTrue=%10.3e converge=%c\n", 
				  phycon.eden, PreviousEden, phycon.eden/PreviousEden,  phycon.EdenTrue ,TorF( conv.lgConvEden));
				/* update density and temperature related variables */
				tfidle(FALSE);
			}

			if( trace.lgTrConvg>=3 )
			{
				fprintf( ioQQQ, "   ConvEdenIoniz%4ld new ne=%12.4e true=%12.4e", 
				  LoopEden, phycon.eden ,  phycon.EdenTrue );

				/* this is flag says whether or not eden/eden has converged */
				if( conv.lgConvEden )
				{
					fprintf( ioQQQ, " converged, eden rel error is %g ", 
						(phycon.EdenTrue-phycon.eden)/phycon.EdenTrue );
				}
				else
				{
					fprintf( ioQQQ, " NOCONV corr:%7.3f prop:%7.3f ", 
					   (phycon.EdenTrue-PreviousEden)/PreviousEden , 
						(phycon.eden-PreviousEden)/PreviousEden );
				}
				if( conv.lgEdenOscl )
					fprintf( ioQQQ, " EDEN OSCIL \n");
			}

			/* loop until converged, or we give up */
			++LoopEden;

			/* if last iteration through here and not converged, and no oscillations, 
			 * and no ionization failures ,
			 * then increase limit by 2x */
			if( LoopEden == (LOOPMAX-1) && !conv.lgEdenOscl && conv.nConvIonizFails==0)
				/* double the limit, but only one time, and only if no oscillations */
				LoopLimit *= 2;

		}	while( !conv.lgConvEden && LoopEden < LoopLimit );
	}
	else if( strcmp( conv.chSolverEden , "new" )== 0 )
	{
		/* will be used to look for bracketing in the electron density */
		double PreviousEdenError = 0.;
		double ChangeEdenLast = 0.;
		double CurrentEdenError = 0.;
		double CurrentEden = 0.;
		double ProposedEden,
			FractionChangeEden = 0. ;

		/* new method of converging electron density */
		LoopEden = 0;
		conv.nConvIonizFails = 0;

		/* this will be increased by 2x if, at the end, no oscillations have occurred */
		LoopLimit = LOOPMAX;

		/* will be set true if sign of change, ever changes */
		conv.lgEdenOscl = FALSE;

		/* this is relative change in electron density that we will permit - it will become
		 * smaller each time we bracket the true electron density */
		factor = 0.02;

		strcpy( conv.chConvIoniz, " NONE!!!!!" );

		/* this is ionization/electron density convergence loop
		 * keep calling ionize until lgIonDone is true */
		do 
		{

			/* this flag will be set false below if electron density not within tolerance 
			 * after ionization is recomputed */
			conv.lgConvEden = TRUE;

			if( trace.lgTrConvg>=3 )
				fprintf( ioQQQ, "   ConvEdenIoniz calling ConvIoniz with eden= %.4e\n",phycon.eden);

			/* converge the current level of ioinization */
			ConvIoniz();

			/* ESUM sets variable EdenTrue to true electron density for resulting
			 * level of ionization, but it does not change phycon.eden, the current
			 * assumed electron density */
			esum();

			/* remember the old electron density for possible printout */
			CurrentEden = phycon.eden;

			/* this is the current error in the electron density */
			CurrentEdenError = phycon.EdenTrue - phycon.eden;

			/* phycon.EdenError is allowed error
			 * the default value of EdenError is 0.01 in zerologic
			 * is changed with the SET Eden Error command
			 * PreviousEden was incoming value of eden
			 * EdenTrue is correct value from esum for current ionization
			 * new eden will be set using these, trying to prevent oscillations */

			/* is error larger than the tolerance we are trying to beat?
			 * first check is whether error is very small after very first check, since
			 * ionization soln may not have settled down yet */
			if( 
				(LoopEden==0 && (float)fabs(CurrentEdenError)/phycon.EdenTrue <= phycon.EdenError/2.) ||
				(LoopEden>0 && (float)fabs(CurrentEdenError)/phycon.EdenTrue <= phycon.EdenError 
				&& FractionChangeEden < phycon.EdenError / 2.) )
				break;

			/* diference is assumed and true electron density is larger
			 * than tolerance, we are not yet converged, default is 0.01 */
			conv.lgConvEden = FALSE;
			strcpy( conv.chConvIoniz, "Ne big chg" );

			/* SEARCH is TRUE if this is only search for first solution */
			if( conv.lgSearch )
			{
				phycon.eden = (float)pow(10.,
					(log10(phycon.eden) + log10(phycon.EdenTrue))/ 2.);
			}
			else
			{

				/* was the sign of the change in the electron density changing,
				 * if so then we have bracked the target */
				if( PreviousEdenError*CurrentEdenError < 0. )
				{
					/* we have bracketed the correct electron density, 
					 * make changes smaller, also solve linear equation for zero error */
					double slope = (PreviousEdenError - CurrentEdenError ) /
						( PreviousEden - CurrentEden );

					ProposedEden = PreviousEden - PreviousEdenError / slope;
					/* as sanity check, this must be between the two limits we examined,
					 * since zero was between them */
					assert( ProposedEden >= MIN2( PreviousEden , CurrentEden ) );
					assert( ProposedEden <= MAX2( PreviousEden , CurrentEden ) );

					factor *= 0.25;
					if( trace.lgTrConvg>=3 )
						fprintf( ioQQQ, 
						"   ConvEdenIoniz bracketed electron density factor now %.3e error is %.4f proposed ne %.4e\n",
						factor,
						(phycon.EdenTrue-phycon.eden)/phycon.EdenTrue, ProposedEden);
				}
				else
				{
					/* did not bracket the target, keep moving in its direction */

					/* the correct electron density - is it too different? */
					EdenUpperLimit = phycon.eden * (1. + factor);
					EdenLowerLimit = phycon.eden / (1. + factor);

					/* get the new electron density */
					if( phycon.EdenTrue > (float)EdenUpperLimit )
					{
						/* this branch, proposed eden too big */
						ProposedEden = EdenUpperLimit;
					}
					else if( phycon.EdenTrue < (float)EdenLowerLimit )
					{
						/* proposed eden too small */
						ProposedEden = EdenLowerLimit;
					}
					else
					{
						/* eden was within fac of the correct value, use it */
						ProposedEden = phycon.EdenTrue;
					}
					if( trace.lgTrConvg>=3 )
						fprintf( ioQQQ, 
						"   ConvEdenIoniz electron density factor %.3e error is %.4f proposed ne %.4e\n",
						factor,
						(phycon.EdenTrue-phycon.eden)/phycon.EdenTrue ,
						ProposedEden);
				}

				/* now remember this change for the next time through the loop  */
				PreviousEdenError = CurrentEdenError ;
				PreviousEden = CurrentEden;
				FractionChangeEden = fabs( phycon.eden - ProposedEden ) / phycon.EdenTrue;
				phycon.eden = ProposedEden;
				ChangeEdenLast = fabs( phycon.eden - PreviousEden ) / phycon.EdenTrue;

				if( trace.lgTrace && trace.lgNeBug )
				{
					fprintf( ioQQQ, 
						"     ConvEdenIoniz, chg ne to%10.3e PreviousEden%10.3e ratio%10.3e EdenTrue=%10.3e\n", 
					  phycon.eden, PreviousEden, phycon.eden/PreviousEden,  phycon.EdenTrue );
				}
			}
			/* loop until we give up  --  normal exit is break in center of loop */
			++LoopEden;
		}	while( LoopEden < LoopLimit &&  !conv.lgAbort );

		/* we now have the proposed new electron density */

		/* update density and temperature related variables */
		tfidle(FALSE);

		/* we have changed the density slightly, so now must reevaluate ionization with this new value */
		/* converge the current level of ioinization
		 * but only do this if change was significant */
		if( fabs(phycon.EdenTrue - phycon.eden)/phycon.EdenTrue  > phycon.EdenError/10. )
		{
			if( trace.lgTrConvg>=3 )
				fprintf( ioQQQ, 
				"   ConvEdenIoniz converged eden, but current error is %.4f, so calling ConvIoniz with final density\n",
				(phycon.EdenTrue - phycon.eden)/phycon.EdenTrue);
			phycon.eden = (float)phycon.EdenTrue;
			ConvIoniz();
		}

		/* ESUM sets variable EdenTrue to true elec den but does not change eden */
		esum();

		/* >>chng 01 mar 14, check whether electron density is no longer converged 
		 * after reevaluating ionization */
		if( 
			(float)fabs(phycon.eden-phycon.EdenTrue)/phycon.EdenTrue > 
			phycon.EdenError )
		{
			/* diference is assumed and true electron density is larger
			 * than tolerance, we are not yet converged, default is 0.01 */
			conv.lgConvEden = FALSE;
			if( trace.lgTrConvg>=3 )
				fprintf( ioQQQ, 
				"   ConvEdenIoniz setting eden not converged, error %.4f, exiting\n",
				(phycon.eden-phycon.EdenTrue)/phycon.EdenTrue );
		}
		else
		{
			conv.lgConvEden = TRUE;
		}

		if( trace.lgTrace && trace.lgNeBug )
		{
			fprintf( ioQQQ, 
				"     ConvEdenIoniz, chg ne to%10.3e PreviousEden%10.3e ratio%10.3e EdenTrue=%10.3e converge=%c\n", 
			  phycon.eden, PreviousEden, phycon.eden/PreviousEden,  phycon.EdenTrue ,TorF( conv.lgConvEden));
			/* update density and temperature related variables */
			tfidle(FALSE);
		}

		if( trace.lgTrConvg>=3 )
		{
			fprintf( ioQQQ, "   ConvEdenIoniz%4ld new ne=%12.4e true=%12.4e", 
			  LoopEden, phycon.eden ,  phycon.EdenTrue );

			/* this is flag says whether or not eden/eden has converged */
			if( conv.lgConvEden )
			{
				fprintf( ioQQQ, " converged, eden rel error is %g ", 
					(phycon.EdenTrue-phycon.eden)/phycon.EdenTrue );
			}
			else
			{
				fprintf( ioQQQ, " NOCONV corr:%7.3f prop:%7.3f ", 
				   (phycon.EdenTrue-PreviousEden)/PreviousEden , 
					(phycon.eden-PreviousEden)/PreviousEden );
			}
			if( conv.lgEdenOscl )
				fprintf( ioQQQ, " EDEN OSCIL \n");
		}

	}
	else
	{
		fprintf( ioQQQ, "ConvEdenIoniz finds insane solver%s \n" , conv.chSolverEden );
		ShowMe();
		puts( "[Stop in ConvEdenIoniz]" );
		cdEXIT(1);
	}

	if( trace.lgTrConvg>=3 )
	{
		fprintf( ioQQQ, "   ConvEdenIoniz exits, lgConvEden=%1c \n" , TorF(conv.lgConvEden ) );
	}

#	ifdef DEBUG_FUN
	fputs( " <->ConvEdenIoniz()\n", debug_fp );
#	endif
	return;
}

/*esum sum free electron density over all species, sets variable erredn.EdenTrue
 *called by ConvEdenIoniz which actually controls the electron density updates */
static void esum(void)
{
	long int n, 
	  ion, 
	  nelem;

	double csum, 
	  edmole, 
	  edsave[LIMELM], 
	  osum;

#	ifdef DEBUG_FUN
	fputs( "<+>esum()\n", debug_fp );
#	endif

	/* EdenExtra is normally zero, set with EDEN command, to add extra e-
	 * EdenSet is normally zero, set with SET EDEN command, to set e- */
	phycon.EdenTrue = (float)(xIonFracs[ipHYDROGEN][2] + xIonFracs[ipHELIUM][2] + 
		2.*xIonFracs[ipHELIUM][3] + phycon.EdenExtra);

	/* add on molecules */
	edmole = phycon.EdenTrue;

	phycon.EdenTrue += hmi.h2plus + hevmolec.hevmol[ipCHP] + hevmolec.hevmol[ipOHP] + 
	  hevmolec.hevmol[ipCOP] + hevmolec.hevmol[ipH2OP] + hevmolec.hevmol[ipO2P] + 
	  hevmolec.hevmol[ipC2P] + hevmolec.hevmol[ipH3OP] + hevmolec.hevmol[ipCH2P] + 
	  hmi.h3plus;

	/* remember electron density from molecules */
	edmole = phycon.EdenTrue - edmole;

	/* pgrains */
	/* >>chng 00 dec 19, include electrons on grains in total sum */
	phycon.EdenTrue += (float)gv.TotalEden;

	/* sum over all metals */
	phycon.EdenMet = 0.;
	/* free free sum should not include hydrogenic since already done
	 * indpenedently in coolr*/
	phycon.EdenFFSum = 0.;
	for( nelem=2; nelem < LIMELM; nelem++ )
	{
		edsave[nelem] = 0.;
		for( ion=2; ion <= nelem; ion++ )
		{
			/* >>chng 96 oct 27, save all contributors to electron density */
			edsave[nelem] += (float)(ion-1)*xIonFracs[nelem][ion];
			phycon.EdenFFSum += POW2( (float)(ion-1) )*xIonFracs[nelem][ion];
		}
		/* add on hydrogenic specides since now counted in free free sum */
		edsave[nelem] += (float)(nelem)*xIonFracs[nelem][nelem+1];
		phycon.EdenMet += (float)edsave[nelem];
	}

	phycon.EdenTrue += phycon.EdenMet;

	/* this variable is set with the set eden command, 
	 * is supposed to override physical electron density */
	if( phycon.EdenSet > 0. )
	{
		phycon.EdenTrue = phycon.EdenSet;
	}

	/* get all electrons not due to hydrogen */
	phycon.EdenNotH = phycon.EdenTrue - xIonFracs[ipHYDROGEN][2];

	if( phycon.EdenTrue < 0. )
	{
		fprintf(ioQQQ,"ESUM finds EdenTrue negative before H-, =%e\n", phycon.EdenTrue);
		ShowMe();
		puts( "[Stop in esum]" );
		cdEXIT(1);
	}

	/* >>chng 97 mar 18, some extreme models have H- density very large during
	 * 666 Error! cap below should be elsewhere, this sub should produce TrueEden
	 *search phase when far from solution.  do not let eden go neg */
#if 0
	if( search.lgSearch )
	{
		phycon.EdenTrue -= (float)MIN2(phycon.EdenTrue*0.05,hmi.hminus);
	}
	else
	{
		phycon.EdenTrue -= (float)MIN2(phycon.EdenTrue/100.,hmi.hminus);
	}
#	endif
	/* >>chng 01 jan 08, following logic added to stop H- from forcing
	 * negative electron density during very first search, when H- is off */
	/* correct for hminus, and flag error if we go negative */
	if( hmi.hminus > phycon.EdenTrue )
	{
		phycon.EdenTrue -= (float)MIN2(phycon.EdenTrue*0.05,hmi.hminus);
	}
	else
	{
		phycon.EdenTrue -= hmi.hminus;
	}

 	if( trace.lgTrace )
	{
		csum = 0.;
		for( ion=1; ion <= 6; ion++ )
		{
			csum += (float)(ion)*xIonFracs[ipCARBON][ion+1];
		}

		osum = 0.;
		for( ion=1; ion <= 8; ion++ )
		{
			osum += (float)(ion)*xIonFracs[ipOXYGEN][ion+1];
		}

		fprintf( ioQQQ, 
			"     ESUM: zone %li True:%11.4e old:%11.4e hcorr:%.2e ff sum:%10.3e H:%8.2e He:%8.2e\n",
		  nzone,
		  phycon.EdenTrue, 
		  phycon.eden, 
		  phycon.EdenHCorr,
		  phycon.EdenFFSum, 
		  xIonFracs[ipHYDROGEN][2], 
		  xIonFracs[ipHELIUM][2] + 2.*xIonFracs[ipHELIUM][3]);

		fprintf( ioQQQ, 
			"     ESUM: cont C:%8.2e O:%8.2e met:%8.2e mol:%8.2e\n", 
		  csum, osum, phycon.EdenMet, edmole );

		if( trace.lgNeBug )
		{
			fprintf( ioQQQ, "     ESUM: heav" );
			for(n=2; n < LIMELM; n++)
			{
				fprintf( ioQQQ, " %8.1e", edsave[n] );
			}
			fprintf( ioQQQ, "\n" );
		}
	}

	if( phycon.EdenTrue <= 0. )
	{
		fprintf( ioQQQ, "ESUM finds non-positive electron density.\n" );
		fprintf( ioQQQ, 
			"     ESUM: EdenTrue to%12.4e fm%12.4e ff sum;%10.3e Ne(H):%10.2e Ne(He):%10.2e Ne(C):\n", 
		  phycon.EdenTrue, 
		  phycon.eden, 
		  phycon.EdenFFSum, 
		  xIonFracs[ipHYDROGEN][2], 
		  xIonFracs[ipHELIUM][2] + 2.*xIonFracs[ipHELIUM][3] );
		ShowMe();
		puts( "[Stop in esum]" );
		cdEXIT(1);
	}

	if(  gv.TotalEden/phycon.EdenTrue > 0.01 )
	{
		fprintf(ioQQQ," esum finds grains have %g percent of the electrons.\n",
			gv.TotalEden/phycon.EdenTrue*100.);
	}

	{
		/*@-redef@*/
		enum {DEBUG=FALSE};
		/*@+redef@*/
		if( DEBUG )
		{
			fprintf(ioQQQ,"esumdebugg\t%li\t%.2e\t%.2e\n",
				nzone,
			  phycon.eden, phycon.EdenTrue);
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->esum()\n", debug_fp );
#	endif
	return;
}

