/*colzro set cooling and heating stack to zero */
void colzro(void);

/*coladd add coolants to the cooling stack, called in evaluation of cooling function */
void coladd(char *chLabel, 
  float xlambda, 
  double cool);

/*CoolSum  total cooling from all entries into cooling stack */
void CoolSum(double *total);

/* cooling functions for the heavy elements */
void CoolAlum(void);
void CoolArgo(void);
void CoolCalc(void);
void CoolCarb(void);
void CoolChlo(void);
void CoolChro(void);
void CoolCoba(void);
void CoolDima(void);
void CoolFluo(void);
void CoolIron(void);
void CoolMagn(void);
void CoolMang(void);
void CoolNeon(void);
void CoolNick(void);
void CoolNitr(void);
void CoolOxyg(void);
void CoolPhos(void);
void CoolPota(void);
void CoolScan(void);
void CoolSili(void);
void CoolSodi(void);
void CoolSulf(void);
void CoolTita(void);
void CoolVana(void);

#define	NCOLNT	10000L

EXTERN struct t_cooling {

	/*
	 *     remember strongest coolants
	 *
	 *     these save arrays of line heating and cooling
	 *     coladd is called by n level cooling routines, and coladd
	 *     fills in cooling (cooling) or heating (heatnt)
	 *     heatnt is always positive, although it is negative cooling
	 */
	float collam[NCOLNT];
	double cooling[NCOLNT], 
	  heatnt[NCOLNT];
	long int ncltot;
	char chClntLab[NCOLNT][5];

	/*
	 *set false during during search for equilibrium temp
	 *check whether to complain about negative cooling
	 */
	int lgColNeg;

	/*
	 *flag set true during cooling map, saying to keep cool even
	 *if cooling is negative
	 */
	int lgCNegChk;

	/*
	 *     max of negative coolants, and a pointer to it
	 */
	float CoolHeatMax;
	float wlCoolHeatMax;
	char chCoolHeatMax[5];

	/* integrated cooling over model */
	double totcol, 

	  /* cooling in this zone */
	  ctot, 

	  /* heatl is total line heating, t(ipLnHeat) */
	  heatl,  

	  /*coolheat is other coolants that were heat sources */
	  coolheat, 

	  /*grossheat is heat from agent that is added as heat-cooling*/
	  GrossHeat; 

	/* derivative of cooling wrt temperature */
	double dCooldT;

	/* derivative of cooling, 1/te^2, .5/T */
	float tsq1, 
	  halfte;

	/* derivative of cooling less heating wrt temperature */
	double dCoolmHeatdT;

	/*
	 *info about 'extra' cooling, lgCextOn says it is on
	 */
	int lgCExtraOn;
	float CoolExtra, 
	  cextpw;

	}	cooling;
