/*CoolNeon evaluate total cooling due to neon */
#include "cddefines.h"
#include "coolheavy.h"
#include "taulines.h"
#include "phycon.h"
#include "embesq.h"
#include "poplevls.h"
#include "ligbar.h"
#include "cooling.h"
#include "level2.h"
#include "putcs.h"
#include "atomseqberyllium.h"
#include "level3.h"
#include "pop3.h"
#include "popexc.h"
#include "ionfracs.h"

void CoolNeon()
{
	double a21, 
	  a31, 
	  a32,
	  cs2s2p, 
	  cs2s3p; 
	float 
	  cs, 
	  pop2;

#	ifdef DEBUG_FUN
	fputs( "<+>CoolNeon()\n", debug_fp );
#	endif

	/* Neon II 12.8 micron
	 * >>refer	ne2	cs	Saraph, H.E. & Tully, J.A. 1994, A&AS, 107, 29 */
	cs = (float)MIN2(0.4,0.1294*phycon.te10/phycon.te02*phycon.te005);
	cs = (float)MAX2(0.272,cs);
	PutCS(cs,&TauLines[ipTNe13]);

	level2(&TauLines[ipTNe13]);

	/* Ne III fine structure lines
	 * >>refer	ne3	cs	Butler, K., & Zeippen, C.J. 1994, A&AS, 108, 1 */
	PutCS(0.774,&TauLines[ipTNe16]);
	PutCS(0.244,&TauLines[ipTNe36]);
	PutCS(0.208,&TauDummy);

	level3(&TauLines[ipTNe16],&TauLines[ipTNe36],&TauDummy);

	/* Ne III 3869+3968, 3343, A's 
	 * >>refer	ne3	as	Mendoza, C. 1982, in Planetary Nebulae, IAU Symp No. 103,
	 * >>refercon ed by D.R. Flower, (D. Reidel: Holland), 143
	 * CS 
	 * >>refer	ne3	cs	Butler, K., & Zeippen, C.J. 1994, A&AS, 108, 1 */
	if( phycon.te < 1e4 )
	{
		cs = 0.269f;
	}
	else
	{
		cs = (float)MIN2(0.333,0.1142*(phycon.te10/phycon.te003/phycon.te003/
		  phycon.te001));
	}
	/* POP3(G1,G2,G3,O12,O13,O23,A21,A31,A32,E12,E23,P2,ABUND,GAM2) */
	CoolHeavy.c3343 = pop3(9.,5.,1.,1.348,0.151,cs,0.209,2.052,2.677,
	  3.583e4,4.301e4,&pop2,xIonFracs[ipNEON][3],0.)*2.677*5.954e-12;
	CoolHeavy.c3869 = pop2*0.209*5.14e-12;
	cooling.dCooldT += CoolHeavy.c3869*(3.72e4*cooling.tsq1 - cooling.halfte);
	coladd("Ne 3",3342,CoolHeavy.c3343);
	coladd("Ne 3",3869,CoolHeavy.c3869);
	coladd("Ne 3",1793,CoolHeavy.c3343*1.38);

	/* Ne IV 2425.4+2422.8  A'S from 
	 * >>refer	ne4	as	Zeippen, C.J. 1982, MNRAS 198 111
	 * Ne IV CS from 
	 * >>refer	ne4	cs	Giles, K. 1981, MNRAS, 195, 63
	 * above gave table, actually used, but following is most recent
	 * calculation, in great agreement, but only gives figures
	 * >>refer	ne4	cs	Ramsbottom, C.A., Bell, K.L., & Keenan, F.P. 1998, MNRAS, 293, 233 
	 * POP3(G1,G2,G3,O12,O13,O23,A21,A31,A32,E12,E23,P2,ABUND,GAM2) */
	a21 = 2.46e-3;
	a31 = 1.02;
	a32 = 0.693;
	CoolHeavy.c4720 = pop3(4.,10.,6.,1.37,0.464,2.14,a21,a31,a32,5.94e4,
	  3.05e4,&pop2,xIonFracs[ipNEON][4],0.)*a32*4.22e-12;
	CoolHeavy.c2424 = pop2*8.21e-12*a21;
	coladd("Ne 4",2424,CoolHeavy.c2424);
	coladd("Ne 4",4720,CoolHeavy.c4720);
	coladd("Ne 4",1602,CoolHeavy.c4720*4.1);

	/* Ne V 3426, CS data from 
	 * >>refer	ne5	cs	Lennon, D.J. & Burke, V.M. 1991, MNRAS 251, 628
	 * revised from 
	 * >>refer	ne5	cs	Lennon, D.J. Burke, V.M. 1994, A&AS, 103, 273
	 * A's from 
	 * >>refer	ne5	as	Baluja, K.L. 1985, J.Phys. B, 18, L413
	 * POP3(G1,G2,G3,O12,O13,O23,A21,A31,A32,E12,E23,P2,ABUND,GAM2) */
	CoolHeavy.c2975 = pop3(9.,5.,1.,2.18,0.254,0.688,0.521,4.35,2.76,
	  4.297e4,4.835e4,&pop2,xIonFracs[ipNEON][5],0.)*2.76*6.69e-12;
	/* following are old values
	 * C2975 = POP3( 9.,5.,1., 1.8,0.25,0.52, 0.521,4.34,2.76,
	 *  1 4.297E4,4.835E4, POP2 , ANEON(5),0.) * 2.76*6.69E-12 */
	CoolHeavy.c1565 = CoolHeavy.c2975*1.901*1.572;
	CoolHeavy.c3426 = pop2*0.521*5.81e-12;
	cooling.dCooldT += CoolHeavy.c3426*(4.20e4*cooling.tsq1 - cooling.halfte) + 
	  (CoolHeavy.c2975 + CoolHeavy.c1565)*9.132e4*cooling.tsq1;
	coladd("Ne 5",2975,CoolHeavy.c2975);
	coladd("Ne 5",1565,CoolHeavy.c1565);
	coladd("Ne 5",3426,CoolHeavy.c3426);

	/* Ne V 24.2, 14.3 micron
	 * CS from 
	 * >>refer	ne5	cs	Lennon, D.J. Burke, V.M. 1994, A&AS, 103, 273
	 * A's from 
	 * >>refer	ne5	as	Baluja, K.L. 1985, J.Phys. B, 18, L413 */
	cs = (float)MIN2(1.84,21.12/(phycon.te10*phycon.te10*phycon.te10/
	  phycon.te003/phycon.te003));
	PutCS(cs,&TauLines[ipTNe24]);
	cs = (float)MIN2(9.5,261.71/(phycon.te10*phycon.te10*phycon.te10*
	  phycon.te10*phycon.te01*phycon.te003));
	PutCS(cs,&TauLines[ipTNe14]);
	cs = (float)MIN2(3.2,139.86/(phycon.sqrte/phycon.te03*phycon.te003/
	  phycon.te001));
	PutCS(cs,&TauDummy);
	level3(&TauLines[ipTNe24],&TauLines[ipTNe14],&TauDummy);

	/* Ne V 5S - 3P, CS 
	 * >>refer	ne5	cs	Lennon, D.J. Burke, V.M. 1994, A&AS, 103, 273
	 * A from 
	 * >>refer	ne5	cs	Mendoza, C. 1982, in Planetary Nebulae, IAU Symp No. 103,
	 * >>refercon ed by D.R. Flower, (D. Reidel: Holland), 143
	 * 666 error! transfer these lines */
	CoolHeavy.c1134 = popexc(11.9/(phycon.te10*phycon.te10*phycon.te03),
	  9.,5.,4.67e3,1.273e5,xIonFracs[ipNEON][5])*1.767e-11;
	coladd("Ne 5",1134,CoolHeavy.c1134);

	/* Ne VI 7.6 micron, A from 
	 * >>refer	ne6	as	Froese Fischer, C. 1983, J.Phys. B, 16, 157
	 * cs from 
	 * >>refer	ne6	cs	Zhang, H.L., Graziani, M., Pradhan, A.K. 1994, A&A, 283, 319
	 * >>chng 96 jul 16 had been just constant 2.0  */
	cs = (float)MIN2(3.71,23.623/(phycon.te20*phycon.te02/phycon.te003));
	PutCS(cs,&TauLines[ipxNe0676]);
	level2(&TauLines[ipxNe0676]);
	/* fs76 = popexc(0.37,2.,4.,1.9E-2,1.89E3,xIonFracs(10,6))*2.62E-13
	 * dCooldT = dCooldT + fs76*(1890.*tsq1-halfte)
	 * call coladd( 'Ne 6' , 76 , FS76 )
	 *
	 * Ne VII col data from 
	 * >>refer	ne7	cs	Berrington, K.A., Burke, P.G., Dufton, P.L., Kingston, A.E. 1985,
	 * >>refercon At. Data Nucl. Data Tables, 33, 195
	 * low te from 
	 * >>refer	ne7	cs	Dufton, P.L., Doyle, J.G., Kingston, A.E. 1979, A&A, 78, 318
	 * newer fit to 
	 * >>refer	ne7	cs	Ramsbottom, C.A., Berrington, K.A., Bell, K.L. 1995,
	 * >>refercon At. Data Nucl. Data Tables, 61, 105 */
	if( phycon.te < 4e4 )
	{
		cs = (float)(0.0352*(phycon.te20/phycon.te03));
	}
	else
	{
		cs = (float)(0.736/(phycon.te10*phycon.te02/phycon.te003));
	}
	/* >>chng 01 sep 09, AtomSeqBeryllium will reset this to 1/3 so critical density correct */
	PutCS(cs,&TauLines[ipT895]);
	/* BESEQ(CS23,CS24,CS34,tarray,A41)
	 * c895 = AtomSeqBeryllium(.52,.61, 2.0,t895,.0578) * 2.223E-11
	 * A's 
	 * >>refer	ne7	as	Fleming, J., Bell, K.L, Hibbert, A., Vaeck, N., Godefroid, M.R.
	 * >>refercon 1996, MNRAS, 279, 1289 */
	AtomSeqBeryllium(.52,.61,2.0,&TauLines[ipT895],.07066);
	embesq.em895 = (float)(PopLevls.PopLevels[3]*0.0578*2.223e-11);

	/* Ne VIII 774, iso with 1549, extrapolation for omega
	 * >>refer	ne8	??	Cochrane, D.M., & McWhirter, R.W.P. 1983, PhyS, 28, 25 */
	ligbar(10,&TauLines[ipT770],&TauLines[ipT88],&cs2s2p,&cs2s3p);
	PutCS(cs2s2p,&TauLines[ipT770]);
	PutCS(cs2s2p*0.5,&TauLines[ipT780]);
	PutCS(1.0,&TauDummy);
	level3(&TauLines[ipT780],&TauDummy,&TauLines[ipT770]);

	PutCS(cs2s3p,&TauLines[ipT88]);
	level2(&TauLines[ipT88]);

#	ifdef DEBUG_FUN
	fputs( " <->CoolNeon()\n", debug_fp );
#	endif
	return;
}

