/*CoolSili compute silicon cooling */
#include "cddefines.h"
#include "coolheavy.h"
#include "taulines.h"
#include "phycon.h"
#include "poplevls.h"
#include "ionfracs.h"
#include "ligbar.h"
#include "makecs.h"
#include "cooling.h"
#include "atomseqboron.h"
#include "level2.h"
#include "putcs.h"
#include "atomseqberyllium.h"
#include "level3.h"
#include "pop3.h"
#include "popexc.h"
#include "expion.h"
#include "embesq.h"

void CoolSili()
{
	double cs, 
	  cs2s2p, 
	  cs2s3p, 
	  cs01, 
	  cs02, 
	  cs12;
	float
	  p2;
	
#	ifdef DEBUG_FUN
	fputs( "<+>CoolSili()\n", debug_fp );
#	endif

	/* Si I 2518 */
	MakeCS(&TauLines[ipSii2518]);
	level2(&TauLines[ipSii2518]);

	/* Si I 2215 */
	MakeCS(&TauLines[ipSii2215]);
	level2(&TauLines[ipSii2215]);

	/* Silicon II 35 micron; elec cs from 
	 *>>refer	si2	cs	Dufton, P.L., & Kingston, A.E. 1994, At. Data Nucl. Data Tables,
	 *>>refercon 57, 273 */
	cs = 5.77;
	/* hydrogen collision strength from 
	 * >>refer	si2	cs	Tielens, A.G.G., & Hollenbach, D. 1985, ApJ, 291, 722
	 * they give rate de-ex 6.5E-10 cm^3 s^-1, indep of temp */
	cs += 6.5e-10/phycon.cdsqte*4.*xIonFracs[ipHYDROGEN][1];
	PutCS(cs,&TauLines[ipTSi35]);
	/*level2(&TauLines[ipTSi35]);*/
	/*AtomSeqBoron compute cooling from 5-level boron sequence model atom */
	/* >>refer	s4	cs	Tayal, S.S., 2000, ApJ 530, 1091*/
	/*>>refer	si2 cs Dufton, P.L., & Kingston, A.E., 1991, MNRAS, 248, 827*/
	/*>>refer	si2 as Dufton, P.L., Keenan, F.P., Hibbert, A., 
	 *>>rerercon Stafford, R.P., Byrne, P.B., & Agnew, D., 1991, MNRAS, 253, 474*/
	AtomSeqBoron(&TauLines[ipTSi35], 
	  &TauLines[ipSi2_2334], 
	  &TauLines[ipSi2_2329], 
	  &TauLines[ipSi2_2350], 
	  &TauLines[ipSi2_2344], 
	  &TauLines[ipSi2_2336], 
	  0.534 , 4.51 , 1.67 , 6.94 , "Si 2");

	/* Si II  2337, atomic data from 
	 * >>refer	si2	cs	Dumont, A.M., & Mathez, G. 1981, A&A, 102, 1
	 * coll str 
	 * >>refer	si2	cs	Dufton, P.L., & Kingston, A.E. 1991, MNRAS, 248, 827
	 * also 
	 * >>refer	si2	cs	Mendoza, C. 1982, in Planetary Nebulae, IAU Symp No. 103,
	 * >>refercon	ed by D.R. Flower, (D. Reidel: Holland), 143 */
#	if 0
	cs = MIN2(6.0,15.836/(phycon.te10*phycon.te02/phycon.te003));
	PutCS(5.5,&TauLines[ipT2335]);
	level2(&TauLines[ipT2335]);
#	endif

	/* Si II 1808, permitted resonance line,
	 * osc str from 
	 * >>refer	si2	as	morton et al 88 (apj sup); 
	 * all si ii collision data (following 4 lines) are from
	 * >>refer	si2	cs	Dufton, P.L., & Kingston, A.E. 1991, MNRAS, 248, 827
	 * following assumes there is typo in table 1 of dufton and kingston
	 * and that they meant 2s 2p^2 ^2D instead of 3d */
	PutCS(13.01,&TauLines[ipT1808]);
	level2(&TauLines[ipT1808]);

	PutCS(3.61,&TauLines[ipT1527]);
	level2(&TauLines[ipT1527]);

	PutCS(2.89,&TauLines[ipT1305]);
	level2(&TauLines[ipT1305]);

	PutCS(12.25,&TauLines[ipT1260]);
	level2(&TauLines[ipT1260]);

	/* permitted Si III 1206.5, collision strength from 
	 * >>refer	si3	cs	Callaway, J. 1994, At. Data Nucl. Data Tables, 57, 9 */
	cs = MIN2(7.0,1.442*phycon.te10*phycon.te03*phycon.te03/
	  phycon.te01);
	PutCS(cs,&TauLines[ipT1207]);
	level2(&TauLines[ipT1207]);

	/* Si III] 1895, CS=
	 * >>refer	si3	cs	Dufton, P.L., & Kingston, A.E. 1989, MNRAS, 241, 209
	 * >>refer	si3	cs	Dufton, P.L., & Kingston, A.E. 1994, ADNDT, 57, 273
	 * grnd 3s^2 ^1S, upper lev 3p ^3P^o j=0,1,2 */
	/* >>refer	si3	as	Callegari, F., & Trigueiros, A.G., 1998, ApJS, 119, 181
	 * >>chng 00 nov 01, A about 3x larger than before */
	cs = 106./(phycon.te10*phycon.te10*phycon.te10*phycon.te02);
	/* >>chng 01 sep 09, AtomSeqBeryllium will reset this to 1/3 so critical density correct */
	PutCS(cs,&TauLines[ipT1895]);
	AtomSeqBeryllium(1.8,3.6,10.4,&TauLines[ipT1895],.013);
	embesq.em1895 = (float)(PopLevls.PopLevels[3]*0.013*1.05e-11);

	/* Si IV 1394, 1403, data from 
	 * >>refer	si4	as	Mendoza, C. 1982, in Planetary Nebulae, IAU Symp No. 103,
	 * >>refercon	ed by D.R. Flower, (D. Reidel: Holland), 143
	 * cs from 
	 * >>refer	si4	cs	Dufton, P.L., & Kingston, A.E. 1987, J.Phys. B, 20, 3899 */
	cs = 6.37*phycon.te10;
	PutCS(cs*0.667,&TauLines[ipT1394]);
	PutCS(cs*0.333,&TauLines[ipT1403]);
	PutCS(1.0,&TauDummy);
	level3(&TauLines[ipT1403],&TauDummy,&TauLines[ipT1394]);

	/* Si VI 1.96 micron
	 * >>refer	si6	cs	Saraph, H.E. & Tully, J.A. 1994, A&AS, 107, 29
	 * >>chng 96 jul 16 had been constant */
	cs = MIN2(0.43,0.0448*phycon.te20/phycon.te003/phycon.te003);
	cs = MAX2(0.3,cs);
	PutCS(cs,&TauLines[ipSi619]);
	level2(&TauLines[ipSi619]);

	/* Si VII 2148- OIII like, 
	 * >>refer	si7	cs	Kafatos, M., & Lynch, J.P. 1980, ApJS, 42, 611 */
	CoolHeavy.c2148 = 
		popexc(0.4,9.,5.,15.,6.7e4,xIonFracs[13][7])*9.26e-12;
	coladd("Si 7",2148,CoolHeavy.c2148);

	/* Si VII ground term, 2.48, 6.51 microns
	 * cs 
	 * >>refer	si7	cs	Butler, K., & Zeippen, C.J. 1994, A&AS, 108, 1 */
	cs = MIN2(0.217,0.0904*phycon.te05*phycon.te03/phycon.te003/
	  phycon.te001);
	PutCS(cs,&TauLines[ipTSi65]);
	cs = MIN2(0.70,8.79e-2*phycon.te10*phycon.te10/phycon.te02);
	PutCS(cs,&TauLines[ipTSi25]);
	cs = MIN2(0.20,9.751e-3*phycon.te20*phycon.te03*phycon.te03/
	  phycon.te003);
	PutCS(cs,&TauDummy);
	level3(&TauLines[ipTSi25],&TauLines[ipTSi65],&TauDummy);

	/* Si 8 1446, 3727-like, 
	 * >>refer	si8	cs	Kafatos, M., & Lynch, J.P. 1980, ApJS, 42, 611 */
	CoolHeavy.c1446 = 
		popexc(0.4,4.,10.,1.,9.97e4,xIonFracs[13][8])*
	  1.39e-11;
	coladd("Si 8",1446,CoolHeavy.c1446);

	/* Si 9 1985, 2150
	 * cs, As from
	 * >>refer	si9	cs	Aggarwal, K.M. 1983, J.Phys. B, 16, L59
	 * >>refer	si9	as	Baluja, K.L. 1985, J.Phys. B, 18, L413 */
	CoolHeavy.c949 = 
		pop3(9.,5.,1.,0.5913,0.0757,0.225,26.3,214.,5.16,
	  7.62e4,7.902e4,&p2,xIonFracs[13][9],0.)*214.*2.096e-11;
	CoolHeavy.c1815 = CoolHeavy.c949*1.912*0.0516;
	CoolHeavy.c1985 = p2*26.3*1.0e-11;
	coladd("Si 9",949,CoolHeavy.c949);
	coladd("Si 9",1815,CoolHeavy.c1815);
	coladd("Si 9",1985,CoolHeavy.c1985);

	/* Si 9 3P fine structure lines, A=
	 * >>refer	si9	as	Baluja, K.L. 1985, J.Phys. B, 18, L413
	 * 2.583, 3.9microns
	 * CS=
	 * >>refer	si9	cs	Lennon, D.J. Burke, V.M. 1994, A&AS, 103, 273 */
	cs01 = MIN2(0.98,28.51/(phycon.te10*phycon.te10*phycon.te10*
	  phycon.te10/phycon.te03*phycon.te003*phycon.te001*phycon.te001));

	cs12 = MIN2(2.7,81.21/(phycon.te10*phycon.te10*phycon.te10*
	  phycon.te10/phycon.te01/phycon.te01/phycon.te001/phycon.te001));

	cs02 = MIN2(0.70,19.67/(phycon.te10*phycon.te10*phycon.te10*
	  phycon.te10/phycon.te03*phycon.te001));

	PutCS(cs01,&TauLines[ipTSi4]);
	PutCS(cs12,&TauLines[ipTSi3]);
	PutCS(cs02,&TauDummy);

	level3(&TauLines[ipTSi4],&TauLines[ipTSi3],&TauDummy);

	/* 5S0 - 3P, cs from, A=guess
	 * >>refer	si9	cs	Aggarwal, K.M. 1984, ApJS, 54, 1 */
	CoolHeavy.c691 = popexc(40.6/phycon.sqrte*phycon.te10,9.,5.,
	  1e4,2.081e5,xIonFracs[13][9])*2.88e-11;
	coladd("Si 9",691,CoolHeavy.c691);

	/* Si 10 606, actually four lines clumped together.
	 * atomic data 
	 * >>refer	si10	cs	Saha, H.P., & Trefftz, E. 1982, A&A, 116, 224 */
	CoolHeavy.c606 = 
		0.10*1.42e-16*expion(2.4e5,xIonFracs[13][10]);
	coladd("Si10",606,CoolHeavy.c606);

	/* Si 10 1.43m, A from 
	 * >>refer	si10	as	Chandra, S. 1982, SoPh, 75, 133
	 * cs from 
	 * >>refer	si10	cs	Zhang, H.L., Graziani, M., Pradhan, A.K. 1994, A&A, 283, 319 */
	if( phycon.te <= 40500. )
	{
		cs = 0.190*phycon.te20/phycon.te001;
	}
	else
	{
		cs = 24.93/(phycon.te20*phycon.te03*phycon.te01*phycon.te003*
		  phycon.te003);
	}
	PutCS(cs,&TauLines[ipSi10143]);
	level2(&TauLines[ipSi10143]);

	/* SI 11 582.9, 1909-LIKE, CS=
	 * >>refer	si11	cs	Berrington, K.A., Burke, P.G., Dufton, P.L., Kingston, A.E.
	 * >>refercon	1985, At. Data Nucl. Data Tables, 33, 195
	 * A=
	 * >>refer	si11	as	Muhlethaler, H.P., & Nussbaumer, H. 1976, A&A 48, 109 */
	CoolHeavy.c583 = 
		popexc(0.10,1.,9.,1e5,2.47e5,xIonFracs[13][11])*
	  3.4e-11;
	coladd("Si11",583,CoolHeavy.c583);

	/* li seq 2s2p and 2s3p, Si 12 499, 521
	 * >>refer	si12	cs	Cochrane, D.M., & McWhirter, R.W.P. 1983, PhyS, 28, 25 */
	ligbar(14,&TauLines[ipTSi499],&TauLines[ipTSi41],&cs2s2p,&cs2s3p);
	PutCS(cs2s2p,&TauLines[ipTSi499]);
	PutCS(cs2s2p*0.5,&TauLines[ipTSi521]);
	PutCS(1.0,&TauDummy);
	level3(&TauLines[ipTSi521],&TauDummy,&TauLines[ipTSi499]);

	PutCS(cs2s3p,&TauLines[ipTSi41]);
	level2(&TauLines[ipTSi41]);

#	ifdef DEBUG_FUN
	fputs( " <->CoolSili()\n", debug_fp );
#	endif
	return;
}
