/* CoStarCompile rebin costar stellar models to match energy grid of code*/
void CoStarCompile(void);

/*CoStarInterpolate read in and interpolate on Werner grid of PN atmospheres, by K Volk */
void CoStarInterpolate(
	/* number of points in the output continuum, will be ncell */
	long int *nstar, 
	/* which interpolation mode is requested
	 * intmode = 1: use temp and nmodid
	 * intmode = 2: use temp and logg
	 * intmode = 3: use M_ZAMS and age */
	int intmode,
	/* Teff for intmode = 1,2; M_ZAMS for intmode = 3 */
	double temp, 
	/* not valid for intmode = 1; log(g) for intmode = 2; age for intmode = 3 */
	double logg,
	/* the index number for the model sequence, only valid for intmode = 1 */
	int nmodid ,
	/* flag indicating whether solar (==0) or halo (==1) abundances */
	int iabund );
