/*GetGF convert oscillator strength into Einstein A */
#include "cddefines.h"
#include "getgf.h"

double GetGF(double eina, 
	  double enercm, 
	  double gup)
{
	double GetGF_v;

#	ifdef DEBUG_FUN
	fputs( "<+>GetGF()\n", debug_fp );
#	endif

	assert( enercm > 0. );
	assert( eina > 0. );
	assert( gup > 0.);

	/* derive the transition prob, given the following
	 * call to function is gf, ener in cm^-1, g_up
	 * gf is product of g and oscilator strength
	 * eina = ( GetGF/gup) / 1.499e-8 / ( 1e4/enercm )**2 */
	GetGF_v = eina*gup*1.499e-8*POW2(1e4/enercm);


#	ifdef DEBUG_FUN
	fputs( " <->GetGF()\n", debug_fp );
#	endif
	return( GetGF_v );
}

