/*H1cs123 hydrogen collision data levels involving 1s,2s,2p,3. */
#include "cddefines.h"
#include "phycon.h"

double H1cs123(long int i, 
  long int j, 
  long int chType)
{
	long int k, 
	  l, 
	  _r;
	double H1cs123_v, 
	  T, 
	  TeUse, 
	  Tmax1, 
	  Tmax2, 
	  Tmax3, 
	  Tmin, 
	  bk, 
	  cs, 
	  cs3d, 
	  cs3p, 
	  cs3s, 
	  ev, 
	  rate, 
	  ryd, 
	  te03, 
	  te05, 
	  te10, 
	  te20;
	static double b[10][11];
	static int _aini = 1;
	if( _aini ){ /* Do 1 TIME INITIALIZATIONS! */
		{ static double _itmp0[] = {2.5501041e-01,9.973588e-02,-5.404749e-02,
		  2.520311e-02,-4.05306e-03,3.508995e-02,28.056,7.2945,0.0,
		  0.0,3.6105477e-01,1.73103797,3.7297254e-01,-4.3240114e-01,
		  1.4296095e-01,-1.670572e-02,0.0,0.0,0.0,0.0,6.461453e-02,
		  -1.1160826e-01,7.6957269e-01,-2.18918875,3.14216481,-2.23498961,
		  6.2651998e-01,1.12515e-02,28.056,7.2945,9.895325e-02,2.3240113e-01,
		  2.0112555e-01,8.7813331e-01,-3.34239518,3.7075526,-1.37320827,
		  0.0,0.0,0.0,5.742134e-02,-6.09531e-03,9.3848281e-01,-3.40393911,
		  5.50742903,-4.25196238,1.2687104,7.24136e-03,28.056,7.2945,
		  1.2168,4.7349,6.5942,-14.9419,10.7255,-3.3407,0.3823,0.0,
		  0.0,0.0,1.9985,13.2632,11.9120,-13.0364,5.6720,-1.2155,0.1034,
		  0.0,0.0,0.0,0.9382,32.8948,-17.9286,-0.8772,5.8667,-2.4439,
		  0.3147,0.0,0.0,0.0,2.0097,3.7515,-7.9734,10.9359,-7.1074,
		  2.1359,-0.2405,0.0,0.0,0.0,6.5316,26.8258,-18.2834,2.22,
		  4.1958,-2.0916,0.289,0.0,0.0,0.0,8.9833,126.0513,-21.9017,
		  20.7445,-20.3788,7.3643,-0.9082,0.0,0.0,0.0};

		for( k=1, _r = 0; k <= 11; k++ )
		{
			for( l=1; l <= 10; l++ )
			{
				b[l-1][k-1] = _itmp0[_r++];
				}
			}
		}
		_aini = 0;
	}

#	ifdef DEBUG_FUN
	fputs( "<+>H1cs123()\n", debug_fp );
#	endif

	/* These are fits given by 
	 *  >>refer	h1	cs	Callaway, J. 1994, At. Data Nucl. Data Tables, 57, 9
	 * H I collision strengths for 1s-2s, 1s-2p, 1s-3, 2s-3, and 2p-3, 
	 * principle quantum numbers n and l.
	 * CLOUDY sums angular momentum (s,p,d) components of level n=3.
	 *
	 * SEE IMPORTANT NOTE BELOW ABOUT EST. VALID ENERGY RANGES OF FITS.
	 ************************************************************************
	 *
	 * i is the lower level and runs from 1 to 3 (1s, 2s, 2p)
	 * j is the upper level and runs from 2 to 4 (2s, 2p, 3)
	 * */
	/* Callaway's fits use 10 variables and there are 11 transitions: */

	/* across are coef. to each transtion, down are the transitions */

	/* some constants
	 * */
	ev = 1.60184e-12;
	bk = 1.380622e-16;
	ryd = 13.60583;

	/* convert temperature T (K) to energy in Rydbergs
	 * */
	T = bk*phycon.te/(ev*ryd);

	/**********************************************************
	 *************-----------IMPORTANT------------*************
	 **********************************************************
	 *
	 * The Callaway fits to effective cross-sections are high-order 
	 * polynomials which become insane not too far from the  
	 * unstated upper energy limits, given below. 
	 * Fits are more stable at low energy and here the validity 
	 * of cross-sections limits the validity of the fits.
	 *
	 * Energy limits of validity:
	 * minimum energy = 0.01 Rydbergs (about 1580K)
	 * */
	Tmin = 0.01;

	/* 1s - 2s,2p maximum energy = 4 Rydbergs (~ 632,000K)
	 * */
	Tmax1 = 4.0;

	/* 1s - 3 max energy is 1.2667 Rydberg (200,000K)
	 * */
	Tmax2 = 1.2667;

	/* 2s,p - 3 max energy is 1.0 Rydberg (158,888K)
	 * */
	Tmax3 = 1.0;

	/**********************************************************
	 * initialize cs */
	cs = 0.;

	/**************fits begin here**************
	 * */
	if( i == 1 && j == 2 )
	{

		/* 1s - 2s (first entry)
		 *
		 * check temperature:  */
		TeUse = MIN2(T,Tmax1);
		T = MAX2(TeUse,Tmin);

		cs = 0.;
		for( k=0; k < 5; k++ )
		{
			cs += b[k][0]*powi(T,k);
		}

		H1cs123_v = cs + b[5][0]*log(b[6][0]*T)*exp(-b[7][0]*T);
	}

	else if( i == 1 && j == 3 )
	{

		/* 1s - 2p (second entry)
		 *
		 * check temperature:  */
		TeUse = MIN2(T,Tmax1);
		T = MAX2(TeUse,Tmin);

		cs = 0.;
		for( k=0; k < 6; k++ )
		{
			cs += b[k][1]*powi(T,k);
		}
		H1cs123_v = cs;
	}

	else if( i == 1 && j == 4 )
	{

		/* 1s - 3s (third entry)
		 *
		 * check temperature:  */
		TeUse = MIN2(T,Tmax2);
		T = MAX2(TeUse,Tmin);

		cs3s = 0.;
		for( k=0; k < 7; k++ )
		{
			cs3s += b[k][2]*powi(T,k);
		}

		cs3s += b[7][2]*log(b[8][2]*T)*exp(-b[9][2]*T);

		/* 1s - 3p (fourth entry) */
		cs3p = 0.;
		for( k=0; k < 7; k++ )
		{
			cs3p += b[k][3]*powi(T,k);
		}

		/* 1s - 3d (fifth entry) */
		cs3d = 0.;
		for( k=0; k < 7; k++ )
		{
			cs3d += b[k][4]*powi(T,k);
		}

		cs3d += b[7][4]*log(b[8][4]*T)*exp(-b[9][4]*T);

		/* Summed cs: 1s - 3  */
		H1cs123_v = cs3s + cs3p + cs3d;
	}

	else if( i == 2 && j == 4 )
	{

		/* 2s - 3s (sixth entry)
		 *
		 * check temperature:  */
		TeUse = MIN2(T,Tmax3);
		T = MAX2(TeUse,Tmin);

		cs3s = 0.;
		for( k=0; k < 7; k++ )
		{
			cs3s += b[k][5]*powi(T,k);
		}

		/* 2s - 3p (seventh entry) */
		cs3p = 0.;
		for( k=0; k < 7; k++ )
		{
			cs3p += b[k][6]*powi(T,k);
		}

		/* 2s - 3d (eighth entry) */
		cs3d = 0.;
		for( k=0; k < 7; k++ )
		{
			cs3d += b[k][7]*powi(T,k);
		}

		/* Summed cs: 2s - 3  */
		H1cs123_v = cs3s + cs3p + cs3d;
	}

	else if( i == 3 && j == 4 )
	{
		/* 2p - 3s (ninth entry)
		 *
		 * check temperature:  */
		TeUse = MIN2(T,Tmax3);
		T = MAX2(TeUse,Tmin);

		cs3s = 0.;
		for( k=0; k < 7; k++ )
		{
			cs3s += b[k][8]*powi(T,k);
		}

		/* 2p - 3p (tenth entry) */
		cs3p = 0.;
		for( k=0; k < 7; k++ )
		{
			cs3p += b[k][9]*powi(T,k);
		}

		/* 2p - 3d (eleventh entry) */
		cs3d = 0.;
		for( k=0; k < 7; k++ )
		{
			cs3d += b[k][10]*powi(T,k);
		}

		/* Summed cs: 2p - 3 */
		H1cs123_v = cs3s + cs3p + cs3d;
	}

	else if( i == 2 && j == 3 )
	{
		/* 2p - 2s 
		 * */
		te20 = pow(phycon.te,.2f);
		te03 = pow(phycon.te,.03f);
		te10 = pow(phycon.te,.10f);
		te05 = pow(phycon.te,.05f);
		if( chType == 'e' )
		{
			rate = 5.738e-4/(te20*te20/te03);
		}
		else
		{
			rate = 6.290e-4/(te10*te05);
		}
		/*  convert to a cs */
		H1cs123_v = rate*sqrt(phycon.te)*6./8.629e-6;

	}
	else
	{
		fprintf( ioQQQ, "  insane levels for H I n=1,2,3 !!!\n" );
		fprintf( ioQQQ, "%4ld%4ld\n", i, j );
		puts( "[Stop in h1cs123]" );
		H1cs123_v = 0.;
		cdEXIT(1);
	}

#	ifdef DEBUG_FUN
	fputs( " <->H1cs123()\n", debug_fp );
#	endif
	return( H1cs123_v );
}

