/* these are the hydrogenic routines written by Robert Bauman           */
/*      For references, see h_bauman.c                                  */
/************************************************************************/
/*  IN THE FOLLOWING WE HAVE  n > n'                                    */
/************************************************************************/

/* returns hydrogenic photoionization cross section in cm-2             */
double H_photo_cs( 
                  /* incident photon energy                             */
                  double ejected_electron_energy, 
                  /* principal quantum number, 1 for ground             */
                  long int n, 
                  /* angular momentum, 0 for s                          */
                  long int l, 
                  /* charge, 1 for H+, 2 for He++, etc                  */
                  long int iz );

/************************************************************************/
/*   Calc the Oscillator Strength f(*) given by                         */
/*                                                                      */
/*                     E(n,l;n',l')     max(l,l')  |              | 2   */
/*   f(n,l;n',l') = -  ------------   ------------ | R(n,l;n',l') |     */
/*                      3 R_oo         ( 2l + 1 )  |              |     */
/*                                                                      */
/*       f(n,l;n',l') is dimensionless.                                 */
/*                                                                      */  
/*   See for example Gordan Drake's                                     */
/*      Atomic, Molecular, & Optical Physics Handbook pg.638            */
/*                                                                      */
/*  In the following, we have n > n'                                    */
/************************************************************************/
double OscStr_f(/*  IN THE FOLLOWING WE HAVE  n > n'                    */
                /* principal quantum number, 1 for ground, upper level  */
                long int n,
                /* angular momentum, 0 for s                            */
                long int l,
                /* principal quantum number, 1 for ground, lower level  */
                long int np,
                /* angular momentum, 0 for s                            */
                long int lp,
                /* Nuclear charge, 1 for H+, 2 for He++, etc            */
                long int iz
                );

/************************************************************************/
/*   Calculates the Einstein A's for hydrogen                           */
/*   for the transition n,l --> n',l'                                   */
/*   units of sec^(-1)                                                  */
/*                                                                      */
/*  In the following, we have n > n'                                    */
/************************************************************************/
double H_Einstein_A(/*  IN THE FOLLOWING WE HAVE  n > n'                        */
                    /* principal quantum number, 1 for ground, upper level      */
                    long int n,
                    /* angular momentum, 0 for s                                */
                    long int l,
                    /* principal quantum number, 1 for ground, lower level      */
                    long int np,
                    /* angular momentum, 0 for s                                */                  
                    long int lp,
                    /* Nuclear charge, 1 for H+, 2 for He++, etc                */                  
                    long int iz
                    );



/************************************************************************/
/*      This routine, hri(), calculates the hydrogen radial intergral,  */
/*      for the transition n,l --> n',l'                                */
/*      It is, of course, dimensionless.                                */
/*                                                                      */
/*  In the following, we have n > n'                                    */
/************************************************************************/
double hri(
           /* principal quantum number, 1 for ground, upper level       */
           long int n,
           /* angular momentum, 0 for s                                 */
           long int l,
           /* principal quantum number, 1 for ground, lower level       */
           long int np,
           /* angular momentum, 0 for s                                 */                  
           long int lp,
           /* Nuclear charge, 1 for H+, 2 for He++, etc                 */
           long int iz
           );

/******************************************************************************/
/******************************************************************************/
/*     Semi-Classical Quantum Defect Radial Integral                          */
/*     See for example                                                        */
/*     Atomic, Molecular & Optical Physics Handbook                           */
/*     Gordon W. F. Drake; Editor                                             */
/*     AIP Press                                                              */
/*     Woddbury, New York.                                                    */
/*     1996                                                                   */
/*                                                                            */
/******************************************************************************/
/******************************************************************************/

/* scqdri() returns -1.0 on error or domain out of range.                     */

/******************************************************************************/
/*   This routine calculates the semi-classical approximation for the         */
/*   dipole moment corresponding to the transition form the state (n,l)       */
/*   to (n`,l`). Here have n > n`( or np). We include the effect of the       */
/*   quantum defect (qd) in the effective quantum number n*(nstar) so that    */
/*   n* = n - qd. Similiarly n`* = n` - qd`.                                  */
/*                                                                            */
/* The routine actually returns the SQUARE of the dipole moment R^2(nl;n`l`). */
/******************************************************************************/
double scqdri( 
            double nstar,
            long int l, 
            double npstar, 
            long int lp, 
            double iz 
            ); 

