/*he1gma evaluate photoionization rates for helium singlets */
#include "cddefines.h"
#include "nhe1lvl.h"
#include "he1crt.h"
#include "he1ind.h"
#include "iso.h"
#include "rfield.h"
#include "phe1lv.h"
#include "heat.h"
#include "ip2gam.h"
#include "hydrogenic.h"
#include "secondaries.h"
#include "opacity.h"
#include "trace.h"
#include "heopfr.h"
#include "nhe1.h"
#include "hhe1.h"
#include "he1nionryd.h"
#include "gammas.h"
#include "photrate.h"
#include "he1.h"

void he1gma( void )
{
	long int i, 
	  n;
	float g2elec, 
	  rectot;
	static double ghe1[9], 
	  he1cn[NHE1LVL], 
	  p1, 
	  p2;

#	ifdef DEBUG_FUN
	fputs( "<+>he1gma()\n", debug_fp );
#	endif

	/* photoionization rates
	 * He I ground state ionization
	 *
	 * photoionization He */
	/* with induced recombination, PhotScaleOn is 1, set to
	 * zero with 'no photoionization' command */
	ghe1[0] = GammaBn(nhe1Com.nhe1[0],ip2gam.ip2ePhoto-1,opac.iophe1[0],
	  1.808,&he1ind.he1qin[0],&he1cn[0])*PhotRate.PhotScaleOn;

	hhe1Com.hhe1[0] = heat.HeatNet*PhotRate.PhotScaleOn;
	PhotRate.PhotoRate[0][0][0][1] = ghe1[0];
	PhotRate.PhotoRate[1][0][0][1] = heat.HeatLowEnr*PhotRate.PhotScaleOn;
	PhotRate.PhotoRate[2][0][0][1] = heat.HeatHiEnr*PhotRate.PhotScaleOn;

	/* now add on rest of integral; these energies can double photoionize */
	g2elec = (float)(GammaBn(ip2gam.ip2ePhoto,rfield.nflux,opac.iophe1[0]+
	  ip2gam.ip2ePhoto-nhe1Com.nhe1[0],1.808,&p1,&p2)*PhotRate.PhotScaleOn);

	hhe1Com.hhe1[0] += heat.HeatNet*PhotRate.PhotScaleOn;
	/* >>chng 00 nov 06, following had ghe1[0] rather than g2elec,
	 * had no effect since not used anywhere */
	PhotRate.PhotoRate[0][0][0][1] += g2elec;
	PhotRate.PhotoRate[1][0][0][1] += heat.HeatLowEnr*PhotRate.PhotScaleOn;
	PhotRate.PhotoRate[2][0][0][1] += heat.HeatHiEnr*PhotRate.PhotScaleOn;

	if( trace.lgTrace && trace.lgHeBug )
	{
		GammaPrt(nhe1Com.nhe1[0],rfield.nflux,opac.iophe1[0],
		  ioQQQ,ghe1[0]+g2elec,(ghe1[0]+g2elec)*0.05);
	}

	he1ind.he1qin[0] += p1;
	he1cn[0] += p2;
	ghe1[0] += g2elec;

	/* gamma => 2 elec cross section - double photoionization 
	 * >>refer	he1	photo	Brown, Robert L., 1970, Phys Rev A, 1, 586,
	 * >>refer	he1	photo	Brown, Robert L., 1970, Phys Rev A, 1, 341 */
	g2elec *= 0.03f;

	/* HeII LA and diffuse continua */
	phe1lv.he1gam[0] = ghe1[0];

	/* He I n>=2 state ionization */
	/* F2 is related to induced rec rate, HE1CN(N) is related to cooling */
	for( n=1; n < NHE1LVL; n++ )
	{
		ghe1[n] = GammaBn(nhe1Com.nhe1[n],nhe1Com.nhe1[0],opac.iophe1[n],
		  He1NIonRyd.He1IonRyd[n],&he1ind.he1qin[n],&he1cn[n])*
		  PhotRate.PhotScaleOn;
		hhe1Com.hhe1[n] = heat.HeatNet;
		phe1lv.he1gam[n] = ghe1[n];
	}

	/*  induced recombination rate */
	he1ind.he1rin[0] = he1ind.he1qin[0]*he1crt.he1lte[0];
	he1ind.he1rin[1] = he1ind.he1qin[1]*(he1crt.he1lte[1] + he1crt.he1lte[9]);

	for( n=2; n < NHE1LVL; n++ )
	{
		/* induced recombination rate */
		he1ind.he1rin[n] = he1crt.he1lte[n]*he1ind.he1qin[n];
	}

	/* >>chng 02 jan 19, kill excited state photoionization with case b no photo*/
	/* option for case b conditions, kill all excited state photionizations */
	if( opac.lgCaseB_no_photo )
	{
		for( n=1; n < NHE1LVL; n++ )
		{
			ghe1[n] = 0.;
			he1ind.he1qin[n] = 0.;
			he1cn[n] = 0.;;
			hhe1Com.hhe1[n] = 0.;
			phe1lv.he1gam[n] = 0.;
		}
	}

	if( trace.lgTrace && trace.lgHeBug )
	{
		rectot = phe1lv.he1rec[ipRecNetEsc][0]*phe1lv.he1rec[0][0];
		for( i=1; i < NHE1LVL; i++ )
		{
			rectot += phe1lv.he1rec[ipRecNetEsc][i]*phe1lv.he1rec[0][i];
		}

		fprintf( ioQQQ, 
			"     He sin Gam:%10.2e RadRec:%10.2e G eff%10.2e GndDrate%10.2e FrOp(other)%10.2e csup%10.2e\n", 
		  phe1lv.he1gam[0], rectot, phe1lv.he1rec[ipRecNetEsc][0], ghe1[0], 
		  heopfr.ophe1f[0], Secondaries.csupra );
	}

	if( trace.lgTrace && (trace.lgHe1Bug || trace.lgHeBug) )
	{
		if( phe1lv.he1gam[0] > 0. )
		{
			fprintf( ioQQQ, 
				"     HE1GAMgr ate%10.2e pht frac Prim%10.2e ots228%10.2e\n", 
			  phe1lv.he1gam[0], ghe1[0]/phe1lv.he1gam[0], 
			  rfield.otscon[iso.ipIsoLevNIonCon[ipHYDROGEN][1][ipH1s]-1]*1.75e-18/phe1lv.he1gam[0] );
		}
		else
		{
			fprintf( ioQQQ, "     HE1GAMgr pht frac = none.\n" );
		}
	}

	if( trace.lgTrace && trace.lgHe1Bug )
	{
		fprintf( ioQQQ, "     HE1GMA finds photo rates:" );
		for( i=1; i <= 9; i++ )
		{
			fprintf( ioQQQ, "%2ld%10.2e", i, phe1lv.he1gam[i-1] );
		}
		fprintf( ioQQQ, "\n" );
	}


#	ifdef DEBUG_FUN
	fputs( " <->he1gma()\n", debug_fp );
#	endif
	return;
}

