/*He2cs123 line collision strengths for lower levels of helium ion, n=1,2,3, by K Korista */
#include "cddefines.h"
#include "phycon.h"

double He2cs123(long int i, 
  long int j)
{
	double He2cs123_v, 
	  cs3d, 
	  cs3p, 
	  cs3s, 
	  t;
	static double a[11]={0.12176209,0.32916723,0.46546497,0.044501688,
	  0.040523277,0.5234889,1.4903214,1.4215094,1.0295881,4.769306,
	  9.7226127};
	static double b[11]={0.039936166,2.9711166e-05,-0.020835863,3.0508137e-04,
	  -2.004485e-15,4.41475e-06,1.0622666e-05,2.0538877e-06,0.80638448,
	  2.0967075e-06,7.6089851e-05};
	static double c[11]={143284.77,0.73158545,-2.159172,0.43254802,
	  2.1338557,8.9899702e-06,-2.9001451e-12,1.762076e-05,52741.735,
	  -2153.1219,-3.3996921e-11};

#	ifdef DEBUG_FUN
	fputs( "<+>He2cs123()\n", debug_fp );
#	endif

	/* These are fits to Table 2
	 * >>refer	he2	cs	Aggarwal, K.M., Callaway, J., Kingston, A.E., Unnikrishnan, K.
	 * >>refercon	1992, ApJS, 80, 473
	 * He II collision rates for 1s-2s, 1s-2p, 1s-3, 2s-3, and 2p-3, 
	 * principal quantum numbers n and l.
	 * CLOUDY sums angular momentum (s,p,d) components of level n=3.
	 *
	 * i is the lower level and runs from 1 to 3 (1s, 2s, 2p)
	 * j is the upper level and runs from 2 to 4 (2s, 2p, 3)
	 * check temperature: fits only good between 5,000K and 500,000K
	 * */
	/* array for fits of 11 transitions see the code below for key: */

	t = phycon.te;
	if( t < 5000. )
	{
		t = 5000.;
	}
	else if( t > 5.0e05 )
	{
		t = 5.0e05;
	}

	/**************fits begin here**************
	 * */
	if( i == 1 && j == 2 )
	{
		/* 1s - 2s (first entry) */
		He2cs123_v = a[0] + b[0]*exp(-t/c[0]);
		/*  He2Rate123 = cs*8.629e-6/SQRT(te)/2.
		 * */
	}
	else if( i == 1 && j == 3 )
	{
		/* 1s - 2p (second entry) */
		He2cs123_v = a[1] + b[1]*pow(t,c[1]);
		/*  He2Rate123 = cs*8.629e-6/SQRT(te)/6.
		 * */
	}
	else if( i == 1 && j == 4 )
	{
		/* 1s - 3s (third entry) */
		cs3s = a[2] + b[2]*log(t) + c[2]/log(t);

		/* 1s - 3p (fourth entry) */
		cs3p = a[3] + b[3]*pow(t,c[3]);

		/* 1s - 3d (fifth entry) */
		cs3d = a[4] + b[4]*pow(t,c[4]);

		/* 1s - 3 sum */
		He2cs123_v = cs3s + cs3p + cs3d;
		/*  He2Rate123 = cs*8.629e-6/SQRT(te)/18.
		 * */
	}
	else if( i == 2 && j == 4 )
	{
		/* 2s - 3s (sixth entry)         */
		cs3s = (a[5] + c[5]*t)/(1 + b[5]*t);

		/* 2s - 3p (seventh entry) */
		cs3p = a[6] + b[6]*t + c[6]*t*t;

		/* 2s - 3d (eighth entry) */
		cs3d = (a[7] + c[7]*t)/(1 + b[7]*t);

		/* 2s - 3 sum */
		He2cs123_v = cs3s + cs3p + cs3d;
		/*  He2Rate123 = cs*8.629e-6/SQRT(te)/18.
		 * */
	}
	else if( i == 3 && j == 4 )
	{
		/* 2p - 3s (ninth entry) */
		cs3s = a[8] + b[8]*exp(-t/c[8]);

		/* 2p - 3p (tenth entry) */
		cs3p = a[9] + b[9]*t + c[9]/t;

		/* 2p - 3d (eleventh entry) */
		cs3d = a[10] + b[10]*t + c[10]*t*t;

		/* 2p - 3 sum */
		He2cs123_v = cs3s + cs3p + cs3d;
		/*  He2Rate123 = cs*8.629e-6/SQRT(te)/18.
		 * */
	}
	else
	{

		/**************fits end here************** */
		fprintf( ioQQQ, "  insane levels for He II n=1,2,3 !!!\n" );
		puts( "[Stop in he2cs123]" );
		cdEXIT(1);
	}

#	ifdef DEBUG_FUN
	fputs( " <->He2cs123()\n", debug_fp );
#	endif
	return( He2cs123_v );
}

