/*compute radiative rates for helium triplets */
#include "cddefines.h"
#include "taulines.h"
#include "he3tau.h"
#include "he3as.h"
#include "d10830.h"
#include "trace.h"
#include "he3.h"

void he3rad(void)
{

#	ifdef DEBUG_FUN
	fputs( "<+>he3rad()\n", debug_fp );
#	endif

	/* notation;
	 * 1-2S  2-2P  3-3S  4-3P  5-3D */

	he3as.a10830 = (float)(1.02e7*he3tau[IPT10830-1].Pesc);
	d10830.DR10830 = (float)(1.02e7*he3tau[IPT10830-1].Pdest);

	d10830.r10830 = (float)(he3as.a10830 + d10830.DR10830);
	if( trace.lgTrace && trace.lgHe3Bug )
	{
		fprintf( ioQQQ, 
			" HE3RAD called, e10830=%g %g d10830= %g %g.\n" ,
			he3as.a10830, he3tau[IPT10830-1].Pesc ,
			d10830.DR10830 , he3tau[IPT10830-1].Pdest);
	}

	/*printf(" DF10830 %e  %e\n", he3as.a10830, d10830.DR10830);*/
	he3as.a3889 = (float)(9.48e6*he3tau[IPT3889-1].Pesc);
	he3as.a5876 = (float)(7.06e7*he3tau[IPT5876-1].Pesc);
	he3as.a7065 = (float)(2.78e7*he3tau[IPT7065-1].Pesc);
	he3as.a4 = 1.08e6f;
	he3as.a19 = 1.28e4f;
	he3as.a591 = 176.f;
	/* >>chng 01 mar 11, from 1.13e-4 to 1.27e-4 - updated Aup */
	he3as.a2sg = 1.27e-4f;

#	ifdef DEBUG_FUN
	fputs( " <->he3rad()\n", debug_fp );
#	endif
	return;
}

