/* hevmolec.h */
#define	NHEVML	18

#define	ipCH	0
#define	ipCHP	1
#define	ipOH	2
#define	ipOHP	3
#define	ipOTWO	4
#define	ipCTWO	5
#define	ipCO	6
#define	ipCOP	7
#define	ipH2O	8
#define	ipH2OP	9
#define	ipO2P	10
#define	ipC2P	11
#define	ipH3P	12
#define	ipH3OP	13
#define	ipCH2P	14
#define	ipCH2	15
#define	ipCH3	16
#define	ipCP	17

EXTERN struct t_hevmolec {
	float hevmol[NHEVML], 
	  hevcol[NHEVML], 
	  HevMolSav[NHEVML];

	/* abundance ratio C12O16 to C13O16, init in zero.c  */
	float RatioC12O16_2_C13O16;
	}	hevmolec;

/*
 *molecules of the heavy elements.  order must exactly match that in hevcolumn
 *number of molecules in heavy element network
 *
 *     this is the explicit version of this common
 *
 *
 *     real ch,chp,oh,ohp,otwo,ctwo,co,cop,h2o,h2op,o2p,c2p,
 *    1 h3p,h3op,ch2p,ch2,ch3,cp
 *     old equil (hevmol(1),ch), (hevmol(2),chp), (hevmol(3),oh),
 *    1 (hevmol(4),ohp), (hevmol(5),otwo), (hevmol(6),ctwo),
 *    2 (hevmol(7),co), (hevmol(8),cop), (hevmol(9),h2o),
 *    3 (hevmol(10),h2op), (hevmol(11),o2p), (hevmol(12),c2p),
 *    4 (hevmol(13), h3p), (hevmol(14),h3op), (hevmol(15),ch2p),
 *    5 (hevmol(16),ch2), (hevmol(17),ch3), (hevmol(18),cp) 
 *
 *column densities of molecules
 *     real chk,chpk,ohk,ohpk,otwok,ctwok,cok,copk,h2ok,h2opk,
 *    1 o2pk,c2pk,h3pk,h3opk,ch2pk,ch2k,ch3k,cpk
 *     old equil (hevcol(1),chk), (hevcol(2),chpk), (hevcol(3),ohk),
 *    1 (hevcol(4),ohpk), (hevcol(5),otwok), (hevcol(6),ctwok),
 *    2 (hevcol(7),cok), (hevcol(8),copk), (hevcol(9),h2ok),
 *    3 (hevcol(10),h2opk), (hevcol(11), o2pk), (hevcol(12),c2pk),
 *    4 (hevcol(13),h3pk), (hevcol(14),h3opk), (hevcol(15),ch2pk),
 *    5 (hevcol(16),ch2k), (hevcol(17),ch3k), (hevcol(18),cpk)
 */
