/*HydroCool compute net cooling due to hydrogenc atom species, ground state 
 * photoionization of hydrogenic species done in sumheat */
#include "cddefines.h"
#include "physconst.h"
#include "taulines.h"
#include "hydrogenic.h"
#include "chargtran.h"
#include "phycon.h"
#include "iso.h"
#include "heat.h"
#include "hfbnet.h"
#include "ionfracs.h"
#include "cooling.h"

void HydroCool(
	   /* iso sequence, 0 for hydrogenic */
	   long int ipISO , 
		/* nelem is charge -1, so 0 for H itself */
		long int nelem)
{
	long int ipHi, 
	  ipLo, 
	  n;
	double RecCoolError, 
	  dbarest, 
	  tcoola, 
	  dhexdt, 
	  *dhone,  /* will become save arrays dimd nhlvl+1*/
	  dhrest, 
	  drestly, 
	  edenIonAbund, 
	  ChargeSquared,
	  hex, 
	  HeatExcited,
	  *hexx,  /* will become save arrays dimd nhlvl+1*/
	  *hlone, /* will become save arrays dimd nhlvl+1*/
	  ThinCoolingCaseB, 
	  ThinCoolingSum;

	double *SavePhotoHeat ,
		*SaveInducCool ,
		*SaveRadRecCool , 
		biggest =0.;

	/* these are labels for hydrogen line cooling, sum of ALL hydrogen lines */
	static char chHlin[LIMELM][5]=
	{"Hl 0","Hl 1","Hl 2","Hl 3","Hl 4","Hl 5","Hl 6","Hl 7","Hl 8","Hl 9",
	 "Hl10","Hl11","Hl12","Hl13","Hl14","Hl15","Hl16","Hl17","Hl18","Hl19",
	 "Hl20","Hl21","Hl22","Hl23","Hl24","Hl25","Hl26","Hl27","Hl28","Hl29"};

	/* these are labels for hydrogen collisional ionization cooling */
	static char chHion[LIMELM][5]=
	{"Hi 0","Hi 1","Hi 2","Hi 3","Hi 4","Hi 5","Hi 6","Hi 7","Hi 8","Hi 9",
	 "Hi10","Hi11","Hi12","Hi13","Hi14","Hi15","Hi16","Hi17","Hi18","Hi19",
	 "Hi20","Hi21","Hi22","Hi23","Hi24","Hi25","Hi26","Hi27","Hi28","Hi29"};

	/* these are labels for hydrogen photoionization heating */
	static char chHp[LIMELM][5]=
	{"Hp 0","Hp 1","Hp 2","Hp 3","Hp 4","Hp 5","Hp 6","Hp 7","Hp 8","Hp 9",
	 "Hp10","Hp11","Hp12","Hp13","Hp14","Hp15","Hp16","Hp17","Hp18","Hp19",
	 "Hp20","Hp21","Hp22","Hp23","Hp24","Hp25","Hp26","Hp27","Hp28","Hp29"};

	/* these are labels for hydrogen induced recombination heating */
	static char chHn[LIMELM][5]=
	{"Hn 0","Hn 1","Hn 2","Hn 3","Hn 4","Hn 5","Hn 6","Hn 7","Hn 8","Hn 9",
	 "Hn10","Hn11","Hn12","Hn13","Hn14","Hn15","Hn16","Hn17","Hn18","Hn19",
	 "Hn20","Hn21","Hn22","Hn23","Hn24","Hn25","Hn26","Hn27","Hn28","Hn29"};

#	ifdef DEBUG_FUN
	fputs( "<+>HydroCool()\n", debug_fp );
#	endif

	/* validate the incoming data */
	assert( nelem >= 0 );
	assert( nelem < LIMELM );

	/* for zero abundance we need to set some produced variables to zero */
	if( xIonFracs[nelem][nelem+2] <= 0. )
	{
		/* all global variables must be zeroed here or set below */
		hydro.chion[nelem] = 0.;
		hydro.coola[nelem] = 0.;
		hydro.restly[nelem] = 0.;
		hydro.barest[nelem] = 0.;
		hydro.hrest[nelem] = 0.;
		hydro.HLineTotCool[nelem] = 
		hydro.HRadRecCool[nelem] = 0.;
		HFBNet.HFreBndNet[nelem] = 0.;
		HFBNet.crcind[nelem] = 0.;
		fixit();/* this looks like a bug - shouldn't ALL hydrogenic species
				 * be done here, not just H itself */
		/* hydrogenic species are special cases since their
		 * ground state heating is evaluated here rather than in bidiag */
		if( nelem <= 1 )
		{
			/* heating by ground of hydrogen and Helium ion
			 * heavies were done in bidiag */
			heat.heating[nelem][nelem] = 0.;
		}

#		ifdef DEBUG_FUN
		fputs( " <->HydroCool()\n", debug_fp );
#		endif
		return;
	}

	/* now make some space */
	dhone = (double *)MALLOC( (unsigned)(iso.nLevels[ipISO][nelem])*sizeof(double) );
	hexx = (double *)MALLOC( (unsigned)(iso.nLevels[ipISO][nelem])*sizeof(double) );
	hlone = (double *)MALLOC( (unsigned)(iso.nLevels[ipISO][nelem])*sizeof(double) );
	SavePhotoHeat = (double *)MALLOC( (unsigned)(iso.nLevels[ipISO][nelem])*sizeof(double) );
	SaveInducCool = (double *)MALLOC( (unsigned)(iso.nLevels[ipISO][nelem])*sizeof(double) );
	SaveRadRecCool = (double *)MALLOC( (unsigned)(iso.nLevels[ipISO][nelem])*sizeof(double) );

	if( dhone==NULL || hexx==NULL || hlone==NULL || SavePhotoHeat==NULL || 
		SaveInducCool==NULL || SaveRadRecCool==NULL)
	{
		fprintf( ioQQQ," could not MALLOC space for scratch arrays\n");
		puts( "[Stop in HydroCool]" );
		cdEXIT(1);
	}

	/* this is energy factor that will appear in some places below */
	ChargeSquared = POW2(nelem+1.);

	/* compute the total cooling due to the hydrogen atom, and its derivative
	 * halfte is 1/(2T) */

	/***********************************************************************
	 *                                                                     *
	 * collisional ionization cooling, less three-body recombination  heat *
	 *                                                                     *
	 ***********************************************************************/

	/* hex will be net collisional ionization cooling, units erg/cm^3/s */
	hex = 0.;
	dhexdt = 0.;

	/* collisional ionization cooling, three body heating 
	 * highest level is fastest collision by far, its coupling to
	 * continuum can overwhelm heating, so only count nearly up to the top */
	/*for( n=ipH1s; n <= (iso.nLevels[ipISO][nelem] - 2); n++ )*/
	for( n=ipH1s; n < iso.nLevels[ipISO][nelem]; n++ )
	{
		/* total collisional ionization cooling less three body heating */
		hexx[n] = 
		  iso.xIsoLevNIonRyd[ipISO][nelem][n]*iso.ColIoniz[ipISO][nelem][n]*phycon.EdenHCorr*
		  (iso.Pop2Ion[ipISO][nelem][n] -iso.PopLTE[ipISO][nelem][n]*phycon.eden);
		hex += hexx[n];
		/* the derivative of the cooling */
		/* >>chng 01 sep 23, get rid of HCionTe */
		/* need extra factor of temp of 1 ryd since div by square of temp in ryd */
		dhexdt += hexx[n]*(iso.xIsoLevNIonRyd[ipISO][nelem][n]/TE1RYD/POW2(phycon.te_ryd) - 
		  cooling.halfte);
	}

	/* convert to physical units, need to convert ryd to ergs, 
	 * and bring to density per vol not per ion */
	hex *= EN1RYD*xIonFracs[nelem][nelem+2];
	dhexdt *= EN1RYD*xIonFracs[nelem][nelem+2];

	/* save net hydrogen collisional ionization cooling less H-3 body heating
	 * for inclusion in printout */
	hydro.chion[nelem] = hex;
	/* dump the coolant on the cooling stack */
	coladd(chHion[nelem],0,MAX2(0.,hydro.chion[nelem]));
	cooling.dCooldT += dhexdt;

	/* heating[3][0] is all three body heating, opposite of coll ion cooling */
	heat.heating[0][3] += MAX2(0.,-hydro.chion[nelem]);

	/***********************************************************************
	 *                                                                     *
	 * Lyman Lya all by itself                                             *
	 *                                                                     *
	 ***********************************************************************/

	/* this is the product of the ion abundance times the electron density,
	 * will multiply level pops which are stored relative to ion */
	edenIonAbund = phycon.eden*xIonFracs[nelem][nelem+2];

	/* EdenHCorr is used in level pops, so should be used here too */
	edenIonAbund = phycon.EdenHCorr*xIonFracs[nelem][nelem+2];

	/* lyman alpha cooling - total cooling is net rad loss */
	ipHi = ipH2p;
	ipLo = ipH1s;

	/* EmisLines[ipHYDROGEN].ColUL is downward collision rate coefficient*/

	ipHi = ipH2p;
	ipLo = ipH1s;
	hlone[ipHi] = 
	  EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].ColUL*(iso.Pop2Ion[ipISO][nelem][ipLo]*
	  iso.Boltzmann[ipISO][nelem][ipHi][ipLo]*
	  iso.stat[ipISO][ipHi]/iso.stat[ipISO][ipLo] - 
	  iso.Pop2Ion[ipISO][nelem][ipHi])*edenIonAbund*
	  EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].EnergyErg;

	ipHi = ipH2s;
	ipLo = ipH1s;
	hlone[ipHi] = 
	  EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].ColUL*(iso.Pop2Ion[ipISO][nelem][ipLo]*
	  iso.Boltzmann[ipISO][nelem][ipHi][ipLo]*
	  iso.stat[ipISO][ipHi]/iso.stat[ipISO][ipLo] - 
	  iso.Pop2Ion[ipISO][nelem][ipHi])*edenIonAbund*
	  EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].EnergyErg;

	hydro.coola[nelem] = hlone[ipH2s]+hlone[ipH2p] ;

	if( hydro.coola[nelem] > 0. )
	{
		/* net coolant, exponential dominates deriv */
		tcoola = hydro.coola[nelem]*(1.184e5*ChargeSquared*cooling.tsq1 - cooling.halfte);
	}
	else
	{
		/* net heating, te^-1/2 dominates */
		tcoola = -hydro.coola[nelem]*cooling.halfte;
	}

	/***********************************************************************
	 *                                                                     *
	 * Lyman line collisional heating/cooling for lines higher than Lya    *
	 *                                                                     *
	 ***********************************************************************/

	drestly = 0.;
	hydro.restly[nelem] = 0.;
	/*for( n=3; n <= (iso.nLevels[ipISO][nelem] - 1); n++ )*/
	testcode();/*try going to very highest level */
	for( n=3; n < iso.nLevels[ipISO][nelem]; n++ )
	{
		hlone[n] = EmisLines[ipHYDROGEN][nelem][n][ipH1s].ColUL*
		  (iso.Pop2Ion[ipISO][nelem][ipH1s]*iso.Boltzmann[ipISO][nelem][n][ipH1s]*POW2((float)n) - 
		  iso.Pop2Ion[ipISO][nelem][n])* edenIonAbund*
		  EmisLines[ipHYDROGEN][nelem][n][ipH1s].EnergyErg;
		/* sum energy in higher lyman lines */
		hydro.restly[nelem] += hlone[n];
		if( hlone[n] > 0. )
		{
			/* HdeltaTe[ipLo][hi], ip1s is 1s, ip2p is 2, etc */
			drestly += hlone[n]*
			  (EmisLines[ipHYDROGEN][nelem][n][ipH1s].EnergyK*cooling.tsq1 - cooling.halfte);
			  /*>>chng 99 jan 28, get rid of hdeltate, use stored temps instead */
			  /*(HdeltaT.HdeltaTe[ipH1s][n]*ChargeSquared*cooling.tsq1 - cooling.halfte);*/
		}
		else
		{
			drestly += -hlone[n]*cooling.halfte;
		}
	}

	/***********************************************************************
	 *                                                                     *
	 * Balmer lines                                                        *
	 *                                                                     *
	 ***********************************************************************/

	/* Balmer line collisional heating/cooling and derivative */
	hydro.barest[nelem] = 0.;
	dbarest = 0.;
	/*for( ipHi=3; ipHi <= (iso.nLevels[ipISO][nelem] - 1); ipHi++ )*/
	for( ipHi=3; ipHi < iso.nLevels[ipISO][nelem]; ipHi++ )
	{
		/* single line cooling */
#		if 0
		hlone[ipHi] = 
			EmisLines[ipHYDROGEN][nelem][ipHi][ipH2p].ColUL*((iso.Pop2Ion[ipISO][nelem][ipH2s] + 
		  iso.Pop2Ion[ipISO][nelem][ipH2p])*iso.Boltzmann[ipISO][nelem][ipHi][ipH2p]*
		  POW2((float)ipHi) /4. - iso.Pop2Ion[ipISO][nelem][ipHi])*
		  edenIonAbund* EmisLines[ipHYDROGEN][nelem][ipHi][ipH2s].EnergyErg;
#		endif
		/* >>chng 01 jun 05, from above to below, with 2s and 2p broken out
		 * in more logical way */

		ipLo = ipH2s;
		hlone[ipHi] = 
		  EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].ColUL*(iso.Pop2Ion[ipISO][nelem][ipLo]*
		  iso.Boltzmann[ipISO][nelem][ipHi][ipLo]*
		  iso.stat[ipISO][ipHi]/iso.stat[ipISO][ipLo] - 
		  iso.Pop2Ion[ipISO][nelem][ipHi])*edenIonAbund*
		  EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].EnergyErg;

		ipLo = ipH2p;
		hlone[ipHi] += 
		  EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].ColUL*(iso.Pop2Ion[ipISO][nelem][ipLo]*
		  iso.Boltzmann[ipISO][nelem][ipHi][ipLo]*
		  iso.stat[ipISO][ipHi]/iso.stat[ipISO][ipLo] - 
		  iso.Pop2Ion[ipISO][nelem][ipHi])*edenIonAbund*
		  EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].EnergyErg;

		hydro.barest[nelem] += hlone[ipHi];
		/* count boltzmann factor from ground - not a typo */
		if( hlone[ipHi] > 0. )
		{
			dhone[ipHi] = 
			  /*>>chng 99 jan 28, get rid of hdeltate, use stored temps instead */
				/*hlone[ipHi]*(HdeltaT.HdeltaTe[ipH1s][ipHi]*ChargeSquared*cooling.tsq1 - cooling.halfte);*/
				hlone[ipHi]*(EmisLines[ipHYDROGEN][nelem][ipHi][ipH1s].EnergyK*cooling.tsq1 - cooling.halfte);
		}
		else
		{
			/* heating agent */
			dhone[ipHi] = -hlone[ipHi]*ChargeSquared*cooling.halfte;
		}
		dbarest += dhone[ipHi];
	}

	/***********************************************************************
	 *                                                                     *
	 * all hydrogen lines from Paschen on up, but not Balmer               *
	 *                                                                     *
	 ***********************************************************************/

	hydro.hrest[nelem] = 0.;
	dhrest = 0.;
	/*for( ipLo=3; ipLo <= (iso.nLevels[ipISO][nelem] - 2); ipLo++ )*/
	for( ipLo=3; ipLo < iso.nLevels[ipISO][nelem]-1; ipLo++ )
	{
		testcode();/*try going to very highest level */
		/*for( ipHi=ipLo + 1; ipHi <= (iso.nLevels[ipISO][nelem] - 1); ipHi++ )*/
		for( ipHi=ipLo + 1; ipHi < iso.nLevels[ipISO][nelem]; ipHi++ )
		{
			hlone[ipHi] = 
			  EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].ColUL*(iso.Pop2Ion[ipISO][nelem][ipLo]*
			  iso.Boltzmann[ipISO][nelem][ipHi][ipLo]*
			  iso.stat[ipISO][ipHi]/iso.stat[ipISO][ipLo] - 
			  iso.Pop2Ion[ipISO][nelem][ipHi])*edenIonAbund*
			  EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].EnergyErg;

			hydro.hrest[nelem] += hlone[ipHi];

			/* next get derivative */
			if( hlone[ipHi] > 0. )
			{
				/* for derivative taking the exponential from ground gave better
				 * representation of effects */
				dhrest += hlone[ipHi]*
		   	  /*>>chng 99 jan 28, get rid of hdeltate, use stored temps instead */
				  (EmisLines[ipHYDROGEN][nelem][ipHi][ipH1s].EnergyK*cooling.tsq1 - cooling.halfte);
				  /*(HdeltaT.HdeltaTe[ipH1s][ipHi]*ChargeSquared*cooling.tsq1 - cooling.halfte);*/
			}
			else
			{
				dhrest += -hlone[ipHi]*cooling.halfte;
			}
		}
	}

	/***********************************************************************
	 *                                                                     *
	 * add total line heating or cooling into stacks, derivatives          *
	 *                                                                     *
	 ***********************************************************************/

	/* this is total hydrogen line cooling (positive) or heating (negative)*/
	hydro.HLineTotCool[nelem] = 
	  hydro.coola[nelem] + hydro.restly[nelem] + hydro.barest[nelem] + 
	  hydro.hrest[nelem];
	/* debug print for understanding contributors to HLineTotCool */
	{
		/*@-redef@*/
		enum {DEBUG=FALSE};
		/*@+redef@*/\
		if( DEBUG )
		{
			if( nelem == 0 )
			{
				fprintf(ioQQQ,"%.2e la %.2f restly %.2f barest %.2f hrest %.2f\n",
					hydro.HLineTotCool[nelem] ,
					hydro.coola[nelem]/hydro.HLineTotCool[nelem] ,
					hydro.restly[nelem]/hydro.HLineTotCool[nelem] ,
					hydro.barest[nelem]/hydro.HLineTotCool[nelem] ,
					hydro.hrest[nelem]/hydro.HLineTotCool[nelem] );

#				if 0
				if( hydro.coola[nelem]/hydro.HLineTotCool[nelem] > 0.9 )
				fprintf(ioQQQ," 1s 2s 2p %.2e %.2e %.2e\n",
					iso.Pop2Ion[ipISO][nelem][ipH1s] , 
					iso.Pop2Ion[ipISO][nelem][ipH2s] ,
					iso.Pop2Ion[ipISO][nelem][ipH2p]);

#				endif
			}
		}
	}

	/* above can be either heating or coolant
	 * must add this to total heating or cooling, as appropriate */
	if( hydro.HLineTotCool[nelem] > 0. )
	{
		/* hydrogen is a net coolant, heat.heating[0][23] set to 0 in coolr*/
		coladd(chHlin[nelem],0,hydro.HLineTotCool[nelem]);
		cooling.dCooldT += tcoola + drestly + dhrest + dbarest;
		hydro.dHLTot[nelem] = 0.;
	}
	else
	{
		/* hydrogen is a net heat source, must add since all hydrogenic added here */
		heat.heating[0][23] -= hydro.HLineTotCool[nelem];
		coladd(chHlin[nelem],0,0.);
		hydro.dHLTot[nelem] = -tcoola - drestly - dbarest - dhrest;
	}

	/***********************************************************************
	 *                                                                     *
	 * cooling / heating due to charge transfer ionization recombination   *
	 *                                                                     *
	 ***********************************************************************/

	if( nelem == ipHYDROGEN )
	{
		/*double OCharExcCooling;*/

		/* only for oxygen, ionize oxygen minus  recomb oxygen
		OCharExcCooling =
			(xIonFracs[ipOXYGEN][1]*ChargTran.HCharExcIon[ipOXYGEN][0]*xIonFracs[ipHYDROGEN][2] -
			xIonFracs[ipOXYGEN][2]*xIonFracs[ipHYDROGEN][1]*ChargTran.HCharExcRec[ipOXYGEN][0]
			)*EN1RYD; */

		/* only for hydrogen, hydrogen ionization minus recombination */
		ChargTran.HCharExcCooling =
			(xIonFracs[ipHYDROGEN][2]*iso.Pop2Ion[ipHYDROGEN][ipHYDROGEN][ipH1s]*xIonFracs[ipOXYGEN][2]*
			ChargTran.HCharExcRec[ipOXYGEN][0]-
			xIonFracs[nelem][2]*xIonFracs[ipOXYGEN][1]*ChargTran.HCharExcIon[ipOXYGEN][0]
			)*EN1RYD;

#		if 0
		fprintf(ioQQQ,"ctexchange\t%.2e\t%.2e\n",
			/*xIonFracs[ipHYDROGEN][2]*iso.Pop2Ion[ipHYDROGEN][ipHYDROGEN][ipH1s]*ChargTran.HCharExcIonTotal*EN1RYD,

			xIonFracs[nelem][2]*ChargTran.HCharExcRecTotal*EN1RYD,*/
			ChargTran.HCharExcCooling ,
			OCharExcCooling

			/*(xIonFracs[ipHYDROGEN][2]*iso.Pop2Ion[ipHYDROGEN][ipHYDROGEN][ipH1s]*ChargTran.HCharExcIonTotal-
			xIonFracs[nelem][2]*ChargTran.HCharExcRecTotal)*EN1RYD/heat.htot*/
			);
#		endif

		ChargTran.HCharExcCooling = 0.; /**/
		/* above can be either heating or coolant
		 * must add this to total heating or cooling, as appropriate */
		if( ChargTran.HCharExcCooling > 0. )
		{
			/* hydrogen is a net coolant, heat.heating[0][23] set to 0 in coolr*/
			coladd("HctC",0,ChargTran.HCharExcCooling);
		}
		else
		{
			/* hydrogen is a net heat source, must add since all hydrogenic added here */
			heat.heating[0][26] = -ChargTran.HCharExcCooling;
			coladd("HctC",0,0.);
		}
	}

	/***********************************************************************
	 *                                                                     *
	 * hydrogen recombination free-bound free bound cooling                *
	 *                                                                     *
	 ***********************************************************************/
	
	/* this is ground, not ncluded in case b sum.  0 is ground in vector, 1 in function */
	SaveRadRecCool[0] = HydroRecCool(1,nelem)*iso.RadRecomb[ipISO][nelem][0][ipRecNetEsc];
	hydro.HRadRecCool[nelem] = SaveRadRecCool[0];

	/* now do case b sum to compare with exact value below */
	ThinCoolingSum = 0.;

	/* in this loop HydroRecCool(2,nelem) is both 2s and 2p */
	for( n=2; n < (iso.nLevels[ipISO][nelem] - 1); n++ )
	{
		/* evaluate and hold optically thin spontaneous radiative cooling*/
		SaveRadRecCool[n] = HydroRecCool(n,nelem);
		/* this is optically thin sum of cooling, will subtract from case b sum
		 * so that we can "top off" the model atom's cooling */
		ThinCoolingSum += SaveRadRecCool[n];
		/* this includes escaping fraction */
		hydro.HRadRecCool[nelem] += SaveRadRecCool[n]*
			iso.RadRecomb[ipISO][nelem][n][ipRecNetEsc];
	}
	/* this is really for debugging - [2] from above is both 2s and 2p, [1] undefined
	 * will make them independent and correct, with [1] defined */
	SaveRadRecCool[ipH2s] = SaveRadRecCool[ipH2p] / 3.;
	SaveRadRecCool[ipH2p] -= SaveRadRecCool[ipH2s];

	/* following is expression for case b sum of 
	 * optically thin radiative recombination cooling */
	if( nelem == 0 )
	{
		/*expansion for hydrogen itself */
		ThinCoolingCaseB = (-25.859117 + 
		  0.16229407*phycon.telogn[0] + 
		  0.34912863*phycon.telogn[1] - 
		  0.10615964*phycon.telogn[2])/(1. + 
		  0.050866793*phycon.telogn[0] - 
		  0.014118924*phycon.telogn[1] + 
		  0.0044980897*phycon.telogn[2] + 
		  6.0969594e-5*phycon.telogn[3]);
	}
	else
	{
		/* same expansion but for hydrogen ions */
		ThinCoolingCaseB = (-25.859117 + 
		  0.16229407*(phycon.telogn[0]-phycon.sqlogz[nelem]) + 
		  0.34912863*POW2(phycon.telogn[0]-phycon.sqlogz[nelem]) - 
		  0.10615964*powi( (phycon.telogn[0]-phycon.sqlogz[nelem]),3) )/(1. + 
		  0.050866793*(phycon.telogn[0]-phycon.sqlogz[nelem]) - 
		  0.014118924*POW2(phycon.telogn[0]-phycon.sqlogz[nelem]) + 
		  0.0044980897*powi( (phycon.telogn[0]-phycon.sqlogz[nelem]),3) + 
		  6.0969594e-5*powi( (phycon.telogn[0]-phycon.sqlogz[nelem]),4) );
	}
	
	/* now convert to linear cooling coefficient */
	ThinCoolingCaseB = POW3(1.+nelem)*pow(10.,ThinCoolingCaseB)/(phycon.te/POW2(1.+nelem) ) ;

	/* this is the error, expect positive since do not include infinite number of levels */
	RecCoolError = ThinCoolingCaseB - ThinCoolingSum;

	/* leave this message in for now.  very large atoms tend to overestimate cooling
	 * due to approximate form of cooling above level 15 */
	if( RecCoolError/ThinCoolingSum < -.04 )
	{
		fprintf( ioQQQ, " RecCoolError lt 0 in HydroCool, frac error=%e nelem is %li\n", 
		  RecCoolError/ThinCoolingSum , nelem );
	}
	hydro.HRadRecCool[nelem] += RecCoolError*iso.RadRecomb[ipISO][nelem][iso.nLevels[ipISO][nelem]-1][ipRecNetEsc];

	/* this is now total free-bound cooling */
	hydro.HRadRecCool[nelem] *= edenIonAbund;

	/***********************************************************************
	 *                                                                     *
	 * heating  by photoionization of                                      *
	 * excited states of all hydrogenic species                            *
	 *                                                                     *
	 ***********************************************************************/

	/* photoionization of excited levels
	 * HPhotHeat(n,nelem) is photoionization heating due to level n,
	 * evaluated in routine hydrgn */
	HeatExcited = 0.;
	{
		/*@-redef@*/
		enum {DEBUG=FALSE};
		/*@+redef@*/
		int ipbig=-1000;
		for( n=ipH2s; n < (iso.nLevels[ipISO][nelem] - 1); n++ )
		{
			SavePhotoHeat[n] = xIonFracs[nelem][nelem+2]*iso.Pop2Ion[ipISO][nelem][n]*
			  iso.PhotoHeat[ipISO][nelem][n];
			HeatExcited += SavePhotoHeat[n];
			if( SavePhotoHeat[n] > biggest )
			{
				biggest = SavePhotoHeat[n];
				ipbig = (int)n;
			}
		}
		if( DEBUG  )
		{
			/* this was not done above */
			SavePhotoHeat[ipH1s] = xIonFracs[nelem][nelem+2]*iso.Pop2Ion[ipISO][nelem][ipH1s]*
			  iso.PhotoHeat[ipISO][nelem][ipH1s];
			fprintf(ioQQQ," nelem=%ld ipbig=%d biggest=%g\n",nelem,
				ipbig , biggest );
			for(n=ipH1s; n< (iso.nLevels[ipISO][nelem] - 1); ++n )
			{
				fprintf(ioQQQ," %g", SavePhotoHeat[n]/HeatExcited);
			}
			fprintf(ioQQQ," \n");
		}
	}

	/* HFreBndNet is net cooling due to 
	 * HRadRecCool is total radiative recombination cooling sum to all levels,
	 * net is this less n>=2 photoionization heating */
	HFBNet.HFreBndNet[nelem] = hydro.HRadRecCool[nelem] - HeatExcited;

	/* heating[1][0] is all excited state photoionization heating from ALL species,
	 * this is set to zero in coolr before loop where this is called.
	 * >>chng 96 jan 25, was -HeatExcited  */
	heat.heating[0][1] += MAX2(0.,-HFBNet.HFreBndNet[nelem]);

	/* net free-bound cooling minus free-free heating,
	 * these have labels like "Hp 0","Hp 1" */
	coladd(chHp[nelem], 0, MAX2(0.,HFBNet.HFreBndNet[nelem]));

	/* if rec coef goes as T^-.8, but times T, so propto t^.2 */
	cooling.dCooldT += 0.2*HFBNet.HFreBndNet[nelem]*phycon.teinv;


	/***********************************************************************
	 *                                                                     *
	 * hydrogen induced recombination cooling                              *
	 *                                                                     *
	 ***********************************************************************/

	HFBNet.crcind[nelem] = 0.;
	for( n=ipH1s; n < (iso.nLevels[ipISO][nelem] - 1); n++ )
	{
		/* >>chng 02 jan 22, removed cinduc, replace with RecomInducCool */
		SaveInducCool[n] = iso.RecomInducCool[ipISO][nelem][n]*iso.PopLTE[ipISO][nelem][n]*edenIonAbund;
		HFBNet.crcind[nelem] += SaveInducCool[n];
		cooling.dCooldT += SaveInducCool[n]*
			(iso.xIsoLevNIonRyd[ipISO][nelem][n]/phycon.te_ryd - 1.5)*phycon.teinv;
	}
	{
		/*@-redef@*/
		enum {DEBUG=FALSE};
		/*@+redef@*/
		if( DEBUG  )
		{
			fprintf(ioQQQ," nelem=%ld \n",nelem);
			for(n=ipH1s; n< (iso.nLevels[ipISO][nelem] - 1); ++n )
			{
				fprintf(ioQQQ," %g", SaveInducCool[n]/HFBNet.crcind[nelem]);
			}
			fprintf(ioQQQ," \n");
		}
	}
	/* this cooling has labels like "Hn 0","Hn 1" - induced rec cooling */
	coladd(chHn[nelem],0,HFBNet.crcind[nelem]);

	{
		/* this is an option to print out each rate affecting each level in strict ste,
		 * this is a check that the rates are indeed in detailed balance */
		/*@-redef@*/
		enum {DEBUG=FALSE};
		enum {LTEPOP=TRUE} ;
		/*@+redef@*/
		/* special debug print for gas near ste */
		if( DEBUG  && (nelem==1 || nelem==0) )
		{
			/* ltepop is option to assume ste for rates */
			if( LTEPOP )
			{
				for(n=ipH1s; n<iso.nLevels[ipISO][nelem]-1; ++n )
				{
					fprintf(ioQQQ,"%li\t%li\t%g\t%g\t%g\t%g\tT=\t%g\t%g\t%g\t%g\n", nelem,n,
						iso.gamnc[ipISO][nelem][n] *iso.PopLTE[ipISO][nelem][n], 
						/* induced recom, intergral times hlte */
						/*iso.RadRecomb[ipISO][nelem][n][ipRecRad]+iso.rinduc[ipISO][nelem][n]  ,*/
						/* >>chng 02 jan 22, remove rinduc, replace with RecomInducRate */
						iso.RadRecomb[ipISO][nelem][n][ipRecRad]+ 
							iso.RecomInducRate[ipISO][nelem][n]*iso.PopLTE[ipISO][nelem][n]  ,
						/* induced rec */
						iso.RecomInducRate[ipISO][nelem][n]*iso.PopLTE[ipISO][nelem][n]  ,
						/* spontaneous recombination */
						iso.RadRecomb[ipISO][nelem][n][ipRecRad] ,
						/* heating, followed by two processes that must balance it */
						iso.PhotoHeat[ipISO][nelem][n]*iso.PopLTE[ipISO][nelem][n], 
						iso.RecomInducCool[ipISO][nelem][n]*iso.PopLTE[ipISO][nelem][n]+SaveRadRecCool[n] ,
						/* induced rec cooling, integral times hlte */
						iso.RecomInducCool[ipISO][nelem][n]*iso.PopLTE[ipISO][nelem][n] ,
						/* free-bound cooling per unit vol */
						SaveRadRecCool[n] );
				}
			}
			else
			{
				for(n=ipH1s; n<iso.nLevels[ipISO][nelem]-1; ++n )
				{
					fprintf(ioQQQ,"%li\t%li\t%g\t%g\t%g\t%g\tT=\t%g\t%g\t%g\t%g\n", nelem,n,
						iso.gamnc[ipISO][nelem][n] *xIonFracs[nelem][nelem+2]*iso.Pop2Ion[ipISO][nelem][n], 
						/* induced recom, intergral times hlte */
						iso.RadRecomb[ipISO][nelem][n][ipRecRad]*edenIonAbund+
							iso.RecomInducRate[ipISO][nelem][n]*iso.PopLTE[ipISO][nelem][n] *edenIonAbund ,
						iso.RadRecomb[ipISO][nelem][n][ipRecRad]*edenIonAbund ,
						iso.RecomInducRate[ipISO][nelem][n]*iso.PopLTE[ipISO][nelem][n] *edenIonAbund ,
						/* heating, followed by two processes that must balance it */
						SavePhotoHeat[n], 
						SaveInducCool[n]+SaveRadRecCool[n]*edenIonAbund ,
						/* induced rec cooling, integral times hlte */
						SaveInducCool[n] ,
						/* free-bound cooling per unit vol */
						SaveRadRecCool[n]*edenIonAbund );
				}
			}
		}
	}

	/* now free up the space */
	free( dhone );
	free( hexx );
	free( hlone );
	free( SavePhotoHeat );
	free( SaveInducCool );
	free( SaveRadRecCool );

#	ifdef DEBUG_FUN
	fputs( " <->HydroCool()\n", debug_fp );
#	endif
	return;
}

