/****************************************************************************
 *                                                                          *
 * hydrogenic.h -                                                           *
 * this file contains the variables for the model hydrogen ions,            *
 * and prototypes for the series of routines that drive the atom            *
 * the EXTERN structure hydro is defined here -                             *
 * all H variables should migrate here                                      *
 *                                                                          *
 * the hydrogenic lines, EmisLines[ipHYDROGEN] are in taulines.h                       *
 *                                                                          *
 ****************************************************************************/

/* the routine that calls the hydrogenic routines */
void Hydrogenic(void);

/*HydroCool compute net heating/cooling due to hydrogenc atom species */
void HydroCool(
	   /* the isoelectronic sequence, 0 for H */
	   long int ipISO , 
		/* nelem is element, so 0 for H itself */
		long int nelem);

/*HydroLevel solve for ionization balance level populations of model hydrogen atom */
void HydroLevel(long int ipZ);

#if 0
/*HydroLevelDep solve for departure coefs in hydrogen ionization balance */
void HydroLevelDep(long int ipZ ,
	double **SaveZ/*[iso.nLevels[ipHYDROGEN]+2][iso.nLevels[ipHYDROGEN]+2]*/, 
	double *bvec/*[iso.nLevels[ipHYDROGEN]+2]*/, 
	double *error/*[iso.nLevels[ipHYDROGEN]+2]*/, 
	double *work/*[iso.nLevels[ipHYDROGEN]+2]*/, 
	double **z/*[iso.nLevels[ipHYDROGEN]+2][iso.nLevels[ipHYDROGEN]+2]*/ ,
	long int *ipiv , /* MALLOC out to [iso.nLevels[ipHYDROGEN]+1] */
	double *totcap/* MALLOC out to [iso.nLevels[ipHYDROGEN]+1]*/);
#endif

/*HydroLevelPop solve for departure coefs in hydrogen ionization balance */
void HydroLevelPop(long int ipZ ,
	double **SaveZ/*[iso.nLevels[ipHYDROGEN]+2][iso.nLevels[ipHYDROGEN]+2]*/, 
	double *bvec/*[iso.nLevels[ipHYDROGEN]+2]*/, 
	double *error/*[iso.nLevels[ipHYDROGEN]+2]*/, 
	double *work/*[iso.nLevels[ipHYDROGEN]+2]*/, 
	double **z/*[iso.nLevels[ipHYDROGEN]+2][iso.nLevels[ipHYDROGEN]+2]*/ ,
	long int *ipiv , /* MALLOC out to [iso.nLevels[ipHYDROGEN]+1] */
	double *totcap/* MALLOC out to [iso.nLevels[ipHYDROGEN]+1]*/);

/*HydroPesc evaluate escape and deEXTERN struction probabilities for hydrogen lines,
 * second parameter is flag saying whether to also do escape prob (TRUE) or
 * just the deEXTERN struction probabilites (FALSE) */
void HydroPesc(long int ipZ, int lgDoEsc);

/*HydroCollid evaluate collision rate for model hydrogen atom */
void HydroCollid(long int ipZ);

/*HydroOTS evaluate model hydrogen atom line and continuum ots rates
void HydroOTS(void); */

/*HydroT2Low called to do hydrogenic level populations when temp too low for matrix */
void HydroT2Low(long int ipZ, 
  double rfac);

/*HydroRecCool hydrogen recombination cooling */
double HydroRecCool(long int n, long int ipZ);

/*HydroBranch compute branching ratios for Jason's model hydrogen atom */
double HydroBranch(long int ihigh, 
  long int ilow, 
  long int iz);

/*HydroRecom photoionization, recombination, radiative rates for model hydrogen atom */
void HydroRecom(long int ipZ);

/*HydColIon calculate hydrogenic ionization rates for all n, and Z*/
double HydColIon(
		long int n,	/* principal quantum number, > 1
						 * since only used for excited states */
		long int iz);/* charge, >=1 since only used for ions 
						 * iz = 1 is helium the least possible charge */

/*Hydcs123 Hydrogenic de-excitation collision rates n=1,2,3 */
double Hydcs123(long int ilow, 
  long int ihigh, 
  long int iz, 
  long int chType);

/*H1cs123 hydrogen collision data levels involving 1s,2s,2p,3. */
double H1cs123(long int i, 
  long int j, 
  long int chType);

/*He2cs123 line collision strengths for lower levels of helium ion, n=1,2,3, by K Korista */
double He2cs123(long int i, 
  long int j);

/*Ne10cs123 line collision rates for lower levels of hydrogenic neon, n=1,2,3 */
double Ne10cs123(long int i, 
  long int j);

/*Fe26cs123 line collision rates for lower levels of hydrogenic iron, n=1,2,3 */
double Fe26cs123(long int i, 
  long int j);

/*HydColDwn rate coefficient for collisional de-excitation for any levels of hydrogenic Z
double HydColDwn(long int ipHi, 
  long int ipLo, 
  long int iz);*/


/* all of these are initialized in zero */
EXTERN struct t_hydro {

	/* >>chng 99 nov 29 from float to double */
	/* cooling due to various hydrogenic species, evaluated in HydroCool */
	/* cooling due to Lya */
	double coola[LIMELM], 
	  /* collisional ionization */
	  chion[LIMELM], 
	  /* hydrogen radiative recombination cooling */
	  HRadRecCool[LIMELM], 
	  hrest[LIMELM], 
	  barest[LIMELM], 
	  restly[LIMELM] ,
	  HLineTotCool[LIMELM], 
	  dHLTot[LIMELM];

	/* an array of indices that point to the energy that is half of La
	 * used to two photon emission */
	long int ipHalfLya[2][LIMELM];
	/* ip2pht will become array of indices for induced two photon,
	 * series of symmetric indices 
	 * ipHy2nu[ipISO][ipZ][energy] */
	long int ***ipSymHy2nu;
	/* will become array of two photon emission cross sections,
	 * Hy2nu[ipISO][ipZ][energy] */
	float ***AsHy2nu;

	/* flag to say (true) to produce emissivity for hydrogenic species,
	 * rather than intensity (the default).  Set with 
	 * hydrogen emissivity commmand.  default is false */
	int lgHydEmiss;

	/* FreFreHeat is free-free heating, evaluated in freeht*/
	double FreeFreeHeat, 
	  /* total free free heating integrated over model */
	  FreeFreeTotHeat,
	  /* FreeFreeCool is cooling, evaluated in coolr*/
	  FreeFreeCool , 
	  /* HFFNet is net cooling, negative if heating*/
	  /* heating stored in heating[11,0]*/
	  HFFNet;

	/* lgHiPop2 flag set if H n=2 population gets large relative to ground
	 * pop2mx is maximum population of n=2 relative to ground */
	int lgHiPop2;
	float pop2mx;

	/* hlbolt[low][up] line boltzmann factors for hydrogen atom*/
	/*double ***hlbolt hlbolt[LIMELM][LMHLVL+1][LMHLVL+1];*/

	/* hcbolt[n] excit to continuum */
	/*double **hcbolt hcbolt[LIMELM][LMHLVL+1]*/

	/* electron scattering escape probability
	 * currently zeroed out in hydrotrans */
	float ***esesc /*esesc[LIMELM][LMHLVL+1][LMHLVL+1]*/;

	/* arrays for stark broadening in Puetter formalism */
	float **strkar/*strkar[LMHLVL+1][LMHLVL+1]*/;
	float **pestrk/*pestrk[LMHLVL+1][LMHLVL+1]*/;

	/* hbn(level,nelem) departure coefficient, hbnOld is averaged value */
	/*double **hbnhbn[LIMELM][LMHLVL+1];*/

	/* collisional ionization */
	/*float **hcolnchcolnc[LIMELM][LMHLVL+1];*/

	/* hn[ipZ][level] population relative to ion, hnOld is averaged value */
	/*float **hnhn[LIMELM][LMHLVL+1];*/

	/* the total level destruction rate, s-1 */
	double **DestRate;/*[LIMELM][LMHLVL+1]*/

	/* radiative recombination */
	/*float ***hrec hrec[LIMELM][LMHLVL+1][3];*/

	/* dstfe2lya is destruction probability for Lya onto FeII,
	 * net deexcitation of Lya but not ots destruction */
	float dstfe2lya;

	/* flag to say which type of solution to do for level pops, departure or pops */
	char chTypeAtom[5];

	/* width of Lya */
	float HLineWidth;

	/* TexcLya is the excitation temperature of Lya */
	float TexcLya;

	/* nLyaHot is counts how ofter Lya hotter than gas */
	long int nLyaHot;

	/* TLyaMax is hottest */
	float TLyaMax, 
	/* TeLyaMax is electron temp at point where Lya max  */
	  TeLyaMax;

	/* nZTLaMax is the zone where this happened */
	long int nZTLaMax;

	/* flag saying that Lya mased */
	int lgHLyaMased;

	/* smallest Lya optical depth that occured in the calculation */
	float xLaMase;

	/* how the hydrogen atom is topped off.  nHTopOff is the level, set to 1 in zero
	long int nHTopOff; */

	/* types of redistribution functions for Lya, other resonances, and subordinate lines */
	int ipLya , ipReso , ipSub ;

	/* chHTopType is the method.used to top off the H atom */
	char chHTopType[5];

	/* continuum to total opacity factors for hydrogen
	float HOpacRatio[LIMELM][NHYDRO_MAX_LEVEL]; */

	/* relative importance of photo ioniz from n=2 of H */
	float photn2;

	/* largest fraction of ground state H destruction due to collisional ionization */
	float HCollIonMax;

	/* fraction of H ionizations due to ground collisions */
	float HCollIonFrac;

	/* the ratio fully stripped ion to atom for all hydrogenic species
	 * HIonSimple is simple estimate, should agree at low density
	double HIonSimple[LIMELM]; */

	/* array of lifetimes for HI levels, not including Lyman lines
	 * lifetime for principal quantum numbers
	 * [0] and [1] are set to -1e37, no defined,
	 * [2] is lya 
	 *
	 * this is used for full H iso sequence, so
	 * must be defined up through most number of levels
	 * needed for any atom on this sequence
	 */
	float HyLife[NHYDRO_MAX_LEVEL];

	/* cintot is total induced cooling over model */
	double cintot;

	/* lgHInducImp says whether or not induced recombination is important*/
	int lgHInducImp;

	}	hydro;
