/* 
 * pair of troutine to do spline interpolation
 * call spline first to set coefficients up,
 * then call splint to interpolate 
 */

void spline(double[],double[],long,double,double,double[]);
void splint(double[],double[],double[],long,double,double*);
void spldrv(double[],double[],double[],long,double,double*);

/*
 * series of interpolation routines from CUJ Feb 2000, by Kyle Loudon
 */

#ifndef INTERPOLATE_H
#define INTERPOLATE_H

double lagrange(const double *x, const double *fx, int n,
   double X);

double newton(const double *x, const double *fx, int n,
   double X, double tolerance, int *degree);

double pwlinear(const double *x, const double *fx, int n,
   double X);

double pwhermite(const double *x, const double *fx, const
   double *fpx, int n, double X);

#endif
