/*iso_Photo do photoionization rates for element nelem on the ipISO isoelectronic sequence */
#include "cddefines.h"
#include "hydrogenic.h"
#include "rfield.h"
#include "iso.h"
#include "opacity.h"
#include "trace.h"
#include "photrate.h"
#include "recoil.h"
#include "heat.h"
#include "gammas.h"

void iso_Photo(
	/* iso sequence, hydrogen or helium for now */
	long ipISO , 
	/* the chemical element, 0 for hydrogen */
	long int nelem)
{
	long int n;

#	ifdef DEBUG_FUN
	fputs( "<+>iso_Photo()\n", debug_fp );
#	endif

	/* check that we were called with valid charge */
	assert( nelem >= 0);
	assert( nelem < LIMELM );
	assert( ipISO == ipHYDROGEN || ipISO == ipHELIUM );

	/* do photoionization rates */
	/* induced recombination; FINDUC is integral of
	 * pho rate times EXP(-hn/kt) for induc rec
	 * CIND is this times hnu-hnu0 to get ind rec cooling
	 * PhotScaleOn is 1, set to 0 with 'no photoionization' command
	 * ipSecIon points to 7.353 Ryd, lowest energy where secondary ioniz
	 * of hydrogen is possible */

	/* photoionization of ground */
	iso.gamnc[ipISO][nelem][ipH1s] = GammaBn(iso.ipIsoLevNIonCon[ipISO][nelem][ipH1s],
		rfield.nflux,
		iso.ipOpac[ipISO][nelem][ipH1s],
		iso.xIsoLevNIonRyd[ipISO][nelem][ipH1s],
		&iso.RecomInducRate[ipISO][nelem][ipH1s],
		&iso.RecomInducCool[ipISO][nelem][ipH1s])*
		PhotRate.PhotScaleOn;

	/* heating due to photo of ground */
	iso.PhotoHeat[ipISO][nelem][ipH1s] = heat.HeatNet*PhotRate.PhotScaleOn;

	PhotRate.PhotoRate[0][0][nelem-ipISO][nelem] = iso.gamnc[ipISO][nelem][ipH1s];
	PhotRate.PhotoRate[1][0][nelem-ipISO][nelem] = heat.HeatLowEnr*PhotRate.PhotScaleOn;
	PhotRate.PhotoRate[2][0][nelem-ipISO][nelem] = heat.HeatHiEnr*PhotRate.PhotScaleOn;

	/* option to print photoionization rates */
	if( trace.lgTrace && trace.lgHBug )
	{
		GammaPrt(iso.ipIsoLevNIonCon[ipISO][nelem][ipH1s],
			rfield.nflux,
			iso.ipOpac[ipISO][nelem][ipH1s],
		  ioQQQ,
		  iso.gamnc[ipISO][nelem][ipH1s],iso.gamnc[ipISO][nelem][ipH1s]*0.05);
	}

	/* CompRecoilIonRate is direct photioniz rate due to 
	 * bound compton scattering of very hard x-rays+Compton scat */
	if( (ipISO == ipHYDROGEN && nelem==ipHYDROGEN) ||
		(ipISO == ipHELIUM && nelem==ipHELIUM) )
		iso.gamnc[ipISO][nelem][ipH1s] += recoil.CompRecoilIonRate[nelem];

	assert( iso.gamnc[ipISO][nelem][ipH1s]>= 0. );

	for( n=1; n < iso.nLevels[ipISO][nelem]; n++ )
	{
		if( n>6 && !opac.lgRedoStatic )
			break;
		/* fixit(); - hydro.lgHInducImp should depend on iso and nelem */
		if( hydro.lgHInducImp )
		{
			iso.gamnc[ipISO][nelem][n] = 
				GammaBn(
				iso.ipIsoLevNIonCon[ipISO][nelem][n],
				iso.ipIsoLevNIonCon[ipISO][nelem][0]-1,
				iso.ipOpac[ipISO][nelem][n],
				iso.xIsoLevNIonRyd[ipISO][nelem][n],
				&iso.RecomInducRate[ipISO][nelem][n],
				&iso.RecomInducCool[ipISO][nelem][n])*
				PhotRate.PhotScaleOn;
		}
		else
		{
			iso.gamnc[ipISO][nelem][n] = 
				(float)(GammaK(iso.ipIsoLevNIonCon[ipISO][nelem][n],
				iso.ipIsoLevNIonCon[ipISO][nelem][ipH1s]-1,
				iso.ipOpac[ipISO][nelem][n],1.)*
				PhotRate.PhotScaleOn);

			/* these are zero */
			iso.RecomInducRate[ipISO][nelem][n] = 0.;
			iso.RecomInducCool[ipISO][nelem][n] = 0.;
		}
		iso.PhotoHeat[ipISO][nelem][n] = heat.HeatNet*PhotRate.PhotScaleOn;
		{
			/*@-redef@*/
			enum {DEBUG=FALSE};
			/*@+redef@*/
			if( DEBUG )
			{
				if( nelem==0 && n==ipH2s && nzone > 267 && iteration==2 )
				{
					GammaPrt(iso.ipIsoLevNIonCon[ipISO][nelem][n],
						iso.ipIsoLevNIonCon[ipISO][nelem][ipH1s]-1,
						iso.ipOpac[ipISO][nelem][n],
					  ioQQQ,
					  iso.gamnc[ipISO][nelem][n],iso.gamnc[ipISO][nelem][n]*0.05);
				}
			}
		}
	}
	{
		/*@-redef@*/
		enum {DEBUG=FALSE};
		/*@+redef@*/
		if( DEBUG )
		{
			if( nelem==0 )
			{
				fprintf(ioQQQ," buggbugg hphotodebugg%li\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\n",
					nzone,
				  iso.gamnc[ipISO][nelem][0],
				  iso.gamnc[ipISO][nelem][1],
				  iso.gamnc[ipISO][nelem][3],
				  iso.gamnc[ipISO][nelem][4],
				  iso.gamnc[ipISO][nelem][5],
				  iso.gamnc[ipISO][nelem][6]);
			}
		}
	}

	/* >>chng 02 jan 19, kill excited state photoionization with case b no photo */
	/* option for case b conditions, kill all excited state photionizations */
	if( opac.lgCaseB_no_photo )
	{
		for( n=1; n < iso.nLevels[ipISO][nelem]; n++ )
		{
			iso.gamnc[ipISO][nelem][n] = 0.;
			iso.RecomInducRate[ipISO][nelem][n] = 0.;
			iso.RecomInducCool[ipISO][nelem][n] = 0.;
		}
	}
	{
		/* this block turns off induced recom for some element */
		/*@-redef@*/
		enum {DEBUG=FALSE};
		/*@+redef@*/
		if( DEBUG && ipISO==1 && nelem==5)
		{
			broken();
			for( n=0; n < iso.nLevels[ipISO][nelem]; n++ )
			{
				iso.RecomInducRate[ipISO][nelem][n] = 0.;
			}
		}
	}

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, "     iso_Photo%2ld low, hi=",nelem);
		fprintf( ioQQQ,PrintEfmt("%9.2e", iso.gamnc[ipISO][nelem][ipH1s]));
		fprintf( ioQQQ,PrintEfmt("%9.2e", recoil.CompRecoilIonRate[ipISO]));
		fprintf( ioQQQ, " total=");
		fprintf( ioQQQ,PrintEfmt("%9.2e",iso.gamnc[ipISO][nelem][ipH1s] ));
		fprintf( ioQQQ, "\n");
	}

#	ifdef DEBUG_FUN
	fputs( " <->iso_Photo()\n", debug_fp );
#	endif
	return;
}
