/*lgEndFun after each zone by Cloudy, determines whether model is complete */
#include "cddefines.h"
/*  */
#ifdef EPS
#	undef EPS
#endif
#define	EPS	1.00001
#include "heat.h"
#include "cooling.h"
#include "coolpr.h"
#include "linesave.h"
#include "co.h"
#include "drneg.h"
#include "badstp.h"
#include "dump.h"
#include "itercnt.h"
#include "trace.h"
#include "printit.h"
#include "colden.h"
#include "nomole.h"
#include "timed.h"
#include "prt.h"
#include "tfidle.h"
#include "mappar.h"
#include "phycon.h"
#include "zonecnt.h"
#include "stopcalc.h"
#include "opacity.h"
#include "thermal.h"
#include "pressure.h"
#include "radius.h"
#include "called.h"
#include "wind.h"
#include "drminu.h"
#include "trovrd.h"
#include "reason.h"
#include "prtlinepres.h"
#include "prtzone.h"
#include "punt.h"
#include "timer.h"
#include "lgendfun.h"
/*dmpary print all coolants for some zone, as from print cooling command */
static void dmpary(void);

int lgEndFun(void)
{
	int lgDone, 
	  lgEndFun_v, 
	  lgPrinted;
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>lgEndFun()\n", debug_fp );
#	endif

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, " lgEndFun called, zone %li.\n" , nzone);
	}

	/* >>chng 97 jun 09, now called before first zone with nozne 0 */
	if( nzone == 0 )
	{
		lgEndFun_v = FALSE;
		
		if( trace.lgTrace )
		{
			fprintf( ioQQQ, " lgEndFun returns, doing nothing since zone 0.\n" );
		}
#		ifdef DEBUG_FUN
		fputs( " <->lgEndFun()\n", debug_fp );
#		endif
		return( lgEndFun_v );
	}

	/* check whether trace is needed for this zone and iteration */
	if( (nzone >= trace.nznbug && iteration >= trace.npsbug) && 
	  trovrd.lgTrOvrd )
	{
		ZoneCnt.nprint = 1;
		trace.lgTrace = TRUE;
	}

	/* option to turn printout on after certain zone */
	if( printit.lgPrtStart && printit.nstart == nzone )
	{
		called.lgTalk = TRUE;
	}

	/* check whether model is done, various criteria used. */
	lgDone = FALSE;

	/* this is flag to chekc whether stopping reason was bad */
	badstp.lgBadStop = FALSE;

	/* >>chng 01 jul 27, add set temper floor option  -
	 * go to constant temperature calculation if temperature
	 * falls below floor */
	if( phycon.te <= StopCalc.TeFloor )
	{
		thermal.lgTSetOn = TRUE;
		thermal.ForceTemp = StopCalc.TeFloor;
		phycon.te = thermal.ForceTemp;
		tfidle(FALSE);
	}

	/* >>chng 97 jul 23, from last iteration only, to any greater than 1
	 * >>chng 97 jul 23, back again to original */
	if( (pressure.lgRadPresON && pressure.pbeta > 1.0) && 
		(strcmp(pressure.chCPres ,"CPRE") == 0) && 
		IterCnt.lgLastIt &&
		pressure.lgRadPresAbortOK )
	{
		/* const total pres model; if RadPres>PGAS, then unstable, stop */
		if( called.lgTalk )
		{
			fprintf( ioQQQ, "\n STOP since P(rad)/P(gas)=%7.3f >1.0\n", 
			  pressure.pbeta );

			if( pressure.HLalpha/pressure.PressureRadiation > 0.9 )
			{
				fprintf( ioQQQ, " Caused by Ly-alpha.\n" );
			}
			else
			{
				fprintf( ioQQQ, " Line contributors to radiation pressure follows:\n" );
				PrtLinePres();
			}
		}
		lgDone = TRUE;
		badstp.lgBadStop = TRUE;
		strcpy( reason.chReason, "of radiation pressure" );

	}

	else if( !wind.lgVelPos && wind.windv0 > 0.)
	{
		/* wind solution with negative velocity */
		lgDone = TRUE;
		strcpy( reason.chReason, "wind veloc too small " );
	}

	else if( !wind.lgVelPos && wind.windv0 < 0.)
	{
		/* D-critical solution reached sonic point */
		lgDone = TRUE;
		strcpy( reason.chReason, "sonic point reached  " );
	}

	else if( called.lgBusted )
	{
		/* calculation failed */
		badstp.lgBadStop = TRUE;
		lgDone = TRUE;
		strcpy( reason.chReason, "code returned BUSTED " );
	}

	else if( co.lgLotsCO )
	{
		/* all carbon in CO */
		lgDone = TRUE;
		strcpy( reason.chReason, "carbon fully moleculr" );
	}

	else if( co.lgComNeg )
	{
		/* heavy element molecule solution with negative population */
		lgDone = TRUE;
		badstp.lgBadStop = TRUE;
		strcpy( reason.chReason, "negative mole abundan" );
	}

	else if( radius.lgdR2Small )
	{
		lgDone = TRUE;
		badstp.lgBadStop = TRUE;
		strcpy( reason.chReason, "DR small rel to thick" );
	}

	else if( phycon.eden < StopCalc.StopElecDensity )
	{
		lgDone = TRUE;
		strcpy( reason.chReason, "lowest EDEN reached. " );
	}

	else if( phycon.eden/phycon.hden < StopCalc.StopElecFrac )
	{
		lgDone = TRUE;
		strcpy( reason.chReason, "low electron fraction" );
	}

	else if( drminu.lgDrMinUsed )
	{
		/* dr became too small */
		badstp.lgBadStop = TRUE;
		lgDone = TRUE;
		strcpy( reason.chReason, "DRAD small- set DRMIN" );
	}

	else if( radius.depth >= radius.router[iteration-1]/EPS || 
	  drneg.lgDrNeg )
	{
		lgDone = TRUE;
		strcpy( reason.chReason, "outer radius reached." );
	}

	else if( StopCalc.iptnu >= 0 && opac.TauAbsGeo[0][StopCalc.iptnu-1] >= 
	  StopCalc.tauend/EPS )
	{
		lgDone = TRUE;
		strcpy( reason.chReason, "optical depth reached" );
	}

	else if( coldenCom.colden[ipCOLUMNDENSITY] >= StopCalc.HColStop/
	  EPS )
	{
		lgDone = TRUE;
		strcpy( reason.chReason, "column dens reached. " );
	}

	else if( coldenCom.colden[ipCHII] >= StopCalc.colpls/EPS )
	{
		lgDone = TRUE;
		strcpy( reason.chReason, "column dens reached. " );
	}

	else if( coldenCom.colden[ipCHI] >= StopCalc.colnut/EPS )
	{
		lgDone = TRUE;
		strcpy( reason.chReason, "column dens reached. " );
	}

	/* >>chng 9 jul 7, when no h2 molecules, include h2 as neutral atomic hydrogen */
	else if( nomole.lgNoH2Mole &&
		( (coldenCom.colden[ipCHI]+2.*coldenCom.colden[ipCOLH2]) >= StopCalc.colnut/EPS)  )
	{
		lgDone = TRUE;
		strcpy( reason.chReason, "column dens reached. " );
	}

	else if( phycon.te > StopCalc.T2High )
	{
		lgDone = TRUE;
		strcpy( reason.chReason, "highest Te reached.  " );
	}

	else if( phycon.te < StopCalc.tend )
	{
		lgDone = TRUE;
		strcpy( reason.chReason, "lowest Te reached.   " );
	}

	else if( nzone >= ZoneCnt.nend[iteration-1] )
	{
		lgDone = TRUE;
		ZoneCnt.lgZoneTrp = TRUE;
		strcpy( reason.chReason, "NZONE reached.       " );
	}

	/* option to stop calculation when line intensity ratio reaches certain value,
	 * nstpl is number of stop line commands entered */
	else if( StopCalc.nstpl > 0 )
	{
		/* line ratio exceeded maximum permitted value
		 * do not consider case where norm line has zero intensity */
		for( i=0; i < StopCalc.nstpl; i++ )
		{
			/* the second line is always set to something, default is hbeta */
			if( LineSv[StopCalc.ipStopLin2[i]].sumlin > 0. )
			{
				char chString[10];
				if( LineSv[StopCalc.ipStopLin1[i]].sumlin/
					LineSv[StopCalc.ipStopLin2[i]].sumlin > StopCalc.stpint[i] )
				{
					lgDone = TRUE;
					sprt_wl( chString , StopCalc.StopLineWl[i] );
					sprintf( reason.chReason, "line %s reached.   ", chString );
				}
			}
		}
	}

	else if( radius.drNext <= 0. )
	{
		/* this cant happen */
		if( called.lgTalk )
		{
			fprintf( ioQQQ, " drNext=%10.2e STOP\n", radius.drNext );
		}
		lgDone = TRUE;
		badstp.lgBadStop = TRUE;
		strcpy( reason.chReason, "internal error - DRAD" );
		ShowMe();
	}

	lgPrinted = FALSE;
	if( lgDone )
	{
		/* flag to call it quits */
		lgEndFun_v = TRUE;
		PrtZone();
		lgPrinted = TRUE;
	}

	else
	{
		/* passed all the tests, keep going
		 * time dependent model of this zone? */
		if( timed.itime == nzone )
		{
			timer();
			puts( "[Stop in lgendfun]" );
			cdEXIT(1);
		}

		/* check whether this zone should be printed */
		if( ((nzone/ZoneCnt.nprint)*ZoneCnt.nprint == nzone || 
		  nzone == 1) || trace.lgTrConvg )
		{
			PrtZone();
			lgPrinted = TRUE;
		}
		/* flag to keep going */
		lgEndFun_v = FALSE;
	}

	/* dump cooling arrays for this zone? */
	if( dump.nzdump == nzone || dump.nzdump == 0 )
		dmpary();

	/* do map of cooling function if desired, and not yet done */
	if( !MapPar.lgMapDone && (MapPar.MapZone < 0 || nzone == MapPar.MapZone) )
	{
		FILE *ioSAVE;
		/* print last zone if not already done */
		if( !lgPrinted )
		{
			PrtZone();
		}

		/* save old output file then redirect to map file */
		ioSAVE = ioQQQ;
		/* >>chng 01 mar 28, ioMAP may not be initialized, PvH */
		if( ioMAP != NULL )
			ioQQQ = ioMAP;
		punt(" map");
		ioQQQ = ioSAVE;

		/* stop after doing map */
		lgEndFun_v = TRUE;
		strcpy( reason.chReason, "MAP command used-stop" );
		
		if( trace.lgTrace )
		{
			fprintf( ioQQQ, " lgEndFun returns after map.\n" );
		}
#		ifdef DEBUG_FUN
		fputs( " <->lgEndFun()\n", debug_fp );
#		endif
		return( lgEndFun_v );
	}

	if( lgEndFun_v && printit.lgOnlyZone )
	{
		puts( "[Stop in lgendfun since only zone printout desired.]" );
		cdEXIT(1);
	}

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, " lgEndFun bottom return.\n" );
	}
#	ifdef DEBUG_FUN
	fputs( " <->lgEndFun()\n", debug_fp );
#	endif
	return( lgEndFun_v );
}

#ifdef EPS
#	undef EPS
#endif
#define	EPS	0.005
/*dmpary print all coolants for some zone, as from print cooling command */
static void dmpary(void)
{
	long int i;
	float ratio;

#	ifdef DEBUG_FUN
	fputs( "<+>dmpary()\n", debug_fp );
#	endif

	fprintf( ioQQQ, 
		" This is a print out of the cooling array for zone number %3ld\n", 
	  nzone );

	fprintf( ioQQQ, 
		" The total heating was HTOT=%10.2e erg/s/cm3, the total cooling was CTOT=%10.2e, and the temperature was%10.3eK.\n", 
	  heat.htot, cooling.ctot, phycon.te );

	fprintf( ioQQQ, 
		" All coolants greater than%6.2f%% of the total will be printed.\n", 
	  EPS*100. );

	/* flag all significant coolants */
	coolpr("ZERO",1,0.,"ZERO");
	for( i=0; i < cooling.ncltot; i++ )
	{
		ratio = (float)(cooling.cooling[i]/cooling.ctot);
		if( fabs(ratio) > EPS )
		{
			coolpr((char*)cooling.chClntLab[i],cooling.collam[i],
			  ratio,"DOIT");
		}

		ratio = (float)(cooling.heatnt[i]/cooling.ctot);
		if( fabs(ratio) > EPS )
		{
			coolpr((char*)cooling.chClntLab[i],cooling.collam[i],
			  ratio,"DOIT");
		}
	}
	coolpr("DONE",1,0.,"DONE");


#	ifdef DEBUG_FUN
	fputs( " <->dmpary()\n", debug_fp );
#	endif
	return;
}

