/*LineFit effective recombination coefficients for lines of C, N, O, by D. Verner */
/*lint -e736 */ /* turn off loss of precision double to float */
#ifdef _MSC_VER
#	pragma warning( disable : 4305 )/* disable bogus const double fl float warning in MS VS*/
#endif
#include "cddefines.h"
#include "linefit.h"
struct t_ADfAP {
	float P[8][110];
	}	ADfAP;
struct t_ADfAST {
	float ST[9][405];
	}	ADfAST;

void LineFitData1(void);
void LineFitData2(void);
void LineFitData3(void);
void LineFitData4(void);
void LineFitData5(void);
void LineFitData6(void);
void LineFitData7(void);
void LineFitData8(void);
void LineFitData9(void);
void LineFitData10(void);

void LineFit(double t, 
	  float r[][471])
{
	long int i, 
	  j, 
	  ipj1, 
	  ipj2;

	static int lgCalled=FALSE;

	double a, 
	  a1, 
	  dr[4][405], 
	  p1, 
	  p2, 
	  p3, 
	  p4, 
	  p5, 
	  p6, 
	  rr[4][110], 
	  te, 
	  x, 
	  z;

	static long jd[6]={143,145,157,360,376,379};

	static long ip[38]={7,9,12,13,14,16,18,19,20,21,22,44,45,49,50,
	  52,53,54,55,56,57,58,59,60,66,67,78,83,84,87,88,95,96,97,100,
	  101,103,104};

	static long id[38]={7,3,10,27,23,49,51,64,38,47,60,103,101,112,
	  120,114,143,145,157,152,169,183,200,163,225,223,237,232,235,
	  249,247,300,276,278,376,360,379,384};

#	ifdef DEBUG_FUN
	fputs( "<+>LineFit()\n", debug_fp );
#	endif

	/*effective recombination coefficients for lines of C, N, O, by D. Verner
	 * Version 2, April 30, 1997
	 ******************************************************************************
	 *** This subroutine calculates effective recombination coefficients
	 *** for 110 permitted recombination lines of C, N, O (Pequignot, Petitjean,
	 *** & Boisson, 1991, A&A, 251, 680) and 405 permitted dielectronic 
	 *** recombination lines (Nussbaumer & Storey, 1984, A&AS, 56, 293)
	 *** Input parameter:   t  - temperature, K
	 *** Output parameters: r(i,j), i=1,471
	 ***          r(i,1) - atomic number
	 ***          r(i,2) - number of electrons
	 ***          r(i,3) - wavelength, angstrom
	 ***          r(i,4) - rate coefficient, cm^3 s^(-1)
	 ****************************************************************************** */

	if( !lgCalled )
	{
		LineFitData1();
		LineFitData2();
		LineFitData3();
		LineFitData4();
		LineFitData5();
		LineFitData6();
		LineFitData7();
		LineFitData8();
		LineFitData9();
		LineFitData10();
		lgCalled = TRUE;
	}

	for( i=0; i < 110; i++ )
	{
		rr[0][i] = ADfAP.P[0][i];
		rr[1][i] = ADfAP.P[1][i];
		rr[2][i] = ADfAP.P[2][i];
		z = ADfAP.P[0][i] - ADfAP.P[1][i] + 1.0;
		te = 1.0e-04*t/z/z;
		p1 = ADfAP.P[3][i];
		p2 = ADfAP.P[4][i];
		p3 = ADfAP.P[5][i];
		p4 = ADfAP.P[6][i];
		if( te < 0.004 )
		{
			a1 = p1*pow(0.004,p2)/(1.0 + p3*pow(0.004,p4));
			a = a1/sqrt(te/0.004);
		}
		else
		{
			if( te > 2.0 )
			{
				a1 = p1*pow(2.0,p2)/(1.0 + p3*pow(2.0,p4));
				a = a1/pow(te/2.0,1.5);
			}
			else
			{
				a = p1*pow(te,p2)/(1.0 + p3*pow(te,p4));
			}
		}
		rr[3][i] = 1.0e-13*z*a*ADfAP.P[7][i];
	}

	for( i=0; i < 405; i++ )
	{
		dr[0][i] = ADfAST.ST[0][i];
		dr[1][i] = ADfAST.ST[1][i];
		dr[2][i] = ADfAST.ST[2][i];
		te = 1.0e-04*t;
		p1 = ADfAST.ST[3][i];
		p2 = ADfAST.ST[4][i];
		p3 = ADfAST.ST[5][i];
		p4 = ADfAST.ST[6][i];
		p5 = ADfAST.ST[7][i];
		p6 = ADfAST.ST[8][i];
		if( te < p6 )
		{
			x = p5*(1.0/te - 1.0/p6);
			if( x > 80.0 )
			{
				a = 0.0;
			}
			else
			{
				a1 = (p1/p6 + p2 + p3*p6 + p4*p6*p6)/pow(p6,1.5)/exp(p5/
				  p6);
				a = a1/exp(x);
			}
		}
		else
		{
			if( te > 6.0 )
			{
				a1 = (p1/6.0 + p2 + p3*6.0 + p4*36.0)/pow(6.0,1.5)/
				  exp(p5/6.0);
				a = a1/pow(te/6.0,1.5);
			}
			else
			{
				a = (p1/te + p2 + p3*te + p4*te*te)/pow(te,1.5)/exp(p5/
				  te);
			}
		}
		dr[3][i] = 1.0e-12*a;
	}

	for( i=0; i < 6; i++ )
	{
		ipj1 = jd[i];
		ipj2 = ipj1 + 1;
		dr[3][ipj1-1] += dr[3][ipj2-1];
		dr[0][ipj2-1] = 0.0;
	}

	for( i=0; i < 38; i++ )
	{
		ipj1 = ip[i];
		ipj2 = id[i];
		rr[3][ipj1-1] += dr[3][ipj2-1];
		dr[0][ipj2-1] = 0.0;
	}

	for( i=0; i < 110; i++ )
	{
		r[0][i] = (float)rr[0][i];
		r[1][i] = (float)rr[1][i];
		r[2][i] = (float)rr[2][i];
		r[3][i] = (float)rr[3][i];
	}

	j = 110;
	for( i=0; i < 405; i++ )
	{
		if( dr[0][i] > 1.0 )
		{
			j += 1;
			r[0][j-1] = (float)dr[0][i];
			r[1][j-1] = (float)dr[1][i];
			r[2][j-1] = (float)dr[2][i];
			r[3][j-1] = (float)dr[3][i];
		}
	}
	
#	ifdef DEBUG_FUN
	fputs( " <->LineFit()\n", debug_fp );
#	endif
	return;
}

	static long int I, 
	  _r;

/********************************************* */
void LineFitData1(void)
{
		{ static float _itmp0[] = {6.,6.,10695.,0.663,-0.679,0.624,
		  0.681,0.994};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][0] = _itmp0[_r++];
			}
		}
		{ static float _itmp1[] = {6.,6.,9088.,0.171,-0.558,0.624,
		  0.681,0.958};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][1] = _itmp1[_r++];
			}
		}
		{ static float _itmp2[] = {6.,6.,9658.,0.054,-0.528,0.624,
		  0.681,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][2] = _itmp2[_r++];
			}
		}
		{ static float _itmp3[] = {6.,6.,1657.,0.954,-0.665,0.239,
		  0.687,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][3] = _itmp3[_r++];
			}
		}
		{ static float _itmp4[] = {6.,6.,6828.,0.046,-0.536,1.504,
		  0.779,0.254};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][4] = _itmp4[_r++];
			}
		}
		{ static float _itmp5[] = {6.,5.,9903.,0.697,-0.784,4.205,
		  0.720,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][5] = _itmp5[_r++];
			}
		}
		{ static float _itmp6[] = {6.,5.,4267.,1.011,-0.754,2.587,
		  0.719,0.950};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][6] = _itmp6[_r++];
			}
		}
		{ static float _itmp7[] = {6.,5.,7231.,1.724,-0.700,1.683,
		  0.667,0.012};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][7] = _itmp7[_r++];
			}
		}
		{ static float _itmp8[] = {6.,5.,6580.,0.584,-0.521,0.624,
		  0.681,0.170};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][8] = _itmp8[_r++];
			}
		}
		{ static float _itmp9[] = {6.,5.,2837.,0.584,-0.521,0.624,
		  0.681,0.313};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][9] = _itmp9[_r++];
			}
		}
		{ static float _itmp10[] = {6.,5.,1761.,0.584,-0.521,0.624,
		  0.681,0.517};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][10] = _itmp10[_r++];
			}
		}
		{ static float _itmp11[] = {6.,5.,1335.,0.953,-0.539,0.412,
		  0.654,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][11] = _itmp11[_r++];
			}
		}
		{ static float _itmp12[] = {6.,4.,8197.,0.587,-0.780,7.448,
		  0.720,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][12] = _itmp12[_r++];
			}
		}
		{ static float _itmp13[] = {6.,4.,8665.,0.293,-0.611,4.486,
		  0.849,0.421};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][13] = _itmp13[_r++];
			}
		}
		{ static float _itmp14[] = {6.,4.,2726.,0.293,-0.611,4.486,
		  0.849,0.574};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][14] = _itmp14[_r++];
			}
		}
		{ static float _itmp15[] = {6.,4.,4069.,0.523,-0.784,4.205,
		  0.720,0.910};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][15] = _itmp15[_r++];
			}
		}
		{ static float _itmp16[] = {6.,4.,7613.,0.523,-0.784,4.205,
		  0.720,0.090};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][16] = _itmp16[_r++];
			}
		}
		{ static float _itmp17[] = {6.,4.,3888.,0.359,-0.572,2.795,
		  0.827,0.119};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][17] = _itmp17[_r++];
			}
		}
		{ static float _itmp18[] = {6.,4.,1923.,0.688,-0.754,2.587,
		  0.719,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][18] = _itmp18[_r++];
			}
		}
		{ static float _itmp19[] = {6.,4.,4649.,0.429,-0.501,0.624,
		  0.681,0.940};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][19] = _itmp19[_r++];
			}
		}
		{ static float _itmp20[] = {6.,4.,4187.,0.174,-0.784,4.205,
		  0.720,0.980};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][20] = _itmp20[_r++];
			}
		}
		{ static float _itmp21[] = {6.,4.,2163.,0.229,-0.754,2.587,
		  0.719,0.426};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][21] = _itmp21[_r++];
			}
		}
		{ static float _itmp22[] = {6.,3.,7726.,0.580,-0.775,7.448,
		  0.720,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][22] = _itmp22[_r++];
			}
		}
		{ static float _itmp23[] = {6.,3.,4659.,0.519,-0.818,4.205,
		  0.720,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][23] = _itmp23[_r++];
			}
		}
		{ static float _itmp24[] = {6.,3.,2529.,0.907,-0.749,4.205,
		  0.720,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][24] = _itmp24[_r++];
			}
		}
		{ static float _itmp25[] = {6.,3.,1549.,3.772,-0.590,0.889,
		  0.549,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][25] = _itmp25[_r++];
			}
		}
		{ static float _itmp26[] = {7.,7.,10117.,0.601,-0.695,1.683,
		  0.667,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][26] = _itmp26[_r++];
			}
		}
		{ static float _itmp27[] = {7.,7.,10525.,0.393,-0.697,1.683,
		  0.667,0.724};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][27] = _itmp27[_r++];
			}
		}
		{ static float _itmp28[] = {7.,7.,9829.,0.393,-0.697,1.683,
		  0.667,0.276};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][28] = _itmp28[_r++];
			}
		}
		{ static float _itmp29[] = {7.,7.,8692.,1.254,-0.624,1.683,
		  0.667,0.957};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][29] = _itmp29[_r++];
			}
		}
		{ static float _itmp30[] = {7.,7.,8212.,0.624,-0.602,1.683,
		  0.667,0.760};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][30] = _itmp30[_r++];
			}
		}
		{ static float _itmp31[] = {7.,7.,7452.,0.047,-0.489,0.624,
		  0.681,0.964};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][31] = _itmp31[_r++];
			}
		}
		{ static float _itmp32[] = {7.,7.,1200.,1.437,-0.664,0.768,
		  0.564,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][32] = _itmp32[_r++];
			}
		}
		{ static float _itmp33[] = {7.,6.,4530.,0.108,-0.754,2.587,
		  0.719,0.650};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][33] = _itmp33[_r++];
			}
		}
		{ static float _itmp34[] = {7.,6.,4026.,0.108,-0.754,2.587,
		  0.719,0.350};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][34] = _itmp34[_r++];
			}
		}
		{ static float _itmp35[] = {7.,6.,4176.,0.085,-0.754,2.587,
		  0.719,0.542};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][35] = _itmp35[_r++];
			}
		}
		{ static float _itmp36[] = {7.,6.,1494.,0.085,-0.754,2.587,
		  0.719,0.391};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][36] = _itmp36[_r++];
			}
		}
		{ static float _itmp37[] = {7.,6.,2232.,0.059,-0.754,2.587,
		  0.719,0.653};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][37] = _itmp37[_r++];
			}
		}
		{ static float _itmp38[] = {7.,6.,4678.,0.059,-0.754,2.587,
		  0.719,0.223};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][38] = _itmp38[_r++];
			}
		}
		{ static float _itmp39[] = {7.,6.,4041.,0.326,-0.754,2.587,
		  0.719,0.926};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][39] = _itmp39[_r++];
			}
		}
		{ static float _itmp40[] = {7.,6.,4552.,0.326,-0.754,2.587,
		  0.719,0.074};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][40] = _itmp40[_r++];
			}
		}
		{ static float _itmp41[] = {7.,6.,4239.,0.252,-0.754,2.587,
		  0.719,0.887};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][41] = _itmp41[_r++];
			}
		}
		{ static float _itmp42[] = {7.,6.,4435.,0.181,-0.754,2.587,
		  0.719,0.790};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][42] = _itmp42[_r++];
			}
		}
		{ static float _itmp43[] = {7.,6.,5005.,0.633,-0.690,1.683,
		  0.667,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][43] = _itmp43[_r++];
			}
		}
		{ static float _itmp44[] = {7.,6.,5679.,1.200,-0.615,1.683,
		  0.667,0.337};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][44] = _itmp44[_r++];
			}
		}
		{ static float _itmp45[] = {7.,6.,1742.,3.561,-0.615,1.683,
		  0.667,0.520};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][45] = _itmp45[_r++];
			}
		}
		{ static float _itmp46[] = {7.,6.,1345.,3.561,-0.615,1.683,
		  0.667,0.137};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][46] = _itmp46[_r++];
			}
		}
		{ static float _itmp47[] = {7.,5.,8237.,0.587,-0.780,7.448,
		  0.720,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][47] = _itmp47[_r++];
			}
		}
		{ static float _itmp48[] = {7.,5.,4379.,0.697,-0.784,4.205,
		  0.720,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][48] = _itmp48[_r++];
			}
		}
		{ static float _itmp49[] = {7.,5.,1885.,1.011,-0.754,2.587,
		  0.719,0.924};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][49] = _itmp49[_r++];
			}
		}
		{ static float _itmp50[] = {7.,5.,4641.,1.434,-0.707,1.683,
		  0.667,0.005};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][50] = _itmp50[_r++];
			}
		}
		{ static float _itmp51[] = {7.,5.,4110.,1.350,-0.734,0.624,
		  0.681,0.058};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][51] = _itmp51[_r++];
			}
		}
		{ static float _itmp52[] = {7.,4.,7703.,0.438,-0.801,10.350,
		  0.717,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][52] = _itmp52[_r++];
			}
		}
		{ static float _itmp53[] = {7.,4.,7582.,0.363,-0.618,7.778,
		  0.848,0.510};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][53] = _itmp53[_r++];
			}
		}
}
void LineFitData2(void)
{
		{ static float _itmp54[] = {7.,4.,4606.,0.587,-0.780,7.448,
		  0.720,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][54] = _itmp54[_r++];
			}
		}
		{ static float _itmp55[] = {7.,4.,4707.,0.293,-0.611,4.486,
		  0.849,0.426};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][55] = _itmp55[_r++];
			}
		}
		{ static float _itmp56[] = {7.,4.,2646.,0.523,-0.784,4.205,
		  0.720,0.730};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][56] = _itmp56[_r++];
			}
		}
		{ static float _itmp57[] = {7.,4.,1700.,0.523,-0.784,4.205,
		  0.720,0.235};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][57] = _itmp57[_r++];
			}
		}
		{ static float _itmp58[] = {7.,4.,1036.,0.520,-0.754,2.587,
		  0.719,0.992};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][58] = _itmp58[_r++];
			}
		}
		{ static float _itmp59[] = {7.,4.,3481.,0.429,-0.501,0.624,
		  0.681,0.817};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][59] = _itmp59[_r++];
			}
		}
		{ static float _itmp60[] = {7.,3.,7618.,0.550,-0.764,10.350,
		  0.717,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][60] = _itmp60[_r++];
			}
		}
		{ static float _itmp61[] = {7.,3.,4945.,0.566,-0.780,7.448,
		  0.720,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][61] = _itmp61[_r++];
			}
		}
		{ static float _itmp62[] = {7.,3.,2981.,0.519,-0.818,4.205,
		  0.720,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][62] = _itmp62[_r++];
			}
		}
		{ static float _itmp63[] = {7.,3.,1620.,0.907,-0.749,4.205,
		  0.720,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][63] = _itmp63[_r++];
			}
		}
		{ static float _itmp64[] = {8.,8.,8447.,0.226,-0.508,0.624,
		  0.681,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][64] = _itmp64[_r++];
			}
		}
		{ static float _itmp65[] = {8.,8.,7773.,1.983,-0.630,0.971,
		  0.573,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][65] = _itmp65[_r++];
			}
		}
		{ static float _itmp66[] = {8.,8.,9264.,1.191,-0.684,1.683,
		  0.667,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][66] = _itmp66[_r++];
			}
		}
		{ static float _itmp67[] = {8.,8.,3947.,0.264,-0.589,0.442,
		  0.756,0.158};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][67] = _itmp67[_r++];
			}
		}
		{ static float _itmp68[] = {8.,8.,1357.,2.231,-0.630,0.971,
		  0.573,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][68] = _itmp68[_r++];
			}
		}
		{ static float _itmp69[] = {8.,7.,4342.,0.144,-0.754,2.587,
		  0.719,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][69] = _itmp69[_r++];
			}
		}
		{ static float _itmp70[] = {8.,7.,4607.,0.112,-0.754,2.587,
		  0.719,0.880};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][70] = _itmp70[_r++];
			}
		}
		{ static float _itmp71[] = {8.,7.,4489.,0.080,-0.754,2.587,
		  0.719,0.074};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][71] = _itmp71[_r++];
			}
		}
		{ static float _itmp72[] = {8.,7.,4094.,0.289,-0.754,2.587,
		  0.719,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][72] = _itmp72[_r++];
			}
		}
		{ static float _itmp73[] = {8.,7.,4278.,0.225,-0.754,2.587,
		  0.719,0.880};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][73] = _itmp73[_r++];
			}
		}
		{ static float _itmp74[] = {8.,7.,4051.,0.225,-0.754,2.587,
		  0.719,0.120};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][74] = _itmp74[_r++];
			}
		}
		{ static float _itmp75[] = {8.,7.,4294.,0.160,-0.754,2.587,
		  0.719,0.850};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][75] = _itmp75[_r++];
			}
		}
		{ static float _itmp76[] = {8.,7.,4339.,0.160,-0.754,2.587,
		  0.719,0.150};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][76] = _itmp76[_r++];
			}
		}
		{ static float _itmp77[] = {8.,7.,4075.,0.601,-0.695,1.683,
		  0.667,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][77] = _itmp77[_r++];
			}
		}
		{ static float _itmp78[] = {8.,7.,4111.,0.409,-0.705,1.683,
		  0.667,0.720};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][78] = _itmp78[_r++];
			}
		}
		{ static float _itmp79[] = {8.,7.,3867.,0.409,-0.705,1.683,
		  0.667,0.280};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][79] = _itmp79[_r++];
			}
		}
		{ static float _itmp80[] = {8.,7.,4152.,0.226,-0.679,1.683,
		  0.667,0.616};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][80] = _itmp80[_r++];
			}
		}
		{ static float _itmp81[] = {8.,7.,4913.,0.226,-0.679,1.683,
		  0.667,0.294};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][81] = _itmp81[_r++];
			}
		}
		{ static float _itmp82[] = {8.,7.,4651.,1.257,-0.624,1.683,
		  0.667,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][82] = _itmp82[_r++];
			}
		}
		{ static float _itmp83[] = {8.,7.,4341.,0.633,-0.609,1.683,
		  0.667,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][83] = _itmp83[_r++];
			}
		}
		{ static float _itmp84[] = {8.,7.,3736.,0.047,-0.506,0.624,
		  0.681,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][84] = _itmp84[_r++];
			}
		}
		{ static float _itmp85[] = {8.,6.,4435.,0.155,-0.784,4.205,
		  0.720,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][85] = _itmp85[_r++];
			}
		}
		{ static float _itmp86[] = {8.,6.,3265.,0.633,-0.690,1.683,
		  0.667,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][86] = _itmp86[_r++];
			}
		}
		{ static float _itmp87[] = {8.,6.,3762.,1.200,-0.615,1.683,
		  0.667,0.383};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][87] = _itmp87[_r++];
			}
		}
		{ static float _itmp88[] = {8.,6.,5592.,0.050,-0.508,0.624,
		  0.691,0.220};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][88] = _itmp88[_r++];
			}
		}
		{ static float _itmp89[] = {8.,5.,7713.,0.438,-0.801,10.350,
		  0.717,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][89] = _itmp89[_r++];
			}
		}
		{ static float _itmp90[] = {8.,5.,7677.,0.363,-0.618,7.778,
		  0.848,0.510};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][90] = _itmp90[_r++];
			}
		}
		{ static float _itmp91[] = {8.,5.,4632.,0.587,-0.780,7.448,
		  0.720,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][91] = _itmp91[_r++];
			}
		}
		{ static float _itmp92[] = {8.,5.,4344.,0.391,-0.611,4.486,
		  0.849,0.450};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][92] = _itmp92[_r++];
			}
		}
		{ static float _itmp93[] = {8.,5.,2450.,0.697,-0.784,4.205,
		  0.720,0.913};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][93] = _itmp93[_r++];
			}
		}
		{ static float _itmp94[] = {8.,5.,1068.,0.906,-0.740,2.587,
		  0.719,0.406};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][94] = _itmp94[_r++];
			}
		}
		{ static float _itmp95[] = {8.,5.,3409.,0.700,-0.700,1.683,
		  0.667,0.003};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][95] = _itmp95[_r++];
			}
		}
		{ static float _itmp96[] = {8.,5.,3066.,0.430,-0.473,0.624,
		  0.681,0.117};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][96] = _itmp96[_r++];
			}
		}
		{ static float _itmp97[] = {8.,4.,7611.,0.354,-0.812,14.400,
		  0.712,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][97] = _itmp97[_r++];
			}
		}
		{ static float _itmp98[] = {8.,4.,7592.,0.311,-0.641,11.480,
		  0.846,0.563};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][98] = _itmp98[_r++];
			}
		}
		{ static float _itmp99[] = {8.,4.,2993.,0.311,-0.641,11.480,
		  0.846,0.430};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][99] = _itmp99[_r++];
			}
		}
		{ static float _itmp100[] = {8.,4.,4930.,0.438,-0.801,10.350,
		  0.717,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][100] = _itmp100[_r++];
			}
		}
		{ static float _itmp101[] = {8.,4.,1845.,0.363,-0.618,7.778,
		  0.848,0.470};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][101] = _itmp101[_r++];
			}
		}
		{ static float _itmp102[] = {8.,4.,2942.,0.587,-0.780,7.448,
		  0.720,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][102] = _itmp102[_r++];
			}
		}
		{ static float _itmp103[] = {8.,4.,1644.,0.492,-0.784,4.205,
		  0.720,0.850};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][103] = _itmp103[_r++];
			}
		}
		{ static float _itmp104[] = {8.,4.,1708.,0.164,-0.784,4.205,
		  0.720,0.680};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][104] = _itmp104[_r++];
			}
		}
		{ static float _itmp105[] = {8.,3.,5291.,0.545,-0.764,10.350,
		  0.717,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][105] = _itmp105[_r++];
			}
		}
		{ static float _itmp106[] = {8.,3.,2082.,0.331,-0.553,11.480,
		  0.846,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][106] = _itmp106[_r++];
			}
		}
		{ static float _itmp107[] = {8.,3.,3434.,0.566,-0.780,7.448,
		  0.720,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][107] = _itmp107[_r++];
			}
		}
}
void LineFitData3(void)
{
		{ static float _itmp108[] = {8.,3.,2070.,0.519,-0.818,4.205,
		  0.720,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][108] = _itmp108[_r++];
			}
		}
		{ static float _itmp109[] = {8.,3.,1125.,0.907,-0.749,4.205,
		  0.720,1.000};
		for( I=1, _r = 0; I <= 8; I++ )
		{
			ADfAP.P[I-1][109] = _itmp109[_r++];
			}
		}
		{ static float _itmp110[] = {6.,6.,1140.1,0.0000,0.4616,0.0000,
		  0.0000,1.0136,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][0] = _itmp110[_r++];
			}
		}
		{ static float _itmp111[] = {6.,5.,8797.3,0.0000,0.0859,0.0000,
		  0.0000,0.4749,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][1] = _itmp111[_r++];
			}
		}
		{ static float _itmp112[] = {6.,5.,6579.3,0.0619,-0.1724,0.1524,
		  -0.0055,1.6026,0.30};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][2] = _itmp112[_r++];
			}
		}
		{ static float _itmp113[] = {6.,5.,5113.4,0.0000,0.3787,0.0000,
		  0.0000,3.6080,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][3] = _itmp113[_r++];
			}
		}
		{ static float _itmp114[] = {6.,5.,4961.1,0.0000,0.0273,0.0000,
		  0.0000,0.7948,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][4] = _itmp114[_r++];
			}
		}
		{ static float _itmp115[] = {6.,5.,4619.1,-0.0004,0.9778,0.0002,
		  0.0000,3.5887,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][5] = _itmp115[_r++];
			}
		}
		{ static float _itmp116[] = {6.,5.,4267.2,0.8583,-1.9394,1.1805,
		  -0.0323,5.6506,0.60};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][6] = _itmp116[_r++];
			}
		}
		{ static float _itmp117[] = {6.,5.,4142.4,0.0000,0.1297,0.0000,
		  0.0000,2.3123,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][7] = _itmp117[_r++];
			}
		}
		{ static float _itmp118[] = {6.,5.,3165.7,0.0001,0.3373,0.0000,
		  0.0000,5.0189,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][8] = _itmp118[_r++];
			}
		}
		{ static float _itmp119[] = {6.,5.,1335.3,1.5568,3.9044,2.6807,
		  -0.0123,0.5834,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][9] = _itmp119[_r++];
			}
		}
		{ static float _itmp120[] = {6.,5.,1167.5,0.0000,0.2038,0.0000,
		  0.0000,0.7948,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][10] = _itmp120[_r++];
			}
		}
		{ static float _itmp121[] = {6.,5.,1092.5,0.0000,0.7724,0.0001,
		  0.0000,0.7948,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][11] = _itmp121[_r++];
			}
		}
		{ static float _itmp122[] = {6.,5.,1036.8,0.4879,0.1712,1.3281,
		  -0.0308,0.9202,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][12] = _itmp122[_r++];
			}
		}
		{ static float _itmp123[] = {6.,5.,971.1,-0.0003,6.4693,0.0006,
		  -0.0001,7.4627,0.25};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][13] = _itmp123[_r++];
			}
		}
		{ static float _itmp124[] = {6.,5.,952.5,-0.0003,3.3894,0.0003,
		  0.0000,5.7634,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][14] = _itmp124[_r++];
			}
		}
		{ static float _itmp125[] = {6.,5.,946.1,0.0001,1.4276,0.0001,
		  0.0000,0.7949,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][15] = _itmp125[_r++];
			}
		}
		{ static float _itmp126[] = {6.,5.,799.8,-0.0001,6.8606,0.0002,
		  0.0000,0.4749,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][16] = _itmp126[_r++];
			}
		}
		{ static float _itmp127[] = {6.,4.,14382.5,0.0291,-0.1855,
		  0.3267,-0.0338,4.6059,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][17] = _itmp127[_r++];
			}
		}
		{ static float _itmp128[] = {6.,4.,13986.1,0.0263,-0.0947,
		  0.1296,-0.0109,3.7460,0.30};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][18] = _itmp128[_r++];
			}
		}
		{ static float _itmp129[] = {6.,4.,13717.4,0.0859,-0.5480,
		  0.9649,-0.0997,4.6058,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][19] = _itmp129[_r++];
			}
		}
		{ static float _itmp130[] = {6.,4.,13579.6,0.1094,-0.2675,
		  0.1883,-0.0090,2.0379,0.40};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][20] = _itmp130[_r++];
			}
		}
		{ static float _itmp131[] = {6.,4.,9700.4,0.0002,0.0060,0.0004,
		  0.0000,0.3000,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][21] = _itmp131[_r++];
			}
		}
		{ static float _itmp132[] = {6.,4.,8664.6,0.0886,-0.2722,0.2362,
		  -0.0138,2.0358,0.35};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][22] = _itmp132[_r++];
			}
		}
		{ static float _itmp133[] = {6.,4.,8340.8,0.0116,0.1716,0.0132,
		  -0.0005,0.3184,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][23] = _itmp133[_r++];
			}
		}
		{ static float _itmp134[] = {6.,4.,8315.1,0.0000,0.3579,0.0001,
		  0.0000,5.3545,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][24] = _itmp134[_r++];
			}
		}
		{ static float _itmp135[] = {6.,4.,8226.2,0.0001,0.3041,0.0000,
		  0.0000,5.3518,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][25] = _itmp135[_r++];
			}
		}
		{ static float _itmp136[] = {6.,4.,8196.5,0.3807,-1.1942,1.0595,
		  -0.0718,2.3905,0.40};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][26] = _itmp136[_r++];
			}
		}
		{ static float _itmp137[] = {6.,4.,8196.5,0.1278,-0.4040,0.3619,
		  -0.0250,2.4353,0.40};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][27] = _itmp137[_r++];
			}
		}
		{ static float _itmp138[] = {6.,4.,8189.1,0.0005,0.5632,0.0001,
		  0.0000,5.3503,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][28] = _itmp138[_r++];
			}
		}
		{ static float _itmp139[] = {6.,4.,7597.8,0.0287,-0.1106,0.1235,
		  -0.0069,1.7323,0.30};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][29] = _itmp139[_r++];
			}
		}
		{ static float _itmp140[] = {6.,4.,6740.3,0.0207,-0.0509,0.0782,
		  -0.0023,0.5355,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][30] = _itmp140[_r++];
			}
		}
		{ static float _itmp141[] = {6.,4.,5826.2,0.0018,0.0078,0.0026,
		  0.0000,0.4390,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][31] = _itmp141[_r++];
			}
		}
		{ static float _itmp142[] = {6.,4.,5305.3,0.0298,-0.1075,0.1472,
		  -0.0124,3.7460,0.30};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][32] = _itmp142[_r++];
			}
		}
		{ static float _itmp143[] = {6.,4.,5263.1,0.0008,0.0046,0.0017,
		  -0.0001,0.4000,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][33] = _itmp143[_r++];
			}
		}
		{ static float _itmp144[] = {6.,4.,5133.4,0.1048,-0.2563,0.1805,
		  -0.0086,2.0382,0.40};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][34] = _itmp144[_r++];
			}
		}
		{ static float _itmp145[] = {6.,4.,4717.9,0.0000,0.2144,0.0000,
		  0.0000,3.6259,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][35] = _itmp145[_r++];
			}
		}
		{ static float _itmp146[] = {6.,4.,4662.4,0.0019,0.0063,0.0042,
		  -0.0002,0.4188,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][36] = _itmp146[_r++];
			}
		}
		{ static float _itmp147[] = {6.,4.,4648.8,0.1151,-0.1057,0.3451,
		  -0.0113,0.4817,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][37] = _itmp147[_r++];
			}
		}
		{ static float _itmp148[] = {6.,4.,4593.2,0.0005,0.6813,0.0001,
		  0.0000,3.6254,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][38] = _itmp148[_r++];
			}
		}
		{ static float _itmp149[] = {6.,4.,4542.7,0.0000,0.0064,0.0000,
		  0.0000,0.2711,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][39] = _itmp149[_r++];
			}
		}
		{ static float _itmp150[] = {6.,4.,4429.2,0.0000,0.4345,0.0001,
		  0.0000,3.5947,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][40] = _itmp150[_r++];
			}
		}
		{ static float _itmp151[] = {6.,4.,4395.3,0.0000,0.0074,0.0000,
		  0.0000,0.3643,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][41] = _itmp151[_r++];
			}
		}
		{ static float _itmp152[] = {6.,4.,4371.1,0.0000,0.3019,0.0000,
		  0.0000,3.6551,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][42] = _itmp152[_r++];
			}
		}
		{ static float _itmp153[] = {6.,4.,4330.0,0.0005,1.3291,0.0000,
		  0.0000,3.5934,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][43] = _itmp153[_r++];
			}
		}
		{ static float _itmp154[] = {6.,4.,4325.5,0.0013,0.0060,0.0021,
		  -0.0001,0.4500,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][44] = _itmp154[_r++];
			}
		}
		{ static float _itmp155[] = {6.,4.,4300.8,0.0000,0.2610,0.0000,
		  0.0000,3.6685,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][45] = _itmp155[_r++];
			}
		}
		{ static float _itmp156[] = {6.,4.,4187.0,0.1051,-0.4050,0.4552,
		  -0.0261,1.7717,0.30};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][46] = _itmp156[_r++];
			}
		}
		{ static float _itmp157[] = {6.,4.,4158.7,0.0116,-0.0223,0.0367,
		  -0.0009,0.4847,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][47] = _itmp157[_r++];
			}
		}
		{ static float _itmp158[] = {6.,4.,4069.4,0.2862,-1.1021,1.2297,
		  -0.0691,1.7324,0.30};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][48] = _itmp158[_r++];
			}
		}
		{ static float _itmp159[] = {6.,4.,3927.4,0.0003,0.5449,0.0000,
		  0.0000,3.6034,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][49] = _itmp159[_r++];
			}
		}
		{ static float _itmp160[] = {6.,4.,3887.1,0.0177,-0.0341,0.0559,
		  -0.0013,0.4847,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][50] = _itmp160[_r++];
			}
		}
		{ static float _itmp161[] = {6.,4.,3602.6,0.0000,0.2012,0.0000,
		  0.0000,3.3809,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][51] = _itmp161[_r++];
			}
		}
}
void LineFitData4(void)
{
		{ static float _itmp162[] = {6.,4.,3414.9,0.0000,0.0060,0.0000,
		  0.0000,0.2711,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][52] = _itmp162[_r++];
			}
		}
		{ static float _itmp163[] = {6.,4.,3385.2,0.0000,0.0554,0.0000,
		  0.0000,0.3472,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][53] = _itmp163[_r++];
			}
		}
		{ static float _itmp164[] = {6.,4.,2512.2,0.0000,0.5505,0.0000,
		  0.0000,0.3472,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][54] = _itmp164[_r++];
			}
		}
		{ static float _itmp165[] = {6.,4.,2440.0,0.0000,0.1694,0.0000,
		  0.0000,0.2711,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][55] = _itmp165[_r++];
			}
		}
		{ static float _itmp166[] = {6.,4.,2296.9,0.8743,3.8841,1.4779,
		  -0.0483,0.4521,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][56] = _itmp166[_r++];
			}
		}
		{ static float _itmp167[] = {6.,4.,2296.1,0.0000,0.4000,0.0000,
		  0.0000,0.5770,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][57] = _itmp167[_r++];
			}
		}
		{ static float _itmp168[] = {6.,4.,2200.4,0.0000,0.5229,0.0000,
		  0.0000,0.4931,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][58] = _itmp168[_r++];
			}
		}
		{ static float _itmp169[] = {6.,4.,2162.9,0.0396,-0.0138,0.1125,
		  0.0029,0.5586,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][59] = _itmp169[_r++];
			}
		}
		{ static float _itmp170[] = {6.,4.,2114.3,0.0000,0.3575,0.0000,
		  0.0000,0.3472,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][60] = _itmp170[_r++];
			}
		}
		{ static float _itmp171[] = {6.,4.,2017.4,0.0000,0.8108,0.0000,
		  0.0000,0.4931,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][61] = _itmp171[_r++];
			}
		}
		{ static float _itmp172[] = {6.,4.,1923.3,0.0000,0.3165,0.0000,
		  0.0000,0.4931,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][62] = _itmp172[_r++];
			}
		}
		{ static float _itmp173[] = {6.,4.,1923.1,0.2666,-0.3774,0.7627,
		  0.0310,0.6278,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][63] = _itmp173[_r++];
			}
		}
		{ static float _itmp174[] = {6.,4.,1828.0,-0.0001,3.8078,-0.0002,
		  0.0000,0.2711,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][64] = _itmp174[_r++];
			}
		}
		{ static float _itmp175[] = {6.,4.,1796.8,0.0000,0.2882,0.0000,
		  0.0000,0.3643,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][65] = _itmp175[_r++];
			}
		}
		{ static float _itmp176[] = {6.,4.,1777.9,0.0000,0.1239,0.0000,
		  0.0000,0.4931,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][66] = _itmp176[_r++];
			}
		}
		{ static float _itmp177[] = {6.,4.,1701.6,0.0000,0.1853,0.0000,
		  0.0000,0.3240,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][67] = _itmp177[_r++];
			}
		}
		{ static float _itmp178[] = {6.,4.,1633.6,0.0000,0.2130,0.0000,
		  0.0000,0.3240,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][68] = _itmp178[_r++];
			}
		}
		{ static float _itmp179[] = {6.,4.,1620.3,0.0243,0.0381,0.0513,
		  -0.0017,0.4200,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][69] = _itmp179[_r++];
			}
		}
		{ static float _itmp180[] = {6.,4.,1577.1,0.2336,3.4440,0.2656,
		  -0.0109,0.3185,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][70] = _itmp180[_r++];
			}
		}
		{ static float _itmp181[] = {6.,4.,1548.9,0.0000,0.2776,0.0000,
		  0.0000,0.3643,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][71] = _itmp181[_r++];
			}
		}
		{ static float _itmp182[] = {6.,4.,1516.3,0.0000,0.1069,0.0000,
		  0.0000,0.3472,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][72] = _itmp182[_r++];
			}
		}
		{ static float _itmp183[] = {6.,4.,1491.2,0.0000,0.3415,0.0000,
		  0.0000,0.3240,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][73] = _itmp183[_r++];
			}
		}
		{ static float _itmp184[] = {6.,4.,1480.4,0.0000,0.1479,0.0000,
		  0.0000,0.5770,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][74] = _itmp184[_r++];
			}
		}
		{ static float _itmp185[] = {6.,4.,1478.1,0.0000,0.4007,0.0000,
		  0.0000,0.4931,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][75] = _itmp185[_r++];
			}
		}
		{ static float _itmp186[] = {6.,4.,1381.7,0.0128,0.0598,0.0227,
		  -0.0012,0.4327,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][76] = _itmp186[_r++];
			}
		}
		{ static float _itmp187[] = {6.,4.,1296.3,0.1194,-0.2296,0.3770,
		  -0.0090,0.4847,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][77] = _itmp187[_r++];
			}
		}
		{ static float _itmp188[] = {6.,4.,1247.4,-0.0001,0.8535,0.5001,
		  -0.0341,0.6671,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][78] = _itmp188[_r++];
			}
		}
		{ static float _itmp189[] = {6.,4.,1175.7,0.3864,3.1446,1.1348,
		  -0.0611,0.4130,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][79] = _itmp189[_r++];
			}
		}
		{ static float _itmp190[] = {6.,4.,977.0,0.8323,5.1970,2.5875,
		  -0.0812,0.4437,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][80] = _itmp190[_r++];
			}
		}
		{ static float _itmp191[] = {6.,4.,574.3,0.0980,0.1127,0.2229,
		  0.0007,0.4990,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][81] = _itmp191[_r++];
			}
		}
		{ static float _itmp192[] = {6.,4.,538.2,0.1342,-0.1435,0.4201,
		  -0.0134,0.4903,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][82] = _itmp192[_r++];
			}
		}
		{ static float _itmp193[] = {6.,4.,511.5,0.0589,0.2539,0.0849,
		  -0.0015,0.4390,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][83] = _itmp193[_r++];
			}
		}
		{ static float _itmp194[] = {6.,4.,493.5,0.1009,0.5483,0.2102,
		  -0.0138,0.5706,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][84] = _itmp194[_r++];
			}
		}
		{ static float _itmp195[] = {6.,4.,492.6,0.0728,0.3386,0.1285,
		  -0.0069,0.4327,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][85] = _itmp195[_r++];
			}
		}
		{ static float _itmp196[] = {6.,4.,483.7,0.0718,0.3649,0.1455,
		  -0.0090,0.5733,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][86] = _itmp196[_r++];
			}
		}
		{ static float _itmp197[] = {6.,4.,476.0,0.0000,1.1418,0.0000,
		  0.0000,0.9157,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][87] = _itmp197[_r++];
			}
		}
		{ static float _itmp198[] = {6.,4.,459.6,0.9723,2.2972,1.8844,
		  -0.0286,0.3893,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][88] = _itmp198[_r++];
			}
		}
		{ static float _itmp199[] = {6.,4.,450.7,0.0000,0.2904,0.0481,
		  -0.0036,0.3764,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][89] = _itmp199[_r++];
			}
		}
		{ static float _itmp200[] = {6.,4.,433.3,0.0453,0.1992,0.0720,
		  -0.0020,0.4534,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][90] = _itmp200[_r++];
			}
		}
		{ static float _itmp201[] = {6.,4.,411.7,0.0001,4.3059,0.0000,
		  0.0000,0.3643,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][91] = _itmp201[_r++];
			}
		}
		{ static float _itmp202[] = {6.,4.,398.4,0.0001,2.6254,0.0002,
		  0.0000,0.3240,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][92] = _itmp202[_r++];
			}
		}
		{ static float _itmp203[] = {6.,4.,371.7,0.1225,0.1922,0.2586,
		  -0.0088,0.4200,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][93] = _itmp203[_r++];
			}
		}
		{ static float _itmp204[] = {7.,7.,10594.8,0.0000,0.0135,0.0000,
		  0.0000,0.4078,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][94] = _itmp204[_r++];
			}
		}
		{ static float _itmp205[] = {7.,7.,9048.1,0.0000,0.0190,0.0024,
		  -0.0003,0.3710,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][95] = _itmp205[_r++];
			}
		}
		{ static float _itmp206[] = {7.,7.,8180.4,0.0000,0.0064,0.0003,
		  0.0000,0.3500,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][96] = _itmp206[_r++];
			}
		}
		{ static float _itmp207[] = {7.,7.,1000.2,0.0000,0.0395,0.0000,
		  0.0000,0.2727,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][97] = _itmp207[_r++];
			}
		}
		{ static float _itmp208[] = {7.,7.,994.2,0.0000,0.0721,0.0000,
		  0.0000,0.3594,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][98] = _itmp208[_r++];
			}
		}
		{ static float _itmp209[] = {7.,7.,980.7,0.0000,0.4728,0.0000,
		  0.0000,0.5591,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][99] = _itmp209[_r++];
			}
		}
		{ static float _itmp210[] = {7.,6.,5679.6,0.0234,-0.0852,0.0927,
		  -0.0056,2.3686,0.30};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][100] = _itmp210[_r++];
			}
		}
		{ static float _itmp211[] = {7.,6.,5495.1,0.0000,0.0781,0.0000,
		  0.0000,1.1623,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][101] = _itmp211[_r++];
			}
		}
		{ static float _itmp212[] = {7.,6.,5004.4,0.0704,-0.1990,0.1603,
		  -0.0099,3.3831,0.40};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][102] = _itmp212[_r++];
			}
		}
		{ static float _itmp213[] = {7.,6.,4724.1,0.0000,0.0186,0.0000,
		  0.0000,0.7718,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][103] = _itmp213[_r++];
			}
		}
		{ static float _itmp214[] = {7.,6.,1085.1,0.0005,0.8561,2.3770,
		  -0.1017,0.8595,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][104] = _itmp214[_r++];
			}
		}
}
void LineFitData5(void)
{
		{ static float _itmp215[] = {7.,6.,916.3,0.0143,-0.2447,1.1821,
		  0.0132,0.8461,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][105] = _itmp215[_r++];
			}
		}
		{ static float _itmp216[] = {7.,6.,646.4,0.0009,2.2631,0.0000,
		  0.0000,1.1627,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][106] = _itmp216[_r++];
			}
		}
		{ static float _itmp217[] = {7.,5.,6938.2,0.0000,0.2206,0.0000,
		  0.0000,0.7295,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][107] = _itmp217[_r++];
			}
		}
		{ static float _itmp218[] = {7.,5.,5334.7,0.0000,0.1260,0.0000,
		  0.0000,0.9211,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][108] = _itmp218[_r++];
			}
		}
		{ static float _itmp219[] = {7.,5.,4507.5,0.0005,0.8446,0.0000,
		  0.0000,4.0119,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][109] = _itmp219[_r++];
			}
		}
		{ static float _itmp220[] = {7.,5.,4477.8,0.0004,1.0155,0.0001,
		  0.0000,4.0085,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][110] = _itmp220[_r++];
			}
		}
		{ static float _itmp221[] = {7.,5.,4373.6,0.0000,0.9660,0.0001,
		  0.0000,4.0183,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][111] = _itmp221[_r++];
			}
		}
		{ static float _itmp222[] = {7.,5.,4199.6,0.0149,0.0226,0.0304,
		  -0.0002,0.8516,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][112] = _itmp222[_r++];
			}
		}
		{ static float _itmp223[] = {7.,5.,4099.4,0.0000,0.0194,0.0280,
		  -0.0010,0.8274,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][113] = _itmp223[_r++];
			}
		}
		{ static float _itmp224[] = {7.,5.,4001.8,0.0023,0.0256,0.0027,
		  0.0000,0.8500,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][114] = _itmp224[_r++];
			}
		}
		{ static float _itmp225[] = {7.,5.,3429.0,0.0000,0.1420,0.0000,
		  0.0000,2.8512,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][115] = _itmp225[_r++];
			}
		}
		{ static float _itmp226[] = {7.,5.,2197.8,0.0000,0.2454,0.0001,
		  0.0000,0.7958,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][116] = _itmp226[_r++];
			}
		}
		{ static float _itmp227[] = {7.,5.,2188.1,-0.0001,1.7355,-0.0001,
		  0.0000,0.8199,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][117] = _itmp227[_r++];
			}
		}
		{ static float _itmp228[] = {7.,5.,2064.3,0.0001,4.2360,0.0014,
		  -0.0001,0.7958,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][118] = _itmp228[_r++];
			}
		}
		{ static float _itmp229[] = {7.,5.,1885.1,0.4468,-0.8007,0.3715,
		  0.0369,3.0634,0.45};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][119] = _itmp229[_r++];
			}
		}
		{ static float _itmp230[] = {7.,5.,1857.2,0.0000,0.3940,0.0000,
		  0.0000,0.8200,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][120] = _itmp230[_r++];
			}
		}
		{ static float _itmp231[] = {7.,5.,1498.3,0.0000,0.9684,0.0000,
		  0.0000,0.7295,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][121] = _itmp231[_r++];
			}
		}
		{ static float _itmp232[] = {7.,5.,991.0,2.8315,12.9695,16.8995,
		  -0.5167,0.8162,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][122] = _itmp232[_r++];
			}
		}
		{ static float _itmp233[] = {7.,5.,979.9,0.1764,-0.4582,0.6309,
		  0.0215,1.0251,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][123] = _itmp233[_r++];
			}
		}
		{ static float _itmp234[] = {7.,5.,782.9,0.0014,6.8449,0.0000,
		  0.0000,1.7651,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][124] = _itmp234[_r++];
			}
		}
		{ static float _itmp235[] = {7.,5.,764.0,1.1769,3.6750,3.8084,
		  -0.1470,0.9780,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][125] = _itmp235[_r++];
			}
		}
		{ static float _itmp236[] = {7.,5.,685.7,0.5940,-0.4426,4.3937,
		  -0.3217,0.9795,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][126] = _itmp236[_r++];
			}
		}
		{ static float _itmp237[] = {7.,5.,472.3,-0.0545,1.1395,0.1343,
		  -0.0013,0.7456,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][127] = _itmp237[_r++];
			}
		}
		{ static float _itmp238[] = {7.,5.,418.8,0.4465,3.5875,0.5445,
		  -0.0132,0.8626,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][128] = _itmp238[_r++];
			}
		}
		{ static float _itmp239[] = {7.,5.,411.3,0.0000,1.3202,-0.0001,
		  0.0000,0.9211,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][129] = _itmp239[_r++];
			}
		}
		{ static float _itmp240[] = {7.,5.,391.3,0.0022,9.8112,0.0001,
		  0.0000,2.7078,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][130] = _itmp240[_r++];
			}
		}
		{ static float _itmp241[] = {7.,5.,387.4,-0.0002,5.2820,-0.0002,
		  0.0000,0.9211,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][131] = _itmp241[_r++];
			}
		}
		{ static float _itmp242[] = {7.,5.,374.4,0.0961,-1.1219,4.6102,
		  -0.4746,0.8564,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][132] = _itmp242[_r++];
			}
		}
		{ static float _itmp243[] = {7.,5.,348.7,-0.0004,15.4012,-0.0006,
		  0.0001,0.7295,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][133] = _itmp243[_r++];
			}
		}
		{ static float _itmp244[] = {7.,5.,340.2,0.0045,18.4734,-0.0004,
		  0.0001,1.7651,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][134] = _itmp244[_r++];
			}
		}
		{ static float _itmp245[] = {7.,5.,323.3,0.0341,32.2696,-0.0123,
		  0.0018,3.9830,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][135] = _itmp245[_r++];
			}
		}
		{ static float _itmp246[] = {7.,5.,311.6,0.2238,0.3397,0.4567,
		  -0.0033,0.8515,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][136] = _itmp246[_r++];
			}
		}
		{ static float _itmp247[] = {7.,4.,9203.0,0.0111,-0.1354,0.4831,
		  -0.0482,0.5315,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][137] = _itmp247[_r++];
			}
		}
		{ static float _itmp248[] = {7.,4.,7850.8,0.0097,0.0216,0.0354,
		  0.0009,1.5444,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][138] = _itmp248[_r++];
			}
		}
		{ static float _itmp249[] = {7.,4.,7760.0,0.0000,0.5947,-0.0001,
		  0.0000,6.4512,0.25};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][139] = _itmp249[_r++];
			}
		}
		{ static float _itmp250[] = {7.,4.,7742.0,-0.0001,0.5524,0.0000,
		  0.0000,6.4494,0.25};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][140] = _itmp250[_r++];
			}
		}
		{ static float _itmp251[] = {7.,4.,7740.8,-0.0002,0.8844,-0.0004,
		  0.0000,6.4485,0.25};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][141] = _itmp251[_r++];
			}
		}
		{ static float _itmp252[] = {7.,4.,7703.2,0.0783,-0.2678,0.2577,
		  -0.0190,3.3144,0.35};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][142] = _itmp252[_r++];
			}
		}
		{ static float _itmp253[] = {7.,4.,7703.2,0.2348,-0.8031,0.7726,
		  -0.0569,3.3133,0.35};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][143] = _itmp253[_r++];
			}
		}
		{ static float _itmp254[] = {7.,4.,7582.3,0.1075,-0.3417,0.3133,
		  -0.0219,3.0892,0.35};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][144] = _itmp254[_r++];
			}
		}
		{ static float _itmp255[] = {7.,4.,7581.7,0.0404,-0.1053,0.0858,
		  -0.0048,2.5490,0.30};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][145] = _itmp255[_r++];
			}
		}
		{ static float _itmp256[] = {7.,4.,5209.1,0.0000,0.0043,0.0195,
		  -0.0018,0.4783,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][146] = _itmp256[_r++];
			}
		}
		{ static float _itmp257[] = {7.,4.,4803.6,0.0202,-0.0542,0.0678,
		  -0.0040,1.8505,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][147] = _itmp257[_r++];
			}
		}
		{ static float _itmp258[] = {7.,4.,4757.2,0.0000,0.3191,0.0000,
		  0.0000,4.5945,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][148] = _itmp258[_r++];
			}
		}
		{ static float _itmp259[] = {7.,4.,4745.2,0.0003,0.5548,0.0000,
		  0.0000,4.6121,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][149] = _itmp259[_r++];
			}
		}
		{ static float _itmp260[] = {7.,4.,4708.1,0.0000,0.3688,0.0000,
		  0.0000,4.5974,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][150] = _itmp260[_r++];
			}
		}
		{ static float _itmp261[] = {7.,4.,4707.4,0.0814,-0.2208,0.2735,
		  -0.0166,1.8703,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][151] = _itmp261[_r++];
			}
		}
		{ static float _itmp262[] = {7.,4.,4705.7,0.0025,1.1065,0.0002,
		  0.0000,4.5996,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][152] = _itmp262[_r++];
			}
		}
		{ static float _itmp263[] = {7.,4.,4680.1,0.0000,0.5669,-0.0001,
		  0.0000,4.5904,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][153] = _itmp263[_r++];
			}
		}
		{ static float _itmp264[] = {7.,4.,4676.2,-0.0001,1.7011,0.0004,
		  -0.0001,4.5902,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][154] = _itmp264[_r++];
			}
		}
		{ static float _itmp265[] = {7.,4.,4640.1,0.0010,0.9578,-0.0001,
		  0.0000,4.5926,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][155] = _itmp265[_r++];
			}
		}
		{ static float _itmp266[] = {7.,4.,4606.4,0.2266,-1.0525,1.4037,
		  -0.1084,2.6627,0.25};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][156] = _itmp266[_r++];
			}
		}
		{ static float _itmp267[] = {7.,4.,4606.2,0.0951,-0.3764,0.4486,
		  -0.0331,2.4572,0.25};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][157] = _itmp267[_r++];
			}
		}
		{ static float _itmp268[] = {7.,4.,4512.8,0.0002,0.0054,0.0129,
		  -0.0011,0.5497,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][158] = _itmp268[_r++];
			}
		}
}
void LineFitData6(void)
{
		{ static float _itmp269[] = {7.,4.,4289.9,0.0154,-0.0448,0.0594,
		  -0.0039,1.6851,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][159] = _itmp269[_r++];
			}
		}
		{ static float _itmp270[] = {7.,4.,4124.4,0.0000,0.3355,0.0000,
		  0.0000,4.6276,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][160] = _itmp270[_r++];
			}
		}
		{ static float _itmp271[] = {7.,4.,4073.5,0.0004,0.5100,-0.0001,
		  0.0000,4.5780,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][161] = _itmp271[_r++];
			}
		}
		{ static float _itmp272[] = {7.,4.,3480.9,0.0045,-0.0291,0.6366,
		  -0.0515,0.1742,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][162] = _itmp272[_r++];
			}
		}
		{ static float _itmp273[] = {7.,4.,3459.1,-0.0001,0.0048,0.0060,
		  -0.0004,0.2000,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][163] = _itmp273[_r++];
			}
		}
		{ static float _itmp274[] = {7.,4.,3200.9,0.0000,0.0110,0.0000,
		  0.0000,0.2391,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][164] = _itmp274[_r++];
			}
		}
		{ static float _itmp275[] = {7.,4.,3078.3,0.0405,0.0627,0.0874,
		  -0.0040,1.6451,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][165] = _itmp275[_r++];
			}
		}
		{ static float _itmp276[] = {7.,4.,3004.1,-0.0005,0.0186,0.0007,
		  0.0000,0.2062,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][166] = _itmp276[_r++];
			}
		}
		{ static float _itmp277[] = {7.,4.,2664.4,0.0000,0.1852,0.0000,
		  0.0000,0.2391,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][167] = _itmp277[_r++];
			}
		}
		{ static float _itmp278[] = {7.,4.,2646.4,0.3066,0.6885,0.7846,
		  -0.0310,1.6158,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][168] = _itmp278[_r++];
			}
		}
		{ static float _itmp279[] = {7.,4.,2630.2,0.0001,0.6841,0.0000,
		  0.0000,1.5424,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][169] = _itmp279[_r++];
			}
		}
		{ static float _itmp280[] = {7.,4.,2602.6,0.0002,1.1617,-0.0001,
		  0.0000,1.5171,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][170] = _itmp280[_r++];
			}
		}
		{ static float _itmp281[] = {7.,4.,2574.6,0.0001,2.1507,0.0003,
		  0.0000,1.5406,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][171] = _itmp281[_r++];
			}
		}
		{ static float _itmp282[] = {7.,4.,2550.6,-0.0001,3.5429,0.0002,
		  0.0000,1.5142,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][172] = _itmp282[_r++];
			}
		}
		{ static float _itmp283[] = {7.,4.,2457.1,0.0000,0.1785,0.0000,
		  0.0000,0.2391,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][173] = _itmp283[_r++];
			}
		}
		{ static float _itmp284[] = {7.,4.,2430.8,-0.0019,0.0709,0.0026,
		  -0.0001,0.2062,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][174] = _itmp284[_r++];
			}
		}
		{ static float _itmp285[] = {7.,4.,2418.8,0.0002,0.8460,0.0001,
		  0.0000,1.5806,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][175] = _itmp285[_r++];
			}
		}
		{ static float _itmp286[] = {7.,4.,2318.1,0.0054,-0.0820,0.3300,
		  -0.0360,0.6469,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][176] = _itmp286[_r++];
			}
		}
		{ static float _itmp287[] = {7.,4.,2234.7,0.0001,1.1331,0.0000,
		  0.0000,1.5707,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][177] = _itmp287[_r++];
			}
		}
		{ static float _itmp288[] = {7.,4.,2190.2,0.0002,1.8069,-0.0001,
		  0.0000,1.4918,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][178] = _itmp288[_r++];
			}
		}
		{ static float _itmp289[] = {7.,4.,2159.5,0.0000,0.5740,0.0000,
		  0.0000,1.0459,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][179] = _itmp289[_r++];
			}
		}
		{ static float _itmp290[] = {7.,4.,2080.3,0.1309,0.2038,0.2829,
		  -0.0129,1.6449,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][180] = _itmp290[_r++];
			}
		}
		{ static float _itmp291[] = {7.,4.,1718.6,0.0751,-1.3414,6.4456,
		  -0.6185,0.3433,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][181] = _itmp291[_r++];
			}
		}
		{ static float _itmp292[] = {7.,4.,1699.8,0.1002,0.2187,0.2544,
		  -0.0103,1.6169,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][182] = _itmp292[_r++];
			}
		}
		{ static float _itmp293[] = {7.,4.,1325.3,0.0667,-0.8159,2.9104,
		  -0.2907,0.5315,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][183] = _itmp293[_r++];
			}
		}
		{ static float _itmp294[] = {7.,4.,1279.7,0.0025,-0.0455,0.2315,
		  -0.0235,0.5303,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][184] = _itmp294[_r++];
			}
		}
		{ static float _itmp295[] = {7.,4.,1271.6,0.0036,-0.0444,0.2866,
		  -0.0275,0.1932,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][185] = _itmp295[_r++];
			}
		}
		{ static float _itmp296[] = {7.,4.,1260.3,0.0000,0.8144,0.0000,
		  0.0000,1.0459,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][186] = _itmp296[_r++];
			}
		}
		{ static float _itmp297[] = {7.,4.,1255.8,-0.0014,1.1562,0.3338,
		  -0.0313,1.4122,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][187] = _itmp297[_r++];
			}
		}
		{ static float _itmp298[] = {7.,4.,1239.8,0.0002,1.2463,0.0000,
		  0.0000,1.4918,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][188] = _itmp298[_r++];
			}
		}
		{ static float _itmp299[] = {7.,4.,1233.8,0.0000,1.0352,0.0001,
		  0.0000,1.5142,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][189] = _itmp299[_r++];
			}
		}
		{ static float _itmp300[] = {7.,4.,1231.0,0.0001,0.8813,0.0001,
		  0.0000,1.5406,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][190] = _itmp300[_r++];
			}
		}
		{ static float _itmp301[] = {7.,4.,1230.4,0.0002,0.6921,0.0000,
		  0.0000,1.5806,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][191] = _itmp301[_r++];
			}
		}
		{ static float _itmp302[] = {7.,4.,1228.4,0.0000,0.6558,0.0001,
		  0.0000,0.7942,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][192] = _itmp302[_r++];
			}
		}
		{ static float _itmp303[] = {7.,4.,1225.5,0.0016,-0.0276,0.1766,
		  -0.0156,0.1317,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][193] = _itmp303[_r++];
			}
		}
		{ static float _itmp304[] = {7.,4.,1223.8,0.0000,0.3810,0.0000,
		  0.0000,0.2391,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][194] = _itmp304[_r++];
			}
		}
		{ static float _itmp305[] = {7.,4.,1222.3,0.0000,0.1345,0.0000,
		  0.0000,0.5296,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][195] = _itmp305[_r++];
			}
		}
		{ static float _itmp306[] = {7.,4.,1221.3,0.0000,0.4580,0.0000,
		  0.0000,1.4106,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][196] = _itmp306[_r++];
			}
		}
		{ static float _itmp307[] = {7.,4.,1173.6,-0.0128,0.9919,0.1844,
		  -0.0155,1.4480,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][197] = _itmp307[_r++];
			}
		}
		{ static float _itmp308[] = {7.,4.,1102.4,-0.0032,0.4261,0.0453,
		  -0.0024,1.4909,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][198] = _itmp308[_r++];
			}
		}
		{ static float _itmp309[] = {7.,4.,1036.2,0.0466,-0.6226,2.3090,
		  -0.1996,0.6230,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][199] = _itmp309[_r++];
			}
		}
		{ static float _itmp310[] = {7.,4.,993.2,-0.0013,1.3770,0.3981,
		  -0.0374,1.4124,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][200] = _itmp310[_r++];
			}
		}
		{ static float _itmp311[] = {7.,4.,955.3,0.0349,-0.2307,1.5474,
		  -0.1407,0.5544,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][201] = _itmp311[_r++];
			}
		}
		{ static float _itmp312[] = {7.,4.,952.9,0.0081,-0.1496,0.7610,
		  -0.0774,0.5303,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][202] = _itmp312[_r++];
			}
		}
		{ static float _itmp313[] = {7.,4.,923.2,0.1057,-0.3719,4.7527,
		  -0.4378,0.2552,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][203] = _itmp313[_r++];
			}
		}
		{ static float _itmp314[] = {7.,4.,765.1,0.1051,-1.9051,10.2062,
		  -0.9291,0.3490,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][204] = _itmp314[_r++];
			}
		}
		{ static float _itmp315[] = {7.,4.,756.6,0.0000,0.2633,0.0000,
		  0.0000,0.2391,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][205] = _itmp315[_r++];
			}
		}
		{ static float _itmp316[] = {7.,4.,715.7,0.0009,3.2627,-0.0002,
		  0.0000,1.4919,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][206] = _itmp316[_r++];
			}
		}
		{ static float _itmp317[] = {7.,4.,704.8,0.0000,0.2364,0.0000,
		  0.0000,0.2391,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][207] = _itmp317[_r++];
			}
		}
		{ static float _itmp318[] = {7.,4.,678.0,0.0001,1.9513,0.0001,
		  0.0000,1.0459,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][208] = _itmp318[_r++];
			}
		}
		{ static float _itmp319[] = {7.,4.,322.6,0.0063,-0.1200,0.9206,
		  -0.0779,0.0798,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][209] = _itmp319[_r++];
			}
		}
		{ static float _itmp320[] = {7.,4.,297.7,0.0427,-0.4023,1.3341,
		  -0.1392,0.4279,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][210] = _itmp320[_r++];
			}
		}
		{ static float _itmp321[] = {7.,4.,283.5,0.1599,-1.8302,6.3083,
		  -0.5637,0.5187,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][211] = _itmp321[_r++];
			}
		}
		{ static float _itmp322[] = {7.,4.,239.6,0.0238,-0.2925,1.8886,
		  -0.1810,0.1931,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][212] = _itmp322[_r++];
			}
		}
		{ static float _itmp323[] = {7.,4.,234.2,-0.0031,0.1646,0.2047,
		  -0.0151,0.1978,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][213] = _itmp323[_r++];
			}
		}
		{ static float _itmp324[] = {7.,4.,225.3,-0.0001,7.3142,-0.0009,
		  0.0001,1.1402,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][214] = _itmp324[_r++];
			}
		}
		{ static float _itmp325[] = {7.,4.,221.8,0.0000,0.7356,0.0000,
		  0.0000,0.2391,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][215] = _itmp325[_r++];
			}
		}
		{ static float _itmp326[] = {7.,4.,217.9,0.0004,3.5092,-0.0003,
		  0.0001,1.4107,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][216] = _itmp326[_r++];
			}
		}
		{ static float _itmp327[] = {7.,4.,209.4,-0.0049,0.1832,0.0068,
		  -0.0002,0.2062,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][217] = _itmp327[_r++];
			}
		}
}
void LineFitData7(void)
{
		{ static float _itmp328[] = {7.,4.,177.6,0.0000,1.5341,0.0001,
		  0.0000,0.7942,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][218] = _itmp328[_r++];
			}
		}
		{ static float _itmp329[] = {8.,8.,27639.7,0.1953,-0.7805,
		  0.8492,-0.0759,13.2470,0.50};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][219] = _itmp329[_r++];
			}
		}
		{ static float _itmp330[] = {8.,8.,18022.8,0.0971,-0.8743,
		  1.6447,-0.1593,14.3535,0.50};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][220] = _itmp330[_r++];
			}
		}
		{ static float _itmp331[] = {8.,8.,11298.9,0.2147,-0.9024,
		  1.0281,-0.0820,12.9529,0.50};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][221] = _itmp331[_r++];
			}
		}
		{ static float _itmp332[] = {8.,8.,9263.6,1.3752,-0.0677,3.8878,
		  -0.4719,15.3842,0.50};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][222] = _itmp332[_r++];
			}
		}
		{ static float _itmp333[] = {8.,8.,7949.5,0.0000,0.4000,0.0000,
		  0.0000,0.5587,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][223] = _itmp333[_r++];
			}
		}
		{ static float _itmp334[] = {8.,8.,7773.3,1.0991,-1.9677,5.9828,
		  -0.6378,14.1284,0.45};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][224] = _itmp334[_r++];
			}
		}
		{ static float _itmp335[] = {8.,8.,6318.6,0.0000,0.0280,0.0000,
		  0.0000,1.0257,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][225] = _itmp335[_r++];
			}
		}
		{ static float _itmp336[] = {8.,7.,25393.1,0.0000,0.0040,0.0000,
		  0.0000,0.2971,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][226] = _itmp336[_r++];
			}
		}
		{ static float _itmp337[] = {8.,7.,11945.6,-0.0001,0.0072,
		  0.0015,-0.0002,0.3500,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][227] = _itmp337[_r++];
			}
		}
		{ static float _itmp338[] = {8.,7.,9377.4,0.0000,0.0063,0.0000,
		  0.0000,0.3616,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][228] = _itmp338[_r++];
			}
		}
		{ static float _itmp339[] = {8.,7.,8883.3,0.0000,0.0056,0.0000,
		  0.0000,0.3475,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][229] = _itmp339[_r++];
			}
		}
		{ static float _itmp340[] = {8.,7.,8771.8,0.0000,0.0161,0.0000,
		  0.0000,0.3456,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][230] = _itmp340[_r++];
			}
		}
		{ static float _itmp341[] = {8.,7.,4651.7,0.1037,-0.2657,0.2045,
		  -0.0029,3.0303,0.35};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][231] = _itmp341[_r++];
			}
		}
		{ static float _itmp342[] = {8.,7.,4593.2,0.0000,0.0080,0.0059,
		  -0.0006,0.3499,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][232] = _itmp342[_r++];
			}
		}
		{ static float _itmp343[] = {8.,7.,4349.8,0.0000,0.0048,0.0075,
		  -0.0005,0.3000,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][233] = _itmp343[_r++];
			}
		}
		{ static float _itmp344[] = {8.,7.,4341.1,0.0376,-0.0999,0.0783,
		  -0.0003,2.8346,0.30};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][234] = _itmp344[_r++];
			}
		}
		{ static float _itmp345[] = {8.,7.,4188.0,-0.0001,0.0154,0.0079,
		  -0.0008,0.3498,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][235] = _itmp345[_r++];
			}
		}
		{ static float _itmp346[] = {8.,7.,4074.8,0.0923,-0.1817,0.1002,
		  -0.0007,4.2197,0.50};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][236] = _itmp346[_r++];
			}
		}
		{ static float _itmp347[] = {8.,7.,3800.2,0.0000,0.1009,0.0000,
		  0.0000,2.2340,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][237] = _itmp347[_r++];
			}
		}
		{ static float _itmp348[] = {8.,7.,3077.8,0.0000,0.0099,0.0000,
		  0.0000,0.3616,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][238] = _itmp348[_r++];
			}
		}
		{ static float _itmp349[] = {8.,7.,3017.9,0.0000,0.0082,0.0000,
		  0.0000,0.3475,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][239] = _itmp349[_r++];
			}
		}
		{ static float _itmp350[] = {8.,7.,3009.0,0.0000,0.0076,0.0000,
		  0.0000,0.3616,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][240] = _itmp350[_r++];
			}
		}
		{ static float _itmp351[] = {8.,7.,386.3,0.0000,0.4461,0.0000,
		  0.0000,0.2804,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][241] = _itmp351[_r++];
			}
		}
		{ static float _itmp352[] = {8.,7.,385.7,0.0000,0.3115,0.0000,
		  0.0000,0.3318,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][242] = _itmp352[_r++];
			}
		}
		{ static float _itmp353[] = {8.,6.,4587.1,0.0000,0.2800,0.0000,
		  0.0000,4.6381,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][243] = _itmp353[_r++];
			}
		}
		{ static float _itmp354[] = {8.,6.,3881.6,0.0000,0.1304,0.0000,
		  0.0000,0.9941,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][244] = _itmp354[_r++];
			}
		}
		{ static float _itmp355[] = {8.,6.,3763.1,0.0000,0.0746,0.0000,
		  0.0000,1.6189,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][245] = _itmp355[_r++];
			}
		}
		{ static float _itmp356[] = {8.,6.,3762.3,0.0053,-0.0983,0.4693,
		  0.0054,0.5684,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][246] = _itmp356[_r++];
			}
		}
		{ static float _itmp357[] = {8.,6.,3326.6,0.0090,0.0107,0.0226,
		  -0.0004,0.7877,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][247] = _itmp357[_r++];
			}
		}
		{ static float _itmp358[] = {8.,6.,3265.9,0.0001,0.9493,0.1777,
		  0.0623,1.2049,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][248] = _itmp358[_r++];
			}
		}
		{ static float _itmp359[] = {8.,6.,3191.9,0.0000,0.0723,0.0000,
		  0.0000,1.8883,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][249] = _itmp359[_r++];
			}
		}
		{ static float _itmp360[] = {8.,6.,3176.1,0.0000,0.2069,0.0000,
		  0.0000,1.3144,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][250] = _itmp360[_r++];
			}
		}
		{ static float _itmp361[] = {8.,6.,3041.6,0.0139,-0.0463,0.0950,
		  -0.0013,1.1799,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][251] = _itmp361[_r++];
			}
		}
		{ static float _itmp362[] = {8.,6.,2092.0,0.0001,0.7959,0.0000,
		  0.0000,1.5025,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][252] = _itmp362[_r++];
			}
		}
		{ static float _itmp363[] = {8.,6.,1947.2,0.0000,1.1393,0.0002,
		  0.0000,1.3915,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][253] = _itmp363[_r++];
			}
		}
		{ static float _itmp364[] = {8.,6.,1924.2,0.0000,0.5098,0.0001,
		  0.0000,1.3217,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][254] = _itmp364[_r++];
			}
		}
		{ static float _itmp365[] = {8.,6.,834.5,-0.0092,16.2803,6.0953,
		  -0.3399,1.2980,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][255] = _itmp365[_r++];
			}
		}
		{ static float _itmp366[] = {8.,6.,703.4,0.0646,-1.0379,5.4702,
		  -0.3506,0.6221,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][256] = _itmp366[_r++];
			}
		}
		{ static float _itmp367[] = {8.,6.,599.6,0.0002,1.4709,1.2954,
		  -0.0807,1.5493,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][257] = _itmp367[_r++];
			}
		}
		{ static float _itmp368[] = {8.,6.,541.6,0.0002,2.4329,0.0001,
		  0.0000,1.2893,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][258] = _itmp368[_r++];
			}
		}
		{ static float _itmp369[] = {8.,6.,374.1,-0.0005,1.8930,1.0691,
		  -0.0524,1.1337,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][259] = _itmp369[_r++];
			}
		}
		{ static float _itmp370[] = {8.,6.,320.7,-0.0001,3.8598,0.0000,
		  0.0000,1.5798,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][260] = _itmp370[_r++];
			}
		}
		{ static float _itmp371[] = {8.,6.,300.5,0.0003,13.1930,0.0015,
		  -0.0002,1.3900,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][261] = _itmp371[_r++];
			}
		}
		{ static float _itmp372[] = {8.,6.,299.3,-0.0001,6.0914,0.0000,
		  0.0000,1.5798,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][262] = _itmp372[_r++];
			}
		}
		{ static float _itmp373[] = {8.,5.,9225.1,0.0001,0.0009,0.0005,
		  0.0000,0.1500,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][263] = _itmp373[_r++];
			}
		}
		{ static float _itmp374[] = {8.,5.,8723.6,0.0000,0.0335,0.0000,
		  0.0000,0.9214,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][264] = _itmp374[_r++];
			}
		}
		{ static float _itmp375[] = {8.,5.,6099.6,0.0000,0.0283,0.0000,
		  0.0000,1.0719,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][265] = _itmp375[_r++];
			}
		}
		{ static float _itmp376[] = {8.,5.,4541.3,0.0011,0.6456,0.0000,
		  0.0000,4.8635,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][266] = _itmp376[_r++];
			}
		}
		{ static float _itmp377[] = {8.,5.,4491.5,0.0003,0.6584,0.0000,
		  0.0000,4.8271,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][267] = _itmp377[_r++];
			}
		}
		{ static float _itmp378[] = {8.,5.,4034.0,0.0000,0.0702,0.0000,
		  0.0000,0.0719,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][268] = _itmp378[_r++];
			}
		}
		{ static float _itmp379[] = {8.,5.,3799.3,0.0000,0.0189,0.0000,
		  0.0000,0.3721,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][269] = _itmp379[_r++];
			}
		}
		{ static float _itmp380[] = {8.,5.,3794.0,0.0000,0.1226,0.0000,
		  0.0000,2.5050,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][270] = _itmp380[_r++];
			}
		}
		{ static float _itmp381[] = {8.,5.,3720.8,0.0000,0.1250,0.0000,
		  0.0000,0.3721,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][271] = _itmp381[_r++];
			}
		}
		{ static float _itmp382[] = {8.,5.,3553.8,0.0000,0.0045,0.0000,
		  0.0000,0.0719,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][272] = _itmp382[_r++];
			}
		}
}
void LineFitData8(void)
{
		{ static float _itmp383[] = {8.,5.,3549.1,0.0000,0.0012,0.0000,
		  0.0000,0.0719,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][273] = _itmp383[_r++];
			}
		}
		{ static float _itmp384[] = {8.,5.,3490.9,0.0033,0.0082,0.0069,
		  0.0003,0.1785,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][274] = _itmp384[_r++];
			}
		}
		{ static float _itmp385[] = {8.,5.,3409.1,0.0004,0.0001,0.0016,
		  0.0002,0.2052,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][275] = _itmp385[_r++];
			}
		}
		{ static float _itmp386[] = {8.,5.,3350.7,0.0012,-0.0001,0.0091,
		  -0.0002,0.1795,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][276] = _itmp386[_r++];
			}
		}
		{ static float _itmp387[] = {8.,5.,3066.1,0.0230,0.0016,0.0859,
		  0.0015,0.2149,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][277] = _itmp387[_r++];
			}
		}
		{ static float _itmp388[] = {8.,5.,3037.9,0.0000,1.5217,0.0000,
		  0.0000,0.7085,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][278] = _itmp388[_r++];
			}
		}
		{ static float _itmp389[] = {8.,5.,3027.9,0.0000,0.0918,0.0000,
		  0.0000,0.9214,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][279] = _itmp389[_r++];
			}
		}
		{ static float _itmp390[] = {8.,5.,3024.3,0.0002,0.0005,0.0005,
		  0.0000,0.2000,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][280] = _itmp390[_r++];
			}
		}
		{ static float _itmp391[] = {8.,5.,3003.0,0.0007,0.5561,0.0000,
		  0.0000,4.8630,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][281] = _itmp391[_r++];
			}
		}
		{ static float _itmp392[] = {8.,5.,2907.1,0.0000,0.2918,0.0000,
		  0.0000,0.9214,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][282] = _itmp392[_r++];
			}
		}
		{ static float _itmp393[] = {8.,5.,2772.5,0.0000,0.6734,-0.0001,
		  0.0000,1.6944,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][283] = _itmp393[_r++];
			}
		}
		{ static float _itmp394[] = {8.,5.,2637.7,0.0000,1.1338,-0.0002,
		  0.0000,1.6242,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][284] = _itmp394[_r++];
			}
		}
		{ static float _itmp395[] = {8.,5.,2620.0,0.0000,1.0784,0.0000,
		  0.0000,1.0719,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][285] = _itmp395[_r++];
			}
		}
		{ static float _itmp396[] = {8.,5.,2511.2,0.0002,2.8067,-0.0001,
		  0.0000,1.7471,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][286] = _itmp396[_r++];
			}
		}
		{ static float _itmp397[] = {8.,5.,2486.3,0.0000,0.3204,0.0000,
		  0.0000,0.0719,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][287] = _itmp397[_r++];
			}
		}
		{ static float _itmp398[] = {8.,5.,2363.6,0.0000,0.2168,0.0000,
		  0.0000,0.3721,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][288] = _itmp398[_r++];
			}
		}
		{ static float _itmp399[] = {8.,5.,1936.1,0.0000,0.1495,0.0000,
		  0.0000,0.3721,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][289] = _itmp399[_r++];
			}
		}
		{ static float _itmp400[] = {8.,5.,1785.9,0.0000,0.5212,0.0000,
		  0.0000,1.0719,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][290] = _itmp400[_r++];
			}
		}
		{ static float _itmp401[] = {8.,5.,1515.5,0.0008,0.0086,0.0048,
		  0.0000,0.1501,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][291] = _itmp401[_r++];
			}
		}
		{ static float _itmp402[] = {8.,5.,1355.1,0.0016,0.0209,0.0111,
		  0.0001,0.1392,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][292] = _itmp402[_r++];
			}
		}
		{ static float _itmp403[] = {8.,5.,1341.8,0.0734,-0.7096,2.5557,
		  -0.1364,0.3106,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][293] = _itmp403[_r++];
			}
		}
		{ static float _itmp404[] = {8.,5.,1296.4,0.0000,0.2047,0.0000,
		  0.0000,0.3721,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][294] = _itmp404[_r++];
			}
		}
		{ static float _itmp405[] = {8.,5.,1289.4,0.0000,1.1066,0.0001,
		  0.0000,0.0719,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][295] = _itmp405[_r++];
			}
		}
		{ static float _itmp406[] = {8.,5.,1212.9,0.0309,-0.3064,0.8385,
		  -0.0813,0.5422,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][296] = _itmp406[_r++];
			}
		}
		{ static float _itmp407[] = {8.,5.,1102.0,0.0018,5.6429,0.0008,
		  -0.0001,6.9210,0.25};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][297] = _itmp407[_r++];
			}
		}
		{ static float _itmp408[] = {8.,5.,1079.9,0.0027,-0.0002,0.0195,
		  -0.0005,0.1795,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][298] = _itmp408[_r++];
			}
		}
		{ static float _itmp409[] = {8.,5.,1067.8,0.0935,-0.1253,0.2148,
		  0.0392,0.8956,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][299] = _itmp409[_r++];
			}
		}
		{ static float _itmp410[] = {8.,5.,1060.0,0.0103,0.0256,0.0214,
		  0.0011,0.1784,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][300] = _itmp410[_r++];
			}
		}
		{ static float _itmp411[] = {8.,5.,1046.0,0.0404,-0.2108,0.3873,
		  -0.0250,0.6667,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][301] = _itmp411[_r++];
			}
		}
		{ static float _itmp412[] = {8.,5.,1006.7,0.0161,12.4488,0.0002,
		  0.0000,7.5667,0.25};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][302] = _itmp412[_r++];
			}
		}
		{ static float _itmp413[] = {8.,5.,922.7,0.7799,-3.0453,4.4113,
		  -0.2320,1.0333,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][303] = _itmp413[_r++];
			}
		}
		{ static float _itmp414[] = {8.,5.,844.4,-0.0001,3.3684,0.0001,
		  0.0000,0.7085,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][304] = _itmp414[_r++];
			}
		}
		{ static float _itmp415[] = {8.,5.,789.4,4.7096,-7.7314,39.5926,
		  -1.4842,0.2109,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][305] = _itmp415[_r++];
			}
		}
		{ static float _itmp416[] = {8.,5.,779.9,0.4003,-3.8675,13.9290,
		  -0.7433,0.3106,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][306] = _itmp416[_r++];
			}
		}
		{ static float _itmp417[] = {8.,5.,745.8,0.0000,0.5475,0.0000,
		  0.0000,0.3721,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][307] = _itmp417[_r++];
			}
		}
		{ static float _itmp418[] = {8.,5.,713.0,0.0041,6.5679,-0.0013,
		  0.0002,2.5057,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][308] = _itmp418[_r++];
			}
		}
		{ static float _itmp419[] = {8.,5.,703.9,0.0000,0.5760,0.0000,
		  0.0000,0.0719,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][309] = _itmp419[_r++];
			}
		}
		{ static float _itmp420[] = {8.,5.,636.5,0.1084,0.2681,0.2245,
		  0.0112,0.1785,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][310] = _itmp420[_r++];
			}
		}
		{ static float _itmp421[] = {8.,5.,617.0,1.7032,-6.6508,9.6338,
		  -0.5066,1.0333,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][311] = _itmp421[_r++];
			}
		}
		{ static float _itmp422[] = {8.,5.,609.4,0.4193,-1.9258,5.0398,
		  -0.0611,0.4046,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][312] = _itmp422[_r++];
			}
		}
		{ static float _itmp423[] = {8.,5.,554.4,0.9392,-0.7450,8.8543,
		  -0.2444,0.4542,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][313] = _itmp423[_r++];
			}
		}
		{ static float _itmp424[] = {8.,5.,487.0,0.0000,0.3641,0.0000,
		  0.0000,0.0719,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][314] = _itmp424[_r++];
			}
		}
		{ static float _itmp425[] = {8.,5.,442.8,0.0228,0.0016,0.0852,
		  0.0015,0.2149,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][315] = _itmp425[_r++];
			}
		}
		{ static float _itmp426[] = {8.,5.,379.8,0.1502,0.0108,0.5603,
		  0.0096,0.2149,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][316] = _itmp426[_r++];
			}
		}
		{ static float _itmp427[] = {8.,5.,342.3,0.0096,0.0238,0.0199,
		  0.0010,0.1785,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][317] = _itmp427[_r++];
			}
		}
		{ static float _itmp428[] = {8.,5.,306.7,0.0046,-0.0187,0.3118,
		  -0.0071,0.0888,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][318] = _itmp428[_r++];
			}
		}
		{ static float _itmp429[] = {8.,5.,303.5,0.0043,0.0573,0.0305,
		  0.0003,0.1392,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][319] = _itmp429[_r++];
			}
		}
		{ static float _itmp430[] = {8.,5.,289.9,0.0113,0.0019,0.2579,
		  -0.0234,0.1676,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][320] = _itmp430[_r++];
			}
		}
		{ static float _itmp431[] = {8.,5.,288.5,0.0000,3.7916,-0.0007,
		  0.0001,1.6242,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][321] = _itmp431[_r++];
			}
		}
		{ static float _itmp432[] = {8.,5.,285.8,0.0521,-0.4336,1.0532,
		  0.0448,0.5153,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][322] = _itmp432[_r++];
			}
		}
		{ static float _itmp433[] = {8.,5.,279.8,0.0999,-0.2634,0.4500,
		  0.0242,0.3298,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][323] = _itmp433[_r++];
			}
		}
		{ static float _itmp434[] = {8.,5.,276.1,0.0124,18.7191,0.0017,
		  -0.0002,3.8567,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][324] = _itmp434[_r++];
			}
		}
		{ static float _itmp435[] = {8.,5.,273.5,-0.0018,25.0077,0.0020,
		  -0.0002,4.3545,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][325] = _itmp435[_r++];
			}
		}
		{ static float _itmp436[] = {8.,5.,267.0,0.1622,-1.1147,2.2783,
		  -0.1975,0.7623,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][326] = _itmp436[_r++];
			}
		}
}
void LineFitData9(void)
{
		{ static float _itmp437[] = {8.,5.,265.5,-0.0001,16.4077,0.0006,
		  -0.0001,1.0719,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][327] = _itmp437[_r++];
			}
		}
		{ static float _itmp438[] = {8.,5.,260.5,0.0005,2.2010,2.6463,
		  -0.1639,0.6095,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][328] = _itmp438[_r++];
			}
		}
		{ static float _itmp439[] = {8.,5.,258.6,0.0060,6.1638,-0.0005,
		  0.0001,2.5060,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][329] = _itmp439[_r++];
			}
		}
		{ static float _itmp440[] = {8.,5.,252.5,0.0128,20.5521,0.0011,
		  -0.0001,3.8567,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][330] = _itmp440[_r++];
			}
		}
		{ static float _itmp441[] = {8.,5.,250.3,-0.0023,31.5306,0.0025,
		  -0.0003,4.3545,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][331] = _itmp441[_r++];
			}
		}
		{ static float _itmp442[] = {8.,5.,238.5,0.1215,0.0327,0.5626,
		  0.0832,0.2035,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][332] = _itmp442[_r++];
			}
		}
		{ static float _itmp443[] = {8.,5.,224.1,0.0000,3.2239,0.0001,
		  0.0000,0.3721,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][333] = _itmp443[_r++];
			}
		}
		{ static float _itmp444[] = {8.,5.,216.2,0.0000,0.5602,0.0000,
		  0.0000,0.3721,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][334] = _itmp444[_r++];
			}
		}
		{ static float _itmp445[] = {8.,5.,213.0,-0.0657,1.4583,0.2876,
		  0.0223,0.6524,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][335] = _itmp445[_r++];
			}
		}
		{ static float _itmp446[] = {8.,5.,211.3,0.0022,5.2042,0.0232,
		  -0.0015,1.9159,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][336] = _itmp446[_r++];
			}
		}
		{ static float _itmp447[] = {8.,5.,207.2,0.1477,-0.0102,1.0783,
		  -0.0272,0.1795,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][337] = _itmp447[_r++];
			}
		}
		{ static float _itmp448[] = {8.,5.,203.0,0.0846,0.2543,0.3268,
		  -0.0198,0.4614,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][338] = _itmp448[_r++];
			}
		}
		{ static float _itmp449[] = {8.,5.,200.8,0.0001,10.4614,0.0006,
		  -0.0001,0.0719,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][339] = _itmp449[_r++];
			}
		}
		{ static float _itmp450[] = {8.,5.,196.4,0.0031,19.1580,-0.0023,
		  0.0004,1.6946,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][340] = _itmp450[_r++];
			}
		}
		{ static float _itmp451[] = {8.,5.,188.2,-0.0032,32.3813,-0.0036,
		  0.0005,4.8979,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][341] = _itmp451[_r++];
			}
		}
		{ static float _itmp452[] = {8.,5.,184.2,-0.0017,29.1270,0.0040,
		  -0.0006,6.5238,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][342] = _itmp452[_r++];
			}
		}
		{ static float _itmp453[] = {8.,5.,182.8,0.1135,0.2808,0.2350,
		  0.0117,0.1785,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][343] = _itmp453[_r++];
			}
		}
		{ static float _itmp454[] = {8.,5.,171.1,0.0174,0.2317,0.1234,
		  0.0014,0.1392,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][344] = _itmp454[_r++];
			}
		}
		{ static float _itmp455[] = {8.,5.,158.6,0.0012,7.8984,0.0004,
		  0.0000,0.9216,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][345] = _itmp455[_r++];
			}
		}
		{ static float _itmp456[] = {8.,4.,6487.5,-0.0765,4.1680,1.2966,
		  -0.1261,2.8234,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][346] = _itmp456[_r++];
			}
		}
		{ static float _itmp457[] = {8.,4.,5875.5,0.0274,-0.0918,0.1266,
		  -0.0106,3.3189,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][347] = _itmp457[_r++];
			}
		}
		{ static float _itmp458[] = {8.,4.,5023.2,-0.0001,0.5197,0.0000,
		  0.0000,5.8621,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][348] = _itmp458[_r++];
			}
		}
		{ static float _itmp459[] = {8.,4.,5006.9,0.0000,0.4687,0.0000,
		  0.0000,5.8758,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][349] = _itmp459[_r++];
			}
		}
		{ static float _itmp460[] = {8.,4.,4982.4,0.0008,0.8823,0.0001,
		  0.0000,5.8662,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][350] = _itmp460[_r++];
			}
		}
		{ static float _itmp461[] = {8.,4.,4981.4,0.0221,-0.0957,0.1292,
		  -0.0117,3.5562,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][351] = _itmp461[_r++];
			}
		}
		{ static float _itmp462[] = {8.,4.,4961.4,0.0012,1.4623,0.0001,
		  0.0000,5.8616,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][352] = _itmp462[_r++];
			}
		}
		{ static float _itmp463[] = {8.,4.,4961.4,0.0009,0.5036,-0.0002,
		  0.0000,5.8627,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][353] = _itmp463[_r++];
			}
		}
		{ static float _itmp464[] = {8.,4.,4958.7,0.0000,0.4494,0.0000,
		  0.0000,5.8588,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][354] = _itmp464[_r++];
			}
		}
		{ static float _itmp465[] = {8.,4.,4953.3,0.0011,1.3491,-0.0006,
		  0.0001,5.8599,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][355] = _itmp465[_r++];
			}
		}
		{ static float _itmp466[] = {8.,4.,4952.5,0.0000,2.1583,-0.0001,
		  0.0000,5.8576,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][356] = _itmp466[_r++];
			}
		}
		{ static float _itmp467[] = {8.,4.,4952.5,0.0004,0.7195,0.0001,
		  0.0000,5.8581,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][357] = _itmp467[_r++];
			}
		}
		{ static float _itmp468[] = {8.,4.,4944.7,0.0000,0.3643,0.0000,
		  0.0000,5.8621,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][358] = _itmp468[_r++];
			}
		}
		{ static float _itmp469[] = {8.,4.,4930.3,0.0407,-0.2476,0.4153,
		  -0.0419,3.9910,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][359] = _itmp469[_r++];
			}
		}
		{ static float _itmp470[] = {8.,4.,4930.3,0.1223,-0.7431,1.2467,
		  -0.1257,3.9913,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][360] = _itmp470[_r++];
			}
		}
		{ static float _itmp471[] = {8.,4.,4924.2,0.0007,0.7699,0.0001,
		  0.0000,5.8606,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][361] = _itmp471[_r++];
			}
		}
		{ static float _itmp472[] = {8.,4.,4498.2,0.0226,-0.0754,0.1040,
		  -0.0087,3.3188,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][362] = _itmp472[_r++];
			}
		}
		{ static float _itmp473[] = {8.,4.,4493.9,0.0005,0.4192,-0.0001,
		  0.0000,5.8498,0.20};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][363] = _itmp473[_r++];
			}
		}
		{ static float _itmp474[] = {8.,4.,4462.6,0.0457,-0.1671,0.2516,
		  -0.0184,3.2313,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][364] = _itmp474[_r++];
			}
		}
		{ static float _itmp475[] = {8.,4.,3236.6,0.0000,0.1399,0.0000,
		  0.0000,1.9093,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][365] = _itmp475[_r++];
			}
		}
		{ static float _itmp476[] = {8.,4.,3164.3,0.0160,0.1955,0.0529,
		  -0.0039,2.9938,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][366] = _itmp476[_r++];
			}
		}
		{ static float _itmp477[] = {8.,4.,3129.6,0.0000,0.1965,0.0000,
		  0.0000,3.0685,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][367] = _itmp477[_r++];
			}
		}
		{ static float _itmp478[] = {8.,4.,3083.8,0.0001,0.4411,0.0000,
		  0.0000,2.9807,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][368] = _itmp478[_r++];
			}
		}
		{ static float _itmp479[] = {8.,4.,3077.9,0.0000,0.1517,0.0000,
		  0.0000,1.9094,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][369] = _itmp479[_r++];
			}
		}
		{ static float _itmp480[] = {8.,4.,3031.3,0.0002,0.7817,0.0000,
		  0.0000,2.9583,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][370] = _itmp480[_r++];
			}
		}
		{ static float _itmp481[] = {8.,4.,3023.6,0.0009,1.3603,0.0001,
		  0.0000,2.9790,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][371] = _itmp481[_r++];
			}
		}
		{ static float _itmp482[] = {8.,4.,3016.6,0.0000,0.5112,0.0000,
		  0.0000,2.9986,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][372] = _itmp482[_r++];
			}
		}
		{ static float _itmp483[] = {8.,4.,3005.2,0.0002,0.9032,0.0002,
		  0.0000,2.9618,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][373] = _itmp483[_r++];
			}
		}
		{ static float _itmp484[] = {8.,4.,3003.8,0.0009,2.7109,0.0000,
		  0.0001,2.9619,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][374] = _itmp484[_r++];
			}
		}
		{ static float _itmp485[] = {8.,4.,2993.3,0.0007,1.3851,-0.0001,
		  0.0000,2.9537,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][375] = _itmp485[_r++];
			}
		}
		{ static float _itmp486[] = {8.,4.,2991.3,0.0035,4.1590,0.0002,
		  -0.0001,2.9540,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][376] = _itmp486[_r++];
			}
		}
		{ static float _itmp487[] = {8.,4.,2974.6,0.0000,2.3453,-0.0001,
		  0.0000,2.9549,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][377] = _itmp487[_r++];
			}
		}
		{ static float _itmp488[] = {8.,4.,2941.4,0.3768,2.0972,0.8634,
		  -0.0657,3.0325,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][378] = _itmp488[_r++];
			}
		}
		{ static float _itmp489[] = {8.,4.,2941.4,0.1258,0.6993,0.2887,
		  -0.0220,3.0326,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][379] = _itmp489[_r++];
			}
		}
		{ static float _itmp490[] = {8.,4.,2784.0,0.0075,-0.1040,0.5878,
		  -0.0604,1.8618,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][380] = _itmp490[_r++];
			}
		}
}
void LineFitData10(void)
{
		{ static float _itmp491[] = {8.,4.,2696.3,0.0009,1.2340,-0.0001,
		  0.0000,2.9394,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][381] = _itmp491[_r++];
			}
		}
		{ static float _itmp492[] = {8.,4.,1660.8,0.1433,2.3447,0.1964,
		  -0.0148,2.9947,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][382] = _itmp492[_r++];
			}
		}
		{ static float _itmp493[] = {8.,4.,1643.7,0.4277,2.2318,1.0820,
		  -0.0818,3.0315,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][383] = _itmp493[_r++];
			}
		}
		{ static float _itmp494[] = {8.,4.,1629.2,0.1100,1.9840,0.1615,
		  -0.0121,2.9994,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][384] = _itmp494[_r++];
			}
		}
		{ static float _itmp495[] = {8.,4.,1524.4,0.0751,1.2396,0.1036,
		  -0.0078,2.9944,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][385] = _itmp495[_r++];
			}
		}
		{ static float _itmp496[] = {8.,4.,1371.3,0.1528,-2.1819,12.1631,
		  -1.1983,2.0811,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][386] = _itmp496[_r++];
			}
		}
		{ static float _itmp497[] = {8.,4.,1085.8,-0.0859,5.0151,1.5551,
		  -0.1513,2.8250,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][387] = _itmp497[_r++];
			}
		}
		{ static float _itmp498[] = {8.,4.,1071.6,0.0003,1.3349,0.0000,
		  0.0000,2.9583,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][388] = _itmp498[_r++];
			}
		}
		{ static float _itmp499[] = {8.,4.,1067.9,0.0000,4.0933,-0.0001,
		  0.0000,2.9549,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][389] = _itmp499[_r++];
			}
		}
		{ static float _itmp500[] = {8.,4.,1055.1,0.0012,1.7375,0.0001,
		  0.0000,2.9791,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][390] = _itmp500[_r++];
			}
		}
		{ static float _itmp501[] = {8.,4.,1040.6,0.1517,0.8702,0.3453,
		  -0.0262,3.0318,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][391] = _itmp501[_r++];
			}
		}
		{ static float _itmp502[] = {8.,4.,1037.4,0.0004,2.3306,-0.0002,
		  0.0000,2.9389,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][392] = _itmp502[_r++];
			}
		}
		{ static float _itmp503[] = {8.,4.,1032.5,0.0011,1.5181,-0.0002,
		  0.0000,2.9540,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][393] = _itmp503[_r++];
			}
		}
		{ static float _itmp504[] = {8.,4.,1031.9,0.0012,1.3021,-0.0001,
		  0.0000,2.9625,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][394] = _itmp504[_r++];
			}
		}
		{ static float _itmp505[] = {8.,4.,1020.0,0.0011,1.9488,0.1513,
		  -0.0122,2.9376,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][395] = _itmp505[_r++];
			}
		}
		{ static float _itmp506[] = {8.,4.,943.7,0.0001,1.1447,0.0000,
		  0.0000,2.6478,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][396] = _itmp506[_r++];
			}
		}
		{ static float _itmp507[] = {8.,4.,774.5,0.0308,-0.3144,2.7102,
		  -0.2657,2.0844,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][397] = _itmp507[_r++];
			}
		}
		{ static float _itmp508[] = {8.,4.,760.4,0.0565,-1.0006,9.1628,
		  -0.9287,1.7646,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][398] = _itmp508[_r++];
			}
		}
		{ static float _itmp509[] = {8.,4.,681.3,0.5482,4.2072,1.6253,
		  -0.1233,3.0007,0.15};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][399] = _itmp509[_r++];
			}
		}
		{ static float _itmp510[] = {8.,4.,629.7,0.2120,-3.1260,19.1353,
		  -1.8583,2.0594,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][400] = _itmp510[_r++];
			}
		}
		{ static float _itmp511[] = {8.,4.,202.3,0.0577,-0.7299,3.0596,
		  -0.3423,1.9926,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][401] = _itmp511[_r++];
			}
		}
		{ static float _itmp512[] = {8.,4.,192.9,0.1384,-2.1966,9.3514,
		  -1.0249,2.1022,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][402] = _itmp512[_r++];
			}
		}
		{ static float _itmp513[] = {8.,4.,168.0,0.0839,-1.2048,5.8036,
		  -0.6387,1.8941,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][403] = _itmp513[_r++];
			}
		}
		{ static float _itmp514[] = {8.,4.,141.3,-0.0005,11.8982,-0.0002,
		  0.0000,3.0188,0.10};
		for( I=1, _r = 0; I <= 9; I++ )
		{
			ADfAST.ST[I-1][404] = _itmp514[_r++];
			}
		}

#	ifdef DEBUG_FUN
	fputs( "<+>blkdata0()\n", debug_fp );
#	endif
	/*block data with D Verner's recombination lines */

#	ifdef DEBUG_FUN
	fputs( " <->blkdata0()\n", debug_fp );
#	endif
}
/*lint +e736 */ /* turn on loss of precision double to float */

