/*lines_lv1_li_ne place lines of elements lithium through neon into lines storage stack */
#include "cddefines.h"
#include "coolheavy.h"
#include "o3exc.h"
#include "doppvel.h"
#include "pmp2s.h"
#include "r1335.h"
#include "recom.h"
#include "phycon.h"
#include "atom_oi.h"
#include "embesq.h"
#include "taulines.h"
#include "ionfracs.h"
#include "trace.h"
#include "linadd.h"
#include "lindst.h"
#include "putline.h"
#include "getlinerec.h"
#include "lines.h"

void lines_lv1_li_ne(void)
{
	long int ipnt;
	double colfac, 
	  corr, 
	  cs5200, 
	  ct4363, 
	  ctRate, 
	  efac, 
	  effec, 
	  efficn2, 
	  fac, 
	  p386, 
	  pump,
	  r4363, 
	  r6584, 
	  raten3, 
	  rb, 
	  rec, 
	  rn3mor, 
	  rn3tot, 
	  rnii, 
	  rp300, 
	  rp386, 
	  sum;
	double rec7323 , rec7332, rec3730 , rec3726 , rec2471,
		reco23tot , reco22tot;

#	ifdef DEBUG_FUN
	fputs( "<+>lines_lv1_li_ne()\n", debug_fp );
#	endif

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, "   lines_lv1_li_ne called\n" );
	}

	/* lev 1 ines */
	ipnt = StuffComment( "level 1 lines" );
	linadd( 0., (float)ipnt , "####", 'i' );

	/* cooling due to collisional ionization of heavy elements */
	linadd(CoolHeavy.colmet,0,"Mion",'c' );

	/* lithium */
	
	/* beryllium */

	/* boron*/

	/* carbon*/

	/* >>chng 97 may 02, added better rec coef
	 * C I 1656 recombination, all agents */
	rec = GetLineRec(3,1657)*TauLines[ipT1656].AovTot;
	PutExtra(rec);

	/* C 1 1656, collision strength from van Regemoter */
	PutLine(&TauLines[ipT1656]);

	/* C 1 1656 recomb; n.b. coll deexcitation not in */
	linadd(rec,1656,"REC ",'i' );

	/* C 1 9850, coll excit */
	linadd(CoolHeavy.c9850,9850,"C Ic",'c' );

	/* >>chng 97 may 02, added better rec coef
	 * C 1 9850, recom contribution rec coef from 
	 * >>refer	C1	rec	apj sup 73, 513.
	 * r9850 is correction for collisional deexcitation as in carb cool
	 * >>chng 97 aug 2, had factor of rec, changed to r9850, this
	 * was a big mistake */
	rec = (GetLineRec(1,9088) + GetLineRec(2,9658))*r1335.r9850;
	linadd(rec,9850,"C Ir",'i' );
	/* total intensity, all processes, C I 9850 */
	PntForLine(9850.,"C  1",&ipnt);
	lindst(rec+CoolHeavy.c9850,9850,"TOTL",ipnt,'i',TRUE );
	
	/* C 1 8727; equivalent to 4363 */
	PntForLine(8727.,"C  1",&ipnt);
	lindst(CoolHeavy.c8727,8727,"C  1",ipnt,'c',TRUE );
	
	/* 1S - 3P */
	linadd(CoolHeavy.c8727*1.22e-6,4621,"C  1",'c' );

	/* C 1 610 micron */
	PutLine(&TauLines[ipT610]);

	/* C 1 370 micron */
	PutLine(&TauLines[ipT370]);

	/* C 2 158 micron, both e- and H0, H2 in excitation */
	PutLine(&TauLines[ipT157]);

	/* total intensity of C II] 2326, all lines in the multiplet */
	linadd(
		TauLines[ipC2_2325].xIntensity+
		TauLines[ipC2_2324].xIntensity+
		TauLines[ipC2_2329].xIntensity+
		TauLines[ipC2_2328].xIntensity+
		TauLines[ipC2_2327].xIntensity+pmp2s.p2326*8.6e-12,
		2326,"TOTL",'i' );
	PutLine(&TauLines[ipC2_2325]);
	PutLine(&TauLines[ipC2_2324]);
	PutLine(&TauLines[ipC2_2329]);
	PutLine(&TauLines[ipC2_2328]);
	PutLine(&TauLines[ipC2_2327]);

	/* photoproduction, Helfand and Trefftz */
	linadd(pmp2s.p2326*8.6e-12,2326,"Phot",'i' );

	/* >>chng 97 may 02, better rec coef */
	rec = GetLineRec(11,1335)*TauLines[ipT1335].AovTot;

	/* total intensity of C 2 1335 */
	PutExtra(MAX2(0.,rec));
	PutLine(&TauLines[ipT1335]);

	/* C 2 1335 recombination, */
	linadd(rec,1335,"REC ",'i' );

	/* C 2 intercombination line with same upper state as 1335 */
	linadd(CoolHeavy.c3134,3134,"C II",'c' );
	
	/* the CII 3918.98/3920.68 and 6578.05/6582.88 multiplets,
	 * contributions by both continuum pumping through XUV line
	 * and recombination */
	/* this is the driving line, pump is photons cm^-3 s^-1 */
	if( nWindLine > 0 )
	{
		pump = TauLine2[186].pump*TauLine2[186].PopOpc;
	}
	else
	{
		pump = 0.;
	}

	/*fprintf(ioQQQ," tauline2 %g %g\n", TauLine2[186].TauIn , pump );*/

	/* CII 3918.98/3920.68 is only pumped, no recombination part */
	PntForLine(3920.,"C  2",&ipnt);
	lindst(pump*0.387 * 5.08e-12/(1.+phycon.eden/1e12) ,3920,"pump",ipnt,'i',TRUE );

	/* recombination and specific pump for CII 5684 */
	rec = GetLineRec(8, 6580 );
	/* convert uv pump rate to intensity with branching ratio and hnu */
	pump *= 0.305 * 0.387 * 3.02e-12;
	/* recombination part of C II 6580 line */
	linadd(rec/(1.+phycon.eden/1e12),6580,"C 2r",'i' );
	/* pumped part of line C II 6580 */
	linadd(pump/(1.+phycon.eden/1e12),6580,"C 2p",'i' );

	/* total intensity, all processes, C II 6580 */
	PntForLine(6580.,"C  2",&ipnt);
	lindst((rec+pump)/(1.+phycon.eden/1e12),6580,"TOTL",ipnt,'i',TRUE );

	/* C 3 977
	 * recombinaton contribution from nussbaumer and story 84 */
	rec = GetLineRec(179,977)*TauLines[ipT977].AovTot;

	/* continuum pumped C 3 977 by continuum near 386A */
	rp386 = TauLines[ipT386].pump*TauLines[ipT386].PopOpc;

	/* higher lines, same process */
	rp300 = TauLines[ipT310].pump*TauLines[ipT310].PopOpc + 
		TauLines[ipT291].pump*TauLines[ipT291].PopOpc + 
		TauLines[ipT280].pump*TauLines[ipT280].PopOpc + 
		TauLines[ipT274].pump*TauLines[ipT274].PopOpc + 
		TauLines[ipT270].pump*TauLines[ipT270].PopOpc;

	/* total line intensity due to pumping */
	p386 = (rp386 + rp300)*2.03e-11*TauLines[ipT977].AovTot;

	/* total C 3 977 including recombination and pumping */
	PutExtra(p386+MAX2(0.,rec));

	/* total C 3] 977, recombination + collisional + pumped excitation */
	PutLine(&TauLines[ipT977]);

	/* dielectronic recombination contribution to C 3 977 */
	linadd(rec,977,"C3 R",'i' );

	/* C 3 977 pumped by continuum near 386A */
	linadd(p386,977,"P386",'r' );

	/* C 3  1909 collision, both lines together */
	fac = embesq.em1908 + TauLines[ipT1909].xIntensity;
	linadd(fac,1909,"TOTL",'i' );

	PutLine(&TauLines[ipT1909]);

	/* C 3 1908 j-2 to ground */
	PntForLine(1907.,"C  3",&ipnt);
	lindst(embesq.em1908,1907,"C  3",ipnt,'i',TRUE );

	corr = TauLines[ipT1909].AovTot;
	fac = phycon.eden*xIonFracs[ipCARBON][4]/(phycon.te/phycon.te10)*
	  recom.DielSupprs[1][2];

	/* C 3 1909 recombination from Storey */
	linadd(3.1e-19*fac*corr,1909,"C3 R",'i' );

	/* C 3 1909 following relax following inner shell photoionization */
	linadd(pmp2s.p1909*corr*1.05e-11,1909,"Phot",'i' );

	/* >>chng 97 may 02, better rec ocef */
	rec = GetLineRec(178,1176)*TauLines[ipc31175].AovTot;
	PutExtra(MAX2(0.,rec));

	/* C 3* 1175, excited state line, above 1909 */
	PutLine(&TauLines[ipc31175]);

	/* dielectronic recombination contribution to C 3 1175 */
	linadd(MAX2(0.,rec),1175,"Rec ",'i' );

	/* recombination C 4 1549 from C 5
	 * >>chng 97 may 02, better rec coef */
	rec = GetLineRec(25,1549)*TauLines[ipT1550].AovTot;

	/* total intensity of C 4 1549, all processes */
	linadd(
		TauLines[ipT1550].xIntensity+
		TauLines[ipT1548].xIntensity+
		rec,1549,"TOTL",'i' );

	sum = 
		TauLines[ipT1550].xIntensity*TauLines[ipT1550].FracInwd + 
		TauLines[ipT1548].xIntensity*TauLines[ipT1548].FracInwd;

	/* inward part of C 4 */
	linadd(sum+rec*TauLines[ipT1550].FracInwd,1549,"Inwd",'i' );

	PutExtra(rec*.3333);
	PutLine(&TauLines[ipT1550]);

	PutExtra(rec*.6666);
	PutLine(&TauLines[ipT1548]);

	/* part of line destroyed by photoionization of Balmer continuum */
	linadd((TauLines[ipT1550].ots+
		TauLines[ipT1548].ots)*TauLines[ipT1548].EnergyErg,
	  1549,"DEST",'i' );

	/* recombination C 4 1549 from CV */
	linadd(rec,1549,"C4 r",'i' );

	/* Li seq 2s 3p Li seq transition */
	PutLine(&TauLines[ipT312]);

	/* nitrogen */
	
	/* 5200 rec, both rad+di, 1/3 of total to doublets */
	colfac = 8.629e-6/phycon.sqrte*phycon.eden;
	cs5200 = 7.28e-5*phycon.te/phycon.te10;

	/* this is recombination with quenching */
	rec = GetLineRec(32,1200)*1.24e-5/(1.24e-5 + cs5200*colfac/10.);

	/* N 1 5200, both 5198, 5200, collisions and recombination */
	PntForLine(5200.,"N  1",&ipnt);
	lindst(CoolHeavy.c5200+rec,5200,"N  1",ipnt,'i',TRUE );
	
	/* N 1 5200, both 5198, 5200, collisions and recombination */
	linadd(CoolHeavy.c5200,5200,"Coll",'c' );

	/* recombination contributon to [NI] 5200 */
	linadd(rec,5200,"REC ",'i' );

	/* [N 1] 3466, 3 - 1 transition, whole multiplet */
	PntForLine(3466.,"N  1",&ipnt);
	lindst(CoolHeavy.c3466,3466,"N  1",ipnt,'c',TRUE );

	/* [N 1] 10400 3 - 2 transition, whole multiplet */
	PntForLine(10400.,"N  1",&ipnt);
	lindst(CoolHeavy.c10400,10400,"N  1",ipnt,'c',TRUE );
	
	/* collisionally excited part */
	PutLine(&TauLines[ipT1200]);
	
	/* 6 lines with fake collision strenghts */
	PutLine(&TauLines[ipT671]);
	PutLine(&TauLines[ipT315]);
	PutLine(&TauLines[ipT333]);
	PutLine(&TauLines[ipT324]);
	PutLine(&TauLines[ipT374g]);
	PutLine(&TauLines[ipT374x]);

	/* N 2 6584 alone */
	PntForLine(6584.,"N  2",&ipnt);
	lindst(CoolHeavy.c6584/(1.+1./2.951),6584,"N  2",ipnt,'c',TRUE );

	/* N 2 6548 alone */
	PntForLine(6548.,"N  2",&ipnt);
	lindst(CoolHeavy.c6584/(1.+2.951),6548,"N  2",ipnt,'c',TRUE );

	/* N 2 6584 alone, recombination contribution */
	efficn2 = 4e-3/(4e-3 + 5.18e-6*phycon.eden/phycon.sqrte);
	r6584 = 8e-22/(phycon.te70/phycon.te03/phycon.te03)*efficn2;
	linadd(r6584*xIonFracs[ipNITROGEN][3]*phycon.eden,6584,"REC ",  'i' );

	/* helium charge transfer from 
	>>refer	n2	CT	Sun Sadeghpour, Kirby Dalgarno and Lafyatis, cfa preprint 4208 */
	ctRate = 1.8e-11*xIonFracs[ipHELIUM][1]*xIonFracs[ipNITROGEN][3]*1.146/(1.146 + 
	  0.87*phycon.cdsqte)*3.46e-12;

	/* >>chng 01 jul 09, add recombination contribution to 5755 */
	/* >>refer	n2	rec	Liu, X.W., Storey, P.J., Barlow, M.J., Danziger, I.J., Cohen, M.,
	 * >>refercon	& Bryce, M., 2000, MNRAS, 312, 585 */
	/* they give intensity in terms of hbeta intensity as their equn 1 */
	if( xIonFracs[ipHYDROGEN][2] > SMALLFLOAT )
	{
		/* H beta recombination, assuming old case B, needed since HS tables have
		 * only a narrow temperature range */
		double Hbeta = 	(pow(10.,-20.89 - 0.10612*POW2(phycon.alogte - 4.4)))/phycon.te;

		rec = CoolHeavy.xN2_A3_tot * Hbeta *
			3.19 * phycon.te30 * xIonFracs[ipNITROGEN][3]/xIonFracs[ipHYDROGEN][2] ;
	}
	else
	{
		rec = 0.;
	}

	/* N 2 5755  total, collisions plus charge transfer plux recombination */
	PntForLine(5755.,"N  2",&ipnt);
	lindst(CoolHeavy.c5755+ctRate+rec ,5755,"N  2",ipnt,'i',TRUE );
	
	/* N 2 5755  collisional contribution */
	linadd(CoolHeavy.c5755,5755,"Coll",'c' );

	/* N 2 5755  charge transfer contribution */
	linadd(ctRate,5755,"C T ",'i' );

	/* N 2 5755  recombination contribution */
	linadd( rec ,5755,"N 2r",'i' );

	/* N 2 fine structure line */
	PutLine(&TauLines[ipT122]);

	/* N 2 fine structure line */
	PutLine(&TauLines[ipT205]);

	/* N 2 2140 intercombination line */
	PutLine(&TauLines[ipT2140]);

	/* >>chng 97 may 02, better rec contribution */
	rec = GetLineRec(201,1085)*TauLines[ipT1085].AovTot;
	PutExtra(MAX2(0.,rec));

	/* N 2 1084, CS guess from g-bar */
	PutLine(&TauLines[ipT1085]);

	/* dielectronic recombination contribution to N 2 1085 */
	linadd(MAX2(0.,rec),1085,"Rec ",'i' );

	/* continuum puming of N 2 intersystem transition */
	rnii = TauLines[ipT671].pump*TauLines[ipT671].PopOpc;

	/* continuum pumped N 2 6584 */
	linadd(rnii*0.377*0.75*3.02e-12*efficn2,6584,"N2cn",'i' );

	/* continuum pumped N 2 5755 */
	efficn2 = 1./(1. + 8.6e-6*phycon.eden/phycon.sqrte);
	linadd(rnii*0.0117*3.46e-12*efficn2,5755,"N2cn",'i' );

	/* pumping of the NII 509A line excites 2p4s ^3P^o,
	 * which decays through the 3328, 5679, and 671 multiplets
	 * the NII 3311 (6 lines), 3840 (6 lines), and 3600 (3 lines) multiplets,
	 * contributions by both continuum pumping through XUV line
	 * and recombination */
	/* this is the driving line, pump is photons cm^-3 s^-1 */
	if( nWindLine > 0 )
	{
		pump = TauLine2[265].pump*TauLine2[265].PopOpc;
	}
	else
	{
		pump = 0.;
	}

	/* NII 3311.42 - 3331.31 (6 lines) are only pumped, no recombination part */
	PntForLine(3311.,"N  2",&ipnt);
	lindst(pump*0.236 * 6.01e-12/(1.+phycon.eden/1e12) ,3311,"pump",ipnt,'i',TRUE );

	/* NII 3829.8-3856.06 (6 lines) are only pumped, no recombination part */
	PntForLine(3840.,"N  2",&ipnt);
	lindst(pump*0.186 * 5.18e-12/(1.+phycon.eden/1e12) ,3840,"pump",ipnt,'i',TRUE );

	/* NII 3593.60/3609.1/3615.86 (3 lines) are only pumped, no recombination part */
	PntForLine(3609.,"N  2",&ipnt);
	lindst(pump*0.025 * 5.52e-12/(1.+phycon.eden/1e12) ,3609,"pump",ipnt,'i',TRUE );

	/* NII 4601.5-4643.1 (6 lines) are only pumped, no recombination part */
	PntForLine(4640.,"N  2",&ipnt);
	lindst(pump*0.186*0.595 * 4.31e-12/(1.+phycon.eden/1e12) ,4640,"pump",ipnt,'i',TRUE );

	/* NII 5002.7/5010.6/5045.1 (3 lines) are only pumped, no recombination part */
	PntForLine(5010.,"N  2",&ipnt);
	lindst(pump*0.025*0.442 * 3.97e-12/(1.+phycon.eden/1e12) ,5010,"pump",ipnt,'i',TRUE );

	/* recombination and specific pump for NII 5679 */
	rec = GetLineRec(44, 5679 );
	/* convert uv pump rate to intensity with branching ratio and hnu */
	pump *= 0.236 * 0.626 * 3.50e-12;
	/* recombination part of N II 5679 line */
	linadd(rec/(1.+phycon.eden/1e12),5679,"N 2r",'i' );
	/* pumped part of line N II 5679 */
	linadd(pump/(1.+phycon.eden/1e12),5679,"N 2p",'i' );

	/* total intensity, all processes, N II 5679 */
	PntForLine(5679.,"N  2",&ipnt);
	lindst((rec+pump)/(1.+phycon.eden/1e12),5679,"TOTL",ipnt,'i',TRUE );

	/* [N 3] 57 micron fine structure line */
	PutLine(&TauLines[ipT57]);

	/* total intensity of N III] 1750, all lines in the multiplet */
	linadd(
		TauLines[ipN3_1749].xIntensity+
		TauLines[ipN3_1747].xIntensity+
		TauLines[ipN3_1754].xIntensity+
		TauLines[ipN3_1752].xIntensity+
		TauLines[ipN3_1751].xIntensity,
		1750,"TOTL",'i' );
	PutLine(&TauLines[ipN3_1749]);
	PutLine(&TauLines[ipN3_1747]);
	PutLine(&TauLines[ipN3_1754]);
	PutLine(&TauLines[ipN3_1752]);
	PutLine(&TauLines[ipN3_1751]);

	/* continuum pumped "Bowen" N 3
	 * rate system a is populated  */
	raten3 = TauLines[ipT374x].PopOpc*TauLines[ipT374x].pump;

	/* rate system b is populated */
	if( DoppVel.TurbVel < 200. )
	{
		rb = TauLines[ipT374x].PopOpc*TauLines[ipT374x].pump + 
			TauLines[ipT374g].PopOpc*TauLines[ipT374g].pump;
	}
	else
	{
		/* only one line if both fully overlap due to large turb */
		rb = TauLines[ipT374g].PopOpc*TauLines[ipT374g].pump;
	}

	rn3mor = 
		TauLines[ipT315].PopOpc*TauLines[ipT315].pump*0.448 + 
		TauLines[ipT324].PopOpc*TauLines[ipT324].pump*0.78 + 
		TauLines[ipT333].PopOpc*TauLines[ipT333].pump*0.434;

	/* pumping of optical N 3 bowen lines */
	rn3tot = (rb + raten3)*0.439 + rn3mor;

	/* continuum pumped "Bowen" N 3, optically thin excited line */
	sum = raten3*4.29e-12;
	PntForLine(4640.,"N3cn",&ipnt);
	lindst(sum,4640,"N3cn",ipnt,'i',TRUE );
	
	/* continuum pumped "Bowen" N 3, optically thin excited line */
	sum = rb*4.29e-12*0.834;
	PntForLine(4634.,"N3cn",&ipnt);
	lindst(sum,4634,"N3cn",ipnt,'i',TRUE );
	
	/* continuum pumped "Bowen" N 3, optically thin excited line */
	sum = rb*4.29e-12*(1. - 0.834);
	PntForLine(4642.,"N3cn",&ipnt);
	lindst(sum,4642,"N3cn",ipnt,'i',TRUE );
	
	/* total rate for N 3 990
	 * correction factor for collisional deexcitation */
	fac = TauLines[ipT990].AovTot;

	/* >>chng 97 may 02, better rec coef */
	rec = GetLineRec(216,991)*TauLines[ipT990].AovTot;
	PutExtra(MAX2(0.,rec)+rn3tot*2.01e-11*fac);

	/* N 3 990, all processes */
	PutLine(&TauLines[ipT990]);

	/* total N 3 990, both electron excitation and continuum pumping */
	linadd(rec+rn3tot*2.01e-11*fac,990,"extr",'i' );

	/* part of N 3 990 due to recombination */
	linadd(rec,990,"rec ",'i' );

	/* N 3 989.8, continuum pumped */
	linadd(rn3tot*2.01e-11,990,"N 3p",'r' );

	/* N 4] 1486, total intensity of both lines */
	linadd(embesq.em1486+TauLines[ipT1486].xIntensity,1486,"TOTL",'i' );

	PutLine(&TauLines[ipT1486]);

	/* the N 4] slow transition by itself */
	linadd(embesq.em1486,1485,"N  4",'i' );

	/* >>chng 97 may 02, better expression for dielectronic recombination */
	rec = GetLineRec(287,765)*TauLines[ipT765].AovTot;

	/* dielectronic recom contribution from Nussbaumer and Storey 1984 */
	PutExtra(rec);

	/* N 4 765, collisionally excited */
	PutLine(&TauLines[ipT765]);

	/* N 4 765 recombination, */
	linadd(MAX2(0.,rec),765,"rec ",'i' );

	/* continuum pumping of NV 1240
	 * N 5 1240, total emission, collisions plus pumping */
	linadd(TauLines[ipT1243].xIntensity+TauLines[ipT1239].xIntensity,1240,"TOTL",'i' );
	sum = TauLines[ipT1243].xIntensity*TauLines[ipT1243].FracInwd + TauLines[ipT1239].xIntensity*
	  TauLines[ipT1239].FracInwd;

	/* inward part of N 5 */
	linadd(sum,1240,"Inwd",'i' );
	PutLine(&TauLines[ipT1243]);
	PutLine(&TauLines[ipT1239]);

	/* N 5 209, 2s-3p li seq */
	PutLine(&TauLines[ipT209]);

	/* oxygen
	 * total Oxygen I  6300, including line optical depth */
	PntForLine(6300.,"O  1",&ipnt);
	lindst(CoolHeavy.c6300,6300,"O  1",ipnt,'c',TRUE );

	/* total Oxygen I  6363, including line optical depth */
	PntForLine(6363.,"O  1",&ipnt);
	lindst(CoolHeavy.c6363,6363,"O  1",ipnt,'c',TRUE );

	/* auroral OI */
	PntForLine(5577.,"O  1",&ipnt);
	lindst(CoolHeavy.c5577,5577,"O  1",ipnt,'c',TRUE );
	
	/* O I fine structure line */
	PutLine(&TauLines[ipT63]);

	/* O I fine structure line */
	PutLine(&TauLines[ipT146]);

	/* total collisional cooling due to 6-level OI atom */
	linadd(MAX2(0.,CoolHeavy.coolOi),0,"TOIc",'c' );

	/* total collisional heating due to 6-level OI atom */
	linadd(MAX2(0.,-CoolHeavy.coolOi),0,"TOIh",'h' );

	/* OI 8446 from six level atom */
	sum = atom_oi.popoi[4]*TauLines[ipT8446].Pesc*TauLines[ipT8446].Aul*2.36e-12;
	PntForLine(8446.,"O  1",&ipnt);

	/*666 error!  these are actually in the optical depth arrays, should
	 * be moved to call PutLine */
	lindst(sum,8446,"6lev",ipnt,'i',FALSE );
	
	/* OI 1304 from six level atom */
	PntForLine(1304.,"O  1",&ipnt);
	sum = atom_oi.popoi[1]*TauLines[ipT1304].Pesc*TauLines[ipT1304].Aul*1.53e-11;
	lindst(sum,1304,"6lev",ipnt,'i',FALSE );
	
	/* OI 1039 from six level atom */
	PntForLine(1039.,"O  1",&ipnt);
	sum = atom_oi.popoi[3]*TauLines[ipT1039].Pesc*TauLines[ipT1039].Aul*1.92e-11;
	lindst(sum,1039,"6lev",ipnt,'i',FALSE );
	
	/* OI 4368 from six level atom */
	PntForLine(4368.,"O  1",&ipnt);
	sum = atom_oi.popoi[5]*TauLines[ipT4368].Pesc*TauLines[ipT4368].Aul*4.55e-12;
	lindst(sum,4368,"6lev",ipnt,'i',FALSE );
	
	/* OI 1.3 micron from six level atom */
	PntForLine(13100.,"O  1",&ipnt);
	sum = atom_oi.popoi[3]*TauLines[ipTOI13].Pesc*TauLines[ipTOI13].Aul*1.52e-12;
	lindst(sum,13,"6lev",ipnt,'i',FALSE );
	
	/* OI 1.1 micron from six level atom */
	PntForLine(11300.,"O  1",&ipnt);
	sum = atom_oi.popoi[4]*TauLines[ipTOI11].Pesc*TauLines[ipTOI11].Aul*1.76e-12;
	lindst(sum,11,"6lev",ipnt,'i',FALSE );
	
	/* OI 2.9 micron from six level atom */
	PntForLine(29000.,"O  1",&ipnt);
	sum = atom_oi.popoi[5]*TauLines[ipTOI29].Pesc*TauLines[ipTOI29].Aul*6.86e-13;
	lindst(sum,29,"6lev",ipnt,'i',FALSE );
	
	/* OI 4.6 micron from six level atom */
	PntForLine(46000.,"O  1",&ipnt);
	sum = atom_oi.popoi[5]*TauLines[ipTOI46].Pesc*TauLines[ipTOI46].Aul*4.32e-13;
	lindst(sum,46,"6lev",ipnt,'i',FALSE );
	
	/*double rec7323 , rec7332, rec3730 , rec3726 , rec2471 
	 * reco23tot , reco22tot;*/

	/* total recombination to 2P^o, the highest two levels of the 5-level atom,
	 * which produces the 7325 multiplet, last factor accounts for coll deexcit  */
	reco23tot = 3.484e-11 / ( phycon.sqrte / phycon.te05 * phycon.te003 ) * 
		phycon.eden * xIonFracs[ipOXYGEN][3] * CoolHeavy.O2_A3_tot;

	sum = CoolHeavy.O2471*2471./7325. + CoolHeavy.O7323 + CoolHeavy.O7332;
	if( sum > SMALLFLOAT )
	{
		/* assume effective branching ratio according to predicted intensities from 5-lev atom*/
		reco23tot /= sum;
	}
	else
	{
		reco23tot = 0.;
	}
	/* these are now ergs per sec unit vol for each transition */
	rec7323 = reco23tot * CoolHeavy.O7323*2.72e-12 ;
	rec7332 = reco23tot * CoolHeavy.O7332*2.72e-12 ;
	rec2471 = reco23tot * CoolHeavy.O2471*2471./7325. * 8.05e-12 ;

	/* total recombination to 2D^o, the middle two levels of the 5-level atom,
	 * which produces the 3727 multiplet, last factor accounts for coll deexcit */
	reco22tot = 1.660e-10 / ( phycon.sqrte * phycon.te03 * phycon.te005 ) * 
		phycon.eden * xIonFracs[ipOXYGEN][3] * CoolHeavy.O2_A2_tot;
	/* assume effective branching ratio according to predicted intensities from 5-lev atom*/
	sum = CoolHeavy.O3726 + CoolHeavy.O3730 ;
	if( sum > SMALLFLOAT )
	{
		reco22tot /= sum;
	}
	else
	{
		reco22tot = 0.;
	}
	/* these are now ergs per sec unit vol for each transition */
	rec3726 = reco22tot * CoolHeavy.O3726 * 5.34e-12 ;
	rec3730 = reco22tot * CoolHeavy.O3730 * 5.34e-12 ;

	/* O II 3727 produced by photoionization OF O0 */
	pmp2s.s3727 = (float)((pmp2s.s3727 + pmp2s.s7325*0.5)*5.34e-12*
	  9.7e-5/(9.7e-5 + phycon.eden*1.15e-6/phycon.sqrte));

	/* O II 3727, all lines of multiplet together */
	PntForLine(3727.,"O  2",&ipnt);
	lindst(CoolHeavy.c3727+pmp2s.s3727+rec3726+rec3730,3727,"TOTL",ipnt,'c',TRUE );

	/* O II 7325, all lines of multiplet together */
	PntForLine(7325.,"O  2",&ipnt);
	lindst(CoolHeavy.c7325+rec7323+rec7332,7325,"TOTL",ipnt,'c',TRUE );

	/* line produced by photoionization of Oo; already in TOTL */
	linadd(pmp2s.s3727,3727,"IONZ",'i' );
	pmp2s.s7325 = (float)(pmp2s.s7325*2.72e-12*0.34/(0.34 + phycon.eden*
	  6.04e-6/phycon.sqrte));

	/* line produced by photoionization of Oo; already in TOTL */
	linadd(pmp2s.s7325,7325,"IONZ",'i' );

	/* five level atom calculations; D5/2 - S3/2 */
	linadd(CoolHeavy.O3730,3729,"O II",'i' );

	/* D3/2 - S3/2 transition */
	linadd(CoolHeavy.O3726,3726,"O II",'i' );

	/* both 2P 1/2 and 3/2 to ground */
	linadd(CoolHeavy.O2471,2471,"O II",'c' );

	/* P1/2-D5/2 and P3/2-D5/2 together */
	linadd(CoolHeavy.O7323,7323,"O II",'i' );

	/* P1/2-D3/2 and P3/2-D3/2 together */
	linadd(CoolHeavy.O7332,7332,"O II",'i' );

	/* chng 01 jul 08, add recombination contribution */
	/* refer	o2	rec	Liu, X-W., Storey, P.J., Barlow, M.J., Danziger, I.J.,
	 * refercon	Cohen, M., & Bryce, M., 2000, MNRAS, 312, 585 */
	/* recom contributions five level atom calculations; D5/2 - S3/2 */
	linadd( rec3730 ,3729,"O 2r",'i' );

	/* D3/2 - S3/2 transition */
	linadd( rec3726 ,3726,"O 2r",'i' );

	/* both 2P 1/2 and 3/2 to ground */
	linadd(rec2471,2471,"O 2r",'i' );

	/* P1/2-D5/2 and P3/2-D5/2 together */
	linadd(rec7323,7323,"O 2r",'i' );

	/* P1/2-D3/2 and P3/2-D3/2 together */
	linadd(rec7332,7332,"O 2r",'i' );

	/* O II 833.8 coll excit */
	PutLine(&TauLines[ipT834]);

	/* the OII multiplets,
	 * contributions by both continuum pumping through XUV line
	 * and recombination */
	/* this is the driving line, pump is photons cm^-3 s^-1 */
	if( nWindLine > 0 )
	{
		pump = TauLine2[387].pump*TauLine2[387].PopOpc;
	}
	else
	{
		pump = 0.;
	}

	/* OII 3113.62 - 3139.68 (8 lines) are only pumped, no recombination part */
	PntForLine(3120.,"O  2",&ipnt);
	lindst(pump*0.336 * 6.37e-12/(1.+phycon.eden/1e12) ,3120,"pump",ipnt,'i',TRUE );

	/* OII 3277.56 - 3306.45 (6 lines) are only pumped, no recombination part */
	PntForLine(3300.,"O  2",&ipnt);
	lindst(pump*0.147 * 6.03e-12/(1.+phycon.eden/1e12) ,3300,"pump",ipnt,'i',TRUE );

	/* OII 3739.76/3762.47/3777.42 (3 lines) are only pumped, no recombination part */
	PntForLine(3762.,"O  2",&ipnt);
	lindst(pump*0.087 * 5.29e-12/(1.+phycon.eden/1e12) ,3762,"pump",ipnt,'i',TRUE );

	/* recombination and specific pump for OII 4638.86-4696.35 (8 lines) */
	rec = GetLineRec(82, 4651 );
	/* convert uv pump rate to intensity with branching ratio and hnu */
	/* recombination part of O II 4651 line */
	linadd(rec,4651,"O 2r",'i' );
	/* pumped part of line O II 4651 */
	linadd(pump* 0.336 * 0.933 * 4.27e-12/(1.+phycon.eden/1e12),4651,"O 2p",'i' );

	/* recombination and specific pump for OII 4317.14-4366.89 (6 lines) */
	rec = GetLineRec(83, 4341 );
	/* convert uv pump rate to intensity with branching ratio and hnu */
	/* recombination part of O II 4341 line */
	linadd(rec/(1.+phycon.eden/1e12),4341,"O 2r",'i' );
	/* pumped part of line O II 4341 */
	linadd(pump* 0.147 * 0.661 * 4.58e-12/(1.+phycon.eden/1e12),4341,"O 2p",'i' );

	/* total intensity, all processes, O II 4341 */
	PntForLine(4341.,"O  2",&ipnt);
	lindst(rec+pump* 0.147 * 0.661 * 4.58e-12/(1.+phycon.eden/1e12),4341,"TOTL",ipnt,'i',TRUE );

	/* recombination and specific pump for OII 3712.74/3727.32/3749.48 (3 lines) */
	rec = GetLineRec(84, 3736 );
	/* convert uv pump rate to intensity with branching ratio and hnu */
	/* recombination part of O II 3736 line */
	linadd(rec/(1.+phycon.eden/1e12),3736,"O 2r",'i' );
	/* pumped part of line O II 3736 */
	linadd(pump* 0.087 * 0.763 * 5.33e-12/(1.+phycon.eden/1e12),3736,"O 2p",'i' );

	/* total intensity, all processes, O II 3736 */
	PntForLine(3736.,"O  2",&ipnt);
	lindst((rec+pump* 0.087 * 0.763 * 5.33e-12)/(1.+phycon.eden/1e12),3736,"TOTL",ipnt,'i',TRUE );

	/* O III 1661+1666 */
	efac = (TauLines[ipT1666].AovTot + TauLines[ipT1661].AovTot)*0.5;

	/* total intensity of OIII] 1665, all processes */
	linadd(TauLines[ipT1666].xIntensity+TauLines[ipT1661].xIntensity,1665,"TOTL",'i' );
	PutLine(&TauLines[ipT1661]);

	PutLine(&TauLines[ipT1666]);

	/* contribution to OIII 1665 due to inner shell (2s^2) ionization */
	linadd(pmp2s.p1666*1.20e-11*efac,1665,"Phot",'i' );

	/* contribution to OIII 1665 due to K-shell ionization */
	linadd(pmp2s.AugerO3*1.20e-11*efac*0.27,1665,"Augr",'i' );

	/* O III  5007 alone, collisions, tot OIII is this times 1.333
	 * fac = c5007/(1.+1./2.887) */
	/* >>chng 01 may 04, branching ratio had been 2.887, revised to 3 as per
	 * >>refer	o3	as	Storey, P.J., & Zeippen, C.J., 2000, 312, 813-816
	 */
	PntForLine(5007.,"O  3",&ipnt);
	lindst(CoolHeavy.c5007/(1.+1./3.01),5007,"O  3",ipnt,'c',TRUE );

	/* O III  4959 alone, collisions, tot OIII is this times 4 */
	PntForLine(4959.,"O  3",&ipnt);
	lindst(CoolHeavy.c5007/(1.+3.01),4959,"O  3",ipnt,'c',TRUE );

	/* O III  4931 alone, collisions */
	/* >>chng 01 jul 11, added this line */
	/* >>refer	o3	as	Nussbaumer, H., & Storey, P., 1981, A&A, 99, 177*/
	/* >>refer	o3	as	Mathis, J.S., & Liu, X.-W., 1999, ApJ, 521, 212-216 */
	PntForLine(4931.,"O  3",&ipnt);
	lindst(CoolHeavy.c5007/(1.+3.01)*4.09e-4 ,4931,"O  3",ipnt,'c',TRUE );

	/* O III 5007 lost through excit photo */
	linadd(o3exc.d5007t/1.25,5007,"LOST",'i' );

	/* collisional quenching ratio */
	effec = 1.6/(1.6 + 0.9*colfac);

	/* O III 4363 recombination, coef from Burgess and Seaton */
	r4363 = 6.3e-21/(phycon.te70*phycon.te10)*phycon.eden*xIonFracs[ipOXYGEN][4]*
	  effec;

	/* charge exchange, 
	 * >>refer	O3	CT	Dalgarno+Sternberg ApJ Let 257, L87.
	 * scalled to agree with 
	 * >>refer	O3	CT	Gargaud et al AA 208, 251, (1989) */
	ct4363 = phycon.sqrte*1.3e-12*4.561e-12*xIonFracs[ipHYDROGEN][1]*xIonFracs[ipOXYGEN][4]*
	  effec;

	/* O III 4363, sum of rec, coll, ct excitation */
	fac = CoolHeavy.c4363 + r4363 + ct4363;
	PntForLine(4363.,"O  3",&ipnt);
	lindst(fac,4363,"TOTL",ipnt,'i',TRUE );

	/* O III 4363,collisions from five level atom */
	linadd(CoolHeavy.c4363,4363,"Coll",'c' );

	/* O III 4363 recombination, coef from Burgess and Seaton */
	linadd(r4363,4363,"Rec ",'i' );

	/* collisional excitation of 2321, 5-level atom */
	PntForLine(2321.,"O  3",&ipnt);
	lindst(CoolHeavy.c4363*0.236,2321,"O  3",ipnt,'c',TRUE );
	/* call linadd( c4363*0.236 , 2321 , 'O  3','c')
	 *
	 * charge exchange, Dalgarno+Sternberg ApJ Let 257, L87. */
	linadd(ct4363,4363,"C EX",'i' );

	/* charge exchange rate, D+S */
	linadd(xIonFracs[ipHYDROGEN][1]*xIonFracs[ipOXYGEN][4]*0.225*3.56e-12*1.34e-11*phycon.sqrte,
	  5592,"C EX",'i' );

	/* O III 88 micron, collisionally excited */
	PutLine(&TauLines[ipTO88]);

	/* O III 52 micron, collisionally excited */
	PutLine(&TauLines[ipT52]);

	/* >>chng 97 may 02, better rec contribution */
	rec = GetLineRec(331,835)*TauLines[ipT835].AovTot;
	PutExtra(MAX2(0.,rec));

	/* O III 834A, collisions and dielectronic recombination */
	PutLine(&TauLines[ipT835]);

	/* O III 834A, dielectronic recombination only */
	linadd(MAX2(0.,rec),835,"rec ",'i' );

	/* O IV 26 micron */
	PutLine(&TauLines[ipT26]);

	/* total intensity of O IV] 1402, all lines in the multiplet */
	linadd(
		TauLines[ipO4_1400].xIntensity+
		TauLines[ipO4_1397].xIntensity+
		TauLines[ipO4_1407].xIntensity+
		TauLines[ipO4_1405].xIntensity+
		TauLines[ipO4_1401].xIntensity,
		1402,"TOTL",'i' );
	PutLine(&TauLines[ipO4_1400]);
	PutLine(&TauLines[ipO4_1397]);
	PutLine(&TauLines[ipO4_1407]);
	PutLine(&TauLines[ipO4_1405]);
	PutLine(&TauLines[ipO4_1401]);

	/* inner shell photoionization, relaxation */
	linadd(pmp2s.p1401*1.42e-11,1401,"InSh",'i' );

	/* >>chng 97 may 02, better rec contribution */
	rec = GetLineRec(378,789)*TauLines[ipT789].AovTot;
	PutExtra(MAX2(0.,rec));

	/* O IV 789A */
	PutLine(&TauLines[ipT789]);

	/* O IV 789A, dielectronic recombination only */
	linadd(MAX2(0.,rec),789,"rec ",'i' );

	/* >>chng 97 may 02, better rec contribution */
	rec = GetLineRec(466,630);
	PutExtra(MAX2(0.,rec));

	/* O V 630, collisional excitation and dielectonic recombination */
	PutLine(&TauLines[ipT630]);

	/* O V 630A, dielectronic recombination only */
	linadd(MAX2(0.,rec),630,"rec ",'i' );

	/* O V 1218], total intensity of both lines */
	linadd(embesq.em1218+TauLines[ipT1214].xIntensity,1218,"TOTL",'i' );
	PutLine(&TauLines[ipT1214]);

	/* the slow transition by itself */
	linadd(embesq.em1218,1211,"O  5",'i' );

	/* BS O V 5112, recombination */
	linadd(1.4e-21/phycon.te70*phycon.eden*xIonFracs[ipOXYGEN][6]*
	  TauLines[ipT1214].AovTot,5112,"O  5",'i' );

	/* O VI 1035, total of pumping and collisional excitation */
	linadd(TauLines[ipT1032].xIntensity+TauLines[ipT1037].xIntensity,1035,"TOTL",'i' );
	sum = TauLines[ipT1032].xIntensity*TauLines[ipT1032].FracInwd + 
		TauLines[ipT1037].xIntensity* TauLines[ipT1037].FracInwd;

	/* inward part of OVI line */
	linadd(sum,1035,"Inwd",'i' );
	PutLine(&TauLines[ipT1032]);
	PutLine(&TauLines[ipT1037]);

	/* O VI 150, li seq 2s 3p */
	PutLine(&TauLines[ipT150]);

	/* fluorine
	 * [F II] 29.33 microns */
	PutLine(&TauLines[ipF0229]);

	/* [F II] 67.2 microns */
	PutLine(&TauLines[ipF0267]);

	/* F IV 44.07 micron */
	PutLine(&TauLines[ipF444]);

	/* F IV 25.83 micron */
	PutLine(&TauLines[ipF425]);

	/* neon
	 * Neon II 12.8 micron */
	PutLine(&TauLines[ipTNe13]);

	/* Ne III fine structure line */
	PutLine(&TauLines[ipTNe16]);

	/* Ne III fine structure line */
	PutLine(&TauLines[ipTNe36]);

	/* Ne III  3869, of 3968+3869 doublet */
	PntForLine(3869.,"Ne 3",&ipnt);
	lindst(CoolHeavy.c3869/(1.+1./3.318),3869,"Ne 3",ipnt,'c',TRUE );
	
	/* Ne III  3968, of 3968+3869 doublet */
	PntForLine(3968.,"Ne 3",&ipnt);
	lindst(CoolHeavy.c3869/(1.+3.318),3968,"Ne 3",ipnt,'c',TRUE );
	
	/* NeIII auroral line */
	PntForLine(3343.,"Ne 3",&ipnt);
	lindst(CoolHeavy.c3343,3343,"Ne 3",ipnt,'c',TRUE );
	
	/* NeIII auroral line */
	PntForLine(1815.,"Ne 3",&ipnt);
	lindst(CoolHeavy.c3343*1.38,1815,"Ne 3",ipnt,'c',TRUE );
	
	/* Ne IV 2424, collisional excitation */
	PntForLine(2424.,"Ne 4",&ipnt);
	lindst(CoolHeavy.c2424,2424,"Ne 4",ipnt,'c',TRUE );
	
	/* Ne IV N=3-2 lines, three level atom approx,
	 * this is the sum of the 4714.5, 4724.2, 4725.5 linew*/
	PntForLine(4720.,"Ne 4",&ipnt);
	lindst(CoolHeavy.c4720,4720,"Ne 4",ipnt,'c',TRUE );
	
	/* Ne IV N=3 lines, three level atom approx */
	PntForLine(1602.,"Ne 4",&ipnt);
	lindst(CoolHeavy.c4720*4.34,1602,"Ne 4",ipnt,'c',TRUE );
	
	/* Ne V 3426 of 3426, 3346 doublet */
	PntForLine(3426.,"Ne 5",&ipnt);
	lindst(CoolHeavy.c3426/(1.+1./2.738),3426,"Ne 5",ipnt,'c',TRUE );
	
	/* Ne V 3346 of 3426, 3346 doublet */
	PntForLine(3346.,"Ne 5",&ipnt);
	lindst(CoolHeavy.c3426/(1.+2.738),3346,"Ne 5",ipnt,'c',TRUE );
	
	/* auroral line */
	PntForLine(2976.,"Ne 5",&ipnt);
	lindst(CoolHeavy.c2975,2976,"Ne 5",ipnt,'c',TRUE );
	
	/* collisionally excited */
	PntForLine(1575.,"Ne 5",&ipnt);
	lindst(CoolHeavy.c1565,1575,"Ne 5",ipnt,'c',TRUE );
	
	/* Ne V 24.2, 14.3 micron */
	PutLine(&TauLines[ipTNe24]);

	/* Ne V 24.2, 14.3 micron */
	PutLine(&TauLines[ipTNe14]);

	/* both components of 5S-3P 1146.1, 1137.0 doublet */
	PntForLine(1141.,"Ne 5",&ipnt);
	lindst(CoolHeavy.c1134,1141,"Ne 5",ipnt,'c',TRUE );
	
	/* [Ne VI] 7.6 microns */
	PutLine(&TauLines[ipxNe0676]);

	/* Ne VII 895, collisionally excited, both lines */
	linadd(embesq.em895+TauLines[ipT895].xIntensity,895,"TOTL",'i' );

	/* Ne VII 895, only fast transition */
	PutLine(&TauLines[ipT895]);

	/* Ne VII 890, single line */
	linadd(embesq.em895,890,"Ne 7",'i' );

	/* Ne VIII 774, collisionally excited */
	linadd(TauLines[ipT770].xIntensity+TauLines[ipT780].xIntensity,774,"TOTL",'i' );

	/* inward part of NeVIII 774 line */
	sum = TauLines[ipT770].xIntensity*TauLines[ipT770].FracInwd + 
		TauLines[ipT780].xIntensity*TauLines[ipT780].FracInwd;
	linadd(sum,774,"Inwd",'i' );

	/* the NeVIII 770 780 doublet */
	PutLine(&TauLines[ipT770]);
	PutLine(&TauLines[ipT780]);

	/* Ne VIII 88 2s 3p, collisionally excited */
	PutLine(&TauLines[ipT88]);

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, "   lines_lv1_li_ne returns\n" );
	}

#	ifdef DEBUG_FUN
	fputs( " <->lines_lv1_li_ne()\n", debug_fp );
#	endif
	return;
}

