/*nsset generate low and high boundaries for ionization distribution of each element 
 * called by contsetintensity after all lines parsed */
#include "cddefines.h"
#include "nhe1lvl.h"
#include "trace.h"
#include "iso.h"
#include "hydrogenic.h"
#include "he1str.h"
#include "ionrange.h"
#include "abundances.h"
#include "nsset.h"

void nsset(void)
{
	long int i, 
	  ii, 
	  j, 
	  jj;

#	ifdef DEBUG_FUN
	fputs( "<+>nsset()\n", debug_fp );
#	endif

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, " NSSET called.\n" );
	}

	jj = 0;
	/* define array of quantum numbers needed for Puetter Stark broadening */
	/* what should ipHYDROGEN be */
	for( i=ipH1s; i < (iso.nLevels[ipHYDROGEN][ipHYDROGEN] - 1); i++ )
	{
		if( i == 0 )
		{
			ii = 1;
		}
		else if( i == 1 )
		{
			ii = 2;
		}
		else
		{
			ii = i;
		}
		for( j=i + 1; j < iso.nLevels[ipHYDROGEN][ipHYDROGEN]; j++ )
		{
			if( j == 1 )
			{
				jj = 2;
			}
			else
			{
				jj = jj;
			}
			hydro.strkar[i][j] = (float)pow(((float)ii*jj),1.2f);
			hydro.pestrk[i][j] = 0.;
		}
	}

	for( i=0; i < (NHE1LVL - 1); i++ )
	{
		for( j=i + 1; j < NHE1LVL; j++ )
		{
			he1str.peshe1[i][j] = 0.;
		}
	}

	/* fix number of stages of ionization */
	for( i=0; i < LIMELM; i++ )
	{
		if( abundances.lgElmtOn[i] )
		{
			IonRange.IonLow[i] = 0;
			/* 
			 * IonHigh[n] is the highest stage of ionization present
			 * the IonHigh array index is on the C scake, so [0] is hydrogen
			 * the value is also on the C scale, so element [nelem] can range
			 * from 0 to nelem+1 
			 */
			IonRange.IonHigh[i] = i + 1;
		}
		else
		{
			/* this element is turned off, make stages impossible */
			IonRange.IonLow[i] = -1;
			IonRange.IonHigh[i] = -1;
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->nsset()\n", debug_fp );
#	endif
	return;
}

