/*ParseAgn parse parameters for the AGN continuum shape command */
#include "cddefines.h"
#include "rfield.h"
#include "parse.h"

void ParseAgn(char *chCard)
{
	int lgEOL;
	long int i;
	double BigBump, 
	  Ratio, 
	  XRays, 
	  xnu;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseAgn()\n", debug_fp );
#	endif

	/* first parameter is temperature of big bump
	 * second parameter is alpha ox */

	/* power law with cutoff */
	rfield.nspec += 1;
	if( rfield.nspec > LIMSPC )
	{
		fprintf( ioQQQ, " Too many continua entered; increase LIMSPC\n" );
		puts( "[Stop in ParseAgn]" );
		cdEXIT(1);
	}

	strcpy( rfield.chSpType[rfield.nspec-1], "AGN  " );
	i = 5;
	/* slope is first parameter is really temperature of bump */
	rfield.slope[rfield.nspec-1] = FFmtRead(chCard,&i,LINELENGTH,&lgEOL);
	if( lgEOL )
	{
		fprintf( ioQQQ, " The big bump temperature should have been on this line.   Sorry.\n" );
		puts( "[Stop in ParseAgn]" );
		cdEXIT(1);
	}

	if( rfield.slope[rfield.nspec-1] <= 0. )
	{
		fprintf( ioQQQ, " Non positive temperature not allowed.   Sorry.\n" );
		puts( "[Stop in ParseAgn]" );
		cdEXIT(1);
	}

	/* temps are log if first le 10 */
	if( rfield.slope[rfield.nspec-1] <= 10. )
		rfield.slope[rfield.nspec-1] = 
		pow(10.,rfield.slope[rfield.nspec-1]);

	/* want cutoff in ryd not kelvin */
	rfield.slope[rfield.nspec-1] /= 1.5789e5;

	/* cutoff is second parameter is really alpha ox */
	rfield.cutoff[0][rfield.nspec-1] = FFmtRead(chCard,&i,LINELENGTH,
	  &lgEOL);
	if( lgEOL )
	{
		fprintf( ioQQQ, " alpha ox should have been on this line.   Sorry.\n" );
		puts( "[Stop in ParseAgn]" );
		cdEXIT(1);
	}
	if( rfield.cutoff[0][rfield.nspec-1] > 3. || 
		rfield.cutoff[0][rfield.nspec-1] < -3. )
	{
		fprintf( ioQQQ, " An alpha ox of%10.2e looks funny to me.  Check Hazy to make sure its ok.\n", 
		  rfield.cutoff[0][rfield.nspec-1] );
	}

	if( rfield.cutoff[0][rfield.nspec-1] >= 0. )
	{
		fprintf( ioQQQ, " The sign of alpha ox is almost certainly incorrect.   Check Hazy.\n" );
	}

	/* bb slope is third parameter */
	rfield.cutoff[1][rfield.nspec-1] = FFmtRead(chCard,&i,LINELENGTH,
	  &lgEOL);
	if( lgEOL )
		rfield.cutoff[1][rfield.nspec-1] = -0.5f;

	/* slope of X-Ray component is last parameter */
	rfield.cutoff[2][rfield.nspec-1] = FFmtRead(chCard,&i,LINELENGTH,
	  &lgEOL);
	if( lgEOL )
		rfield.cutoff[2][rfield.nspec-1] = -1.0f;

	/* 403.3 is ratio of energies where alpha ox defined,
	 * assumed to be 2500A and 2keV */
	Ratio = pow(403.3,rfield.cutoff[0][rfield.nspec-1] - 1.);

	/* following code must be kept parallel with ffun1 */
	xnu = 0.3645;
	BigBump = pow(xnu,-1. + rfield.cutoff[1][rfield.nspec-1])*
	  sexp(xnu/rfield.slope[rfield.nspec-1]);
	xnu = 147.;

	/* XRays = xnu**(-2.) */
	XRays = pow(xnu,rfield.cutoff[2][rfield.nspec-1] - 1.);
	if( BigBump <= 0. )
	{
		fprintf( ioQQQ, " Big Bump had zero flux at .3645 Ryd.\n" );
		puts( "[Stop in ParseAgn]" );
		cdEXIT(1);
	}
	rfield.cutoff[0][rfield.nspec-1] = (Ratio/(XRays/BigBump));

#	ifdef DEBUG_FUN
	fputs( " <->ParseAgn()\n", debug_fp );
#	endif
	return;
}

