/*ParseDLaw parse parameters on the dlaw command */
#include "cddefines.h"
#include "abundances.h"
#include "dlaw.h"
#include "pressure.h"
#include "varypar.h"
#include "input.h"
#include "readar.h"
#include "parse.h"

void ParseDLaw(char *chCard )
{
	char chCAP[5];
	int lgEOL, 
	  lgEnd;
	long int i, 
	  j;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseDLaw()\n", debug_fp );
#	endif

	/* call fcn FABDEN(RADIUS) which uses the ten parameters
	 * N.B.; existing version of FABDEN must be deleted
	 * >>chng 96 nov 29, added table option */
	if( lgMatch("TABL",chCard) )
	{
		/* when called, read in densities from input stream */
		strcpy( pressure.chCPres, "DLW2" );
		if( lgMatch("DEPT",chCard) )
		{
			abundances.lgDLWDepth = TRUE;
		}
		else
		{
			abundances.lgDLWDepth = FALSE;
		}

		readar(chCard,&lgEnd);
		i = 1;
		abundances.frad[0] = (float)FFmtRead(chCard,&i,LINELENGTH,&lgEOL);
		abundances.fhden[0] = (float)FFmtRead(chCard,&i,LINELENGTH,&lgEOL);
		if( lgEOL )
		{
			fprintf( ioQQQ, " no pairs entered - cant interpolate\n" );
			puts( "[Stop in getdlaw]" );
			cdEXIT(1);
		}

		abundances.nvals = 2;
		lgEnd = FALSE;

		/* read pairs of numbers until we find line starting with END */
		while( !lgEnd && abundances.nvals < LIMTABD )
		{
			readar(chCard,&lgEnd);
			if( !lgEnd )
			{
				cap4(chCAP , chCard);
				if( strncmp(chCAP , "END" , 3 ) == 0 )
					lgEnd = TRUE;
			}

			if( !lgEnd )
			{
				i = 1;
				abundances.frad[abundances.nvals-1] = (float)FFmtRead(chCard
				  ,&i,LINELENGTH,&lgEOL);
				abundances.fhden[abundances.nvals-1] = (float)FFmtRead(chCard
				  ,&i,LINELENGTH,&lgEOL);
				abundances.nvals += 1;
			}
		}
		abundances.nvals -= 1;

		for( i=1; i < abundances.nvals; i++ )
		{
			/* the radius values are assumed to be strictly increasing */
			if( abundances.frad[i] <= abundances.frad[i-1] )
			{
				fprintf( ioQQQ, " density.in radii must be in increasing order\n" );
				puts( "[Stop in getdlaw]" );
				cdEXIT(1);
			}
		}
	}
	else
	{
		/* this is usual case, call fabden to get density */
		i = 4;
		for( j=0; j < 10; j++ )
		{
			dlaw.DensityLaw[j] = FFmtRead(chCard,&i,LINELENGTH,&lgEOL);
		}

		/* set flag so we know which law to use later */
		strcpy( pressure.chCPres, "DLW1" );

		/* vary option */
		if( VaryPar.lgVarOn )
		{
			/* NB - there are 5 = LIMEXT numbers on this line - if LIMEXT ever changes,
			 * chnage this too */
			strcpy( VaryPar.chVarFmt[VaryPar.nparm], "DLAW %f %f %f %f %f " );

			/* index for where to write */
			VaryPar.nvfpnt[VaryPar.nparm] = input.nRead;
			for( j=0; j<LIMEXT; ++j )
			{
				VaryPar.vparm[j][VaryPar.nparm] = (float)dlaw.DensityLaw[j];
			}
			VaryPar.vincr[VaryPar.nparm] = 0.5;
			VaryPar.nvarxt[VaryPar.nparm] = LIMEXT;
			++VaryPar.nparm;
		}

	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseDLaw()\n", debug_fp );
#	endif
	return;
}
