/*ParseF_nu parse intensity command parameters */
#include "cddefines.h"
#include "physconst.h"
#include "rfield.h"
#include "radius.h"
#include "parse.h"

void ParseF_nu(char *chCard, 
  long int *nqh, 
  float *ar1, 
  char *chType, 
  int lgNU2)
{
	int lgEOL;
	long int i;
	double fr;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseF_nu()\n", debug_fp );
#	endif

	/* flux density of this continuum source, at optional frequency */
	i = 5;
	*nqh += 1;
	if( *nqh > LIMSPC )
	{
		fprintf( ioQQQ, " Too many continua entered; increase LIMSPC\n" );
		puts( "[Stop in ParseF_nu]" );
		cdEXIT(1);
	}

	strcpy( rfield.chRSpec[*nqh-1], chType );

	rfield.totpow[*nqh-1] = FFmtRead(chCard,&i,LINELENGTH,&lgEOL);

	/* large luminosity but per sq cm */
	if( rfield.totpow[*nqh-1] > 37. && strcmp(rfield.chRSpec[*nqh-1]
	  ,"SQCM") == 0 )
	{
		fprintf( ioQQQ, " This intensity is VERY large.  Problems?  Was luminosity intended??\n" );
	}

	if( lgEOL )
	{
		NoNumb(chCard);
	}

	strcpy( rfield.chSpNorm[*nqh-1], "FLUX" );

	/* this is optional frequency in Rydbergs */
	rfield.range[0][*nqh-1] = FFmtRead(chCard,&i,LINELENGTH,&lgEOL);

	/* >>chng 96 dec 18, was 1 changed to H mass nuc ryd
	 * if( lgEOL ) range(nqh,1) = 1. */
	if( lgEOL )
	{
		rfield.range[0][*nqh-1] = HIONPOT;
	}

	if( rfield.range[0][*nqh-1] <= 0. )
	{
		rfield.range[0][*nqh-1] = pow(10.,rfield.range[0][*nqh-1]);
	}

	if( lgNU2 )
	{
		/* range is now freq in ryd, totpow is log of product nu*f_nu */
		fr = log10(rfield.range[0][*nqh-1]*FR1RYD);
		rfield.totpow[*nqh-1] -= fr;
	}

	/* set R to large value in case R not specified (per sq cm)
	 * and this is per unit area */
	if( strcmp(chType,"SQCM") == 0 && radius.Radius == 0. )
	{
		/* RDFALT in BLOCK DATA SCALAR, is 25 */
		*ar1 = (float)radius.rdfalt;
		radius.Radius = pow(10.f,*ar1);
	}


#	ifdef DEBUG_FUN
	fputs( " <->ParseF_nu()\n", debug_fp );
#	endif
	return;
}

