/*ParseFireBall parse parameters from fireball command */
#include "cddefines.h"
#include "radius.h"
#include "rfield.h"
#include "parse.h"

void ParseFireBall(double z, 
  long int *nqh, 
  float *ar1)
{
	double a, 
	  rlogl;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseFireBall()\n", debug_fp );
#	endif

	/* check that stack of shape and luminosity specifications
	 * is parallel, stop if not - this happens is background comes
	 * BETWEEN another set of shape and luminosity commands */
	if( rfield.nspec != *nqh )
	{
		fprintf( ioQQQ, " This command has come between a previous ordered pair of continuum shape and luminosity commands.\n Reorder the commands to complete each continuum specification before starting another.\n" );
		fprintf( ioQQQ, " Sorry.\n" );
		puts( "[Stop in ParseFireBall]" );
		cdEXIT(1);
	}

	rfield.nspec += 1;
	*nqh += 1;
	if( *nqh > LIMSPC )
	{
		fprintf( ioQQQ, " Too many continua entered; increase LIMSPC\n" );
		puts( "[Stop in ParseFireBall]" );
		cdEXIT(1);
	}
	/* put in a black body */
	strcpy( rfield.chSpType[rfield.nspec-1], "BLACK" );
	rfield.slope[rfield.nspec-1] = (2.756*(1. + z));
	rfield.cutoff[0][rfield.nspec-1] = 0.;
	rfield.cutoff[1][rfield.nspec-1] = 0.;
	strcpy( rfield.chSpNorm[*nqh-1], "LUMI" );
	a = log10(rfield.slope[rfield.nspec-1]);
	rlogl = log10(2.99792e10*7.56464e-15) + 4.*a;
	strcpy( rfield.chRSpec[*nqh-1], "SQCM" );
	rfield.range[0][*nqh-1] = rfield.emm;
	rfield.range[1][*nqh-1] = rfield.egamry;
	rfield.totpow[*nqh-1] = rlogl;

	/* set radius to very large value if not already set */
	/* set radius to very large value if not already set */
	/* >>chng 01 jul 24, from Radius == 0 to this, as per PvH comments */
	if( !radius.lgRadiusKnown )
	{
		*ar1 = (float)radius.rdfalt;
		radius.Radius = pow(10.f,*ar1);
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseFireBall()\n", debug_fp );
#	endif
	return;
}

