/*ParseMap parse map command to produce map of heating and cooling,
 * map is produced by calling punt(" map") */
#include "cddefines.h"
#include "mappar.h"
#include "parse.h"

void ParseMap(char *chCard )
{
	int lgEOL, 
	  lgLogOn;
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseMap()\n", debug_fp );
#	endif

	/* say output goes to stdout */
	if( ioQQQ == NULL )
	{
		ioMAP = stdout;
	}
	else
	{
		ioMAP = ioQQQ;
	}

	/* do cooling space map for specified zones
	 * if no number, or <0, do map and punch out without doing first zone */
	i = 5;
	MapPar.MapZone = (long)FFmtRead(chCard,&i,LINELENGTH,&lgEOL);
	if( lgEOL )
	{
		MapPar.MapZone = -1;
		
#		ifdef DEBUG_FUN
		fputs( " <->ParseMap()\n", debug_fp );
#		endif
		return;
	}

	if( lgMatch("RANG",chCard) )
	{
		MapPar.RangeMap[0] = (float)FFmtRead(chCard,&i,LINELENGTH,&lgEOL);
		if( MapPar.RangeMap[0] <= 10. )
		{
			MapPar.RangeMap[0] = (float)pow(10.f,MapPar.RangeMap[0]);
			lgLogOn = TRUE;
		}
		else
		{
			lgLogOn = FALSE;
		}
		MapPar.RangeMap[1] = (float)FFmtRead(chCard,&i,LINELENGTH,&lgEOL);
		if( lgLogOn )
			MapPar.RangeMap[1] = (float)pow(10.f,MapPar.RangeMap[1]);

		if( lgEOL )
		{
			fprintf( ioQQQ, " There must be a zone number, followed by two temperatures, on this line.  Sorry.\n" );
			puts( "[Stop in ParseMap]" );
			cdEXIT(1);
		}
		
#		ifdef DEBUG_FUN
		fputs( " <->ParseMap()\n", debug_fp );
#		endif
		return;
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseMap()\n", debug_fp );
#	endif
	return;
}

