/*ParseMetal parse parameters on metal command */
#include "cddefines.h"
#include "input.h"
#include "varypar.h"
#include "grainvar.h"
#include "called.h"
#include "abundances.h"
#include "parse.h"

void ParseMetal(char *chCard )
{
	int lgEOL, 
	  lgGrains, 
	  lgLogOn;
	long int i;
	double dmlog;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseMetal()\n", debug_fp );
#	endif

	/* parse the metals command */

	/* metal depletion factor, if negative then it is the log */
	i = 5;
	abundances.ScaleMetals = (float)FFmtRead(chCard,&i,LINELENGTH,&lgEOL);
	if( lgEOL )
	{
		if( lgMatch("DEPL",chCard) )
		{
			/* this option - no numbers on line but keyword depletion is
			 * deplete by set of scale factors */
			abundances.lgDepln = TRUE;
			for( i=0; i < LIMELM; i++ )
			{
				abundances.depset[i] = abundances.Depletion[i];
			}
			abundances.ScaleMetals = 1.;
			
#			ifdef DEBUG_FUN
			fputs( " <->ParseMetal()\n", debug_fp );
#			endif
			return;
		}
		else
		{
			/* no number, so keyword, punch out */
			if( !called.lgTalk )
			{
				fprintf( ioQQQ, " %80.80s\n", chCard );
			}
			fprintf( ioQQQ, " There must be a number on this line.  Sorry.\n" );
			puts( "[Stop in ParseMetal]" );
			cdEXIT(1);
		}
	}

	/* sort out whether log */
	lgLogOn = FALSE;
	if( lgMatch(" LOG",chCard) )
	{
		lgLogOn = TRUE;
	}
	else if( lgMatch("LINE",chCard) )
	{
		lgLogOn = FALSE;
	}

	if( abundances.ScaleMetals <= 0. || lgLogOn )
	{
		dmlog = abundances.ScaleMetals;
		abundances.ScaleMetals = (float)pow(10.f,abundances.ScaleMetals);
	}
	else
	{
		dmlog = log10(abundances.ScaleMetals);
	}

	/* option to vary grain abundance as well */
	if( lgMatch("GRAI",chCard) )
	{
		lgGrains = TRUE;
		gv.GrainMetal = abundances.ScaleMetals;
	}
	else
	{
		lgGrains = FALSE;
		gv.GrainMetal = 1.;
	}

	/* vary option */
	if( VaryPar.lgVarOn )
	{
		if( lgGrains )
		{
			strcpy( VaryPar.chVarFmt[VaryPar.nparm], "METALS LOG=%f GRAINS" );
		}
		else
		{
			strcpy( VaryPar.chVarFmt[VaryPar.nparm], "METALS LOG=%f" );
		}

		/* pointer to where to write */
		VaryPar.nvfpnt[VaryPar.nparm] = input.nRead;
		VaryPar.vparm[0][VaryPar.nparm] = (float)dmlog;
		VaryPar.vincr[VaryPar.nparm] = 0.5;
		VaryPar.nvarxt[VaryPar.nparm] = 1;
		++VaryPar.nparm;
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseMetal()\n", debug_fp );
#	endif
	return;
}

