/*ParsePowerlawContinuum parse the power law continuum command */
#include "cddefines.h"
#include "rfield.h"
#include "varypar.h"
#include "input.h"
#include "parse.h"

void ParsePowerlawContinuum(char *chCard)
{
	int lgEOL;
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>ParsePowerlawContinuum()\n", debug_fp );
#	endif

	/* power law with cutoff and X-ray continuum */
	rfield.nspec += 1;
	if( rfield.nspec > LIMSPC )
	{
		fprintf( ioQQQ, " Too many continua entered; increase LIMSPC\n" );
		puts( "[Stop in ParsePowerlawContinuum]" );
		cdEXIT(1);
	}

	strcpy( rfield.chSpType[rfield.nspec-1], "POWER" );

	/* first parameter is slope of continuum, probably should be negative */
	i = 5;
	rfield.slope[rfield.nspec-1] = FFmtRead(chCard,&i,LINELENGTH,&lgEOL);
	if( lgEOL )
	{
		fprintf( ioQQQ, " There should have been a number on this line.   Sorry.\n" );
		puts( "[Stop in ParsePowerlawContinuum]" );
		cdEXIT(1);
	}

	if( rfield.slope[rfield.nspec-1] >= 0. )
	{
		fprintf( ioQQQ, " Is the slope of this power law correct?\n" );
	}

	/* second optional parameter is high energy cut off */
	rfield.cutoff[0][rfield.nspec-1] = FFmtRead(chCard,&i,LINELENGTH,
	  &lgEOL);

	/* no cutoff if eof hit */
	if( lgEOL )
	{
		/* no extra parameters at all, so put in extreme cutoffs */
		rfield.cutoff[0][rfield.nspec-1] = 1e4;
		rfield.cutoff[1][rfield.nspec-1] = 1e-4;
	}
	else
	{
		/* first cutoff was present, check for second */
		rfield.cutoff[1][rfield.nspec-1] = FFmtRead(chCard,&i,
		  LINELENGTH,&lgEOL);
		if( lgEOL )
			rfield.cutoff[1][rfield.nspec-1] = 1e-4;
	}

	/* check that energies were entered in the correct order */
	if( rfield.cutoff[1][rfield.nspec-1] > rfield.cutoff[0][rfield.nspec-1] )
	{
		fprintf( ioQQQ, " The optional cutoff energies do not appear to be in the correct order.  Check Hazy.\n" );
		puts( "[Stop in ParsePowerlawContinuum]" );
		cdEXIT(1);
	}

	/* check for keywork KELVIN to interprete cutoff energies as degrees */
	if( lgMatch("KELV",chCard) )
	{
		/* temps are log if first le 10 */
		if( rfield.cutoff[0][rfield.nspec-1] <= 10. )
			rfield.cutoff[0][rfield.nspec-1] = pow(10.,rfield.cutoff[0][rfield.nspec-1]);
		if( rfield.cutoff[1][rfield.nspec-1] <= 10. )
			rfield.cutoff[1][rfield.nspec-1] = pow(10.,rfield.cutoff[1][rfield.nspec-1]);
		rfield.cutoff[0][rfield.nspec-1] /= 1.5789e5;
		rfield.cutoff[1][rfield.nspec-1] /= 1.5789e5;
	}

	if( rfield.cutoff[0][rfield.nspec-1] < 0. || rfield.cutoff[1][rfield.nspec-1] < 
	  0. )
	{
		fprintf( ioQQQ, " A negative cutoff energy is not physical.  Sorry.\n" );
		puts( "[Stop in ParsePowerlawContinuum]" );
		cdEXIT(1);
	}

	if( rfield.cutoff[1][rfield.nspec-1] == 0. && 
		rfield.slope[rfield.nspec-1] <= -1. )
	{
		fprintf( ioQQQ, " A power-law with this slope, and no low energy cutoff, may have an unphysically large\n brightness temperature in the radio.\n" );
	}

	/* vary option */
	if( VaryPar.lgVarOn )
	{
		/* pointer to where to write */
		VaryPar.nvfpnt[VaryPar.nparm] = input.nRead;
		if( lgMatch("ARYB",chCard) )
		{
			/* this test is for key "varyb", meaning to vary second parameter
			 * the cutoff temperature
			 * this is the number of parameters to feed onto the input line */
			VaryPar.nvarxt[VaryPar.nparm] = 2;
			/* vary ?? */
			sprintf( VaryPar.chVarFmt[VaryPar.nparm], 
				"POWER LAW %f KELVIN%%f %%f", 
			  rfield.slope[rfield.nspec-1] );
			/* param is linear scale factor */
			VaryPar.vparm[0][VaryPar.nparm] = (float)log10(rfield.cutoff[0][rfield.nspec-1]*
			  1.5789e5);
			VaryPar.vparm[1][VaryPar.nparm] = (float)log10(rfield.cutoff[1][rfield.nspec-1]*
			  1.5789e5);
			VaryPar.vincr[VaryPar.nparm] = 0.2f;
		}
		else if( lgMatch("ARYC",chCard) )
		{
			/* the keyword wsa "varyc"
			 * this is the number of parameters to feed onto the input line */
			VaryPar.nvarxt[VaryPar.nparm] = 1;

			/* vary ?? */
			sprintf( VaryPar.chVarFmt[VaryPar.nparm], "POWER LAW%f %f KELVIN %%f )", 
			  rfield.slope[rfield.nspec-1], 
			  log10(rfield.cutoff[0][rfield.nspec-1]* 1.5789e5) );

			VaryPar.vparm[0][VaryPar.nparm] = (float)log10(rfield.cutoff[1][rfield.nspec-1]*
			  1.5789e5);
			VaryPar.vincr[VaryPar.nparm] = 0.2f;
		}
		else
		{
			/* vary the first parameter only, but still are two more
			 * this is the number of parameters to feed onto the input line */
			VaryPar.nvarxt[VaryPar.nparm] = 3;
			strcpy( VaryPar.chVarFmt[VaryPar.nparm], 
				"POWER LAW KELVIN%f %f %f" );
			/* param is slope of the power law */
			VaryPar.vparm[0][VaryPar.nparm] = (float)rfield.slope[rfield.nspec-1];
			VaryPar.vparm[1][VaryPar.nparm] = (float)log10(rfield.cutoff[0][rfield.nspec-1]*
			  1.5789e5);
			VaryPar.vparm[2][VaryPar.nparm] = (float)log10(rfield.cutoff[1][rfield.nspec-1]*
			  1.5789e5);
			VaryPar.vincr[VaryPar.nparm] = 0.2f;
		}
		++VaryPar.nparm;
	}


#	ifdef DEBUG_FUN
	fputs( " <->ParsePowerlawContinuum()\n", debug_fp );
#	endif
	return;
}

