/*ParseRatio derive continuum luminosity of this continuum relative to previous */
#include "cddefines.h"
#include "varypar.h"
#include "input.h"
#include "rfield.h"
#include "parse.h"

void ParseRatio(char *chCard, 
  long int *nqh)
{
	int lgAoxOn, 
	  lgEOL;
	long int  i;
	double aox;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseRatio()\n", debug_fp );
#	endif

	/* enter a continuum luminosity as a ratio of
	 * nuFnu for this continuum relative to a previous continuum
	 * format; first number is ratio of second to first continuum
	 * second number is energy for this ratio
	 * if third numbewr on line, then 2nd number is energy of
	 * first continuum, while 3rd number is energy of second continuum */

	*nqh += 1;
	if( *nqh == 1 )
	{
		fprintf( ioQQQ, " Cant form ratio since this is first continuum.\n" );
		puts( "[Stop in ParseRatio]" );
		cdEXIT(1);
	}

	else if( *nqh > LIMSPC )
	{
		fprintf( ioQQQ, " Too many continua entered; increase LIMSPC\n" );
		puts( "[Stop in ParseRatio]" );
		cdEXIT(1);
	}

	/* per sq cm or luminosity is really irrelevant */
	strcpy( rfield.chRSpec[*nqh-1], "SQCM" );
	strcpy( rfield.chSpNorm[*nqh-1], "RATI" );

	/* this option is to specify alpha ox */
	if( lgMatch("ALPH",chCard) )
	{
		/* lgAoxOn is flag saying that we will spicify alpha ox */
		lgAoxOn = TRUE;
		/* only one parameter to be recognized, alpha ox */
		i = 5;
		aox = FFmtRead(chCard,&i,LINELENGTH,&lgEOL);

		/* 403.3 is ratio of energies where alpha ox defined,
		 * assumed to be 2500A and 2keV */
		rfield.totpow[*nqh-1] = pow(403.3,aox);
		rfield.range[0][*nqh-1] = 0.3645;
		rfield.range[1][*nqh-1] = 147.;
	}

	else
	{
		/* set flag saying that alpha ox will not be specified */
		lgAoxOn = FALSE;
		/* set this to impossible number since not used, but lint needs a value */
		aox = -DBL_MAX;
		/* specify ratio, two energies */
		i = 5;
		rfield.totpow[*nqh-1] = FFmtRead(chCard,&i,LINELENGTH,&lgEOL);

		/* assumed to be a log if negative or zero */
		if( rfield.totpow[*nqh-1] <= 0. || lgMatch(" LOG",chCard ) )
		{
			rfield.totpow[*nqh-1] = pow(10.,rfield.totpow[*nqh-1]);
		}

		if( lgEOL )
		{
			fprintf( ioQQQ, " There must be a number on this line.\n" );
			puts( "[Stop in ParseRatio]" );
			cdEXIT(1);
		}

		rfield.range[0][*nqh-1] = FFmtRead(chCard,&i,LINELENGTH,&lgEOL);

		if( lgEOL )
		{
			fprintf( ioQQQ, " There must be at least 2 numbers on this line.\n" );
			fprintf( ioQQQ, " The ratio, and two energies\n" );
			puts( "[Stop in ParseRatio]" );
			cdEXIT(1);
		}

		rfield.range[1][*nqh-1] = FFmtRead(chCard,&i,LINELENGTH,&lgEOL);

		/* if only one number then assume same for each */
		if( lgEOL )
		{
			rfield.range[1][*nqh-1] = rfield.range[0][*nqh-1];
		}

		if( rfield.range[0][*nqh-1] < rfield.emm || 
			 rfield.range[1][*nqh-1] < rfield.emm )
		{
			fprintf( ioQQQ, " One of the energies is too low, outside the range of the code.\n" );
			puts( "[Stop in ParseRatio]" );
			cdEXIT(1);
		}
		else if( rfield.range[0][*nqh-1] > rfield.egamry || rfield.range[1][*nqh-1] > 
		  rfield.egamry )
		{
			fprintf( ioQQQ, " One of the energies is too high, outside the range of the code.\n" );
			puts( "[Stop in ParseRatio]" );
			cdEXIT(1);
		}
	}

	/* vary option */
	if( VaryPar.lgVarOn )
	{
		/* pointer to where to write */
		VaryPar.nvfpnt[VaryPar.nparm] = input.nRead;
		if( lgAoxOn )
		{
			/* this is the number of parameters to feed onto the input line */
			VaryPar.nvarxt[VaryPar.nparm] = 1;
			/* vary alpha ox */
			strcpy( VaryPar.chVarFmt[VaryPar.nparm], "RATIO alphox %f" );
			/* param is linear scale factor */
			VaryPar.vparm[0][VaryPar.nparm] = (float)aox;
			VaryPar.vincr[VaryPar.nparm] = 0.2f;
		}
		else
		{
			/* this is the number of parameters to feed onto the input line */
			VaryPar.nvarxt[VaryPar.nparm] = 3;
			strcpy( VaryPar.chVarFmt[VaryPar.nparm], "RATIO LOG %f %f %f" );
			/* param is log of abundance by number relative to hydrogen */
			VaryPar.vparm[0][VaryPar.nparm] = (float)log10(rfield.totpow[*nqh-1]);
			VaryPar.vparm[1][VaryPar.nparm] = (float)rfield.range[0][*nqh-1];
			VaryPar.vparm[2][VaryPar.nparm] = (float)rfield.range[1][*nqh-1];
			VaryPar.vincr[VaryPar.nparm] = 0.2f;
		}
		++VaryPar.nparm;
	}


#	ifdef DEBUG_FUN
	fputs( " <->ParseRatio()\n", debug_fp );
#	endif
	return;
}

