/*ParseTrace read in options off the trace command line */
#include "cddefines.h"
#include "itercnt.h"
#include "zonecnt.h"
#include "trace.h"
#include "parse.h"

void ParseTrace(char *chCard )
{
	int lgEOL;
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseTrace()\n", debug_fp );
#	endif

	/* turn on trace at a certain zone; .LE.0 or none for starting trace
	 * optional second number is iteration to start debugger
	 * optional word "hydrogen" provides more info on hydrogen solution */

	i = 5;
	/* this is which zone to turn on */
	trace.nznbug = (long)FFmtRead(chCard,&i,LINELENGTH,&lgEOL);
	if( lgEOL )
	{
		trace.lgTrace = TRUE;
	}

	/* this is which iteration to turn on */
	trace.npsbug = (long)FFmtRead(chCard,&i,LINELENGTH,&lgEOL);
	if( lgEOL )
	{
		trace.npsbug = 1;
	}

	/* turn trace on now if no numbers on line */
	if( trace.nznbug == 0 && trace.npsbug <= 1 )
	{
		trace.lgTrace = TRUE;
		ZoneCnt.nprint = 1;
		IterCnt.IterPrnt[0] = 1;
	}

	/* were there any keywords on the line? */
	if( lgMatch("BETA",chCard) )
		trace.lgTr8446 = TRUE;

	if( lgMatch("CARB",chCard) )
		trace.lgCarBug = TRUE;

	if( lgMatch("CALC",chCard) )
		trace.lgCalBug = TRUE;

	if( lgMatch("COMP",chCard) )
		trace.lgComBug = TRUE;

	if( lgMatch("CONT",chCard) )
		trace.lgConBug = TRUE;

	/* trace convergence is a special command, 
	 * only convergence loops, not full trace */
	if( lgMatch("CONV",chCard) )
	{
		/* 
		 * nznbug was first number on line, which will be level of debugging,
		 * smaller numbers make less output, larger probe deeper levels of the code
		 * trace.lgTrConvg values and routine 
		 * 1 ConvPresTempEdenIoniz 
		 * 2 ConvTempEdenIoniz
		 * 3 ConvEdenIoniz
		 * 4 ConvIoniz
		 * 5 ionize
		 * > 5 all levels
		 */

		/* if no number was entered then to very high level of debugging */
		if( trace.nznbug == 0 )
		{
			trace.lgTrConvg = 100;
		}
		else
		{
			/* number was entered so use it to indicate level of debugging */
			trace.lgTrConvg = trace.nznbug;
		}

		/* turn off normal trace parameters, this is a special case */
		trace.lgTrace = FALSE;
		trace.nznbug = 10000;
		ZoneCnt.nprint = 10000;
		IterCnt.IterPrnt[0] = 10000;
	}

	if( lgMatch("COOL",chCard) )
		trace.lgCoolTr = TRUE;

	if( lgMatch("DIFF",chCard) )
		trace.lgTrDiff = TRUE;

	if( lgMatch(" DR ",chCard) )
		trace.lgDrBug = TRUE;

	if( lgMatch("EDEN",chCard) )
		trace.lgNeBug = TRUE;

	if( lgMatch("GAUN",chCard) )
		trace.lgTrGant = TRUE;

	if( lgMatch("GRAI",chCard) )
		trace.lgDustBug = TRUE;

	if( lgMatch("HEAV",chCard) )
		trace.lgHeavyBug = TRUE;

	if( lgMatch("HEAT",chCard) )
		trace.lgHeatBug = TRUE;

	/* trace helium */
	if( lgMatch("HELI",chCard) )
	{
		trace.lgHeBug = TRUE;
		if( lgMatch("SING",chCard) )
			trace.lgHe1Bug = TRUE;

		if( lgMatch("ATOM",chCard) )
			trace.lgHe1Bug = TRUE;

		/* this will match either ionzed or ion */
		if( lgMatch(" ION",chCard) )
			trace.lgHe2Bug = TRUE;

		if( lgMatch("TRIP",chCard) )
			trace.lgHe3Bug = TRUE;
	}

	/* the simple trace hydrogen command */
	if( lgMatch("HYDR",chCard) && !lgMatch("H-LI",chCard))
	{
		trace.lgHBug = TRUE;
		trace.lgHBugFull = FALSE;
		/* this says which element, on the C scale (H=0), to trace */
		trace.ipZTrace = 0;

	}

	/* the trace h-like hydrogenic species command, with lots of options */
	if( lgMatch("H-LI",chCard) )
	{
		trace.lgHBug = TRUE;
		/* option to turn on full printout */
		if( lgMatch("FULL",chCard) )
		{
			trace.lgHBugFull = TRUE;
		}
		else
		{
			trace.lgHBugFull = FALSE;
		}

		/* look for one of the element names on the line*/
		trace.ipZTrace = GetElem(chCard);

		/* if no element appears on the line fcn returns -1,
		 * in this case we want to do hydrogen */
		trace.ipZTrace = MAX2(0, trace.ipZTrace );
	}

	/* the trace h-like hydrogenic species command, with lots of options */
	if( lgMatch("HE-L",chCard) )
	{
		/* option to turn on full printout */
		if( lgMatch("FULL",chCard) )
		{
			trace.lgHeBugFull = TRUE;
		}
		else
		{
			trace.lgHeBugFull = FALSE;
		}
		/* turn on regular trace for helium */
		trace.lgHeBug = TRUE;

		/* look for one of the element names on the line*/
		trace.ipZTrace = GetElem(chCard);

		/* if no element appears on the line fcn returns -1,
		 * in this case we want to do helium */
		trace.ipZTrace = MAX2(1, trace.ipZTrace );
	}

	if( lgMatch("IRON",chCard) )
		trace.lgFeBug = TRUE;

	if( lgMatch("VELN",chCard) )
		trace.lgTrLevN = TRUE;

	if( lgMatch("LINE",chCard) )
		trace.lgTrLine = TRUE;

	if( lgMatch("NEON",chCard) )
		trace.lgNeonBug = TRUE;

	if( lgMatch("MOLE",chCard) )
		trace.lgTrMole = TRUE;

	/* trace pointers */
	if( lgMatch("POIN",chCard) )
		trace.lgPointBug = TRUE;
	
	/* following two are optical, optimize */
	if( lgMatch("PTIC",chCard) )
		trace.lgOptcBug = TRUE;
	
	if( lgMatch("PTIM",chCard) )
		trace.lgTrOptm = TRUE;
	
	if( lgMatch(" OTS",chCard) )
		trace.lgOTSBug = TRUE;
	
	if( lgMatch("THRE",chCard) )
		trace.lgTrace3Bod = TRUE;

	/* two photon emission, spontaneous and induced */
	if( lgMatch(" TWO",chCard) )
		trace.lgBug2nu = TRUE;

#	ifdef DEBUG_FUN
	fputs( " <->ParseTrace()\n", debug_fp );
#	endif
	return;
}
