/*PhotoIonize fill array PhotoRate with photoionization rates for heavy elements */
#include "cddefines.h"
#include "heat.h"
#include "photrate.h"
#include "yield.h"
#include "heavy.h"
#include "opacity.h"
#include "converge.h"
#include "grainvar.h"
#include "ionrange.h"
#include "elementnames.h"
#include "gammas.h"
#include "photoionize.h"

void PhotoIonize(
	/* nlem is atomic number on C scale, 0 for H */
	long int nelem , 
	/* debugging flag to turn on print */
	int lgPrintIt )
{
	long int nion, 
	  iphi, 
	  iplow, 
	  ipop, 
	  limit_hi, 
	  limit_lo,
	  ns;

#	ifdef DEBUG_FUN
	fputs( "<+>PhotoIonize()\n", debug_fp );
#	endif
	
	/* IonLow(nelem) and IonHigh(nelem) are bounds for evaluation*/

	/*begin sanity checks */
	assert( IonRange.IonLow[nelem] >= 0 );
	assert( IonRange.IonLow[nelem] <= nelem);
	assert( IonRange.IonHigh[nelem] <= nelem + 1);
	/*end sanity checks */

	/* NB - in following, nelem is on c scale, so is 29 for Zn */

	/* min since hydrogenic rates produced in hydrgn routine.
	 * IonHigh and IonLow range from 0 to nelem+1, but for photo rates
	 * we want 0 to nelem since cannot destroy fully stripped ion.  
	 * since hydrogenic done elsewhere, want to actually do IonHigh-1.
	 * with limit below, and with following for loop only going up to nion < limit_hi,
	 * this works out ok.  for nelem=30-1 (Zn), IonHigh can be 30, and then
	 * limit_hi is 29.  for loop will then go up to 28. With logic below do not
	 * need to fill in PhotoRate[0][1][nelemm][nelem] */
	/* >>chng 00 dec 07, logic on limit_hi now precisely identical to bidiag */
	/*limit_hi = MIN2(nelem,IonRange.IonHigh[nelem]);*/
	limit_hi = MIN2(nelem-2,IonRange.IonHigh[nelem]-1);

	/* when grains are present want to use atoms as lower bound to number of stages of ionization,
	 * since atomic rates needed for species within grains */
	if( !conv.nPres2Ioniz && gv.lgDustOn )
	{
		limit_lo = 0;
	}
	else
	{
		limit_lo = IonRange.IonLow[nelem];
	}
	/*if(nelem==5)fprintf(ioQQQ,"grainsss lgn %li lim %li\n", conv.nPres2Ioniz, limit_lo );*/

	/* >>chng 01 dec 11, lower bound now limit_lo */
	for( nion=limit_lo; nion <= limit_hi; nion++ )
	{
		for( ns=0; ns < Heavy.nsShells[nion][nelem]; ns++ )
		{
			/* always reevaluate the outer shell, and all shells if lgRedoStatic is set */
			if( (ns==(Heavy.nsShells[nion][nelem]-1) || opac.lgRedoStatic) )
			{
				/* option to redo the rates only on occasion */
				iplow = opac.ipElement[0][ns][nion][nelem];
				iphi = opac.ipElement[1][ns][nion][nelem];
				ipop = opac.ipElement[2][ns][nion][nelem];

				/* compute the photoionization rate,PhotScaleOn is 1, set 0
				 * with "no photoionization" command */
				PhotRate.PhotoRate[0][ns][nion][nelem] = 
					GammaK(iplow,iphi,
				  ipop,yield.vyield[0][ns][nion][nelem])*PhotRate.PhotScaleOn;

				/* these three lines must be kept parallel with the lines
				 * in GammaK nion*/

				/* the heating rate */
				PhotRate.PhotoRate[1][ns][nion][nelem] = heat.HeatLowEnr*PhotRate.PhotScaleOn;
				PhotRate.PhotoRate[2][ns][nion][nelem] = heat.HeatHiEnr*PhotRate.PhotScaleOn;

			}
		}
	}

	/* option to print information about these rates for this element */
	if( lgPrintIt )
	{
		/* option to print rates for particular shell */
		ns = 5;
		nion = 1;
		GammaPrt(
		  opac.ipElement[0][ns][nion][nelem], 
		  opac.ipElement[1][ns][nion][nelem], 
		  opac.ipElement[2][ns][nion][nelem], 
		  ioQQQ, /* io unit we will write to */
		  PhotRate.PhotoRate[0][ns][nion][nelem], 
		  0.05);

		/* outer loop is from K to most number of shells present in atom */
		for( ns=0; ns < Heavy.nsShells[0][nelem]; ns++ )
		{
			fprintf( ioQQQ, "\n %s", elementnames.chElementNameShort[nelem] );
			fprintf( ioQQQ, " %s" , Heavy.chShell[ns]);
			/* MB hydrogenic photo rate may not be included in beow */
			for( nion=0; nion < IonRange.IonHigh[nelem]; nion++ )
			{
				if( Heavy.nsShells[nion][nelem] > ns )
				{
					fprintf( ioQQQ, " %8.1e", PhotRate.PhotoRate[0][ns][nion][nelem] );
				}
				else
				{
					break;
				}
			}
		}
	}


#	ifdef DEBUG_FUN
	fputs( " <->PhotoIonize()\n", debug_fp );
#	endif
	return;
}

