/* these routines are in pop371.c */
/* called by assert feii depart coef command */
void AssertFeIIDep( double *pred , double *BigError , double *StdDev );
void FeIIFillLow16(void);
/* reads in feii data from disk, creates space for main arrays */
void FeIICreate(void);
void FeIIPrint(void);
void pop371(void);
/* called in LineSet4, this sums over FeII bands and returns intensities
 * args are lower and upper edges of bands as set in fe2bands.dat */
double FeIISumBand(float wl1, 
	  float wl2);
void FeIITauInc(void);
void FeIITauAver(void);
void FeIIPoint(void);
void FeIIAccel(double *fe2drive);
void RTFeIIMake( int lgDoEsc );
/* called by LineSet4, this adds feii line intensities together */
void FeIIAddLines( void );
/* called by dopunch, this creates the punch verner file */
void FeIIPunchLines( FILE * ioPUN );
void FeIIEmitOut(double VolFac, 
  double ref);
/* initialize optical depth arrays, called by TauOut */
void FeIITauInit(void);

/*FeIIIntenZero zero out intensity of FeII atom */
void FeIIIntenZero(void);

/* punch some departure coef for large atom, set with punch feii departure command*/
void FeIIPunDepart(FILE* ioPUN , 
	/* option to punch all dep coef if TRUE */
	int lgDoAll );

/* send the departure coef for physical level nPUN to unit ioPUN */
void FeIIPun1Depart( 
	/* the io unit where the print should be directed */
	FILE * ioPUN , 
	/* the physical (not c) number of the level */
	long int nPUN );
/* punch line data for FeII atom */
void FeIIPunData(
	/* io unit for punch */
	FILE* ioPUN ,
	/* punch all levels if true, only subset if false */
	int lgDoAll );

/* punch some level pops for large atom, set with punch feii level populations command*/
void FeIIPunPop(FILE* ioPUN , 
	/* option to punch all level pops if TRUE */
	int lgDoAll );

/* include FeII lines in punched optical depths, etc, called from PunchLineStuff */
void Fe2PunchLineStuff( FILE * io , float xLimit  , long index);

/* send the level pops for physical level nPUN to unit ioPUN */
void FeIIPun1Pop( 
	/* the io unit where the print should be directed */
	FILE * ioPUN , 
	/* the physical (not c) number of the level */
	long int nPUN );

/* zero out variables that deal with FeII, called by zero */
void FeIIZero(void);

/* initialize some variables, called by zero */
void FeIIReset(void);

/* do OTS and outward parts of FeII lines, if large atom is turned on */
void Fe2RTOTS(void);

/* do outward rates for FeII, called by RTDiffuse */
void Fe2RTOut(void);

/*ParseAtomFeII parse the atom feii command */
void ParseAtomFeII(char *chCard );

/* this is the number of levels for the large FeII atom */
#define	NFE2LEVN	371

/* this is set true when space is allocated for the FeII arrays,
 * once this happens nFeIILevel cannot be changed with the atom feii levels command 
 * set false in cddefines */
extern int lgFeIIMalloc;

/* number of levels for the large FeII atom, changed with the atom feii levels command 
 * set to NFE2LEVN in cddefines */
EXTERN long int nFeIILevel;
/* this remembers number of FeII levels allocated when MALLOC first called.  */
EXTERN long int nFeIILevelAlloc;

EXTERN struct t_fe2 {
	/*
	 * lgFeIION is set true if the feii verner command is given, 
	 */
	int lgFeIION;

	/* option to always evaluate model atom, set with SLOW key on atom feii command */
	int lgSlow;

	/* option to print calls to pop371, set with print key on atom feii */
	int lgPrint;

	/* option to only simulate calls to pop371 */
	int lgSimulate;

	/* say which FeII atom this is, Verner or Netzer */
	char chFeIIAtom[7];

	/* punch verner short for shorter punch */
	int lgShortFe2;

	/* says whether (true) or not (false) pumping of the FeiI model atom by HI Lya is included
	 * normally true, set false with the NO FEII command */
	int lgLyaPumpOn;

	/* energy range for FeII lines output with punch verner, 
	 * set with punch verner range e ryd, e ryd */
	float fe2ener[2];

	/* energy range and threshold for FeII lines output with punch verner */
	float fe2thresh;

	/* these are the lower and upper bounds to the FeII continuum, in Angstroms,*/
	float fe2con_wl1 , fe2con_wl2;
	/* the number of intervals to break the FeII continuum into */
	long int nfe2con;

	/* redistribution function to use for resonance and subordinate lines */
	int ipRedisFcnResonance;
	int ipRedisFcnSubordinate;

#	if 0
	/* moved out to global variables 
	 * >>chng 99 dec 9 */
	/* band wavelength, lower and upper bounds, in vacuum Angstroms */
	/* FeII.bands[n][3], where n is the number of bands in Fe2Bands.dat
	 * these bands are defined in Fe2Bands.dat and read in at startup
	 * of calculation */
	float **bands; 

	/* number of bands in fe2bands.dat */
	long int nBands;
#	endif

	}	FeII;
