/*prtmet print all line optical depths at end of iteration */
#include "cddefines.h"
#include "taulines.h"
#include "printit.h"
#include "iso.h"
#include "abundances.h"
#include "prtmet.h"

/*prme print heavy element line optical depths at end of calculation */
void prme(char *chDoIt, 
  EmLine * t);

void prtmet(void)
{
	long int i,
		ipZ , ipHi , ipLo ;
#	ifdef DEBUG_FUN
	fputs( "<+>prtmet()\n", debug_fp );
#	endif

	/* default is to not print optical depths, turn on with
	 * print optical depths on command */
	if( printit.lgPrtTau )
	{

		/* 'In' means to zero counter, following elements mean nothing */
		prme("In",&TauLines[0]);

		/* do hydrogenic species */
		for( ipZ=0; ipZ < LIMELM; ipZ++ )
		{
			if( abundances.lgElmtOn[ipZ] )
			{
				for( ipHi=ipH2p; ipHi < MIN2(5,iso.nLevels[ipHYDROGEN][ipZ]); ipHi++ )
				{
					/* first do Lya */
					ipLo = ipH1s;
					prme(" c",&EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo]);
					for( ipLo=ipH2p; ipLo < ipHi; ipLo++ )
					{
						prme(" c",&EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo]);
					}
				}
			}
		}

		/* do he-like species */
		for( ipZ=1; ipZ < LIMELM; ipZ++ )
		{
			if( abundances.lgElmtOn[ipZ] )
			{
				for( ipHi=1; ipHi < iso.nLevels[ipHELIUM][ipZ]; ipHi++ )
				{
					for( ipLo=0; ipLo < ipHi; ipLo++ )
					{
						prme(" c",&EmisLines[ipHELIUM][ipZ][ipHi][ipLo]);
					}
				}
			}
		}

		/* print all lines lines */
		for( i=1; i <= nLevel1; i++ )
		{
			prme(" c",&TauLines[i]);
		}

		for( i=0; i < nWindLine; i++ )
		{
			prme(" c",&TauLine2[i]);
		}

		for( i=0; i < nCORotate; i++ )
		{
			prme(" c",&C12O16Rotate[i]);
		}

		for( i=0; i < nCORotate; i++ )
		{
			prme(" c",&C13O16Rotate[i]);
		}

		for( i=0; i < nHFLines; i++ )
		{
			prme(" c",&HFLines[i]);
		}

		/* this means print it */
		prme("  ",&TauLines[0]);
	}

#	ifdef DEBUG_FUN
	fputs( " <->prtmet()\n", debug_fp );
#	endif
	return;
}

/*prme print heavy element line optical depths at end of calculation */
#define	NLIM	6

/******************************************************************************
 *
 * prme - the helper routine for above 
 *
 ******************************************************************************/

void prme(char *chDoIt, 
  EmLine * t)
{
	/* char chLabel[3]; */
	static char chLsav[NLIM][11];
	long int i;
	static long int n;
	static float tsav[NLIM] = {0.};

#	ifdef DEBUG_FUN
	fputs( "<+>prme()\n", debug_fp );
#	endif

	/* this routine is called by prtmet, and is used to print out
	 * line optical depths after model complete - it IS NOT a
	 * timing pace setter */

	/* label for line */
	/* strcpy( chLabel, elementnames.chElementSym[ t->nelem -1] ); */

	if( strcmp(chDoIt,"In") == 0 )
	{
		n = 0;

	}
	else if( strcmp(chDoIt,"  ") == 0 )
	{
		/* NB number in following statement must agree with nlim */
		fprintf( ioQQQ, "   " );
		for( i=0; i < n; i++ )
		{
			fprintf( ioQQQ, "%10.10s",chLsav[i]);
			fprintf( ioQQQ,PrintEfmt("%9.2e", tsav[i] ));
			fprintf( ioQQQ, " ");
		}
		fprintf( ioQQQ, " \n" );

	}
	else if( t->TauIn > printit.PrtTauFnt || t->TauIn < 0. )
	{
		/* t->t(ipLnTauIn) is the optical depth
		 * PrtTauFnt is threshold for printing it */
		if( n >= NLIM )
		{
			/* NB number in following statement must agree with nlim */
			fprintf( ioQQQ, "   " );
			for( i=0; i < NLIM; i++ )
			{
				fprintf( ioQQQ, "%10.10s",chLsav[i]);
				fprintf( ioQQQ,PrintEfmt("%9.2e", tsav[i] ));
				fprintf( ioQQQ, " ");
			}
			fprintf( ioQQQ, " \n" );
			n = 0;
		}

		strcpy( chLsav[n], chLineLbl(t) );
		tsav[n] = t->TauIn;
		++n;
	}

#	ifdef DEBUG_FUN
	fputs( " <->prme()\n", debug_fp );
#	endif
	return;
}
