/*punResults punch results from punch results command */
/*PunResults1Line do single line of output for the punch results and punch line intensity commands */
#include "cddefines.h"
#include "linesave.h"
#include "cddrive.h"
#include "opacity.h"
#include "mean.h"
#include "rdinit.h"
#include "readar.h"
#include "punch.h"

void punResults(FILE* io)
{
	char chCard[81];
	int lgEOF;
	long int i , n;

#	ifdef DEBUG_FUN
	fputs( "<+>punResults()\n", debug_fp );
#	endif

	/* used to punch out line intensities, optical depths,
	 * and column densities */
	lgEOF = FALSE;
	/* first initialize the line image reader */
	rdinit();

	fprintf( io, "**********************************************************************************************************************************\n" );
	lgEOF = FALSE;
	readar(chCard,&lgEOF);
	while( !lgEOF )
	{
		fprintf( io, "%s\n", chCard );
		readar(chCard,&lgEOF);
	}

	/* first print any cautions or warnings */
	cdWarnings(io);
	cdCautions(io);
	fprintf( io, "**********************************************************************************************************************************\n" );

	fprintf( io, "C*OPTICAL DEPTHS ELECTRON=%10.3e\n", opac.telec );

	fprintf( io, "BEGIN EMISSION LINES\n" );
	PunResults1Line(io,"    ",0,0.,'o',"Start");

	for( i=0; i < LineSave.nsum; i++ )
	{
		if( LineSv[i].sumlin > 0. )
		{
			PunResults1Line(io,(char*)LineSv[i].chALab,LineSv[i].wavelength,
			  LineSv[i].sumlin,LineSv[i].chSumTyp,"Line ");
		}
	}

	PunResults1Line(io,"    ",0,0.,'o',"Flush");

	fprintf( io, "     \n" );

	fprintf( io, "BEGIN COLUMN DENSITIES\n" );
	/* make sure this is kept parallel with cdGett, which uses it
	 * real in all column densities*/

	/* this dumps out the whole array, which will be picked up by cdGett */
	/* following loop relies on LIMELM being 30, assert it here in case
	 * this is ever changed */
	assert( LIMELM == 30 );
	/* this order of indices is to keep 30 as the fastest variable,
	 * and the 32 (LIMELM+2) as the slower one */
	for(i=0; i < LIMELM+2; i++)
	{
		for( n=0; n<LIMELM; n++ )
		{
			fprintf( io, " %10.3e", IonMeans.xIonMeans[0][n][i] );
			/* throw line feed every 10 numbers */
			if( n==9|| n==19 || n==29 )
			{
				fprintf( io, "\n" );
			}
		}
	}

	fprintf( io, "END OF RESULTS\n" );
	fprintf( io, "**********************************************************************************************************************************\n" );

#	ifdef DEBUG_FUN
	fputs( " <->punResults()\n", debug_fp );
#	endif
	return;
}

/*PunResults1Line do single line of output for the punch results and punch line intensity commands */
/* the number of emission lines across one line of printout */
#define	LINEWIDTH	6

void PunResults1Line(FILE * io, 
  /* 4 char + null string */
  char *chLab, 
  float wl, 
  double xInten, 
  char chType,
  char *chFunction)/* null terminated string saying what to do */
{

	long int i;
	static float wavelength[LINEWIDTH];
	static long ipLine;
	static double xIntenSave[LINEWIDTH];
	static char chTypeSave[LINEWIDTH];
	static char chLabSave[LINEWIDTH][5];

#	ifdef DEBUG_FUN
	fputs( "<+>PunResults1Line()\n", debug_fp );
#	endif

	/* if LineWidth is changed then change format in write too */

	if( strcmp(chFunction,"Start") == 0 )
	{
		ipLine = 0;
	}
	else if( strcmp(chFunction,"Line ") == 0 )
	{
		/* save results in array so that they can be printed when done */
		wavelength[ipLine] = wl;
		strcpy( chLabSave[ipLine], chLab );
		xIntenSave[ipLine] = xInten;
		chTypeSave[ipLine] = chType;

		/* now increment the counter and then check if we have filled the line, 
		 * and so should print it */
		++ipLine;
		if( ipLine == LINEWIDTH )
		{
			if( strcmp(punch.chPunRltType,"array ") == 0 )
			{
				/* usual array 6 wide */
				for( i=0; i < ipLine; i++ )
				{
					fprintf( io, " %4.4s", chLabSave[i] );
					fprintf( io, "%6f", wavelength[i] );
					fprintf( io,PrintEfmt("%10.3e", xIntenSave[i]) );
					fprintf( io, " %c", chTypeSave[i] );
				}
				fprintf( io, " \n" );
			}
			else if( strcmp(punch.chPunRltType,"column") == 0 )
			{
				/* single column for input into data base */
				for( i=0; i < ipLine; i++ )
				{
					fprintf( io, " %4.4s", chLabSave[i] );
					fprintf( io, "%6f", wavelength[i] );
					fprintf( io,PrintEfmt("%10.3e", xIntenSave[i] ));
					fprintf( io, " %c", chTypeSave[i] );
					fprintf( io, "\n" );
				}
			}
			else
			{
				fprintf( ioQQQ, " PunResults1Line called with insane chPunRltType=%6.6s\n", 
				  punch.chPunRltType );
			}
			ipLine = 0;
		}
	}
	else if( strcmp(chFunction,"Flush") == 0 )
	{
		if( ipLine > 0 )
		{
			/* this is an option to print many emission lines across an output line,
			 * the array option, or a single column of numbers, the column option
			 * that appears on the "punch results" and "punch intensity" commands
			 */
			if( strcmp(punch.chPunRltType,"array ") == 0 )
			{
				/* usual array 6 wide */
				for( i=0; i < ipLine; i++ )
				{
					fprintf( io, " %4.4s", chLabSave[i] );
					fprintf( io, "%6f", wavelength[i] );
					fprintf( io,PrintEfmt("%10.3e", xIntenSave[i]) );
					fprintf( io, " %c", chTypeSave[i] );
				}
				fprintf( io, " \n" );
			}
			else if( strcmp(punch.chPunRltType,"column") == 0  )
			{
				/* single column for input into data base */
				for( i=0; i < ipLine; i++ )
				{
					fprintf( io, " %4.4s", chLabSave[i] );
					fprintf( io, "%6f", wavelength[i] );
					fprintf( io,PrintEfmt("%10.3e", xIntenSave[i] ));
					fprintf( io, " %c", chTypeSave[i] );
					fprintf( io, "\n" );
				}
			}
			else
			{
				fprintf( ioQQQ, " PunResults1Line called with insane chPunRltType=%6.6s\n", 
				  punch.chPunRltType );
			}
		}
	}
	else
	{
		fprintf( ioQQQ, " PunResults1Line called with insane request=%5.5s\n", 
		  chFunction );
		puts( "[Stop in result]" );
		cdEXIT(1);
	}

#	ifdef DEBUG_FUN
	fputs( " <->PunResults1Line()\n", debug_fp );
#	endif
	return;
}

