/*PunSpec generate output for the punch special command */
#include "cddefines.h"
#include "taulines.h"
#include "radius.h"
#include "opacity.h"
/* includes above almost always needed */
#include "coolheavy.h"
#include "rfield.h"
#include "iso.h"
#include "ffun.h"
#include "heat.h"
#include "colden.h"
#include "phycon.h"
#include "atom_oi.h"
#include "ionfracs.h"
#include "punspec.h"

void PunSpec(FILE* io , 
  char *chTime)
{
	/*long int i;*/

#	ifdef DEBUG_FUN
	fputs( "<+>PunSpec()\n", debug_fp );
#	endif

	if( strncmp(chTime,"LAST",4) == 0 )
	{
#		if 0
		long ipISO , ipZ , limit , i;
		double EdenAbund , fach;
#		include "physconst.h"
#		include "hydrogenic.h"
#		include "ionfracs.h"
		/* code to execute only after last zone 
		PunFeII( io );*/
		ipISO = ipHYDROGEN;
		ipZ = ipHYDROGEN;

		/* in all following the factor of two is because a single
		 * decay produces two photons */
		EdenAbund = iso.Pop2Ion[ipHYDROGEN][ipZ][ipH2s]*xIonFracs[ipZ][ipZ+2]*8.226*pow(1.+ipZ,6);
		fprintf(io," 2s = %.3e\n", EdenAbund);

		/* upper limit to H-like 2-phot is energy of La, which is in ipCont-1 cell */
		limit = EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].ipCont-1;
		/* remember sum of rates, this will add up to twice the real rate since
		 * each transition makes two photons */
		for( i=0; i < limit; i++ )
		{
			/*>>chng 01 jan 23, previous change had doubled cross section for H two-photon,
			 * so here we divide by 2 to get old answer */
			/* >>chng 01 sep 16, break out TWO_PHOT_CONST and factor of two from AsHy2nu */
			fach = hydro.AsHy2nu[ipISO][ipZ][i]/2.f;
			fach *= rfield.anu2[i]/rfield.widflx[i]*EN1RYD;
			fprintf(io,"%.3e\t%.3e\t%.3e\n", 
				RYDLAM/1e4/rfield.anu[i] , fach , fach*(float)EdenAbund );
		}
#		endif

	}
	else
	{
		/* code to execute after every zone */
		/*temperature, old, new CO cooling */
		/*fprintf(io,"%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\n",  phycon.te, 
			CoolHeavy.COVibCoolOld , 
			CoolHeavy.C12O16Rot,
			CoolHeavy.C13O16Rot,
			CoolHeavy.dCOVdTOld , 
			CoolHeavy.dC12O16Rot,
			CoolHeavy.dC13O16Rot);
		fprintf(io,"%.2e\t%.2e\n",  
			EmisLines[ipHYDROGEN][ipHYDROGEN][3][0].TauIn*1.5e-5 , 
			opac.TauAbsFace[EmisLines[ipHYDROGEN][ipHYDROGEN][3][0].ipCont-1] );*/
		/* plots for FFJ 
		fprintf(io, "%.3e\t%.3e\t%.3e\t%.3e\n",
			coldenCom.colden[ipCOLUMNDENSITY],
			phycon.te,
			phycon.eden,
			heat.htot );*/
		fprintf(io,"%.4e\t%.4e\t%.4e\t%.4e\t%.4e\n",
			radius.depth,
			TauLines[ipT1304].Pesc,
			atom_oi.popoi[1],
			TauLines[ipT1304].PopLo,
			xIonFracs[ipOXYGEN][1]
			);
	}

#	ifdef DEBUG_FUN
	fputs( " <->PunSpec()\n", debug_fp );
#	endif
	return;
}
#if 0
		/* code to execute after every zone */
		double texc;
		/*FILE *ioSAV;
		ioSAV = ioQQQ;
		ioQQQ = io;
		DumpLine( &TauLines[ipT63] );*/
		texc = TexcLine( &TauLines[ipT63]);
		fprintf(io," %e %e\n",  
			TauLines[ipT63].TauIn, 
			texc);/**/
		/*ioQQQ = ioSAV;*/
		/* code to execute after every zone */
		fprintf( io, "%10.2e%10.2e", radius.depth , radius.drad);
		fprintf( io, "%10.2e %10.2e ", radius.depth , radius.drad);
		fprintf( io, "%10.2e %10.2e", TauLines[ipT63].TauIn ,
		fprintf( io, "\n" );
		fprintf( io, "%10.2e", TauLine2[186].PopLo*TauLine2[186].pump );
		fprintf( io, "%10.2e", TauLine2[191].PopLo*TauLine2[191].pump );
		fprintf( io, "%10.2e", TauLine2[194].PopLo*TauLine2[194].pump );
		fprintf( io, "%10.2e", TauLine2[197].PopLo*TauLine2[197].pump );
		fprintf( io, "%10.2e", TauLine2[199].PopLo*TauLine2[199].pump );
		fprintf( io, "%10.2e", TauLine2[200].PopLo*TauLine2[200].pump );
		fprintf( io, "%10.2e", TauLine2[201].PopLo*TauLine2[201].pump );
		fprintf( io, "\n" );
#endif 
