/*punt produce map of heating-cooling space for specified zone, called as result of
 * map command  */
#include "cddefines.h"
#ifdef EPS
#	undef EPS
#endif
#define	EPS	0.005
#include "cooling.h"
#include "mappar.h"
#include "stopcalc.h"
#include "ionfracs.h"
#include "thigh.h"
#include "called.h"
#include "heat.h"
#include "phycon.h"
#include "trace.h"
#include "coolpr.h"
#include "pressure.h"
#include "tfidle.h"
#include "nsset.h"
#include "converge.h"
#include "punt.h"

void punt(char *chType)
{
	char chLabel[5];
	char units;
	long int i, 
	  ksav, 
	  j, 
	  jsav, 
	  k;
	float wl;
	double cfrac, 
	  ch, 
	  fac, 
	  factor, 
	  hfrac, 
	  oldch, 
	  ratio, 
	  strhet, 
	  strong, 
	  t1, 
	  tlowst, 
	  tmax, 
	  tmin, 
	  torg;

#	ifdef DEBUG_FUN
	fputs( "<+>punt()\n", debug_fp );
#	endif

	t1 = phycon.te;
	torg = phycon.te;
	MapPar.lgMapOK = TRUE;
	/* flag indicating that we have computed a map */
	MapPar.lgMapDone = TRUE;

	/* make sure pressure has been evaluated */
	strong = PressureTotalDo();

	/* print out all coolants if all else fails */
	if( called.lgTalk )
	{
		fprintf( ioQQQ, " Cloudy punts, Te=%10.3e HTOT=%10.3e CTOT=%10.3e nzone=%4ld\n", 
		  phycon.te, heat.htot, cooling.ctot, nzone );
		fprintf( ioQQQ, " COOLNG array is\n" );

		if( cooling.ctot > 0. )
		{
			coolpr("ZERO",1,0.,"ZERO");
			for( i=0; i < cooling.ncltot; i++ )
			{
				ratio = cooling.cooling[i]/cooling.ctot;
				if( ratio>EPS )
				{
					coolpr((char*)cooling.chClntLab[i],cooling.collam[i],
					  ratio,"DOIT");
				}
			}

			coolpr("DONE",1,0.,"DONE");
			fprintf( ioQQQ, " Line heating array follows\n" );
			coolpr("ZERO",1,0.,"ZERO");

			for( i=0; i < cooling.ncltot; i++ )
			{
				ratio = cooling.heatnt[i]/cooling.ctot;
				if( ratio>EPS )
				{
					coolpr((char*)cooling.chClntLab[i],cooling.collam[i],
					  ratio,"DOIT");
				}
			}

			coolpr("DONE",1,0.,"DONE" );
		}
	}

	/* map out te-ionization-cooling space before punching out. */
	if( called.lgTalk )
	{
		fprintf( ioQQQ, " map of heating, cooling, vs temp, follows.\n");
		fprintf( ioQQQ, 
			"     Te     Heat-------------------> Cool---------------------->   dH/dT     dC/DT       Ne         NH      HII       Helium \n" );
	}

	if( strcmp(chType,"punt") == 0 )
	{
		/* this is the original use of punt, we are punting
		 * only map within factor of two of final temperature
		 * fac will the range to either side of punted temperature */
		fac = 1.5;
		tmin = torg/fac;
		tmax = torg*fac;

		/* we want about 20 steps between high and low temperature
		 * default of nMapStep is 20, set with set nmaps command */
		factor = pow(10.,log10(tmax/tmin)/(float)(MapPar.nMapStep));
		phycon.te = (float)tmin;
	}

	else if( strcmp(chType," map") == 0 )
	{
		/* create some sort of map of heating-cooling */
		tlowst = MAX2(MapPar.RangeMap[0],StopCalc.TeLowest);
		tmin = tlowst*0.998;
		tmax = MIN2(MapPar.RangeMap[1],StopCalc.TeHighest)*1.002;

		/* we want about nMapStep (=20) steps between high and low temperature */
		factor = pow(10.,log10(tmax/tmin)/(float)(MapPar.nMapStep));

		if( thigh.lgTeHigh )
		{
			/* high te */
			factor = 1./factor;
			/* TeHighest is highest possible temperature, 1E10 */
			phycon.te = (float)(MIN2(MapPar.RangeMap[1],StopCalc.TeHighest)/factor);
		}

		else
		{
			/* low te */
			phycon.te = (float)(tlowst/factor);
		}
	}

	else
	{
		/* don't know what to do */
		fprintf( ioQQQ, " PUNT called with insane argument,=%4.4s\n", 
		  chType );
		puts( "[Stop in punt]" );
		cdEXIT(1);
	}

	/* now allocate space for te, c, h vectors in MapPar, if not already done */
	if( MapPar.nMapAlloc==0 )
	{
		/* space not allocated, do so now */
		MapPar.nMapAlloc = MapPar.nMapStep+4;

		/* now make the space */
		MapPar.temap = (float *)MALLOC( sizeof(float)*(size_t)(MapPar.nMapStep+4) );
		if( MapPar.temap == NULL )
		{ 
			printf( " not enough memory to allocate MapPar.temap in punt\n" );
			puts( "[Stop in punt]" );
			cdEXIT(1);
		}
		MapPar.cmap = (float *)MALLOC( sizeof(float)*(size_t)(MapPar.nMapStep+4) );
		if( MapPar.cmap == NULL )
		{ 
			printf( " not enough memory to allocate MapPar.cmap in punt\n" );
			puts( "[Stop in punt]" );
			cdEXIT(1);
		}
		MapPar.hmap = (float *)MALLOC( sizeof(float)*(size_t)(MapPar.nMapStep+4) );
		if( MapPar.hmap == NULL )
		{ 
			printf( " not enough memory to allocate MapPar.hmap in punt\n" );
			puts( "[Stop in punt]" );
			cdEXIT(1);
		}

	}

	cooling.lgCNegChk = FALSE;
	MapPar.nmap = 0;
	oldch = 0.;
	phycon.te *= (float)factor;

	while( (double)phycon.te < tmax*0.999 && (double)phycon.te > tmin*1.001 )
	{
		/* strong means nothing, but we must give value to something*/
		strong = PressureTotalDo();
		/* must reset upper and lower bounds for ionization distributions */
		nsset();
		/* this turns on constant reevaluation of everything */
		conv.lgSearch = TRUE;

		/* update density - temperature variables which may have changed */
		tfidle(FALSE);

		/* this counts how many times ionize is called in this model after startr,
		 * and is flag used by ionize to understand it is being called the first time*/
		conv.nTotalIoniz = 0;

		/* now get inital ionization solution for this temperature */
		ConvEdenIoniz();
		MapPar.temap[MapPar.nmap] = phycon.te;
		MapPar.cmap[MapPar.nmap] = (float)cooling.ctot;
		MapPar.hmap[MapPar.nmap] = (float)heat.htot;

		wl = 0.f;
		strong = 0.;

		for( j=0; j < cooling.ncltot; j++ )
		{
			if( cooling.cooling[j] > strong )
			{
				strcpy( chLabel, cooling.chClntLab[j] );
				strong = cooling.cooling[j];
				wl = cooling.collam[j];
			}
		}

		cfrac = strong/cooling.ctot;
		strhet = 0.;
		/* these will be reset in following loop*/
		ksav = -INT_MAX;
		jsav = -INT_MAX;

		for( k=0; k < LIMELM; k++ )
		{
			for( j=0; j < LIMELM; j++ )
			{
				if( heat.heating[k][j] > strhet )
				{
					strhet = heat.heating[k][j];
					jsav = j;
					ksav = k;
				}
			}
		}

		ch = cooling.ctot - heat.htot;
		/* use ratio to check for change of sign since product
		 * can underflow at low densities */
		if( oldch/ch < 0. && called.lgTalk )
		{
			fprintf( ioQQQ, " ----------------------------------------------- Probable thermal solution here. --------------------------------------------\n" );
		}

		oldch = ch;
		hfrac = strhet/heat.htot;
		if( called.lgTalk )
		{
			/* convert to micros if IR transition */
			if( wl < 100000.f )
			{
				units = 'A';
			}

			else
			{
				wl /= 10000.f;
				units = 'm';
			}

			if( trace.lgTrace )
			{
				fprintf( ioQQQ, "TRACE: te, htot, ctot%11.3e%11.3e%11.3e\n", 
				  phycon.te, heat.htot, cooling.ctot );
			}

			/*fprintf( ioQQQ, 
				"%10.4e%11.4e%4ld%4ld%6.3f%11.4e %4.4s %4ld%c%6.3f%10.2e%11.4e%11.4e%6.2f%6.2f%6.2f%6.2f\n",;*/
			fprintf(ioQQQ,"%s", PrintEfmt("%11.4e", phycon.te ) );
			fprintf(ioQQQ,"%s", PrintEfmt("%11.4e", heat.htot ) );
			fprintf(ioQQQ,"[%2ld][%2ld]%6.3f",
			  jsav,ksav,  
			  hfrac);
			fprintf(ioQQQ,"%s", PrintEfmt("%11.4e", cooling.ctot ) );
			fprintf(ioQQQ," %s %.1f%c%6.3f",
			  chLabel , 
			  wl, 
			  units, 
			  cfrac );
			fprintf(ioQQQ,"%s", PrintEfmt(" %10.2e", heat.dHTotDT ) );
			fprintf(ioQQQ,"%s", PrintEfmt("%11.2e", cooling.dCooldT ) );
			fprintf(ioQQQ,"%s", PrintEfmt("%11.4e", phycon.eden ) );
			fprintf(ioQQQ,"%s", PrintEfmt("%11.4e", phycon.hden ) );
			fprintf(ioQQQ,"%6.2f%6.2f%6.2f%6.2f\n",
			  log10(MAX2(1e-9,xIonFracs[ipHYDROGEN][2]/phycon.hden)), 
			  log10(MAX2(1e-9,xIonFracs[ipHELIUM][1]/xIonFracs[ipHELIUM][0])), 
			  log10(MAX2(1e-9,xIonFracs[ipHELIUM][2]/xIonFracs[ipHELIUM][0])), 
			  log10(MAX2(1e-9,xIonFracs[ipHELIUM][3]/xIonFracs[ipHELIUM][0])) );
			fflush(ioQQQ);
		}

		phycon.te *= (float)factor;
		/* increment nmap but do not exceed nMapAlloc */
		MapPar.nmap = MIN2(MapPar.nMapAlloc,MapPar.nmap+1);

		{
			/*@-redef@*/
			enum {DEBUG=FALSE};
			/*@+redef@*/
			if( DEBUG )
			{
				static int kount = 0;
				factor = 1.;
				phycon.te = 8674900.f;
				++kount;
				if( kount >=100 )
				{
					fprintf(ioQQQ," exiting in punt\n");
					break;
				}
			}
		}
	}

	/* now check whether sharp inflections occurred, and also find the biggest jump
	 * in the heating and cooling */
	MapPar.lgMapOK = TRUE;
	 for( i=1; i< MapPar.nmap-2; ++i )
	 {
		float s1,s2,s3;/* the three slopes we will use */
		s1 = MapPar.cmap[i-2] - MapPar.cmap[i-1];
		s2 = MapPar.cmap[i-1] - MapPar.cmap[i];
		s3 = MapPar.cmap[i] - MapPar.cmap[i+1];
		if( s1*s3 > 0. && s2*s3 < 0. )
		{
			 /* of the three points, the outer had the same slope 
			  * (their product was positive) but there was an inflection
			  * between them (the negative product).  The data chain looked like
			  *     2 4
			  *    1 3  or vice versa, either case is wrong */
			fprintf( ioQQQ,
				" cooling curve had double inflection at T=%.2e, warning being generated.\n",
				MapPar.temap[i] );
			MapPar.lgMapOK = FALSE;
		}

		s1 = MapPar.hmap[i-2] - MapPar.hmap[i-1];
		s2 = MapPar.hmap[i-1] - MapPar.hmap[i];
		s3 = MapPar.hmap[i]   - MapPar.hmap[i+1];
		if( s1*s3 > 0. && s2*s3 < 0. )
		{
			 /* of the three points, the outer had the same slope 
			  * (their product was positive) but there was an inflection
			  * between them (the negative product).  The data chain looked like
			  *     2 4
			  *    1 3  or vice versa, either case is wrong */
			fprintf( ioQQQ,
				" heating curve had double inflection at T=%.2e, warning being generated.\n",
				MapPar.temap[i] );
			MapPar.lgMapOK = FALSE;
		}
	 }

	cooling.lgCNegChk = TRUE;
	phycon.te = (float)t1;

#	ifdef DEBUG_FUN
	fputs( " <->punt()\n", debug_fp );
#	endif
	return;
}

