/*PutLine enter local line intensity into the intensity stack for eventual printout */
/*PutExtra enter and 'extra' intensity source for some line */
#include "cddefines.h"
#include "linesave.h"
#include "linadd.h"
#include "grainvar.h"
#include "rfield.h"
#include "opacity.h"
#include "radius.h"
#include "putline.h"

static float ExtraInten;

void PutLine(EmLine * t)
{
	char chLabel[5];
	float wl;
	double xIntensity,
		other;

#	ifdef DEBUG_FUN
	fputs( "<+>PutLine()\n", debug_fp );
#	endif

	/* routine to use line array data to generate input
	 * for emission line array */

	/* if ipass=0 then we must generate label info since first pass
	 * gt.0 then only need line intensity data */
	if( LineSave.ipass == 0 )
	{
		/* these variables not used by linadd if ipass ne 0 */
		/* chIonLbl is function that generates a null terminated 4 char string, of form "C  2" */
		chIonLbl(chLabel, t);
		/* iWavLen converts wavelength into truncated form used in printout, ie,
		 * FIR lines are small integers, two-photon emission is 0 wavelength
		assert( t->WLAng >= 0. );
		assert( t->WLAng < 1e20 ); */

		/* the following converts wavelength into format for convenient printing,
		 * also returns units and possible shift of decimal point
		i = iWavLen(t, &chUnits , &chShift); */
		wl = t->WLAng;

		/* following is only non-zero for lines that are added into continuum */
		LineSv[LineSave.nsum].xLineEnergy = t->EnergyRyd;
		xIntensity = 0.;
	}
	else
	{
		/* both the counting and integrating modes comes here */
		strcpy( chLabel, "    " );
		wl = 0.;
		/* total line intensity or luminosity */
		xIntensity = t->xIntensity + ExtraInten;
	}
	/* initial counting case, where ipass == -1, just ignored above, call linadd below */

	/* ExtraInten is option that allows extra intensity (i.e., recomb)
	 * to be added to this line  with Call PutExtra( exta )
	 * in main lines this extra
	 * contribution must be identified explicitly */
	/* note that xLineEnergy is non-zero since defined above, for this call to linadd only,
	 * so this will be added to continuum.  Following calls to linadd will not be added to
	 * continuum since xLineEnergy will be left zero */
	ExtraInten = 0.;
	linadd(xIntensity,wl,chLabel,'i');

	/* inward part of line - do not move this away from previous lines
	 * since xIntensity is used here */
	xIntensity = xIntensity*t->FracInwd;
	linadd(xIntensity,wl,"Inwd",'i');

	/* cooling part of line */
	other = t->cool;
	linadd(other,wl,"Coll",'c');

	/* fluorescent excited part of line */
	other = t->PopOpc * t->pump * t->AovTot * t->EnergyErg;
	linadd(other,wl,"Pump",'i');

	/* heating part of line */
	other = t->heat;
	linadd(other,wl,"Heat",'h');

	assert( t->ipCont > 0. );
	/* this is dust part */
	if( gv.lgDustOn )
	{
		if( LineSave.ipass > 0 )
		{
			/* main production pass, sum lines only
			 * evaluate 2nd exponential integral function
			 * >>chng 97 nov 05, some variables not defined above nflux */
			if( t->ipCont <= rfield.nflux )
			{
				/* >>chng 01 aug 23, replace e2 with stored vlue */
				/*e2fn = e2(opac.TauAbsGeo[0][ipnt-1],opac.ExpmTau[ipnt-1]);*/
				/*float e2fn = opac.e2TauAbs[t->ipCont-1];*/
				/* DSTOTH was unit vol energy lost onto dust by cooling lines
				 * dstoth = dstoth + xInten * (1.-e2fn) */
				/* >>chng 01 aug 23, add to dust array, (had not been
				 * in before) also use inward fraction */
				LineDSv[LineSave.ndsum].smdlin += (float)(xIntensity*radius.dVeff*
				  (1. + opac.albedo[t->ipCont-1])*opac.e2TauAbs[t->ipCont-1]);
			}
		}
		else if( LineSave.ipass == 0 )
		{
			/* set parameters for first pass */
			LineDSv[LineSave.ndsum].smdlin = 0.;
			LineDSv[LineSave.ndsum].wavelength = wl;
			strcpy( LineDSv[LineSave.ndsum].chSMDLab, chLabel );
		}
		/* there is also case where ipass is negative, in this one we just add counter
		 * since space for array has not been malloced yet */
		/* increment the counter to the number of lines */
		++LineSave.ndsum;
	}

#	ifdef DEBUG_FUN
	fputs( " <->PutLine()\n", debug_fp );
#	endif
	return;
}

/* ==================================================================== */
/*PutExtra enter and 'extra' intensity source for some line */
void PutExtra(double Extra)
{

#	ifdef DEBUG_FUN
	fputs( "<+>PutExtra()\n", debug_fp );
#	endif

	ExtraInten = (float)Extra;

#	ifdef DEBUG_FUN
	fputs( " <->PutExtra()\n", debug_fp );
#	endif
	return;
}

