/*RTMake do escape and destruction probs for all lines in code.  
 * Called with FALSE arg by ionize, to only redo destruction probabilites,
 * and with TRUE by cloudy to do both escape and destruction */
#include "cddefines.h"
#include "wind.h"
#include "taulines.h"
#include "pop371.h"
#include "iso.h"
#include "abundances.h"
#include "ionrange.h"
#include "ionfracs.h"
#include "converge.h"
#include "hydrogenic.h"
#include "hetran.h"
#include "rt.h"

void RTMake(
	/* this is TRUE if we want to do both escape and destruction probs,
	 * and FALSE if only destruction probabilities are needed */
	int lgDoEsc )
{
	long int i,
		nelem;
	long ipHi , ipLo;
	double factor;

#	ifdef DEBUG_FUN
	fputs( "<+>RTMake()\n", debug_fp );
#	endif

	for( nelem=0; nelem < LIMELM; nelem++ )
	{
		/* note that nelem scale is totally on c not physical scale, so 0 is h */
		/* evaluate hydrogenic balance if ionization reaches this high */

		if( (IonRange.IonHigh[nelem] == nelem + 1)  )
		{
			/* evaluate branch As, escape probabilities, and destruction rates */
			HydroPesc(nelem , lgDoEsc);
		}
	}

	/* do helium singlets and triplets */
	HeTran();

	/* now main sets of lines */
	if( wind.windv == 0. )
	{
		{
			/* option to print particulars of some line when called */
			/*@-redef@*/
			enum {DEBUG=FALSE};
			/*@+redef@*/
			if( DEBUG )
			{
				DumpLine(&TauLines[93]);/**/
				/*DumpLine(&TauLines[128]);*/
			}
		}
		/* loop over he-like species */
		for( nelem=1; nelem<LIMELM; ++nelem )
		{
			/* do not consider elements that have been turned off */
			if( abundances.lgElmtOn[nelem] )
			{
				if( xIonFracs[nelem][nelem+1] > 1e-30 )
				{
					factor = xIonFracs[nelem][nelem+1];
				}
				else
				{
					/* case where almost no parent ion - this will make
					 * very large line opacity, so background dest small */
					factor = 1.;
				}
				for( ipHi=1; ipHi < iso.nLevels[ipHELIUM][nelem]; ipHi++ )
				{
					for( ipLo=0; ipLo < ipHi; ipLo++ )
					{
						/* >>chng 01 aug 18, do not add fake he-like lines (majority) to line stack */
						/* >>chng 02 feb 10, test had been on A, change to ipCont */
						if( EmisLines[ipHELIUM][nelem][ipHi][ipLo].ipCont < 1 ) 
							continue;
						/* must temporarily make ipLnPopOpc physical */
						EmisLines[ipHELIUM][nelem][ipHi][ipLo].PopOpc *= 
							(float)factor;

						/* generate escape prob, pumping rate, destruction prob, 
						 * inward outward fracs 
						fprintf(ioQQQ,"%li %li %li %li\n", nelem, ipHi, ipLo,EmisLines[ipHELIUM]);
						fflush(ioQQQ); */

						RTMakeStat(&EmisLines[ipHELIUM][nelem][ipHi][ipLo] , lgDoEsc );

						/* go back to original units so that final correction ok */
						EmisLines[ipHELIUM][nelem][ipHi][ipLo].PopOpc /= 
							(float)factor;
					}
				}
			}
		}
		/*fprintf(ioQQQ,"new opc, dst, redis\t%.2e\t%.2e\t%i\n",
		EmisLines[ipHELIUM][1][ipHe2p1P][0].opacity, EmisLines[ipHELIUM][1][ipHe2p1P][0].Pdest, EmisLines[ipHELIUM][1][ipHe2p1P][0].iRedisFun );*/	
		/* static model - level 1 lines */
		for( i=1; i <= nLevel1; i++ )
		{
			RTMakeStat(&TauLines[i] , lgDoEsc );
		}
		/* co carbon monoxide */
		for( i=0; i < nCORotate; i++ )
		{
			RTMakeStat(&C12O16Rotate[i] , lgDoEsc );
			RTMakeStat(&C13O16Rotate[i] , lgDoEsc );
		}
		for( i=0; i < nHFLines; i++ )
		{
			RTMakeStat(&HFLines[i] , lgDoEsc );
		}

		/* >>chng 01 aug 11, the level 2 lines were only updated when lgDoEsc was true,
		 * this meant that dest probs were not updated but once, causing very high-Z models
		 * to develop numerical oscialltions.  removed if, now evaluate level 2 always */
		/* only update their dest/esc probs one time per zone */
		/* lgLevel2_OTS_Imp set true in dimacool if ots rates were significant */
		/* level 2 heavy element lines in cooling with only g-bar,*/
		if( lgDoEsc + conv.lgLevel2_OTS_Imp )
		{
			for( i=0; i < nWindLine; i++ )
			{
				/* >>chng 02 sug 11, do not include he-like in sum */
				if( TauLine2[i].IonStg <= TauLine2[i].nelem-1 )
				{
					float dest;
					dest = TauLine2[i].Pdest;
					RTMakeStat(&TauLine2[i] , lgDoEsc );
					/* >>chng 99 sep 17, following to prevent oscillations
					 * where level 2 lines overlap He+ ionizing continuum */
					/* dest probs for these level 2 lines should not matter
					 * since they should be weak ots sources.  there can be
					 * problems with the zoning when they high H or He edges,
					 * so use average */
					TauLine2[i].Pdest = TauLine2[i].Pdest*0.25f + 0.75f*dest ;
				}
			}
		}
	}
	else
	{
		/* windy model */
		/* loop over he-like species */
		for( nelem=1; nelem<LIMELM; ++nelem )
		{
			/* do not consider elements that have been turned off */
			if( abundances.lgElmtOn[nelem] )
			{
				if( xIonFracs[nelem][nelem+1] > 1e-30 )
				{
					factor = xIonFracs[nelem][nelem+1];
				}
				else
				{
					/* case where almost no parent ion - this will make
					 * very large line opacity, so background dest small */
					factor = 1.;
				}
				for( ipHi=1; ipHi < iso.nLevels[ipHELIUM][nelem]; ipHi++ )
				{
					for( ipLo=0; ipLo < ipHi; ipLo++ )
					{
						/* >>chng 01 aug 18, do not add fake he-like lines (majority) to line stack */
						/* >>chng 02 feb 10, change to test on ipCont and not A */
						if( EmisLines[ipHELIUM][nelem][ipHi][ipLo].ipCont < 1 ) 
							continue;

						/* must temporarily make ipLnPopOpc physical */
						EmisLines[ipHELIUM][nelem][ipHi][ipLo].PopOpc *= 
							(float)factor;

						/* generate escape prob, pumping rate, destruction prob, 
						 * inward outward fracs  */
						RTMakeWind(&EmisLines[ipHELIUM][nelem][ipHi][ipLo] , lgDoEsc );

						/* go back to original units so that final correction ok */
						EmisLines[ipHELIUM][nelem][ipHi][ipLo].PopOpc /= 
							(float)factor;
					}
				}
			}
		}
		/* level 1 lines */
		for( i=1; i <= nLevel1; i++ )
		{
			RTMakeWind(&TauLines[i] , lgDoEsc );
		}
		/* co carbon monoxide */
		for( i=0; i < nCORotate; i++ )
		{
			RTMakeWind(&C12O16Rotate[i] , lgDoEsc );
			RTMakeWind(&C13O16Rotate[i] , lgDoEsc );
		}
		for( i=0; i < nHFLines; i++ )
		{
			RTMakeWind(&HFLines[i] , lgDoEsc );
		}

		if( lgDoEsc )
		{
			/* level 2 lines
			 * heavy element lines in cooling with only g-bar 
			 * only update their dest/esc probs one time per zone */
			for( i=0; i < nWindLine; i++ )
			{
				if( TauLine2[i].nelem != TauLine2[i].IonStg )
				{
					RTMakeWind(&TauLine2[i] , lgDoEsc );
				}
			}
		}
	}

	/* Verner's model FeII atom
	 * do not call if Netzer model used, or it Fe(2) is zero
	 * exception is when code is searching for first soln */
	if( FeII.lgFeIION )
	{
		RTFeIIMake( lgDoEsc );
	}

#	ifdef DEBUG_FUN
	fputs( " <->RTMake()\n", debug_fp );
#	endif
	return;
}

