/*RTMakeWind do line radiative transfer for wind geometry */
#include "cddefines.h"
#include "rfield.h"
#include "doppvel.h"
#include "rtescprob.h"
#include "ionfracs.h"
#include "rt.h"

void RTMakeWind(EmLine * t , int lgDoEsc)
{
	float damp, 
	  velocity;

#	ifdef DEBUG_FUN
	fputs( "<+>RTMakeWind()\n", debug_fp );
#	endif

	/* 
	 * this is the routine that computes much of the radiative transfer
	 * physics for lines in wind case.  Lines diveded into two types,
	 * high quality (cs1=0) and lower quality g-bar lines
	 */

	/* >>chng 01 aug 18, do not evaluation if no population */
	/* >>chng 01 oct 25, add test for lgDoEsc, this is to make sure
	 * that rates are evaluated at start of a new iteration */
	if( xIonFracs[ t->nelem-1][t->IonStg] == 0.  && !lgDoEsc )
	{
		/* zero population, return after setting everything with side effects */
		t->Pesc = 1.f;

		/* inward escaping fraction */
		t->FracInwd = 0.5;

		/* pumping rate */
		t->pump = 0.;

		/* destruction probability */
		t->Pdest = 0.;

#		ifdef DEBUG_FUN
		fputs( " <->RTMakeStat()\n", debug_fp );
#		endif
		return;
	}

	/*confirm pops and cs ok */
	assert( t->ColOvTot <= 1. && t->ColOvTot >= 0. );

	/* t->nelem is atomic number of species */
	assert( t->nelem >= 1 && t->ipCont > 0 );

	/* line width, thermal + turbulence */
	velocity = DoppVel.doppler[t->nelem-1];

	/* evaluate and store damping constant */
	damp = t->damprel/velocity;
	t->damp = damp;

	/* use only one-sided escape probabilities
	 * get escape probability, this gets fractions too */
	if( lgDoEsc )
	{
		t->Pesc = (float)esc_CRDwing_1side(t->TauIn,damp);

		/* inward fraction */
		t->FracInwd = 0.5;

		/* continuum pumping */
		if( rfield.lgInducProcess )
		{
			t->pump = t->Aul*t->gHi/t->gLo*t->Pesc*
			  rfield.OccNumbIncidCont[t->ipCont-1];
		}
		else
		{
			t->pump = 0.;
		}
	}

	/* get destruction probability */
	t->Pdest = (float)(
		RT_DestProb(
		t->PopOpc,
		t->opacity,
		/* index for line in continuum array, on f not c scale */
		t->ipCont,
	    velocity,
		t->Pesc, 
		"  K2"));

#	ifdef DEBUG_FUN
	fputs( " <->RTMakeWind()\n", debug_fp );
#	endif
	return;
}

