/*RTOptDepthIncre increment optical depths once per zone, called after RadInc */
#include "cddefines.h"
#define	CAPMASER	(-30.)
#include "taulines.h"
#include "nhe1lvl.h"
#include "iso.h"
#include "nfeii.h"
#include "rfield.h"
#include "iphmin.h"
#include "trace.h"
#include "he1tau.h"
#include "hyperfine.h"
#include "he1nxt.h"
#include "wind.h"
#include "ionrange.h"
#include "doppvel.h"
#include "he3lines.h"
#include "phe1lv.h"
#include "prtmet.h"
#include "filfac.h"
#include "hmi.h"
#include "he3tau.h"
#include "opacity.h"
#include "phycon.h"
#include "radius.h"
#include "fe2tau.h"
#include "ionfracs.h"
#include "he1stat.h"
#include "dtmase.h"
#include "pop371.h"
#include "rt.h"

void RTOptDepthIncre(void)
{

	char chLbl[11];

	long int i, 
	  ipHi, 
	  ipZ, 
	  j, 
	  ipLo;

	double dtau, 
	  factor, 
	  fnext, 
	  r;

#	ifdef DEBUG_FUN
	fputs( "<+>RTOptDepthIncre()\n", debug_fp );
#	endif

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, " RTOptDepthIncre called.\n" );
	}

	opac.telec += (float)(radius.dReff*phycon.eden*6.65e-25);
	opac.thmin += 
		(float)(radius.dReff*hmi.hminus*3.9e-17*(1. - rfield.ContBoltz[iphminCom.iphmin-1]/
	  hmi.hmidep));

	/* following used for wind solution in TAUCHN */
	/* >>chng 01 mar 24, removed following, equivalent logic now in RTLineTauInc */
	/*if( wind.windv > 0. )
		wind.wndeff = 
		(float)(MIN2(radius.depth,radius.Radius)/MAX2(DoppVel.doppler[0],
		  wind.windv)*filfac.FillFac);*/

	/* prevent maser runaway */
	dtMase.dTauMase = 0.;

	/* if following is still zero when maser used, then maser was in
	 * heavy element line */
	dtMase.ijMase = 0;

	/* hydrogenic species */
	for( ipZ=0; ipZ < LIMELM; ipZ++ )
	{
		if( (IonRange.IonHigh[ipZ] == ipZ + 1)  )
		{
			/* must convert to physical scale for opacities,
			 * get ionic abundances first */
			if( xIonFracs[ipZ][ipZ+2] > 1e-30 )
			{
				factor = xIonFracs[ipZ][ipZ+2];
			}
			else
			{
				/* case where almost no parent ion - this will make
				 * very large line opacity, so background dest small */
				factor = 1.;
			}

			for( ipLo=0; ipLo < (iso.nLevels[ipHYDROGEN][ipZ] - 1); ipLo++ )
			{
				for( ipHi=ipLo + 1; ipHi < iso.nLevels[ipHYDROGEN][ipZ]; ipHi++ )
				{
					/* must temporarily make ipLnPopOpc physical */
					EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].PopOpc *= 
						(float)factor;
					/* actually do the work */
					RTLineTauInc(&EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo]);
					/* go back to original units so that final correction ok */
					EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo].PopOpc /= 
						(float)factor;
				}
			}
			ipLo = 0;
			/* these are the extra lyman lines */
			for( ipHi=2; ipHi < iso.nLyman[ipHYDROGEN]; ipHi++ )
			{
				/* must matke ipLnPopOpc physical */
				iso.ExtraLymanLines[ipHYDROGEN][ipZ][ipHi].PopOpc = EmisLines[ipHYDROGEN][ipZ][3][ipLo].PopOpc *(float)factor;
				/* actually do the work */
				RTLineTauInc(&iso.ExtraLymanLines[ipHYDROGEN][ipZ][ipHi]);
			}
		}
	}

	/* he-like species */
	for( ipZ=1; ipZ < LIMELM; ipZ++ )
	{
		if( IonRange.IonHigh[ipZ] >= ipZ )
		{
			/* must convert to physical scale for opacities,
			 * get ionic abundances first */
			if( xIonFracs[ipZ][ipZ+1] > 1e-30 )
			{
				factor = xIonFracs[ipZ][ipZ+1];
			}
			else
			{
				/* case where almost no parent ion - this will make
				 * very large line opacity, so background dest small */
				factor = 1.;
			}

			for( ipHi=1; ipHi < iso.nLevels[ipHELIUM][ipZ]; ipHi++ )
			{
				for( ipLo=0; ipLo < ipHi; ipLo++ )
				{
					/* must temporarily make ipLnPopOpc physical */
					EmisLines[ipHELIUM][ipZ][ipHi][ipLo].PopOpc *= 
						(float)factor;
					/* actually do the work */
					RTLineTauInc(&EmisLines[ipHELIUM][ipZ][ipHi][ipLo]);
					/* go back to original units so that final correction ok */
					EmisLines[ipHELIUM][ipZ][ipHi][ipLo].PopOpc /= 
						(float)factor;
				}
			}
			ipLo = 0;
			/* these are the extra lyman lines */
			for( ipHi=2; ipHi < iso.nLyman[ipHELIUM]; ipHi++ )
			{
				/* must make ipLnPopOpc physical */
				iso.ExtraLymanLines[ipHELIUM][ipZ][ipHi].PopOpc = EmisLines[ipHELIUM][ipZ][3][ipLo].PopOpc *(float)factor;
				/* actually do the work */
				RTLineTauInc(&iso.ExtraLymanLines[ipHELIUM][ipZ][ipHi]);
			}
		}
	}

	/* increment optical depths for all heavy element lines
	 * same routine does wind and static,
	 * does not start from 0 since first line is dummy */
	for( i=1; i <= nLevel1; i++ )
	{
		RTLineTauInc(&TauLines[i]);
		if( TauLines[i].TauIn < CAPMASER )
		{
			fprintf( ioQQQ, " RTOptDepthIncre, Tau line maser tau too small,%10.2e\n", 
			  TauLines[i].TauIn );
			strcpy( chLbl, chLineLbl(&TauLines[i] ) );
			fprintf( ioQQQ, " line=%3ld zone=%4ld %10.10s\n", 
			  i, nzone, chLbl );
			ShowMe();
			puts( "[Stop in RTOptDepthIncre]" );
			cdEXIT(1);
		}
	}

	/* all lines in cooling with g-bar */
	for( i=0; i < nWindLine; i++ )
	{
		if( TauLine2[i].nelem != TauLine2[i].IonStg )
		{
			RTLineTauInc(&TauLine2[i]);
			if( TauLine2[i].TauIn < CAPMASER )
			{
				fprintf( ioQQQ, " RTOptDepthIncre, Wind line maser tau too small,%10.2e\n", 
				  TauLine2[i].TauIn );
				fprintf( ioQQQ, " line=%3ld zone=%4ld\n", i, nzone );
				ShowMe();
				puts( "[Stop in RTOptDepthIncre]" );
				cdEXIT(1);
			}
		}
	}

	/* all hyper fine structure lines  */
	for( i=0; i < nHFLines; i++ )
	{
		/* remember current gas-phase abundances */
		float save = xIonFracs[HFLines[i].nelem-1][HFLines[i].IonStg];

		/* bail if no abundance */
		if( save<=0. ) continue;

		/* set gas-phase abundance to total times isotope ratio */
		xIonFracs[HFLines[i].nelem-1][HFLines[i].IonStg] *= hyperfine.HFLabundance[i] ;

		RTLineTauInc(&HFLines[i]);
		if( HFLines[i].TauIn < CAPMASER )
		{
			fprintf( ioQQQ, " RTOptDepthIncre, Wind line maser tau too small,%10.2e\n", 
				HFLines[i].TauIn );
			fprintf( ioQQQ, " line=%3ld zone=%4ld\n", i, nzone );
			ShowMe();
			puts( "[Stop in RTOptDepthIncre]" );
			cdEXIT(1);
		}

		/* put the correct gas-phase abundance back in the array */
		xIonFracs[HFLines[i].nelem-1][HFLines[i].IonStg] = save;
	}
	{
		/* this is an option to print out one of the two photon continua */
		/*@-redef@*/
		enum {DEBUG=FALSE};
		/*@+redef@*/
		if( DEBUG )
		{	
			fprintf(ioQQQ,"isotope pops\t%.3e\t%.3e\t%.3e\t%.3e\n",
				/*HFLines[0].PopOpc , HFLines[0].opacity,
				TauLines[ipH21cm].PopOpc , TauLines[ipH21cm].opacity);*/
				HFLines[0].TauIn , HFLines[0].TauTot,
				TauLines[ipH21cm].TauIn , TauLines[ipH21cm].TauTot);
		}
	}

	/* carbon monoxide co lines */
	for( i=0; i < nCORotate; i++ )
	{
		RTLineTauInc(&C12O16Rotate[i]);
		if( C12O16Rotate[i].TauIn < CAPMASER )
		{
			fprintf( ioQQQ, " RTOptDepthIncre, C12O16 line maser tau too small,%10.2e\n", 
			  C12O16Rotate[i].TauIn );
			fprintf( ioQQQ, " line=%3ld zone=%4ld\n", i, nzone );
			ShowMe();
			puts( "[Stop in RTOptDepthIncre]" );
			cdEXIT(1);
		}
	}
	for( i=0; i < nCORotate; i++ )
	{
		RTLineTauInc(&C13O16Rotate[i]);
		if( C13O16Rotate[i].TauIn < CAPMASER )
		{
			fprintf( ioQQQ, " RTOptDepthIncre, C13O16 line maser tau too small,%10.2e\n", 
			  C13O16Rotate[i].TauIn );
			fprintf( ioQQQ, " line=%3ld zone=%4ld\n", i, nzone );
			ShowMe();
			puts( "[Stop in RTOptDepthIncre]" );
			cdEXIT(1);
		}
	}

	/* do large FeII atom if this is enabled */
	if( FeII.lgFeIION )
	{
		FeIITauInc();
	}

	/* following is for static atmosphere */
	if( wind.windv == 0. )
	{
		if( trace.lgTrace )
		{
			fprintf( ioQQQ, " RTOptDepthIncre updates for static atmos\n" );
		}

		/* He I lines
		 * Helium lines, optical depths are total, not He alone
		 * hydrogen and helium were added in with correction for stimulated emission */
		factor = xIonFracs[ipHELIUM][2]*radius.dReff/DoppVel.doppler[1];
		fnext = xIonFracs[ipHELIUM][2]*radius.dRNeff/DoppVel.doppler[1]*0.6;
		for( ipLo=0; ipLo < (NHE1LVL - 1); ipLo++ )
		{
			for( ipHi=ipLo + 1; ipHi < NHE1LVL; ipHi++ )
			{
				/* line absorption, corrected for stimulated emission */
				/* >>chng 01 aug 11, change from 2 to 3 */
				if( ipHi+1 < NHE1LVL - 3 )
				{
					dtau = (phe1lv.he1n[ipLo] - phe1lv.he1n[ipHi]*
					  he1statCOM.he1stat[ipLo]/he1statCOM.he1stat[ipHi])*
					  he1tauCOM.he1opc[ipLo][ipHi];
				}
				else
				{
					/* do not allow stim emission for psuedo-states */
					dtau = phe1lv.he1n[ipLo]*he1tauCOM.he1opc[ipLo][ipHi];
				}
				he1tauCOM.he1tau[ipLo][ipHi] += (float)(dtau*factor);
				he1nxtCOM.he1nxt[ipLo][ipHi] = (float)(he1tauCOM.he1tau[ipLo][ipHi] + 
				  dtau*fnext);
				if( he1nxtCOM.he1nxt[ipLo][ipHi] < CAPMASER )
				{
					fprintf( ioQQQ, " RTOptDepthIncre, He1 line maser tau too small,%10.2e\n", 
					  he1nxtCOM.he1nxt[ipLo][ipHi] );
					fprintf( ioQQQ, " upper, lower=%3ld%3ld zone=%4ld\n", 
					  ipHi+1, ipLo+1, nzone );
					ShowMe();
					puts( "[Stop in RTOptDepthIncre]" );
					cdEXIT(1);
				}
			}
		}

		t206.TauIn += (float)((phe1lv.he12s - phe1lv.he12p*
		  0.333)*1.162e-6*factor);
		if( t206.TauIn < CAPMASER )
		{
			fprintf( ioQQQ, " RTOptDepthIncre, He1 2.06 mic line maser tau too small,%10.2e\n", 
			  t206.TauIn );
			fprintf( ioQQQ, " zone=%4ld\n", nzone );
			ShowMe();
			puts( "[Stop in RTOptDepthIncre]" );
			cdEXIT(1);
		}

		factor = radius.dReff/DoppVel.doppler[1];
		he3tau[IPT10830-1].TauIn += (float)(8.80e-7*(he3lines.p2s - 
		  he3lines.p2p/3.)*factor);
		he3tau[IPT3889-1].TauIn += (float)(3.75e-8*he3lines.p2s*
		  factor);
		he3tau[IPT5876-1].TauIn += (float)(5.35e-7*he3lines.p2p*
		  factor);
		/* >>chng 01 may 20, comparison with he-like iso seq showed that opacity
		 * was wrong, - from 2.95e-7 to 7.342e-8, 4x too large */
		/*he3tau[IPT7065-1].TauIn += (float)(2.95e-7*he3lines.p2p*
		  factor);*/
		he3tau[IPT7065-1].TauIn += (float)(7.342e-8*he3lines.p2p*
		  factor);

		/* iron fe feii fe2 
		 * first are overlapping feii lines */
		for( i=0; i < NFEII; i++ )
		{
			fe2tau.Fe2TauLte[i] += fe2tau.feopc[i]*(float)radius.dReff;
		}

	}

	/* this is windy solution*/
	else
	{
		if( trace.lgTrace )
		{
			fprintf( ioQQQ, " RTOptDepthIncre updates for wind\n" );
		}

		/* expanding atmosphere
		 * min of depth or radius is to stop (nearly) infinite line
		 * line optical depths when ionization parameter set so
		 * radius itself is very large */
		r = MIN2(radius.depth,radius.Radius)/MAX2(DoppVel.doppler[0],
		  wind.windv)*filfac.FillFac;

		/* He I lines
		 * Helium lines and continua, optical depths are total, not He alone
		 * hydrogen and helium were added in with correction for stimulated emission */
		factor = xIonFracs[ipHELIUM][2]*r;
		for( i=0; i < (NHE1LVL - 1); i++ )
		{
			for( j=i + 1; j < NHE1LVL; j++ )
			{
				/* line absorption, corrected for stimulated emission */
				if( j+1 <= NHE1LVL - 2 )
				{
					dtau = (phe1lv.he1n[i] - phe1lv.he1n[j]*he1statCOM.he1stat[i]/
					  he1statCOM.he1stat[j])*he1tauCOM.he1opc[i][j];
				}
				else
				{
					/* do not include stim emission for psuedo-states */
					dtau = phe1lv.he1n[i]*he1tauCOM.he1opc[i][j];
				}
				he1tauCOM.he1tau[i][j] = (float)(dtau*factor);
				he1nxtCOM.he1nxt[i][j] = he1tauCOM.he1tau[i][j];
			}
		}
		t206.TauIn = (float)(phe1lv.he12s*xIonFracs[ipHELIUM][2]*1.162e-6*
		  r);
		t206.TauTot = t206.TauIn;

		he3tau[IPT10830-1].TauIn = (float)(r*(he3lines.p2s - 
		  he3lines.p2p/3.)*8.80e-7);
		he3tau[IPT10830-1].TauTot = he3tau[IPT10830-1].TauIn;
		he3tau[IPT3889-1].TauIn = (float)(3.75e-8*he3lines.p2s* r);
		he3tau[IPT3889-1].TauTot = he3tau[IPT3889-1].TauIn;
		he3tau[IPT5876-1].TauIn = (float)(5.35e-7*he3lines.p2p* r);
		he3tau[IPT5876-1].TauTot = he3tau[IPT5876-1].TauIn;
		/* >>chng 01 may 20, comparison with he-like iso seq showed that opacity
		 * was wrong, - from 2.95e-7 to 7.342e-8, 4x too large */
		/*he3tau[IPT7065-1].TauIn = (float)(2.95e-7*he3lines.p2p* r);*/
		he3tau[IPT7065-1].TauIn = (float)(7.342e-8*he3lines.p2p* r);
		he3tau[IPT7065-1].TauTot = he3tau[IPT7065-1].TauIn;
		/* end branch for windy solution */
	}

	if( trace.lgTrace && trace.lgOptcBug )
	{
		fprintf( ioQQQ, " RTOptDepthIncre updated optical depths:\n" );

		fprintf( ioQQQ, "    He trp:" );
		for(i=0; i < NHE3TAU; i++)
		{
			fprintf( ioQQQ, "%10.2e", he3tau[i].TauIn );
		}
		fprintf( ioQQQ, "\n" );

		prtmet();

	}

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, " RTOptDepthIncre returns.\n" );
	}

#	ifdef DEBUG_FUN
	fputs( " <->RTOptDepthIncre()\n", debug_fp );
#	endif
	return;
}

