/*smeets generate hydrogenic collisional ionization rate coefficients 
 * for quantum number n */
#include "cddefines.h"
#include "phycon.h"
#include "smeets.h"

double smeets(long int n)
{
	double coef, 
	  denom, 
	  eps, 
	  smeets_v, 
	  tryd;

#	ifdef DEBUG_FUN
	fputs( "<+>smeets()\n", debug_fp );
#	endif

	/* a function written to calculate the rate coefficients 
	 * for hydrogen collisional ionizations from
	 * Jason Ferguson, summer 94
	 * valid for all n
	 * Vriens & Smeets 1980. Phys Rev A 22, 940.
	 * */
	tryd = 8.617e-5*phycon.te;
	eps = 1.57890e5/phycon.te/n/n;
	denom = pow(eps,2.33) + 4.38*pow(eps,1.72) + 1.32*eps;
	coef = 9.56e-6/pow(tryd,1.5)/denom*sexp(eps);
	smeets_v = coef;


#	ifdef DEBUG_FUN
	fputs( " <->smeets()\n", debug_fp );
#	endif
	return( smeets_v );
}

