/*tababun interpolate on table of points to do 'element table' command, */
#include "cddefines.h"
#include "abundances.h"
#include "tababun.h"

double tababun(double r0, 
  double depth, 
  long int iel)
{
	int lgHit;
	long int j;
	double frac, 
	  tababun_v, 
	  x;

#	ifdef DEBUG_FUN
	fputs( "<+>tababun()\n", debug_fp );
#	endif
	/*interpolate on table of points to do 'element table' command,
	 *based on code by K Volk
	 *each line is log radius and abundance. */
	/* atomic number */

	/* interpolate on radius or depth? */
	if( abundances.lgAbTaDepth[iel-1] )
	{
		/* depth key appeared = we want depth */
		x = log10(depth);
	}
	else
	{
		/* use radius */
		x = log10(r0);
	}

	/* this will be reset below, but is here as a safety check */
	tababun_v = -DBL_MAX;

	if( x < abundances.AbTabRad[0][iel-1] || x >= abundances.AbTabRad[abundances.nAbunTabl-1][iel-1] )
	{
		fprintf( ioQQQ, " requested radius outside range of tababun\n" );
		fprintf( ioQQQ, " radius was%10.2e min, max=%10.2e%10.2e\n", 
		  x, abundances.AbTabRad[0][iel-1], abundances.AbTabRad[abundances.nAbunTabl-1][iel-1] );
		puts( "[Stop in tababun]" );
		cdEXIT(1);
	}

	else
	{
		lgHit = FALSE;
		j = 1;

		while( !lgHit && j <= abundances.nAbunTabl - 1 )
		{
			if( abundances.AbTabRad[j-1][iel-1] <= (float)x && 
				abundances.AbTabRad[j][iel-1] > (float)x )
			{
				frac = (x - abundances.AbTabRad[j-1][iel-1])/(abundances.AbTabRad[j][iel-1] - 
				  abundances.AbTabRad[j-1][iel-1]);
				tababun_v = abundances.AbTabFac[j-1][iel-1] + frac*
				  (abundances.AbTabFac[j][iel-1] - abundances.AbTabFac[j-1][iel-1]);
				lgHit = TRUE;
			}
			j += 1;
		}

		if( !lgHit )
		{
			fprintf( ioQQQ, " radius outran dlaw table scale, requested=%6.2f largest=%6.2f\n", 
			  x, abundances.AbTabRad[abundances.nAbunTabl-1][iel-1] );
			puts( "[Stop in tababun]" );
			cdEXIT(1);
		}
	}

	/* got it, now return value, not log of density */
	tababun_v = pow(10.,tababun_v);


#	ifdef DEBUG_FUN
	fputs( " <->tababun()\n", debug_fp );
#	endif
	return( tababun_v );
}

