/*totlin sum total intensity of cooling, recombination, or intensity lines */
#include "cddefines.h"
#include "linesave.h"
#include "totlin.h"

double totlin(
	/* chInfor is 1 char, 
	'i' information, 
	'r' recombination or 
	'c' collision */
	int chInfo)
{
	long int i;
	double totlin_v;

#	ifdef DEBUG_FUN
	fputs( "<+>totlin()\n", debug_fp );
#	endif

	/* routine goes through set of entered line
	 * intensities and picks out those which have
	 * types agreeing with chInfo.  Valid types are
	 * 'c', 'r', and 'i'
	 *begin sanity check */
	if( (chInfo != 'i' && chInfo != 'r') && chInfo != 'c' )
	{
		fprintf( ioQQQ, " TOTLIN does not understand chInfo=%c\n", 
		  chInfo );
		puts( "[Stop in totlin]" );
		cdEXIT(1);
	}
	/*end sanity check */

	/* now find sum of lines of type chInfo */
	totlin_v = 0.;
	for( i=0; i < LineSave.nsum; i++ )
	{
		if( LineSv[i].chSumTyp == chInfo )
		{
			totlin_v += LineSv[i].sumlin;
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->totlin()\n", debug_fp );
#	endif
	return( totlin_v );
}

