/*TrimStages raise or lower most extreme stages of ionization considered,
 * called by ConvIonizeOpacityDo */
#include "cddefines.h"
#include "ionfracs.h"
#include "ionrange.h"
#include "heat.h"
#include "trimstages.h"

void TrimStages(
	/* nelem is on the C scale, 0 for H, 5 for C */
	long int nelem )
{

#	ifdef DEBUG_FUN
	fputs( "<+>TrimStages()\n", debug_fp );
#	endif

	/*confirm all numbers are within their range of validity */
	assert( nelem >= 0 && nelem < LIMELM );
	assert( IonRange.IonLow[nelem] >= 0 );
	assert( IonRange.IonHigh[nelem] <= nelem+1 );
	/* IonHigh can be equal to IonLow if both are zero - no ionization*/
	assert( IonRange.IonLow[nelem] < IonRange.IonHigh[nelem] || 
		(IonRange.IonLow[nelem]==0 && IonRange.IonHigh[nelem]==0 )  );

	/* raise or lower highest and lowest stages of ionization to
	 * consider only significant stages
	 * IonLow[nelem] lowest stage of ionization on C scale, atom == 0
	 * IonHigh[nelem]  stage of ionization
	 *
	 * NB  NB  NB  NB  xIonFracs must have 1 added to above to get over tot abund */

	/* special - trim down upper stages trim if they have essentially zero abundance */
	while( 
		(xIonFracs[nelem][IonRange.IonHigh[nelem]+1]/xIonFracs[nelem][0] < SMALLFLOAT || 
		/* >>chng 02 feb 06, add this check, which can only happen in exotic models
		 * at startup.  This index is safe since IonHigh is always at least 1.  At worst
		 * test will check abundance of element, which is 0 element of IonFracs */
		xIonFracs[nelem][IonRange.IonHigh[nelem]]/xIonFracs[nelem][0] < SMALLFLOAT || 
		xIonFracs[nelem][IonRange.IonHigh[nelem]+1] < SMALLFLOAT || 
		xIonFracs[nelem][IonRange.IonHigh[nelem]] < SMALLFLOAT) && 
		IonRange.IonHigh[nelem] > IonRange.IonLow[nelem] + 1 )
	{
		/* xIonFracs(nelem,i) is density of ith ionization stage (cm^-3) */
		/* the -2 is correct, -1 since atom of ion is what heats, and another -1 since
		 * scale for xIonFracs is offset by one from heating array */
		xIonFracs[nelem][IonRange.IonHigh[nelem]+1] = 0.;
		heat.heating[nelem][IonRange.IonHigh[nelem]-1] = 0.;

		/* decrement high stage limit */
		--IonRange.IonHigh[nelem];
	}

	/* >>chng 01 aug 02, add logic to trim up zero abundances */
	/* special - trim up lower stages trim if they have essentially zero abundance */
	/* >>chng 02 feb 06, add check on true density */
	while( 
		(xIonFracs[nelem][IonRange.IonLow[nelem]+1]/xIonFracs[nelem][0] < SMALLFLOAT || 
		xIonFracs[nelem][IonRange.IonLow[nelem]+1] < SMALLFLOAT ) && 
		IonRange.IonLow[nelem] < IonRange.IonHigh[nelem] - 1 )
	{
		/* xIonFracs[nelem][i+1] is density of ith ionization stage (cm^-3) */
		/* the -2 is correct, -1 since atom of ion is what heats, and another -1 since
		 * scale for xIonFracs is offset by one from heating array */
		xIonFracs[nelem][IonRange.IonLow[nelem]+1] = 0.;
		/* >>chng 01 aug 04, remove -1 which clobbers heat.heating when IonLow == 0 */
		/*heat.heating[nelem][IonRange.IonLow[nelem]-1] = 0.;*/
		heat.heating[nelem][IonRange.IonLow[nelem]] = 0.;

		/* decrement high stage limit */
		++IonRange.IonLow[nelem];
	}

	/* sanity check */
	/* IonHigh can be equal to IonLow if both are zero - no ionization*/
	assert( IonRange.IonLow[nelem] < IonRange.IonHigh[nelem] || 
		(IonRange.IonLow[nelem]==0 && IonRange.IonHigh[nelem]==0 )  );

#	if 0
	/* >>chng 02 feb 08, this was a major logical error - upward trim
	 * occurs after this bit, so can never happen */
	/* only have atom and first ion, do not lower any more */
	if( IonRange.IonHigh[nelem] == 1 )
	{ 
		/* these are standard bounds checks that appear throughout this routine
		xIonFracs[IonLow+1] is first one with positive abundances */
		if( IonRange.IonLow[nelem] > 1 )
		{
			assert( xIonFracs[nelem][IonRange.IonLow[nelem]] == 0. );
		}
		assert( xIonFracs[nelem][IonRange.IonLow[nelem]+1] > SMALLFLOAT );

		assert( xIonFracs[nelem][IonRange.IonHigh[nelem]+1] > SMALLFLOAT );
		if( IonRange.IonHigh[nelem] < nelem+1 )
		{
			assert( xIonFracs[nelem][IonRange.IonHigh[nelem]+2] == 0. );
		}
		assert( xIonFracs[nelem][IonRange.IonHigh[nelem]+1] > SMALLFLOAT );

#		ifdef DEBUG_FUN
		fputs( " <->TrimStages()\n", debug_fp );
#		endif
		return;
	}
#	endif

	/* trim down high stages that have too small an abundance */
	/* >>chng 01 apr 21, last comparison had been IonHigh > 2, change to relative to IonLow */
	if( 
		(!IonRange.lgNoDec && 
		xIonFracs[nelem][IonRange.IonHigh[nelem]+1]/xIonFracs[nelem][0] <= (float)IonRange.trimhi) && 
		IonRange.IonHigh[nelem] > IonRange.IonLow[nelem]+1  )
	{
		xIonFracs[nelem][IonRange.IonHigh[nelem]+1] = 0.;
		heat.heating[nelem][IonRange.IonHigh[nelem]-1] = 0.;
		--IonRange.IonHigh[nelem];
	}

	/* sanity check */
	/* IonHigh can be equal to IonLow if both are zero - no ionization*/
	assert( IonRange.IonLow[nelem] < IonRange.IonHigh[nelem] || 
		(IonRange.IonLow[nelem]==0 && IonRange.IonHigh[nelem]==0 )  );

	/* lower lowest stage of ionization if we have significant abundance at current lowest */
	if( 
		xIonFracs[nelem][IonRange.IonLow[nelem]+1]/xIonFracs[nelem][0] > 1e-3f && 
		IonRange.IonLow[nelem] > 0 )
	{
		/* lower lowest level of ionization */
		--IonRange.IonLow[nelem];
		/* >>chng 01 aug 02, set this to zero so that sanity check elsewhere will be ok */
		xIonFracs[nelem][IonRange.IonLow[nelem]+1] = /*xIonFracs[nelem][0] **/ SMALLFLOAT;

		/* tell code to do all photo rates only in case where lowest is lowered still */
		/*conv.lgIonStageTrimed = TRUE;*/
	}

	/* raise lowest stage of ionization, but only if we are near illuminated face of cloud*/
	/* >>chng 01 aug 08, add test on nzones */
	/* >>chng 02 feb 07, this logic was inverted!  change from nzone > 1 to nzone < 10 */
	/*else if( nzone > 1 &&*/
	else if( nzone < 10 &&
		(xIonFracs[nelem][IonRange.IonLow[nelem]+1]/xIonFracs[nelem][0] <= (float)IonRange.trimlo) && 
		(IonRange.IonLow[nelem] < (IonRange.IonHigh[nelem] - 2) ) )
	{
		/* raise lowest level of ionization */
		xIonFracs[nelem][IonRange.IonLow[nelem]+1] = 0.;
		/* no minus one in below since this is low bound, already bounds at atom */
		heat.heating[nelem][IonRange.IonLow[nelem]] = 0.;
		++IonRange.IonLow[nelem];
	}

	/* sanity check */
	/* IonHigh can be equal to IonLow if both are zero - no ionization*/
	assert( IonRange.IonLow[nelem] < IonRange.IonHigh[nelem] || 
		(IonRange.IonLow[nelem]==0 && IonRange.IonHigh[nelem]==0 )  );

	/* these are standard bounds checks that appear throughout this routine
	 * xIonFracs[IonLow+1] is first one with positive abundances
	 * 
	 * in case where lower ionization stage was just lowered the abundance
	 * was set to SMALLFLOAT so test must be < SMALLFLOAT */
	if( IonRange.IonLow[nelem] > 1 )
	{
		assert( xIonFracs[nelem][IonRange.IonLow[nelem]] == 0. );
	}
	if( xIonFracs[nelem][IonRange.IonLow[nelem]+1] < SMALLFLOAT &&
		xIonFracs[nelem][IonRange.IonLow[nelem]+1]/xIonFracs[nelem][0] < SMALLFLOAT )
	{
		fixit();/* delete this debugging block */
		fprintf(ioQQQ,"bummer2\n");
	}
	assert( xIonFracs[nelem][IonRange.IonLow[nelem]+1] >= SMALLFLOAT ||
		xIonFracs[nelem][IonRange.IonLow[nelem]+1]/xIonFracs[nelem][0] >= SMALLFLOAT );

#	ifdef DEBUG_FUN
	fputs( " <->TrimStages()\n", debug_fp );
#	endif
	return;
}
