/*cdInit routine to initialize variables, called at start of calculation */
/*cdEXIT exit handler to terminate calculation, called at end of calculation */
#include "cddefines.h"
/* NB - following must appear after cddefines.h since code there
 * ensures that __unix is defined on any unix box */
#ifdef __unix
#	include <unistd.h>
#	include <stdlib.h>
#endif
#include "cddrive.h"
#include "vary.h"
#include "optimr.h"
#include "blockdata.h"
#include "setfpenv.h" 
#include "assertresults.h" 
#include "called.h"
#include "input.h"
#include "parse.h"
#include "punch.h"
#include "phfit.h"
#include "zero.h"
#include "varypar.h"
/* include mpi header if mpi true */
/* This flag indicates whether we are multi-processing.
 * if this is true then all output happens at the end,
 * if false then each set of results is printed and flushed when it happens.
 * must be set true on parallel machines, false on pc */
#ifdef MPI
#	include <mpi.h>
#endif


/*************************************************************************
 *
 * cdMPI sets flag to tell exit handler to call MPI_Finalize 
 *
 ************************************************************************/

/* flag set true when cdMPI called, tells exit handler to clean up mpi */
/* lint error saying never used for anything is fine -- 
 * only is used if mpi flags are set */
static int lgMPI;

/*cdMPI sets flag telling exit handler to call MPI_Finalize, must
 * call after cdInit when MPI is used */
void cdMPI(void) /* set flag so that exit handler will clean up MPI */
{
	lgMPI = TRUE;
	return;
}

/* =================================================================== */
void cdInit()
{
	long i;
	double vtest;
	double cs;
#	ifdef __unix
	char *ptr;
#	endif

#if	0
	static int lgFIRST=TRUE;
	/* if this is very first call then set up handler */
	if( lgFIRST )
	{
		/* register the exit handler */
		if( atexit( exithandler ) )
		{
			fprintf(ioQQQ," cdInit got error on return from atexit \n");
			cdEXIT(EXIT_FAILURE);
		}

		lgFIRST = FALSE;
	}
#	endif

	/* set ioQQQ to standard output */
	ioQQQ = stdout;

	/* set flag saying that we have been called */
	lgcdInitCalled = TRUE;

	/* set ioPrnErr to stderr */
	ioPrnErr = stderr;

	/* but don't what to usually do this */
	lgPrnErr = FALSE;

	/* set MPI flag false, set true with cdMPI()*/
	lgMPI = FALSE;

	cdDefines();
	blkdata2();		/* fe2data */
	blkdata4();		/* hpdata */

	/* >>chng 00 mar 10, moved call for grain block data init to Cloudy, PvH */

	/*need a fake call to phfit so that ionization potentials are stored in 
	 * proper structures */
	cs = phfit(1,1,1,13.7,0);
	if( cs<=0. ) 
		total_insanity();

	/*set FP environment to crash on div by zero*/
	SetFPEnv();

	/*********************************************************
	 *  on a VAX compile with /G_FLOATING option on FORTRAN; *
	 *  following makes sure this happened.                  *
	 *********************************************************/
	vtest = 1e-35;
	vtest /= 1e35;
	if( vtest == 0. )
	{
		fprintf( ioQQQ, " Something is wrong with the double precision.  Use /g_floating on a VAX\n" );
	}

	/*********************************************************
	 *  check that we are being compiled with ANSI C or C++  *
	 *********************************************************/
	/* >>chng 02 feb 15, this test disabled - K&R compilers probably
	 * no longer exist, and this slows down execution of optimized code 
	 * on a P4 by roughtly 30% */
#	if !defined(__STDC__) && !defined(__cplusplus)
	{
		/* following should be set true to allow this test,
		 * set false to have non-ANSI compilers work */
		/*@-redef@*/
		enum {CHECKIT=FALSE};
		/*@+redef@*/
		if( CHECKIT )
		{
			fprintf(ioQQQ," I must be compiled using ANSI C options.  This was not enabled.\n");
			fprintf(ioQQQ," Visual Studio use the /Za flag.\n");
			fprintf(ioQQQ," GNU gcc use the -ansi flag.\n");
			fprintf(ioQQQ," Dec alpha use the -std1 flag.\n");
			fprintf(ioQQQ," Sparc use the -Xc flag.\n");
			puts( "[Stop in cdInit]" );
			cdEXIT(EXIT_FAILURE);
		}
	}
#	endif

	/* >>chng 02 feb 27, include this test, provided by Peter van Hoof */
	/* check that we ARE NOT being compiled by gcc version 2.96 */
#	if __GNUC__ == 2 && __GNUC_MINOR__ == 96
	fprintf(ioQQQ,"HELP!!! You compiled me with gcc 2.96!\n");
	fprintf(ioQQQ,"This version of gcc cannot compile Cloudy and must not be used!\n");
	fprintf(ioQQQ,"Use kgcc or update gcc to a functional version.\n");
	puts( "[Stop in cdInit]" );
	cdEXIT(EXIT_FAILURE);
#	endif


	/* initialize some variables dealing with cloudy's interaction with machine environment */
	/* if TALK is TRUE then do standard printout
	 * if FALSE then never say anything */
	called.lgTalk = TRUE;
	called.lgBusted = FALSE;
	/* this flag is needed to turn print on to ahave effect */
	called.lgTalkIsOK = TRUE;
	/* means talk not forced off by call to cdTalk*/
	called.lgTalkForce = FALSE;

	vary.lgNoVary = FALSE;
	vary.lgVaryOn = FALSE;
	optimr.lgOptimr = FALSE;

	/* this is a global variable in assertresults.h, and can be checked by
	 * other routines to see if asserts are ok - (most calculations will not use asserts,
	 * and this will be the only place values are set, although they will be checked in maincl) */
	lgAssertsOK = TRUE;
	lgBigBotch = FALSE;

#	ifdef __unix
	/* determine hostname; used by PHYMIR */
        if( (ptr = getenv("HOST")) != NULL )
		strcpy(VaryPar.HostName,ptr);
	else
		strcpy(VaryPar.HostName,"unknown");
	/* determine the no. of CPUs on this machine; used by PHYMIR */
#	if defined(_SC_NPROCESSORS_ONLN)  /* Sun Sparc, DEC Alpha */
	VaryPar.maxCPU = sysconf(_SC_NPROCESSORS_ONLN);
#	elif defined(_SC_NPROC_ONLN)      /* SGI Iris */
	VaryPar.maxCPU = sysconf(_SC_NPROC_ONLN);
#	elif defined(_SC_CRAY_NCPU)       /* Cray */
	VaryPar.maxCPU = sysconf(_SC_CRAY_NCPU);
#	else                              
	/* Other systems, supply no. of CPUs on OPTIMIZE PHYMIR command line */
	VaryPar.maxCPU = 1;
#	endif
#	else
	strcpy(VaryPar.HostName,"unknown");
	VaryPar.maxCPU = 1;
#	endif

	/* number of lines entered with cdLine
	 * both check that number less than NKRD, the limit
	 * the line save array is devined from 0 through input.nSave */
	input.nSave = -1;

	/* nRead is the number of the command in the input stream - many vary options
	 * point to it to refer to the original command.  it is incremented before
	 * it is used, so will become 0.  it is the array element within the stack
	 * of emission lines */
	input.nRead = -1;

	/* this is number of init lines read in */
	input.nSaveIni = 0;

	/* flag identifying whether any line images were too long, tested in cdRead */
	lgCardSavTooLong = FALSE;

	/* this is sanity check that lines are read in ok */
	for( i=0; i < NKRD; i++ )
	{
		strcpy( input.chCardSav[i], "error! - no line image input" );
	}

	/* initialize stuff for opening punch files, should not be done in zero() */
	punch.lgOpenUnits = TRUE;
	PunchFilesInit();

	/* start the timer to log execution time */
	cdSetExecTime();

	/* zero out lots of variables */
	zero();

#	ifdef DEBUG_FUN
	fputs( " <->cdInit()\n", debug_fp );
#	endif
	return;
}


/* =================================================================== */
/*cdEXIT the routine that should be called to exit cloudy */
#ifdef _MSC_VER
/* MS compiler directive saying that cdEXIT does not return */
__declspec(noreturn) 
#elif defined(__GNUC__)
 __attribute__ ((noreturn))
#endif
void cdEXIT(int iexit)
{
	/*@-redef@*/
	enum {DEBUG=FALSE};
	/*@+redef@*/
	if( DEBUG )
	{
		fprintf(ioQQQ," cdEXIT called\n");
	}

	/* close any open units */
	/* flush ioQQQ */
	fflush( ioQQQ );

	ClosePunchFiles();

	/* this routine must be called upon exit or machine will appear to "hang" */
#	ifdef MPI
	if( lgMPI )
	{
		fprintf(ioQQQ," MPI_Finalize called.\n");
		MPI_Finalize();
	}
#	endif
	exit( iexit );
}
