/*CollidIonize fill in collisional ionization rates, and resulting cooling */
#include "cddefines.h"
#include "physconst.h"
#include "secondaries.h"
#include "phycon.h"
#include "ionrange.h"
#include "ionrec.h"
#include "rfield.h"
#include "heavy.h"
#include "cfit.h"
#include "collidionize.h"

void CollidIonize(
	/* element number on c scale, H is 0 */
	long int nelem )
{
	long int ion,
		limit;
	float DimaRate;
	double crate;

#	ifdef DEBUG_FUN
	fputs( "<+>CollidIonize()\n", debug_fp );
#	endif

	/* compute collisional ionization rate */

	/* CollidRate[nelem][ion][0] is collisional ionization rate, s-1
	 * CollidRate[nelem][ion][1] is collisional ionization cooling, erg/s
	 */

	/* zero out rates below lowest ionization stage we will consider */
	for( ion=0; ion < (IonRange.IonLow[nelem] - 1); ion++ )
	{
		ionrec.CollIonRate_Ground[nelem][ion][0] = 0.;
		ionrec.CollIonRate_Ground[nelem][ion][1] = 0.;
	}

	/* chng logic changed to be precisely same as bidiag */
	limit = MIN2(nelem-2,IonRange.IonHigh[nelem]-1);

	for( ion=IonRange.IonLow[nelem]; ion <= limit; ion++ )
	{
		/* 
		 * collisional ionization by thermal electrons
		 * >>chng 97 mar 19, to Dima's new routine using
		 * >>refer	all	coll_ion	Voronov G.S., 1997, At. Data Nucl. Data Tables 65, 1
		 */
		DimaRate = (float)cfit( nelem+1, nelem+1-ion , phycon.te );

		crate = DimaRate*phycon.eden;

		/* total collisional ionization rate 
		 * with both thermal and suprathermal electrons */
		ionrec.CollIonRate_Ground[nelem][ion][0] = crate + Secondaries.csupra;

		/* cooling due to collisional ionization, which only includes thermal */
		ionrec.CollIonRate_Ground[nelem][ion][1] = (crate*
			rfield.anu[Heavy.ipHeavy[nelem][ion]-1]* EN1RYD);
	}

	for( ion=IonRange.IonHigh[nelem]; ion <= nelem; ion++ )
	{
		ionrec.CollIonRate_Ground[nelem][ion][0] = 0.;
		ionrec.CollIonRate_Ground[nelem][ion][1] = 0.;
	}

	/* check not rates are negative - in release mode this loop will optimize out */
	for( ion=0; ion <= nelem; ion++ )
	{
		/* there can be no negative rates */
		ASSERT( ionrec.CollIonRate_Ground[nelem][ion][0] >= 0. );
	}

#	ifdef DEBUG_FUN
	fputs( " <->CollidIonize()\n", debug_fp );
#	endif
	return;
}
